/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.Put70;
import com.gemstone.gemfire.internal.cache.versions.VMVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashMap;
import junit.framework.TestCase;

public class ClientsWithVersioningRetryDUnitTest
extends CacheTestCase {
    public ClientsWithVersioningRetryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ClientsWithVersioningRetryDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "true");
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        ClientsWithVersioningRetryDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "false");
            }
        });
    }

    public void testRetryPut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createServerRegion(vm0, RegionShortcut.REPLICATE);
        this.createServerRegion(vm1, RegionShortcut.REPLICATE);
        final DistributedMember memberID = (DistributedMember)vm0.invoke(new SerializableCallable("get id"){

            public Object call() {
                return ((DistributedRegion)ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region")).getDistributionManager().getDistributionManagerId();
            }
        });
        vm0.invoke(new SerializableCallable("create entry with fake event ID"){

            public Object call() {
                DistributedRegion dr = (DistributedRegion)ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                VMVersionTag tag = new VMVersionTag();
                tag.setMemberID(dr.getVersionMember());
                tag.setRegionVersion(123L);
                tag.setEntryVersion(9);
                tag.setVersionTimeStamp(System.currentTimeMillis());
                EventID eventID = new EventID(new byte[0], 1L, 0L);
                EntryEventImpl event = EntryEventImpl.create((LocalRegion)dr, (Operation)Operation.CREATE, (Object)"TestObject", (Object)"TestValue", null, (boolean)false, (DistributedMember)memberID, (boolean)true, (EventID)eventID);
                event.setVersionTag((VersionTag)tag);
                event.setContext(new ClientProxyMembershipID(memberID));
                dr.recordEvent((InternalCacheEvent)event);
                event.release();
                return memberID;
            }
        });
        vm1.invoke(new SerializableRunnable("recover event tag in vm1 from vm0"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DistributedRegion dr = (DistributedRegion)ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                EventID eventID = new EventID(new byte[0], 1L, 0L);
                EntryEventImpl event = EntryEventImpl.create((LocalRegion)dr, (Operation)Operation.CREATE, (Object)"TestObject", (Object)"TestValue", null, (boolean)false, (DistributedMember)memberID, (boolean)true, (EventID)eventID);
                try {
                    event.setContext(new ClientProxyMembershipID(memberID));
                    boolean recovered = ((BaseCommand)Put70.getCommand()).recoverVersionTagForRetriedOperation(event);
                    TestCase.assertTrue((String)"Expected to recover the version for this event ID", (boolean)recovered);
                    TestCase.assertEquals((String)"Expected the region version to be 123", (long)123L, (long)event.getVersionTag().getRegionVersion());
                }
                finally {
                    event.release();
                }
            }
        });
        vm1.invoke(new SerializableRunnable("recover posdup event tag in vm1 event tracker from vm0"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DistributedRegion dr = (DistributedRegion)ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                EventID eventID = new EventID(new byte[0], 1L, 0L);
                EntryEventImpl event = EntryEventImpl.create((LocalRegion)dr, (Operation)Operation.CREATE, (Object)"TestObject", (Object)"TestValue", null, (boolean)false, (DistributedMember)memberID, (boolean)true, (EventID)eventID);
                event.setPossibleDuplicate(true);
                try {
                    dr.hasSeenEvent(event);
                    TestCase.assertTrue((String)"Expected to recover the version for the event ID", (event.getVersionTag() != null ? 1 : 0) != 0);
                }
                finally {
                    event.release();
                }
            }
        });
    }

    public void testRetryPutAll() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createServerRegion(vm0, RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                region.put((Object)0, (Object)"value");
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                        if (msg instanceof DistributedPutAllOperation.PutAllMessage) {
                            DistributionMessageObserver.setInstance(null);
                            ClientsWithVersioningRetryDUnitTest.this.disconnectFromDS(vm1);
                        }
                    }
                });
            }
        });
        int port1 = this.createServerRegion(vm1, RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        int port2 = this.createServerRegion(vm2, RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        this.createClientRegion(vm3, port1, port2);
        vm3.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                map.put(0, "a");
                map.put(113, "b");
                region.putAll(map);
                RegionEntry entry = ((LocalRegion)region).getRegionEntry((Object)0);
                TestCase.assertNotNull((Object)entry);
                TestCase.assertNotNull((Object)entry.getVersionStamp());
                TestCase.assertEquals((int)2, (int)entry.getVersionStamp().getEntryVersion());
                return null;
            }
        });
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertNull((Object)DistributionMessageObserver.getInstance());
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertTrue((cache == null || cache.isClosed() ? 1 : 0) != 0);
            }
        });
    }

    public void testRetryPutAllInAccessor() {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        ClientsWithVersioningRetryDUnitTest.getLogWriter().info("creating region in vm0");
        this.createRegionInPeer(vm0, RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                region.put((Object)0, (Object)"value");
            }
        });
        ClientsWithVersioningRetryDUnitTest.getLogWriter().info("creating region in vm1");
        this.createRegionInPeer(vm1, RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        ClientsWithVersioningRetryDUnitTest.getLogWriter().info("creating region in vm2");
        this.createRegionInPeer(vm2, RegionShortcut.PARTITION_REDUNDANT_PERSISTENT);
        ClientsWithVersioningRetryDUnitTest.getLogWriter().info("creating region in vm3");
        this.createRegionInPeer(vm3, RegionShortcut.PARTITION_PROXY);
        vm2.invoke(new SerializableRunnable("install message listener to ignore update"){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage msg) {
                        if (msg instanceof DistributedPutAllOperation.PutAllMessage) {
                            DistributionMessageObserver.setInstance(null);
                            DistributedTestCase.pause(5000);
                            ClientsWithVersioningRetryDUnitTest.this.disconnectFromDS(vm0);
                            throw new RuntimeException("test code is ignoring message: " + msg);
                        }
                    }
                });
            }
        });
        vm3.invoke(new SerializableCallable("perform putAll in accessor"){

            public Object call() throws Exception {
                Region region = ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                map.put(0, "a");
                map.put(113, "b");
                region.putAll(map);
                return null;
            }
        });
        vm1.invoke(new SerializableRunnable("verify vm1"){

            @Override
            public void run() {
                TestCase.assertNull((Object)DistributionMessageObserver.getInstance());
                Region region = ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                VersionTag tag = ((LocalRegion)region).getVersionTag((Object)0);
                TestCase.assertEquals((int)2, (int)tag.getEntryVersion());
            }
        });
        vm2.invoke(new SerializableRunnable("verify vm2"){

            @Override
            public void run() {
                TestCase.assertNull((Object)DistributionMessageObserver.getInstance());
                Region region = ClientsWithVersioningRetryDUnitTest.this.getCache().getRegion("region");
                VersionTag tag = ((LocalRegion)region).getVersionTag((Object)0);
                TestCase.assertEquals((int)2, (int)tag.getEntryVersion());
            }
        });
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertTrue((cache == null || cache.isClosed() ? 1 : 0) != 0);
            }
        });
    }

    private void disconnectFromDS(VM vm) {
        vm.invoke(new SerializableCallable("disconnecting vm " + vm){

            public Object call() throws Exception {
                CacheTestCase.disconnectFromDS();
                return null;
            }
        });
    }

    private int createServerRegion(VM vm, final RegionShortcut shortcut) {
        SerializableCallable createRegion = new SerializableCallable("create server region"){

            public Object call() throws Exception {
                RegionFactory rf = ClientsWithVersioningRetryDUnitTest.this.getCache().createRegionFactory(shortcut);
                if (!shortcut.equals((Object)RegionShortcut.REPLICATE)) {
                    rf.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(2).create());
                }
                rf.create("region");
                CacheServer server = ClientsWithVersioningRetryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void createRegionInPeer(VM vm, final RegionShortcut shortcut) {
        SerializableCallable createRegion = new SerializableCallable("create peer region"){

            public Object call() throws Exception {
                RegionFactory rf = ClientsWithVersioningRetryDUnitTest.this.getCache().createRegionFactory(shortcut);
                if (!shortcut.equals((Object)RegionShortcut.REPLICATE)) {
                    rf.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(2).create());
                }
                rf.create("region");
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    private int createServerRegionWithPersistence(VM vm, final boolean persistentPdxRegistry) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory();
                if (persistentPdxRegistry) {
                    cf.setPdxPersistent(true).setPdxDiskStore("store");
                }
                Cache cache = ClientsWithVersioningRetryDUnitTest.this.getCache(cf);
                cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("store");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                af.setDiskStoreName("store");
                ClientsWithVersioningRetryDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = ClientsWithVersioningRetryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createServerAccessor(VM vm) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.EMPTY);
                ClientsWithVersioningRetryDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = ClientsWithVersioningRetryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void createClientRegion(VM vm, int port1, int port2) {
        this.createClientRegion(vm, port1, port2, false);
    }

    private void createClientRegion(final VM vm, final int port1, final int port2, final boolean threadLocalConnections) {
        SerializableCallable createRegion = new SerializableCallable("create client region in " + vm){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port1);
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port2);
                cf.setPoolPRSingleHopEnabled(false);
                cf.setPoolThreadLocalConnections(threadLocalConnections);
                cf.setPoolReadTimeout(600000);
                ClientCache cache = ClientsWithVersioningRetryDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("region");
                return null;
            }
        };
        vm.invoke(createRegion);
    }
}

