/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.VM;

public class TestHeapDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;

    public TestHeapDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static long getHeapSizeOfClient() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long getHeapSizeOfDS() {
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                return bean != null && bean.getTotalHeapSize() > 0L;
            }

            @Override
            public String description() {
                return "wait for getHeapSizeOfDS to complete and get results";
            }
        };
        TestHeapDUnitTest.waitForCriterion(waitCriteria, 120000L, 3000L, true);
        DistributedSystemMXBean bean = TestHeapDUnitTest.getManagementService().getDistributedSystemMXBean();
        TestHeapDUnitTest.assertNotNull((Object)bean);
        return bean.getTotalHeapSize() * 1000L;
    }

    public void testTotalHeapSize() throws Exception {
        this.initManagement(false);
        long totalHeapSizeOnAll = 0L;
        for (VM vm : managedNodeList) {
            totalHeapSizeOnAll += ((Number)vm.invoke(TestHeapDUnitTest.class, "getHeapSizeOfClient")).longValue();
        }
        long totalHeapSizeFromMXBean = ((Number)managingNode.invoke(TestHeapDUnitTest.class, "getHeapSizeOfDS")).intValue();
        TestHeapDUnitTest.getLogWriter().info("testTotalHeapSize totalHeapSizeFromMXBean = " + totalHeapSizeFromMXBean + " totalHeapSizeOnAll = " + totalHeapSizeOnAll);
        TestHeapDUnitTest.assertNotSame((Object)0, (Object)totalHeapSizeFromMXBean);
        TestHeapDUnitTest.assertNotSame((Object)0, (Object)totalHeapSizeOnAll);
        TestHeapDUnitTest.assertNotSame((Object)0, (Object)(totalHeapSizeFromMXBean - totalHeapSizeOnAll > 0L ? totalHeapSizeFromMXBean - totalHeapSizeOnAll : -1L * (totalHeapSizeFromMXBean - totalHeapSizeOnAll)));
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }
}

