/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.VM;

public class TestClientsDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqDataDUnitTest");

    public TestClientsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public static Integer getNumOfClients() {
        DistributedTestCase.WaitCriterion waitCriteria = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                return bean != null && bean.getNumClients() > 0;
            }

            @Override
            public String description() {
                return "wait for getNumOfClients bean to complete and get results";
            }
        };
        TestClientsDUnitTest.waitForCriterion(waitCriteria, 120000L, 3000L, true);
        DistributedSystemMXBean bean = TestClientsDUnitTest.getManagementService().getDistributedSystemMXBean();
        TestClientsDUnitTest.assertNotNull((Object)bean);
        return bean.getNumClients();
    }

    public void testNumOfClients() throws Exception {
        this.initManagement(false);
        VM server = (VM)managedNodeList.get(1);
        VM client = (VM)managedNodeList.get(2);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.cqDUnitTest.createServer(server, serverPort);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = TestClientsDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        Integer numOfClients = (Integer)managingNode.invoke(TestClientsDUnitTest.class, "getNumOfClients");
        TestClientsDUnitTest.getLogWriter().info("testNumOfClients numOfClients = " + numOfClients);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
        TestClientsDUnitTest.assertEquals((int)1, (int)numOfClients);
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }
}

