/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ShowStackTraceDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;

    public ShowStackTraceDUnitTest(String name) {
        super(name);
    }

    private void createCache(Properties props) {
        this.getSystem(props);
        this.getCache();
    }

    private Properties createProperties(Host host, String name, String groups) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "info");
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("enable-time-statistics", "true");
        props.setProperty("name", name);
        props.setProperty("groups", groups);
        return props;
    }

    private void setupSystem() {
        ShowStackTraceDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM[] servers = new VM[]{host.getVM(0), host.getVM(1)};
        Properties propsManager = this.createProperties(host, "Manager", "G1");
        final Properties propsServer2 = this.createProperties(host, "Server", "G2");
        this.createDefaultSetup(propsManager);
        servers[1].invoke(new SerializableRunnable("Create cache for server1"){

            @Override
            public void run() {
                ShowStackTraceDUnitTest.this.createCache(propsServer2);
            }
        });
    }

    public void testExportStacktrace() throws ClassNotFoundException, IOException {
        this.setupSystem();
        File allStacktracesFile = new File("allStackTraces.txt");
        allStacktracesFile.createNewFile();
        allStacktracesFile.deleteOnExit();
        CommandStringBuilder csb = new CommandStringBuilder("export stack-traces");
        csb.addOption("file", allStacktracesFile.getCanonicalPath());
        String commandString = csb.toString();
        ShowStackTraceDUnitTest.getLogWriter().info("CommandString : " + commandString);
        CommandResult commandResult = this.executeCommand(commandString);
        ShowStackTraceDUnitTest.getLogWriter().info("Output : \n" + this.commandResultToString(commandResult));
        ShowStackTraceDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.OK));
        File mgrStacktraceFile = new File("managerStacktrace.txt");
        mgrStacktraceFile.createNewFile();
        mgrStacktraceFile.deleteOnExit();
        csb = new CommandStringBuilder("export stack-traces");
        csb.addOption("file", mgrStacktraceFile.getCanonicalPath());
        csb.addOption("member", "Manager");
        commandString = csb.toString();
        ShowStackTraceDUnitTest.getLogWriter().info("CommandString : " + commandString);
        commandResult = this.executeCommand(commandString);
        ShowStackTraceDUnitTest.getLogWriter().info("Output : \n" + this.commandResultToString(commandResult));
        ShowStackTraceDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.OK));
        File serverStacktraceFile = new File("serverStacktrace.txt");
        serverStacktraceFile.createNewFile();
        serverStacktraceFile.deleteOnExit();
        csb = new CommandStringBuilder("export stack-traces");
        csb.addOption("file", serverStacktraceFile.getCanonicalPath());
        csb.addOption("member", "Server");
        commandString = csb.toString();
        ShowStackTraceDUnitTest.getLogWriter().info("CommandString : " + commandString);
        commandResult = this.executeCommand(commandString);
        ShowStackTraceDUnitTest.getLogWriter().info("Output : \n" + this.commandResultToString(commandResult));
        ShowStackTraceDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.OK));
        File groupStacktraceFile = new File("groupstacktrace.txt");
        groupStacktraceFile.createNewFile();
        groupStacktraceFile.deleteOnExit();
        csb = new CommandStringBuilder("export stack-traces");
        csb.addOption("file", groupStacktraceFile.getCanonicalPath());
        csb.addOption("group", "G2");
        commandString = csb.toString();
        ShowStackTraceDUnitTest.getLogWriter().info("CommandString : " + commandString);
        commandResult = this.executeCommand(commandString);
        ShowStackTraceDUnitTest.getLogWriter().info("Output : \n" + this.commandResultToString(commandResult));
        ShowStackTraceDUnitTest.assertTrue((boolean)commandResult.getStatus().equals((Object)Result.Status.OK));
        File wrongStackTraceFile = new File("wrongStackTrace.txt");
        wrongStackTraceFile.createNewFile();
        wrongStackTraceFile.deleteOnExit();
        csb = new CommandStringBuilder("export stack-traces");
        csb.addOption("file", wrongStackTraceFile.getCanonicalPath());
        csb.addOption("member", "WrongMember");
        commandString = csb.toString();
        ShowStackTraceDUnitTest.getLogWriter().info("CommandString : " + commandString);
        commandResult = this.executeCommand(commandString);
        ShowStackTraceDUnitTest.getLogWriter().info("Output : \n" + this.commandResultToString(commandResult));
        ShowStackTraceDUnitTest.assertFalse((boolean)commandResult.getStatus().equals((Object)Result.Status.OK));
    }
}

