/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.remote.CommandProcessor;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class ShowMetricsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;

    public ShowMetricsDUnitTest(String name) {
        super(name);
    }

    private void createLocalSetUp() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Controller");
        this.getSystem(localProps);
        Cache cache = this.getCache();
        RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        Region region1 = dataRegionFactory.create("REGION1");
        Region region2 = dataRegionFactory.create("REGION2");
    }

    public void testShowMetricsDefault() {
        this.createDefaultSetup(null);
        this.createLocalSetUp();
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                ShowMetricsDUnitTest.this.getSystem(localProps);
                Cache cache = ShowMetricsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create("REGION1");
            }
        });
        SerializableCallable showMetricCmd = new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = ShowMetricsDUnitTest.this.createMBeanWaitCriterion(1, "", null, 0);
                DistributedTestCase.waitForCriterion(wc, 5000L, 500L, true);
                CommandProcessor commandProcessor = new CommandProcessor();
                Result result = commandProcessor.createCommandStatement("show metrics", Collections.EMPTY_MAP).process();
                String resultStr = ShowMetricsDUnitTest.this.commandResultToString((CommandResult)result);
                DistributedTestCase.getLogWriter().info(resultStr);
                TestCase.assertEquals((String)resultStr, (boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
                return resultStr;
            }
        };
        VM managerVm = Host.getHost(0).getVM(0);
        Object managerResultObj = managerVm.invoke(showMetricCmd);
        String managerResult = (String)managerResultObj;
        ShowMetricsDUnitTest.getLogWriter().info("#SB Manager");
        ShowMetricsDUnitTest.getLogWriter().info(managerResult);
    }

    public void systemSetUp() {
        this.createDefaultSetup(null);
        this.createLocalSetUp();
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                ShowMetricsDUnitTest.this.getSystem(localProps);
                Cache cache = ShowMetricsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create("REGION1");
            }
        });
    }

    public void testShowMetricsRegion() throws InterruptedException {
        this.systemSetUp();
        String regionName = "REGION1";
        SerializableCallable showMetricCmd = new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = ShowMetricsDUnitTest.this.createMBeanWaitCriterion(2, "REGION1", null, 0);
                DistributedTestCase.waitForCriterion(wc, 5000L, 500L, true);
                CommandProcessor commandProcessor = new CommandProcessor();
                Result result = commandProcessor.createCommandStatement("show metrics --region=REGION1", Collections.EMPTY_MAP).process();
                String resultAsString = ShowMetricsDUnitTest.this.commandResultToString((CommandResult)result);
                TestCase.assertEquals((String)resultAsString, (boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
                return resultAsString;
            }
        };
        VM managerVm = Host.getHost(0).getVM(0);
        Object managerResultObj = managerVm.invoke(showMetricCmd);
        String managerResult = (String)managerResultObj;
        ShowMetricsDUnitTest.getLogWriter().info("#SB Manager");
        ShowMetricsDUnitTest.getLogWriter().info(managerResult);
    }

    private DistributedTestCase.WaitCriterion createMBeanWaitCriterion(final int beanType, final String regionName, final DistributedMember distributedMember, final int cacheServerPort) {
        DistributedTestCase.WaitCriterion waitCriterion = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ObjectName csMxBeanName;
                CacheServerMXBean csMxBean;
                boolean done = false;
                Cache cache = ShowMetricsDUnitTest.this.getCache();
                ManagementService mgmtService = ManagementService.getManagementService((Cache)cache);
                if (beanType == 1) {
                    DistributedSystemMXBean dsMxBean = mgmtService.getDistributedSystemMXBean();
                    if (dsMxBean != null) {
                        done = true;
                    }
                } else if (beanType == 2) {
                    DistributedRegionMXBean dsRegionMxBean = mgmtService.getDistributedRegionMXBean("/" + regionName);
                    if (dsRegionMxBean != null) {
                        done = true;
                    }
                } else if (beanType == 3) {
                    ObjectName memberMBeanName = mgmtService.getMemberMBeanName(distributedMember);
                    MemberMXBean memberMxBean = (MemberMXBean)mgmtService.getMBeanInstance(memberMBeanName, MemberMXBean.class);
                    if (memberMxBean != null) {
                        done = true;
                    }
                } else if (beanType == 4) {
                    ObjectName regionMBeanName = mgmtService.getRegionMBeanName(distributedMember, "/" + regionName);
                    RegionMXBean regionMxBean = (RegionMXBean)mgmtService.getMBeanInstance(regionMBeanName, RegionMXBean.class);
                    if (regionMxBean != null) {
                        done = true;
                    }
                } else if (beanType == 5 && (csMxBean = (CacheServerMXBean)mgmtService.getMBeanInstance(csMxBeanName = mgmtService.getCacheServerMBeanName(cacheServerPort, distributedMember), CacheServerMXBean.class)) != null) {
                    done = true;
                }
                return done;
            }

            @Override
            public String description() {
                return "Waiting for the mbean to be created";
            }
        };
        return waitCriterion;
    }

    public void testShowMetricsMember() throws ClassNotFoundException, IOException, InterruptedException {
        this.systemSetUp();
        Cache cache = this.getCache();
        final DistributedMember distributedMember = cache.getDistributedSystem().getDistributedMember();
        String exportFileName = "memberMetricReport.csv";
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        CacheServer cs = this.getCache().addCacheServer();
        cs.setPort(ports[0]);
        cs.start();
        final int cacheServerPort = cs.getPort();
        SerializableCallable showMetricCmd = new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = ShowMetricsDUnitTest.this.createMBeanWaitCriterion(3, "", distributedMember, 0);
                DistributedTestCase.waitForCriterion(wc, 5000L, 500L, true);
                wc = ShowMetricsDUnitTest.this.createMBeanWaitCriterion(5, "", distributedMember, cacheServerPort);
                DistributedTestCase.waitForCriterion(wc, 10000L, 500L, true);
                String command = "show metrics --member=" + distributedMember.getId() + " --" + "port" + "=" + cacheServerPort + " --" + "file" + "=" + "memberMetricReport.csv";
                CommandProcessor commandProcessor = new CommandProcessor();
                Result result = commandProcessor.createCommandStatement(command, Collections.EMPTY_MAP).process();
                String resultAsString = ShowMetricsDUnitTest.this.commandResultToString((CommandResult)result);
                TestCase.assertEquals((String)resultAsString, (boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
                TestCase.assertTrue((boolean)result.hasIncomingFiles());
                result.saveIncomingFiles(null);
                File file = new File("memberMetricReport.csv");
                file.deleteOnExit();
                TestCase.assertTrue((boolean)file.exists());
                file.delete();
                return resultAsString;
            }
        };
        VM managerVm = Host.getHost(0).getVM(0);
        Object managerResultObj = managerVm.invoke(showMetricCmd);
        String managerResult = (String)managerResultObj;
        ShowMetricsDUnitTest.getLogWriter().info("#SB Manager");
        ShowMetricsDUnitTest.getLogWriter().info(managerResult);
        cs.stop();
    }

    public void testShowMetricsRegionFromMember() throws ClassNotFoundException, IOException, InterruptedException {
        this.systemSetUp();
        Cache cache = this.getCache();
        final DistributedMember distributedMember = cache.getDistributedSystem().getDistributedMember();
        String exportFileName = "regionOnAMemberReport.csv";
        String regionName = "REGION1";
        SerializableCallable showMetricCmd = new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = ShowMetricsDUnitTest.this.createMBeanWaitCriterion(4, "REGION1", distributedMember, 0);
                DistributedTestCase.waitForCriterion(wc, 5000L, 500L, true);
                CommandProcessor commandProcessor = new CommandProcessor();
                Result result = commandProcessor.createCommandStatement("show metrics --region=REGION1 --member=" + distributedMember.getName() + " --file=" + "regionOnAMemberReport.csv", Collections.EMPTY_MAP).process();
                String resultAsString = ShowMetricsDUnitTest.this.commandResultToString((CommandResult)result);
                TestCase.assertEquals((String)resultAsString, (boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
                TestCase.assertTrue((boolean)result.hasIncomingFiles());
                result.saveIncomingFiles(null);
                File file = new File("regionOnAMemberReport.csv");
                file.deleteOnExit();
                TestCase.assertTrue((boolean)file.exists());
                file.delete();
                return resultAsString;
            }
        };
        VM managerVm = Host.getHost(0).getVM(0);
        Object managerResultObj = managerVm.invoke(showMetricCmd);
        String managerResult = (String)managerResultObj;
        ShowMetricsDUnitTest.getLogWriter().info("#SB Manager");
        ShowMetricsDUnitTest.getLogWriter().info(managerResult);
    }

    public void testShowMetricsRegionFromMemberWithCategories() throws ClassNotFoundException, IOException, InterruptedException {
        this.systemSetUp();
        Cache cache = this.getCache();
        final DistributedMember distributedMember = cache.getDistributedSystem().getDistributedMember();
        String exportFileName = "regionOnAMemberReport.csv";
        String regionName = "REGION1";
        SerializableCallable showMetricCmd = new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = ShowMetricsDUnitTest.this.createMBeanWaitCriterion(4, "REGION1", distributedMember, 0);
                DistributedTestCase.waitForCriterion(wc, 5000L, 500L, true);
                CommandProcessor commandProcessor = new CommandProcessor();
                Result result = commandProcessor.createCommandStatement("show metrics --region=REGION1 --member=" + distributedMember.getName() + " --file=" + "regionOnAMemberReport.csv" + " --categories=region,eviction", Collections.EMPTY_MAP).process();
                String resultAsString = ShowMetricsDUnitTest.this.commandResultToString((CommandResult)result);
                TestCase.assertEquals((String)resultAsString, (boolean)true, (boolean)result.getStatus().equals((Object)Result.Status.OK));
                TestCase.assertTrue((boolean)result.hasIncomingFiles());
                result.saveIncomingFiles(null);
                File file = new File("regionOnAMemberReport.csv");
                file.deleteOnExit();
                TestCase.assertTrue((boolean)file.exists());
                file.delete();
                return resultAsString;
            }
        };
        VM managerVm = Host.getHost(0).getVM(0);
        Object managerResultObj = managerVm.invoke(showMetricCmd);
        String managerResult = (String)managerResultObj;
        ShowMetricsDUnitTest.getLogWriter().info("#SB Manager");
        ShowMetricsDUnitTest.getLogWriter().info(managerResult);
    }
}

