/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.LocatorLauncher;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Before;

public class ShellCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;

    public ShellCommandsDUnitTest(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() {
        this.getDefaultShell();
    }

    protected CommandResult connectToLocator(int locatorPort) {
        return this.executeCommand(new CommandStringBuilder("connect").addOption("locator", "localhost[" + locatorPort + "]").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectToLocatorBecomesManager() {
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int jmxManagerPort = ports[0];
        int locatorPort = ports[1];
        System.setProperty("gemfire.jmx-manager-port", String.valueOf(jmxManagerPort));
        System.setProperty("gemfire.jmx-manager-http-port", "0");
        ShellCommandsDUnitTest.assertEquals((String)String.valueOf(jmxManagerPort), (String)System.getProperty("gemfire.jmx-manager-port"));
        ShellCommandsDUnitTest.assertEquals((String)"0", (String)System.getProperty("gemfire.jmx-manager-http-port"));
        String pathname = this.getClass().getSimpleName() + "_" + ShellCommandsDUnitTest.getTestName();
        File workingDirectory = new File(pathname);
        workingDirectory.mkdir();
        ShellCommandsDUnitTest.assertTrue((boolean)workingDirectory.isDirectory());
        LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setBindAddress(null).setForce(Boolean.valueOf(true)).setMemberName(pathname).setPort(Integer.valueOf(locatorPort)).setWorkingDirectory(IOUtils.tryGetCanonicalPathElseGetAbsolutePath((File)workingDirectory)).build();
        ShellCommandsDUnitTest.assertNotNull((Object)locatorLauncher);
        ShellCommandsDUnitTest.assertEquals((int)locatorPort, (int)locatorLauncher.getPort());
        try {
            locatorLauncher.start();
            LocatorLauncher.LocatorState locatorState = locatorLauncher.waitOnStatusResponse(60L, 10L, TimeUnit.SECONDS);
            ShellCommandsDUnitTest.assertNotNull((Object)locatorState);
            ShellCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)locatorState.getStatus());
            CommandResult result = this.connectToLocator(locatorPort);
            ShellCommandsDUnitTest.assertNotNull((Object)result);
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)result.getStatus());
        }
        finally {
            ShellCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)locatorLauncher.stop().getStatus());
            ShellCommandsDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorLauncher.status().getStatus());
        }
    }

    public void testEchoWithVariableAtEnd() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        gfshInstance.setEnvProperty("TESTSYS", "SYS_VALUE");
        String command = "echo --string=\"Hello World! This is ${TESTSYS}\"";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.assertEquals((String)"Hello World! This is SYS_VALUE", (String)StringUtils.trim((String)stringResult));
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoWithVariableAtEnd failed");
        }
    }

    public void testEchoWithNoVariable() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        gfshInstance.setEnvProperty("TESTSYS", "SYS_VALUE");
        String command = "echo --string=\"Hello World! This is VMWARE\"";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.assertTrue((boolean)stringResult.contains("Hello World! This is VMWARE"));
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoWithNoVariable failed");
        }
    }

    public void testEchoWithVariableAtStart() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        gfshInstance.setEnvProperty("TESTSYS", "SYS_VALUE");
        String command = "echo --string=\"${TESTSYS} Hello World! This is VMWARE\"";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.assertTrue((boolean)stringResult.contains("SYS_VALUE Hello World! This is VMWARE"));
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoWithVariableAtStart failed");
        }
    }

    public void testEchoWithMultipleVariables() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        gfshInstance.setEnvProperty("TESTSYS", "SYS_VALUE");
        String command = "echo --string=\"${TESTSYS} Hello World! This is VMWARE ${TESTSYS}\"";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.assertTrue((boolean)stringResult.contains("SYS_VALUE Hello World! This is VMWARE SYS_VALUE"));
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoWithMultipleVariables failed");
        }
    }

    public void testEchoAllPropertyVariables() {
        String command;
        CommandResult cmdResult;
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        if ((cmdResult = this.executeCommand(command = "echo --string=\"$*\"")) != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoAllPropertyVariables failed");
        }
    }

    public void testEchoForSingleVariable() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        gfshInstance.setEnvProperty("TESTSYS", "SYS_VALUE");
        String command = "echo --string=${TESTSYS}";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.assertTrue((boolean)stringResult.contains("SYS_VALUE"));
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoForSingleVariable failed");
        }
    }

    public void testEchoForSingleVariable2() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testEcho command gfshInstance is null");
        }
        gfshInstance.setEnvProperty("TESTSYS", "SYS_VALUE");
        String command = "echo --string=\"${TESTSYS} ${TESTSYS}\"";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.assertTrue((boolean)stringResult.contains("SYS_VALUE"));
        } else {
            ShellCommandsDUnitTest.fail((String)"testEchoForSingleVariable2 failed");
        }
    }

    public void testDebug() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testDebug command gfshInstance is null");
        }
        gfshInstance.setDebug(false);
        String command = "debug --state=ON";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            ShellCommandsDUnitTest.fail((String)"testDebug failed");
        }
        ShellCommandsDUnitTest.assertEquals((boolean)gfshInstance.getDebug(), (boolean)true);
    }

    public void testHistory() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testHistory command gfshInstance is null");
        }
        gfshInstance.setDebug(false);
        String command = "history";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            ShellCommandsDUnitTest.fail((String)"testHistory failed");
        }
    }

    public void testHistoryWithFileName() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testHistory command gfshInstance is null");
        }
        String historyFileName = gfshInstance.getGfshConfig().getHistoryFileName();
        File historyFile = new File(historyFileName);
        String fileName = historyFile.getParent();
        fileName = fileName + File.separator + this.getClass().getSimpleName() + "_" + this.getName() + "-exported.history";
        String command = "history --file=" + fileName;
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            ShellCommandsDUnitTest.fail((String)"testHistory failed");
        }
    }

    public void testClearHistory() {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            ShellCommandsDUnitTest.fail((String)"In testClearHistory command gfshInstance is null");
        }
        gfshInstance.setDebug(false);
        String command = "history --clear";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            ShellCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            ShellCommandsDUnitTest.getLogWriter().info("testClearHistory cmdResult=" + this.commandResultToString(cmdResult));
            String resultString = this.commandResultToString(cmdResult);
            ShellCommandsDUnitTest.getLogWriter().info("testClearHistory resultString=" + resultString);
            ShellCommandsDUnitTest.assertTrue((boolean)resultString.contains("Successfully deleted history"));
            ShellCommandsDUnitTest.assertTrue((gfshInstance.getGfshHistory().getHistoryList().size() <= 1 ? 1 : 0) != 0);
        } else {
            ShellCommandsDUnitTest.fail((String)"testClearHistory failed");
        }
    }
}

