/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.internal.lang.ThreadUtils;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.commands.GemfireDataCommandsDUnitTest;
import com.gemstone.gemfire.management.internal.cli.commands.MiscellaneousCommands;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.List;
import java.util.Properties;
import management.cli.TestableGfsh;

public class MiscellaneousCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;

    public MiscellaneousCommandsDUnitTest(String name) {
        super(name);
    }

    public void testGCForGroup() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        String command = "gc --group=Group1";
        CommandResult cmdResult = this.executeCommand(command);
        cmdResult.resetToFirstLine();
        if (cmdResult != null) {
            String cmdResultStr = this.commandResultToString(cmdResult);
            MiscellaneousCommandsDUnitTest.getLogWriter().info("testGCForGroup cmdResultStr=" + cmdResultStr);
            MiscellaneousCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            if (cmdResult.getType().equals("table")) {
                TabularResultData table = (TabularResultData)cmdResult.getResultData();
                List memberNames = table.retrieveAllValues("Member ID/Name");
                MiscellaneousCommandsDUnitTest.assertEquals((boolean)true, (memberNames.size() == 1 ? 1 : 0) != 0);
            } else {
                MiscellaneousCommandsDUnitTest.fail((String)"testGCForGroup failed as CommandResult should be table type");
            }
        } else {
            MiscellaneousCommandsDUnitTest.fail((String)"testGCForGroup failed as did not get CommandResult");
        }
    }

    public static String getMemberId() {
        Cache cache = new GemfireDataCommandsDUnitTest("test").getCache();
        return cache.getDistributedSystem().getDistributedMember().getId();
    }

    public void testGCForMemberID() {
        this.createDefaultSetup(null);
        VM vm1 = Host.getHost(0).getVM(1);
        String vm1MemberId = (String)vm1.invoke(MiscellaneousCommandsDUnitTest.class, "getMemberId");
        String command = "gc --member=" + vm1MemberId;
        CommandResult cmdResult = this.executeCommand(command);
        cmdResult.resetToFirstLine();
        if (cmdResult != null) {
            String cmdResultStr = this.commandResultToString(cmdResult);
            MiscellaneousCommandsDUnitTest.getLogWriter().info("testGCForMemberID cmdResultStr=" + cmdResultStr);
            MiscellaneousCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            if (cmdResult.getType().equals("table")) {
                TabularResultData table = (TabularResultData)cmdResult.getResultData();
                List memberNames = table.retrieveAllValues("Member ID/Name");
                MiscellaneousCommandsDUnitTest.assertEquals((boolean)true, (memberNames.size() == 1 ? 1 : 0) != 0);
            } else {
                MiscellaneousCommandsDUnitTest.fail((String)"testGCForGroup failed as CommandResult should be table type");
            }
        } else {
            MiscellaneousCommandsDUnitTest.fail((String)"testGCForCluster failed as did not get CommandResult");
        }
    }

    public void testShowLogDefault() {
        this.createDefaultSetup(null);
        VM vm1 = Host.getHost(0).getVM(0);
        String vm1MemberId = (String)vm1.invoke(MiscellaneousCommandsDUnitTest.class, "getMemberId");
        String command = "show log --member=" + vm1MemberId;
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String log = this.commandResultToString(cmdResult);
            MiscellaneousCommandsDUnitTest.assertNotNull((Object)log);
            MiscellaneousCommandsDUnitTest.getLogWriter().info("Show Log is" + log);
            MiscellaneousCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            MiscellaneousCommandsDUnitTest.fail((String)"testShowLog failed as did not get CommandResult");
        }
    }

    public void testShowLogNumLines() {
        this.createDefaultSetup(null);
        VM vm1 = Host.getHost(0).getVM(0);
        String vm1MemberId = (String)vm1.invoke(MiscellaneousCommandsDUnitTest.class, "getMemberId");
        String command = "show log --member=" + vm1MemberId + " --lines=50";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String log = this.commandResultToString(cmdResult);
            MiscellaneousCommandsDUnitTest.assertNotNull((Object)log);
            MiscellaneousCommandsDUnitTest.getLogWriter().info("Show Log is" + log);
            MiscellaneousCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            MiscellaneousCommandsDUnitTest.fail((String)"testShowLog failed as did not get CommandResult");
        }
    }

    public void testGCForEntireCluster() {
        this.setupForGC();
        String command = "gc";
        CommandResult cmdResult = this.executeCommand(command);
        cmdResult.resetToFirstLine();
        if (cmdResult != null) {
            String cmdResultStr = this.commandResultToString(cmdResult);
            MiscellaneousCommandsDUnitTest.getLogWriter().info("testGCForEntireCluster cmdResultStr=" + cmdResultStr);
            MiscellaneousCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            if (cmdResult.getType().equals("table")) {
                TabularResultData table = (TabularResultData)cmdResult.getResultData();
                List memberNames = table.retrieveAllValues("Member ID/Name");
                MiscellaneousCommandsDUnitTest.assertEquals((boolean)true, (memberNames.size() == 2 ? 1 : 0) != 0);
            } else {
                MiscellaneousCommandsDUnitTest.fail((String)"testGCForGroup failed as CommandResult should be table type");
            }
        } else {
            MiscellaneousCommandsDUnitTest.fail((String)"testGCForGroup failed as did not get CommandResult");
        }
    }

    void setupForGC() {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = MiscellaneousCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create("testRegion");
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    public void testShutDownWithoutTimeout() {
        this.setupForShutDown();
        ThreadUtils.sleep((long)2500L);
        MiscellaneousCommands misc = new MiscellaneousCommands();
        Result result = misc.executeFunction(this.getCache(), -1L);
        MiscellaneousCommandsDUnitTest.getLogWriter().info("testShutDownWithoutTimeout result=" + result);
        this.verifyShutDown();
        final TestableGfsh defaultShell = this.getDefaultShell();
        MiscellaneousCommandsDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !defaultShell.isConnectedAndReady();
            }

            @Override
            public String description() {
                return "Waits for the shell to disconnect!";
            }
        }, 1000L, 250L, true);
        MiscellaneousCommandsDUnitTest.assertFalse((boolean)defaultShell.isConnectedAndReady());
    }

    public void testShutDownForTIMEOUT() {
        this.setupForShutDown();
        ThreadUtils.sleep((long)2500L);
        MiscellaneousCommands misc = new MiscellaneousCommands();
        Result result = misc.executeFunction(this.getCache(), 1L);
        MiscellaneousCommandsDUnitTest.getLogWriter().info("testShutDownForTIMEOUT result=" + result);
        this.verifyShutDown();
        final TestableGfsh defaultShell = this.getDefaultShell();
        MiscellaneousCommandsDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !defaultShell.isConnectedAndReady();
            }

            @Override
            public String description() {
                return "Waits for the shell to disconnect!";
            }
        }, 1000L, 250L, false);
        MiscellaneousCommandsDUnitTest.assertFalse((boolean)defaultShell.isConnectedAndReady());
    }

    void setupForShutDown() {
        VM vm0 = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = MiscellaneousCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create("testRegion");
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    void verifyShutDown() {
        final VM vm0 = Host.getHost(0).getVM(0);
        final VM vm1 = Host.getHost(0).getVM(1);
        final SerializableCallable connectedChecker = new SerializableCallable(){

            public Object call() throws Exception {
                boolean cacheExists = true;
                try {
                    Cache cacheInstance = CacheFactory.getAnyInstance();
                    cacheExists = cacheInstance.getDistributedSystem().isConnected();
                }
                catch (CacheClosedException e) {
                    cacheExists = false;
                }
                return cacheExists;
            }
        };
        DistributedTestCase.WaitCriterion waitCriterion = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return Boolean.FALSE.equals(vm0.invoke(connectedChecker)) && Boolean.FALSE.equals(vm1.invoke(connectedChecker));
            }

            @Override
            public String description() {
                return "Wait for gfsh to get disconnected from Manager.";
            }
        };
        MiscellaneousCommandsDUnitTest.waitForCriterion(waitCriterion, 5000L, 200L, true);
        MiscellaneousCommandsDUnitTest.assertEquals((String)("Connected cache still exists in vm1: " + vm1), (Object)Boolean.FALSE, (Object)vm1.invoke(connectedChecker));
        MiscellaneousCommandsDUnitTest.assertEquals((String)("Connected cache still exists in vm0: " + vm0), (Object)Boolean.FALSE, (Object)vm0.invoke(connectedChecker));
    }
}

