/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import java.util.Properties;
import junit.framework.TestCase;

public class FunctionCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    private static final String REGION_NAME = "FunctionCommandsReplicatedRegion";

    public FunctionCommandsDUnitTest(String name) {
        super(name);
    }

    void setupWith2Regions() {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        this.createDefaultSetup(null);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int i;
                TestFunction function = new TestFunction(true, "TestFunction1");
                FunctionService.registerFunction((Function)function);
                Cache cache = FunctionCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create("RegionOne");
                for (i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
                region = dataRegionFactory.create("RegionTwo");
                for (i = 0; i < 1000; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                int i;
                TestFunction function = new TestFunction(true, "TestFunction1");
                FunctionService.registerFunction((Function)function);
                Cache cache = FunctionCommandsDUnitTest.this.getCache();
                RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = dataRegionFactory.create("RegionOne");
                for (i = 0; i < 10000; ++i) {
                    region.put((Object)("key" + (i + 400)), (Object)("value" + (i + 400)));
                }
                region = dataRegionFactory.create("Regiontwo");
                for (i = 0; i < 10; ++i) {
                    region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
                }
            }
        });
    }

    public void disable_testExecuteFunctionWithNoRegionOnManager() {
        this.setupWith2Regions();
        TestFunction function = new TestFunction(true, "TestFunction1");
        FunctionService.registerFunction((Function)function);
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestFunction function = new TestFunction(true, "TestFunction1");
                FunctionService.registerFunction((Function)function);
            }
        });
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String command = "execute function --id=" + function.getId() + " --region=/RegionOne";
        Log.getLogWriter().info("testExecuteFunctionWithNoRegionOnManager command : " + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testExecuteFunctionWithNoRegionOnManager stringResult : " + strCmdResult);
            FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            FunctionCommandsDUnitTest.assertTrue((boolean)strCmdResult.contains("Execution summary"));
        } else {
            FunctionCommandsDUnitTest.fail((String)"testExecuteFunctionWithNoRegionOnManager failed as did not get CommandResult");
        }
    }

    public static String getMemberId() {
        Cache cache = new FunctionCommandsDUnitTest("test").getCache();
        return cache.getDistributedSystem().getDistributedMember().getId();
    }

    public void testExecuteFunctionOnRegion() {
        this.createDefaultSetup(null);
        TestFunction function = new TestFunction(true, "TestFunction1");
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable((Function)function){
            final /* synthetic */ Function val$function;
            {
                this.val$function = function;
            }

            @Override
            public void run() {
                RegionFactory dataRegionFactory = FunctionCommandsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create(FunctionCommandsDUnitTest.REGION_NAME);
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)this.val$function);
            }
        });
        String command = "execute function --id=" + function.getId() + " --region=" + REGION_NAME;
        Log.getLogWriter().info("testExecuteFunctionOnRegion command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            Log.getLogWriter().info("testExecuteFunctionOnRegion cmdResult=" + cmdResult);
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testExecuteFunctionOnRegion stringResult=" + stringResult);
            assert (stringResult.contains("Execution summary"));
        } else {
            FunctionCommandsDUnitTest.fail((String)"testExecuteFunctionOnRegion did not return CommandResult");
        }
    }

    public void testExecuteFunctionOnMember() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        TestFunction function = new TestFunction(true, "TestFunction1");
        FunctionService.registerFunction((Function)function);
        VM vm1 = Host.getHost(0).getVM(1);
        String vm1MemberId = (String)vm1.invoke(FunctionCommandsDUnitTest.class, "getMemberId");
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionFactory dataRegionFactory = FunctionCommandsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create(FunctionCommandsDUnitTest.REGION_NAME);
                TestFunction function = new TestFunction(true, "TestFunction1");
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)function);
            }
        });
        String command = "execute function --id=" + function.getId() + " --member=" + vm1MemberId;
        Log.getLogWriter().info("testExecuteFunctionOnMember command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        Log.getLogWriter().info("testExecuteFunctionOnMember stringResult:" + stringResult);
        FunctionCommandsDUnitTest.assertTrue((boolean)stringResult.contains("Execution summary"));
    }

    public void testExecuteFunctionOnMembers() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        TestFunction function = new TestFunction(true, "TestFunction1");
        FunctionService.registerFunction((Function)function);
        VM vm1 = Host.getHost(0).getVM(1);
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionFactory dataRegionFactory = FunctionCommandsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create(FunctionCommandsDUnitTest.REGION_NAME);
                TestFunction function = new TestFunction(true, "TestFunction1");
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)function);
            }
        });
        String command = "execute function --id=" + function.getId();
        Log.getLogWriter().info("testExecuteFunctionOnMembers command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            Log.getLogWriter().info("testExecuteFunctionOnMembers cmdResult:" + cmdResult);
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testExecuteFunctionOnMembers stringResult:" + stringResult);
            FunctionCommandsDUnitTest.assertTrue((boolean)stringResult.contains("Execution summary"));
        } else {
            FunctionCommandsDUnitTest.fail((String)"testExecuteFunctionOnMembers did not return CommandResult");
        }
    }

    public void testExecuteFunctionOnMembersWithArgs() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        TestFunction function = new TestFunction(true, "executeFunctionToReturnArgs");
        FunctionService.registerFunction((Function)function);
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionFactory dataRegionFactory = FunctionCommandsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create(FunctionCommandsDUnitTest.REGION_NAME);
                TestFunction function = new TestFunction(true, "executeFunctionToReturnArgs");
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)function);
            }
        });
        String command = "execute function --id=" + function.getId() + " --arguments=arg1,arg2";
        Log.getLogWriter().info("testExecuteFunctionOnMembersWithArgs command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            Log.getLogWriter().info("testExecuteFunctionOnMembersWithArgs cmdResult:" + cmdResult);
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testExecuteFunctionOnMembersWithArgs stringResult:" + stringResult);
            FunctionCommandsDUnitTest.assertTrue((boolean)stringResult.contains("Execution summary"));
            FunctionCommandsDUnitTest.assertTrue((boolean)stringResult.contains("arg1"));
        } else {
            FunctionCommandsDUnitTest.fail((String)"testExecuteFunctionOnMembersWithArgs did not return CommandResult");
        }
    }

    public void testExecuteFunctionOnGroup() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        TestFunction function = new TestFunction(true, "TestFunction1");
        FunctionService.registerFunction((Function)function);
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionFactory dataRegionFactory = FunctionCommandsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                Region region = dataRegionFactory.create(FunctionCommandsDUnitTest.REGION_NAME);
                TestFunction function = new TestFunction(true, "TestFunction1");
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)function);
            }
        });
        String command = "execute function --id=" + function.getId() + " --group=Group1";
        Log.getLogWriter().info("testExecuteFunctionOnGroup command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        Log.getLogWriter().info("testExecuteFunctionOnGroup stringResult:" + stringResult);
        assert (stringResult.contains("Execution summary"));
    }

    public void testDestroyOnMember() {
        this.createDefaultSetup(null);
        TestFunction function = new TestFunction(true, "TestFunction1");
        FunctionService.registerFunction((Function)function);
        VM vm1 = Host.getHost(0).getVM(1);
        String vm1MemberId = (String)vm1.invoke(FunctionCommandsDUnitTest.class, "getMemberId");
        String command = "destroy function --id=" + function.getId() + " --member=" + vm1MemberId;
        Log.getLogWriter().info("testDestroyOnMember command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            Log.getLogWriter().info("testDestroyOnMember strCmdResult=" + strCmdResult);
            FunctionCommandsDUnitTest.assertTrue((boolean)strCmdResult.contains("Destroyed TestFunction1 Successfully"));
        } else {
            FunctionCommandsDUnitTest.fail((String)"testDestroyOnMember failed as did not get CommandResult");
        }
    }

    public void testDestroyOnGroup() {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        TestFunction function = new TestFunction(true, "TestFunction1");
        FunctionService.registerFunction((Function)function);
        String command = "destroy function --id=" + function.getId() + " --group=Group1";
        Log.getLogWriter().info("testDestroyOnGroup command : " + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testDestroyOnGroup stringResult : " + strCmdResult + ">>>>");
            FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            FunctionCommandsDUnitTest.assertTrue((boolean)strCmdResult.contains("Destroyed TestFunction1 Successfully"));
        } else {
            FunctionCommandsDUnitTest.fail((String)"testDestroyOnGroup failed as did not get CommandResult");
        }
    }

    public void testListFunction() {
        Properties localProps = new Properties();
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        CommandResult cmdResult = this.executeCommand("list functions");
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        FunctionCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No Functions Found"));
        TestFunction function1 = new TestFunction(true, "TestFunction1");
        VM managerVm = Host.getHost(0).getVM(0);
        managerVm.invoke(new SerializableRunnable((Function)function1){
            final /* synthetic */ Function val$function1;
            {
                this.val$function1 = function;
            }

            @Override
            public void run() {
                FunctionService.registerFunction((Function)this.val$function1);
            }
        });
        TestFunction function2 = new TestFunction(true, "TestFunction2");
        TestFunction function3 = new TestFunction(true, "TestFunction3");
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        vm1.invoke(new SerializableRunnable((Function)function2, (Function)function3){
            final /* synthetic */ Function val$function2;
            final /* synthetic */ Function val$function3;
            {
                this.val$function2 = function;
                this.val$function3 = function2;
            }

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                localProps.setProperty("groups", "Group2");
                FunctionCommandsDUnitTest.this.getSystem(localProps);
                FunctionCommandsDUnitTest.this.getCache();
                FunctionService.registerFunction((Function)this.val$function2);
                FunctionService.registerFunction((Function)this.val$function3);
            }
        });
        TestFunction function4 = new TestFunction(true, "TestFunction4");
        TestFunction function5 = new TestFunction(true, "TestFunction5");
        TestFunction function6 = new TestFunction(true, "TestFunction6");
        VM vm2 = Host.getHost(0).getVM(2);
        final String vm2Name = "VM" + vm2.getPid();
        vm2.invoke(new SerializableRunnable((Function)function4, (Function)function5, (Function)function6){
            final /* synthetic */ Function val$function4;
            final /* synthetic */ Function val$function5;
            final /* synthetic */ Function val$function6;
            {
                this.val$function4 = function;
                this.val$function5 = function2;
                this.val$function6 = function3;
            }

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", vm2Name);
                localProps.setProperty("groups", "Group3");
                FunctionCommandsDUnitTest.this.getSystem(localProps);
                FunctionCommandsDUnitTest.this.getCache();
                FunctionService.registerFunction((Function)this.val$function4);
                FunctionService.registerFunction((Function)this.val$function5);
                FunctionService.registerFunction((Function)this.val$function6);
            }
        });
        cmdResult = this.executeCommand("list functions");
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        FunctionCommandsDUnitTest.assertEquals((int)8, (int)this.countLinesInString(stringResult, false));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*Function"));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*" + function1.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + function2.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + function3.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function4.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function5.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function6.getId()));
        cmdResult = this.executeCommand("list functions --group=Group1,Group3");
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        FunctionCommandsDUnitTest.assertEquals((int)6, (int)this.countLinesInString(stringResult, false));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*Function"));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*" + function1.getId()));
        FunctionCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm1Name + ".*"));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function4.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function5.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function6.getId()));
        cmdResult = this.executeCommand("list functions --member=Manager," + vm1Name);
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        FunctionCommandsDUnitTest.assertEquals((int)5, (int)this.countLinesInString(stringResult, false));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*Function"));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*" + function1.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + function2.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + function3.getId()));
        FunctionCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*"));
        cmdResult = this.executeCommand("list functions --matches=.*[135]$");
        FunctionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        FunctionCommandsDUnitTest.assertEquals((int)5, (int)this.countLinesInString(stringResult, false));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Member.*Function"));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*" + function1.getId()));
        FunctionCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function2.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + function3.getId()));
        FunctionCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function4.getId()));
        FunctionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function5.getId()));
        FunctionCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + function6.getId()));
    }
}

