/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.TestCase;
import org.junit.Test;

public class DiskStoreCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    final List<String> filesToBeDeleted = new CopyOnWriteArrayList<String>();

    public DiskStoreCommandsDUnitTest(String testName) {
        super(testName);
    }

    @Test
    public void testMissingDiskStore() {
        String regionName = "testShowMissingDiskStoreRegion";
        this.createDefaultSetup(null);
        VM vm0 = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        String diskStoreName = "DiskStoreCommandsDUnitTest";
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                DiskStoreCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
            }
        });
        for (final VM vm : new VM[]{vm0, vm1}) {
            String vmName = "VM" + vm.getPid();
            vm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                    File diskStoreDirFile = new File("DiskStoreCommandsDUnitTest" + vm.getPid());
                    diskStoreDirFile.mkdirs();
                    DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
                    diskStoreFactory.setDiskDirs(new File[]{diskStoreDirFile});
                    diskStoreFactory.setMaxOplogSize(1L);
                    diskStoreFactory.setAllowForceCompaction(true);
                    diskStoreFactory.setAutoCompact(false);
                    diskStoreFactory.create("testShowMissingDiskStoreRegion");
                    RegionFactory regionFactory = cache.createRegionFactory();
                    regionFactory.setDiskStoreName("testShowMissingDiskStoreRegion");
                    regionFactory.setDiskSynchronous(true);
                    regionFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    regionFactory.setScope(Scope.DISTRIBUTED_ACK);
                    regionFactory.create("testShowMissingDiskStoreRegion");
                }
            });
        }
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion("testShowMissingDiskStoreRegion");
                region.put((Object)"A", (Object)"B");
            }
        });
        CommandResult cmdResult = this.executeCommand("show missing-disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No missing disk store found"));
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion("testShowMissingDiskStoreRegion");
                region.close();
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion("testShowMissingDiskStoreRegion");
                region.put((Object)"A", (Object)"C");
                region.close();
            }
        });
        vm0.invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory();
                regionFactory.setDiskStoreName("testShowMissingDiskStoreRegion");
                regionFactory.setDiskSynchronous(true);
                regionFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                regionFactory.setScope(Scope.DISTRIBUTED_ACK);
                regionFactory.create("testShowMissingDiskStoreRegion");
            }
        });
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.WaitCriterion waitCriterion = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                        PersistentMemberManager memberManager = ((GemFireCacheImpl)cache).getPersistentMemberManager();
                        return !memberManager.getWaitingRegions().isEmpty();
                    }

                    @Override
                    public String description() {
                        return "Waiting for another persistent member to come online";
                    }
                };
                DistributedTestCase.waitForCriterion(waitCriterion, 70000L, 100L, true);
            }
        });
        cmdResult = this.executeCommand("show missing-disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Disk Store ID.*Host.*Directory"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, ".*DiskStoreCommandsDUnitTest" + vm1.getPid()));
        StringTokenizer resultTokenizer = new StringTokenizer(this.getLineFromString(stringResult, 3));
        String id = resultTokenizer.nextToken();
        cmdResult = this.executeCommand("revoke missing-disk-store --id=" + id);
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("Missing disk store successfully revoked"));
        super.destroyDefaultSetup();
        for (final VM vm : new VM[]{vm0, vm1}) {
            String vmName = "VM" + vm.getPid();
            vm.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    try {
                        FileUtil.delete((File)new File("DiskStoreCommandsDUnitTest" + vm.getPid()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void testDescribeOfflineDiskStore() {
        this.createDefaultSetup(null);
        final File diskStoreDir = new File(new File(".").getAbsolutePath(), "DiskStoreCommandDUnitDiskStores");
        diskStoreDir.mkdir();
        this.filesToBeDeleted.add(diskStoreDir.getAbsolutePath());
        String diskStoreName1 = "DiskStore1";
        String region1 = "Region1";
        String region2 = "Region2";
        VM vm1 = Host.getHost(0).getVM(1);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
                diskStoreFactory.setDiskDirs(new File[]{diskStoreDir});
                DiskStore diskStore1 = diskStoreFactory.create("DiskStore1");
                TestCase.assertNotNull((Object)diskStore1);
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT);
                regionFactory.setDiskStoreName("DiskStore1");
                regionFactory.setDiskSynchronous(true);
                regionFactory.create("Region1");
                regionFactory.setCompressor((Compressor)SnappyCompressor.getDefaultInstance());
                regionFactory.create("Region2");
                cache.close();
                TestCase.assertTrue((boolean)new File(diskStoreDir, "BACKUPDiskStore1.if").exists());
            }
        });
        CommandResult cmdResult = this.executeCommand("describe offline-disk-store --name=DiskStore1 --disk-dirs=" + diskStoreDir.getAbsolutePath());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, ".*/Region1: -lru=none -concurrencyLevel=16 -initialCapacity=16 -loadFactor=0.75 -compressor=none -statisticsEnabled=false"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, ".*/Region2: -lru=none -concurrencyLevel=16 -initialCapacity=16 -loadFactor=0.75 -compressor=com.gemstone.gemfire.compression.SnappyCompressor -statisticsEnabled=false"));
        cmdResult = this.executeCommand("describe offline-disk-store --name=DiskStore1 --disk-dirs=" + diskStoreDir.getAbsolutePath() + " --region=/" + "Region1");
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)2, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, ".*/Region1: .*"));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, ".*/Region2: .*"));
    }

    public void testValidateDiskStore() {
        this.createDefaultSetup(null);
        final File diskStoreDir = new File(new File(".").getAbsolutePath(), "DiskStoreCommandDUnitDiskStores");
        diskStoreDir.mkdir();
        this.filesToBeDeleted.add(diskStoreDir.getAbsolutePath());
        String diskStoreName1 = "DiskStore1";
        String region1 = "Region1";
        String region2 = "Region2";
        VM vm1 = Host.getHost(0).getVM(1);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
                diskStoreFactory.setDiskDirs(new File[]{diskStoreDir});
                DiskStore diskStore1 = diskStoreFactory.create("DiskStore1");
                TestCase.assertNotNull((Object)diskStore1);
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT);
                regionFactory.setDiskStoreName("DiskStore1");
                regionFactory.setDiskSynchronous(true);
                regionFactory.create("Region1");
                regionFactory.create("Region2");
                cache.close();
                TestCase.assertTrue((boolean)new File(diskStoreDir, "BACKUPDiskStore1.if").exists());
            }
        });
        String command = "validate offline-disk-store --name=DiskStore1 --disk-dirs=" + diskStoreDir.getAbsolutePath();
        Log.getLogWriter().info("testValidateDiskStore command" + command);
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            String stringResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testValidateDiskStore cmdResult is stringResult " + stringResult);
            DiskStoreCommandsDUnitTest.assertTrue((boolean)stringResult.contains("Total number of region entries in this disk store is"));
        } else {
            Log.getLogWriter().info("testValidateDiskStore cmdResult is null");
            DiskStoreCommandsDUnitTest.fail((String)"Did not get CommandResult in testValidateDiskStore");
        }
    }

    public void testAlterDiskStore() throws ClassNotFoundException, IOException {
        String regionName = "region1";
        String diskStoreName = "disk-store1";
        String diskDirName = "diskStoreDir";
        File diskStoreDir = new File("diskStoreDir");
        diskStoreDir.deleteOnExit();
        if (!diskStoreDir.exists()) {
            diskStoreDir.mkdir();
        }
        final String diskDirPath = diskStoreDir.getCanonicalPath();
        VM vm1 = Host.getHost(0).getVM(1);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DiskStoreCommandsDUnitTest.this.getSystem();
                Region region = DiskStoreCommandsDUnitTest.this.createParRegWithPersistence("region1", "disk-store1", diskDirPath);
                region.put((Object)"a", (Object)"QWE");
                return region.put((Object)"b", (Object)"ASD");
            }
        });
        DiskStoreCommandsDUnitTest.disconnectAllFromDS();
        this.createDefaultSetup(null);
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) {
            DiskStoreCommandsDUnitTest.fail((String)"In testAlterDiskStore command gfshInstance is null");
        }
        gfshInstance.setDebug(true);
        CommandStringBuilder csb = new CommandStringBuilder("alter disk-store");
        csb.addOption("name", "disk-store1");
        csb.addOption("region", "region1");
        csb.addOption("disk-dirs", diskDirPath);
        csb.addOption("concurrency-level", "5");
        csb.addOption("initial-capacity", "6");
        csb.addOption("lru-action", "local-destroy");
        csb.addOption("compressor", "com.gemstone.gemfire.compression.SnappyCompressor");
        csb.addOption("enable-statistics", "true");
        String commandString = csb.getCommandString();
        commandString.trim();
        CommandResult cmdResult = this.executeCommand(commandString);
        String resultString = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.getLogWriter().info("#SB command output : \n" + resultString);
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultString.contains("concurrencyLevel=5"));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultString.contains("lruAction=local-destroy"));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultString.contains("compressor=com.gemstone.gemfire.compression.SnappyCompressor"));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultString.contains("initialCapacity=6"));
        csb = new CommandStringBuilder("alter disk-store");
        csb.addOption("name", "disk-store1");
        csb.addOption("region", "region1");
        csb.addOption("disk-dirs", diskDirPath);
        csb.addOption("compressor", "none");
        cmdResult = this.executeCommand(csb.getCommandString().trim());
        resultString = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(resultString, "-compressor=none"));
        csb = new CommandStringBuilder("alter disk-store");
        csb.addOption("name", "disk-store1");
        csb.addOption("region", "region1");
        csb.addOption("disk-dirs", diskDirPath);
        csb.addOption("remove", "true");
        commandString = csb.getCommandString();
        commandString.trim();
        cmdResult = this.executeCommand(commandString);
        resultString = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.getLogWriter().info("command output : \n" + resultString);
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)Result.Status.OK.equals((Object)cmdResult.getStatus()));
        Object postDestroyValue = vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DiskStoreCommandsDUnitTest.this.getSystem();
                Region region = DiskStoreCommandsDUnitTest.this.createParRegWithPersistence("region1", "disk-store1", diskDirPath);
                return region.get((Object)"a");
            }
        });
        DiskStoreCommandsDUnitTest.assertNull((Object)postDestroyValue);
        csb = new CommandStringBuilder("alter disk-store");
        csb.addOption("name", "disk-store1");
        csb.addOption("region", "region1");
        csb.addOption("disk-dirs", diskDirPath);
        csb.addOption("concurrency-level", "5");
        csb.addOption("remove", "true");
        commandString = csb.getCommandString();
        commandString.trim();
        cmdResult = this.executeCommand(commandString);
        resultString = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.getLogWriter().info("Alter DiskStore with wrong remove option  : \n" + resultString);
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)Result.Status.ERROR.equals((Object)cmdResult.getStatus()));
        this.filesToBeDeleted.add("diskStoreDir");
    }

    public void testBackupDiskStoreBackup() throws IOException {
        String regionName = "region1";
        String fullBackUpName = "fullBackUp";
        String controllerName = "controller";
        String vm1Name = "vm1";
        String diskStoreName = "diskStore";
        String controllerDiskDirName = "controllerDiskDir";
        String vm1DiskDirName = "vm1DiskDir";
        String incrementalBackUpName = "incrementalBackUp";
        VM manager = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        this.createDefaultSetup(null);
        File controllerDiskDir = new File("controllerDiskDir");
        controllerDiskDir.mkdir();
        final String controllerDiskDirPath = controllerDiskDir.getCanonicalPath();
        this.filesToBeDeleted.add(controllerDiskDirPath);
        File vm1DiskDir = new File("vm1DiskDir");
        vm1DiskDir.mkdir();
        final String vm1DiskDirPath = vm1DiskDir.getCanonicalPath();
        this.filesToBeDeleted.add(vm1DiskDirPath);
        File fullBackupDir = new File("fullBackUp");
        fullBackupDir.mkdir();
        String fullBackupDirPath = fullBackupDir.getCanonicalPath();
        this.filesToBeDeleted.add(fullBackupDirPath);
        Properties props = new Properties();
        props.setProperty("name", "controller");
        this.getSystem(props);
        manager.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = DiskStoreCommandsDUnitTest.this.createParRegWithPersistence("region1", "diskStore", controllerDiskDirPath);
                region.put((Object)"A", (Object)"1");
                region.put((Object)"B", (Object)"2");
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", "vm1");
                DiskStoreCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                Region region = DiskStoreCommandsDUnitTest.this.createParRegWithPersistence("region1", "diskStore", vm1DiskDirPath);
            }
        });
        CommandStringBuilder csb = new CommandStringBuilder("backup disk-store");
        csb.addOption("dir", fullBackupDirPath);
        String commandString = csb.toString();
        CommandResult cmdResult = this.executeCommand(commandString);
        String resultAsString = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.getLogWriter().info("Result from full backup : \n" + resultAsString);
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains("Manager"));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains("vm1"));
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = DiskStoreCommandsDUnitTest.this.getCache().getRegion("region1");
                region.put((Object)"F", (Object)"231");
                region.put((Object)"D", (Object)"ew");
            }
        });
        File incrementalBackUpDir = new File("incrementalBackUp");
        incrementalBackUpDir.mkdir();
        String incrementalBackUpDirPath = incrementalBackUpDir.getCanonicalPath();
        this.filesToBeDeleted.add(incrementalBackUpDirPath);
        csb = new CommandStringBuilder("backup disk-store");
        csb.addOption("dir", incrementalBackUpDirPath);
        csb.addOption("baseline-dir", fullBackupDirPath);
        cmdResult = this.executeCommand(csb.toString());
        resultAsString = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.getLogWriter().info("Result from incremental backup : \n" + resultAsString);
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains("Manager"));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultAsString.contains("vm1"));
    }

    public void testCreateDiskStore() {
        String diskStore1Name = "testCreateDiskStore1";
        String diskStore2Name = "testCreateDiskStore2";
        Properties localProps = new Properties();
        localProps.setProperty("groups", "Group0");
        this.createDefaultSetup(localProps);
        CommandResult cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No Disk Stores Found"));
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        final File diskStore1Dir1 = new File(new File(".").getAbsolutePath(), "testCreateDiskStore1.1");
        this.filesToBeDeleted.add(diskStore1Dir1.getAbsolutePath());
        final File diskStore1Dir2 = new File(new File(".").getAbsolutePath(), "testCreateDiskStore1.2");
        this.filesToBeDeleted.add(diskStore1Dir2.getAbsolutePath());
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                diskStore1Dir1.mkdirs();
                diskStore1Dir2.mkdirs();
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                localProps.setProperty("groups", "Group1");
                DiskStoreCommandsDUnitTest.this.getSystem(localProps);
                DiskStoreCommandsDUnitTest.this.getCache();
            }
        });
        VM vm2 = Host.getHost(0).getVM(2);
        final String vm2Name = "VM" + vm2.getPid();
        final File diskStore2Dir = new File(new File(".").getAbsolutePath(), "testCreateDiskStore2");
        this.filesToBeDeleted.add(diskStore2Dir.getAbsolutePath());
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                diskStore2Dir.mkdirs();
                Properties localProps = new Properties();
                localProps.setProperty("name", vm2Name);
                localProps.setProperty("groups", "Group2");
                DiskStoreCommandsDUnitTest.this.getSystem(localProps);
                DiskStoreCommandsDUnitTest.this.getCache();
            }
        });
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("create disk-store");
        commandStringBuilder.addOption("name", "testCreateDiskStore1");
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("allow-force-compaction", "true");
        commandStringBuilder.addOption("auto-compact", "false");
        commandStringBuilder.addOption("compaction-threshold", "67");
        commandStringBuilder.addOption("max-oplog-size", "355");
        commandStringBuilder.addOption("queue-size", "5321");
        commandStringBuilder.addOption("time-interval", "2023");
        commandStringBuilder.addOption("write-buffer-size", "3110");
        commandStringBuilder.addOption("dir", diskStore1Dir1.getAbsolutePath() + "#1452637463");
        commandStringBuilder.addOption("dir", diskStore1Dir2.getAbsolutePath());
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Success"));
        cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + "testCreateDiskStore1" + " .*"));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testCreateDiskStore1" + " .*"));
        DiskStoreCommandsDUnitTest.assertEquals((int)diskStore1Dir1.listFiles().length, (int)2);
        commandStringBuilder = new CommandStringBuilder("describe disk-store");
        commandStringBuilder.addOption("member", vm1Name);
        commandStringBuilder.addOption("name", "testCreateDiskStore1");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Allow Force Compaction.*Yes"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Auto Compaction.*No"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Compaction Threshold.*67"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Max Oplog Size.*355"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Queue Size.*5321"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Time Interval.*2023"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Write Buffer Size.*3110"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, ".*testCreateDiskStore1.1 .*1452637463"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, ".*testCreateDiskStore1.2 .*2147483647"));
        commandStringBuilder = new CommandStringBuilder("create disk-store");
        commandStringBuilder.addOption("name", "testCreateDiskStore2");
        commandStringBuilder.addOption("group", "Group2");
        commandStringBuilder.addOption("dir", diskStore2Dir.getAbsolutePath());
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*Success"));
        cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + "testCreateDiskStore1" + " .*"));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testCreateDiskStore1" + " .*"));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + "testCreateDiskStore2" + " .*"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testCreateDiskStore2" + " .*"));
    }

    public void testDestroyDiskStore() {
        String diskStore1Name = "testDestroyDiskStore1";
        String diskStore2Name = "testDestroyDiskStore2";
        String region1Name = "testDestroyDiskStoreRegion1";
        String region2Name = "testDestroyDiskStoreRegion2";
        Properties localProps = new Properties();
        localProps.setProperty("groups", "Group0");
        this.createDefaultSetup(localProps);
        CommandResult cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No Disk Stores Found"));
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        final File diskStore1Dir1 = new File(new File(".").getAbsolutePath(), "testDestroyDiskStore1.1");
        this.filesToBeDeleted.add(diskStore1Dir1.getAbsolutePath());
        final File diskStore2Dir1 = new File(new File(".").getAbsolutePath(), "testDestroyDiskStore2.1");
        this.filesToBeDeleted.add(diskStore2Dir1.getAbsolutePath());
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                diskStore1Dir1.mkdirs();
                diskStore2Dir1.mkdirs();
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                localProps.setProperty("groups", "Group1,Group2");
                DiskStoreCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
                diskStoreFactory.setDiskDirs(new File[]{diskStore1Dir1});
                diskStoreFactory.create("testDestroyDiskStore1");
                diskStoreFactory.setDiskDirs(new File[]{diskStore2Dir1});
                diskStoreFactory.create("testDestroyDiskStore2");
            }
        });
        VM vm2 = Host.getHost(0).getVM(2);
        final String vm2Name = "VM" + vm2.getPid();
        final File diskStore1Dir2 = new File(new File(".").getAbsolutePath(), "testDestroyDiskStore1.2");
        this.filesToBeDeleted.add(diskStore1Dir2.getAbsolutePath());
        final File diskStore2Dir2 = new File(new File(".").getAbsolutePath(), "testDestroyDiskStore2.2");
        this.filesToBeDeleted.add(diskStore2Dir2.getAbsolutePath());
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                diskStore1Dir2.mkdirs();
                diskStore2Dir2.mkdirs();
                Properties localProps = new Properties();
                localProps.setProperty("name", vm2Name);
                localProps.setProperty("groups", "Group2");
                DiskStoreCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
                diskStoreFactory.setDiskDirs(new File[]{diskStore1Dir2});
                diskStoreFactory.create("testDestroyDiskStore1");
                RegionFactory regionFactory = cache.createRegionFactory();
                regionFactory.setDiskStoreName("testDestroyDiskStore1");
                regionFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                regionFactory.create("testDestroyDiskStoreRegion1");
                regionFactory.create("testDestroyDiskStoreRegion2");
                diskStoreFactory.setDiskDirs(new File[]{diskStore2Dir2});
                diskStoreFactory.create("testDestroyDiskStore2");
            }
        });
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("destroy disk-store");
        commandStringBuilder.addOption("name", "testDestroyDiskStore1");
        commandStringBuilder.addOption("group", "Group1");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Success"));
        cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)5, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + "testDestroyDiskStore1" + " .*"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testDestroyDiskStore1" + " .*"));
        DiskStoreCommandsDUnitTest.assertEquals((int)0, (int)diskStore1Dir1.listFiles().length);
        DiskStoreCommandsDUnitTest.assertEquals((int)4, (int)diskStore1Dir2.listFiles().length);
        commandStringBuilder = new CommandStringBuilder("destroy disk-store");
        commandStringBuilder.addOption("name", "testDestroyDiskStore2");
        commandStringBuilder.addOption("group", "Group2");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Success"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*Success"));
        cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm1Name + ".*" + "testDestroyDiskStore2" + " .*"));
        DiskStoreCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testDestroyDiskStore2" + " .*"));
        DiskStoreCommandsDUnitTest.assertEquals((int)0, (int)diskStore2Dir1.listFiles().length);
        DiskStoreCommandsDUnitTest.assertEquals((int)0, (int)diskStore2Dir2.listFiles().length);
        commandStringBuilder = new CommandStringBuilder("destroy disk-store");
        commandStringBuilder.addOption("name", "testDestroyDiskStore1");
        commandStringBuilder.addOption("group", "Group2");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Disk store not found on this member"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testDestroyDiskStoreRegion1" + ".*" + "testDestroyDiskStoreRegion2" + ".*"));
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DiskStoreCommandsDUnitTest.this.getCache();
                Region region = cache.getRegion("testDestroyDiskStoreRegion1");
                region.destroyRegion();
                region = cache.getRegion("testDestroyDiskStoreRegion2");
                region.destroyRegion();
            }
        });
        commandStringBuilder = new CommandStringBuilder("destroy disk-store");
        commandStringBuilder.addOption("name", "testDestroyDiskStore1");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        DiskStoreCommandsDUnitTest.assertEquals((int)5, (int)this.countLinesInString(stringResult, false));
        DiskStoreCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*Disk store not found on this member"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Disk store not found on this member"));
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*Success"));
        cmdResult = this.executeCommand("list disk-stores");
        DiskStoreCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        DiskStoreCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No Disk Stores Found"));
        DiskStoreCommandsDUnitTest.assertEquals((int)0, (int)diskStore1Dir2.listFiles().length);
    }

    private Region<?, ?> createParRegWithPersistence(String regionName, String diskStoreName, String diskDirName) {
        Cache cache = this.getCache();
        File diskStoreDirFile = new File(diskDirName);
        if (!diskStoreDirFile.exists()) {
            diskStoreDirFile.mkdirs();
        }
        DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory();
        diskStoreFactory.setDiskDirs(new File[]{diskStoreDirFile});
        diskStoreFactory.setMaxOplogSize(1L);
        diskStoreFactory.setAllowForceCompaction(true);
        diskStoreFactory.setAutoCompact(false);
        diskStoreFactory.create(diskStoreName);
        EvictionAttributes ea = EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDiskStoreName(diskStoreName);
        regionFactory.setDiskSynchronous(true);
        regionFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        regionFactory.setScope(Scope.DISTRIBUTED_ACK);
        regionFactory.setEvictionAttributes(ea);
        return regionFactory.create(regionName);
    }

    @Override
    public void tearDown2() throws Exception {
        for (String path : this.filesToBeDeleted) {
            try {
                FileUtil.delete((File)new File(path));
            }
            catch (IOException e) {
                DiskStoreCommandsDUnitTest.getLogWriter().error("Unable to delete file", (Throwable)e);
            }
        }
        this.filesToBeDeleted.clear();
        super.tearDown2();
    }
}

