/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;
import util.ClassBuilder;

public class CreateAlterDestroyRegionCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    final String alterRegionName = "testAlterRegionRegion";
    final String alterAsyncEventQueueId1 = "testAlterRegionQueue1";
    final String alterAsyncEventQueueId2 = "testAlterRegionQueue2";
    final String alterAsyncEventQueueId3 = "testAlterRegionQueue3";
    final String alterGatewaySenderId1 = "testAlterRegionSender1";
    final String alterGatewaySenderId2 = "testAlterRegionSender2";
    final String alterGatewaySenderId3 = "testAlterRegionSender3";
    VM alterVm1;
    String alterVm1Name;
    VM alterVm2;
    String alterVm2Name;
    final List<String> filesToBeDeleted = new CopyOnWriteArrayList<String>();

    public CreateAlterDestroyRegionCommandsDUnitTest(String name) {
        super(name);
    }

    public void testCreateRegionWithGoodCompressor() {
        this.createDefaultSetup(null);
        VM vm = Host.getHost(0).getVM(1);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertNotNull((Object)CreateAlterDestroyRegionCommandsDUnitTest.this.getCache());
            }
        });
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("create region");
        commandStringBuilder.addOption("name", "compressedRegion");
        commandStringBuilder.addOption("type", "REPLICATE");
        commandStringBuilder.addOption("compressor", "com.gemstone.gemfire.compression.SnappyCompressor");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("compressedRegion");
                TestCase.assertNotNull((Object)region);
                TestCase.assertTrue((boolean)SnappyCompressor.getDefaultInstance().equals((Object)region.getAttributes().getCompressor()));
            }
        });
        commandStringBuilder = new CommandStringBuilder("destroy region");
        commandStringBuilder.addOption("name", "compressedRegion");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
    }

    public void testCreateRegionWithBadCompressor() {
        this.createDefaultSetup(null);
        VM vm = Host.getHost(0).getVM(1);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertNotNull((Object)CreateAlterDestroyRegionCommandsDUnitTest.this.getCache());
            }
        });
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("create region");
        commandStringBuilder.addOption("name", "compressedRegion");
        commandStringBuilder.addOption("type", "REPLICATE");
        commandStringBuilder.addOption("compressor", "BAD_COMPRESSOR");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("compressedRegion");
                TestCase.assertNull((Object)region);
            }
        });
    }

    public void testCreateRegionWithNoCompressor() {
        this.createDefaultSetup(null);
        VM vm = Host.getHost(0).getVM(1);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertNotNull((Object)CreateAlterDestroyRegionCommandsDUnitTest.this.getCache());
            }
        });
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("create region");
        commandStringBuilder.addOption("name", "testRegion");
        commandStringBuilder.addOption("type", "REPLICATE");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testRegion");
                TestCase.assertNotNull((Object)region);
                TestCase.assertNull((Object)region.getAttributes().getCompressor());
            }
        });
        commandStringBuilder = new CommandStringBuilder("destroy region");
        commandStringBuilder.addOption("name", "testRegion");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
    }

    public void testDestroyRegion() {
        this.createDefaultSetup(null);
        for (int i = 1; i <= 2; ++i) {
            Host.getHost(0).getVM(i).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache();
                    RegionFactory factory = cache.createRegionFactory(RegionShortcut.PARTITION);
                    factory.create("Customer");
                    PartitionAttributesFactory paFactory = new PartitionAttributesFactory();
                    paFactory.setColocatedWith("Customer");
                    factory.setPartitionAttributes(paFactory.create());
                    factory.create("Order");
                }
            });
        }
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        try {
                            MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
                            String queryExp = MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", "/Customer", "*");
                            ObjectName queryExpON = new ObjectName(queryExp);
                            return !mbeanServer.queryNames(null, queryExpON).isEmpty();
                        }
                        catch (MalformedObjectNameException mone) {
                            DistributedTestCase.getLogWriter().error((Throwable)mone);
                            TestCase.fail((String)mone.getMessage());
                            return false;
                        }
                    }

                    @Override
                    public String description() {
                        return "Waiting for the region to be registed with the MXBean";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 5000L, 500L, true);
            }
        });
        String command = "destroy region --name=DOESNOTEXIST";
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion command=" + command);
        CommandResult cmdResult = this.executeCommand(command);
        String strr = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion strr=" + strr);
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(strr, "Could not find.*\"DOESNOTEXIST\".*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
        command = "destroy region --name=/Customer";
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion command=" + command);
        cmdResult = this.executeCommand(command);
        strr = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion strr=" + strr);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
        command = "destroy region --name=/Order";
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion command=" + command);
        cmdResult = this.executeCommand(command);
        strr = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(strr, ".*Order.*destroyed successfully.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion strr=" + strr);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        command = "destroy region --name=/Customer";
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion command=" + command);
        cmdResult = this.executeCommand(command);
        strr = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(strr, ".*Customer.*destroyed successfully.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().info("testDestroyRegion strr=" + strr);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
    }

    public void testAlterRegion() throws IOException {
        this.createDefaultSetup(null);
        CommandResult cmdResult = this.executeCommand("list regions");
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No Regions Found"));
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache();
                cache.createRegionFactory(RegionShortcut.PARTITION).setStatisticsEnabled(true).create("testAlterRegionRegion");
            }
        });
        this.alterVm1 = Host.getHost(0).getVM(1);
        this.alterVm1Name = "VM" + this.alterVm1.getPid();
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", CreateAlterDestroyRegionCommandsDUnitTest.this.alterVm1Name);
                localProps.setProperty("groups", "Group1");
                CreateAlterDestroyRegionCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache();
                cache.createRegionFactory(RegionShortcut.PARTITION).setStatisticsEnabled(true).create("testAlterRegionRegion");
                AsyncEventListener<Object, Object> listener = new AsyncEventListener<Object, Object>(){

                    public void close() {
                    }

                    public boolean processEvents(List<AsyncEvent<Object, Object>> events) {
                        return true;
                    }
                };
                cache.createAsyncEventQueueFactory().create("testAlterRegionQueue1", (AsyncEventListener)listener);
                cache.createAsyncEventQueueFactory().create("testAlterRegionQueue2", (AsyncEventListener)listener);
                cache.createAsyncEventQueueFactory().create("testAlterRegionQueue3", (AsyncEventListener)listener);
                GatewaySenderFactory gatewaySenderFactory = cache.createGatewaySenderFactory();
                gatewaySenderFactory.setManualStart(true);
                gatewaySenderFactory.create("testAlterRegionSender1", 2);
                gatewaySenderFactory.create("testAlterRegionSender2", 3);
                gatewaySenderFactory.create("testAlterRegionSender3", 4);
            }
        });
        this.alterVm2 = Host.getHost(0).getVM(2);
        this.alterVm2Name = "VM" + this.alterVm2.getPid();
        this.alterVm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", CreateAlterDestroyRegionCommandsDUnitTest.this.alterVm2Name);
                localProps.setProperty("groups", "Group1,Group2");
                CreateAlterDestroyRegionCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache();
                cache.createRegionFactory(RegionShortcut.PARTITION).setStatisticsEnabled(true).create("testAlterRegionRegion");
            }
        });
        this.deployJarFilesForRegionAlter();
        this.regionAlterGroupTest();
        this.regionAlterSetAllTest();
        this.regionAlterNoChangeTest();
        this.regionAlterSetDefaultsTest();
        this.regionAlterManipulatePlugInsTest();
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").destroyRegion();
            }
        });
    }

    private void regionAlterGroupTest() {
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", this.alterRegionName);
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("eviction-max", "5764");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)5764, (int)attributes.getEvictionAttributes().getMaximum());
            }
        });
        this.alterVm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)5764, (int)attributes.getEvictionAttributes().getMaximum());
            }
        });
        commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("group", "Group2");
        commandStringBuilder.addOption("eviction-max", "6963");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)5764, (int)attributes.getEvictionAttributes().getMaximum());
            }
        });
        this.alterVm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)6963, (int)attributes.getEvictionAttributes().getMaximum());
            }
        });
    }

    private void regionAlterSetAllTest() {
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("eviction-max", "35464");
        commandStringBuilder.addOption("enable-cloning", "true");
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId1);
        commandStringBuilder.addOption("entry-idle-time-expiration", "3453");
        commandStringBuilder.addOption("entry-idle-time-expiration-action", "DESTROY");
        commandStringBuilder.addOption("entry-time-to-live-expiration", "7563");
        commandStringBuilder.addOption("entry-time-to-live-expiration-action", "DESTROY");
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerA");
        commandStringBuilder.addOption("cache-loader", "com.cadrdunit.RegionAlterCacheLoader");
        commandStringBuilder.addOption("cache-writer", "com.cadrdunit.RegionAlterCacheWriter");
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId1);
        commandStringBuilder.addOption("region-idle-time-expiration", "6234");
        commandStringBuilder.addOption("region-idle-time-expiration-action", "DESTROY");
        commandStringBuilder.addOption("region-time-to-live-expiration", "4562");
        commandStringBuilder.addOption("region-time-to-live-expiration-action", "DESTROY");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)5, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)35464, (int)attributes.getEvictionAttributes().getMaximum());
                TestCase.assertEquals((int)3453, (int)attributes.getEntryIdleTimeout().getTimeout());
                TestCase.assertTrue((boolean)attributes.getEntryIdleTimeout().getAction().isDestroy());
                TestCase.assertEquals((int)7563, (int)attributes.getEntryTimeToLive().getTimeout());
                TestCase.assertTrue((boolean)attributes.getEntryTimeToLive().getAction().isDestroy());
                TestCase.assertEquals((int)6234, (int)attributes.getRegionIdleTimeout().getTimeout());
                TestCase.assertTrue((boolean)attributes.getRegionIdleTimeout().getAction().isDestroy());
                TestCase.assertEquals((int)4562, (int)attributes.getRegionTimeToLive().getTimeout());
                TestCase.assertTrue((boolean)attributes.getRegionTimeToLive().getAction().isDestroy());
                TestCase.assertEquals((int)1, (int)attributes.getAsyncEventQueueIds().size());
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue1"));
                TestCase.assertEquals((int)1, (int)attributes.getGatewaySenderIds().size());
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender1"));
                TestCase.assertEquals((int)1, (int)attributes.getCacheListeners().length);
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerA", (String)attributes.getCacheListeners()[0].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheWriter", (String)attributes.getCacheWriter().getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheLoader", (String)attributes.getCacheLoader().getClass().getName());
            }
        });
    }

    private void regionAlterNoChangeTest() {
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("enable-cloning", "true");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)35464, (int)attributes.getEvictionAttributes().getMaximum());
                TestCase.assertEquals((int)3453, (int)attributes.getEntryIdleTimeout().getTimeout());
                TestCase.assertTrue((boolean)attributes.getEntryIdleTimeout().getAction().isDestroy());
                TestCase.assertEquals((int)7563, (int)attributes.getEntryTimeToLive().getTimeout());
                TestCase.assertTrue((boolean)attributes.getEntryTimeToLive().getAction().isDestroy());
                TestCase.assertEquals((int)6234, (int)attributes.getRegionIdleTimeout().getTimeout());
                TestCase.assertTrue((boolean)attributes.getRegionIdleTimeout().getAction().isDestroy());
                TestCase.assertEquals((int)4562, (int)attributes.getRegionTimeToLive().getTimeout());
                TestCase.assertTrue((boolean)attributes.getRegionTimeToLive().getAction().isDestroy());
                TestCase.assertEquals((int)1, (int)attributes.getAsyncEventQueueIds().size());
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue1"));
                TestCase.assertEquals((int)1, (int)attributes.getGatewaySenderIds().size());
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender1"));
                TestCase.assertEquals((int)1, (int)attributes.getCacheListeners().length);
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerA", (String)attributes.getCacheListeners()[0].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheWriter", (String)attributes.getCacheWriter().getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheLoader", (String)attributes.getCacheLoader().getClass().getName());
            }
        });
    }

    private void regionAlterSetDefaultsTest() {
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("eviction-max");
        commandStringBuilder.addOption("enable-cloning");
        commandStringBuilder.addOption("async-event-queue-id");
        commandStringBuilder.addOption("entry-idle-time-expiration");
        commandStringBuilder.addOption("entry-time-to-live-expiration-action");
        commandStringBuilder.addOption("cache-listener");
        commandStringBuilder.addOption("cache-loader");
        commandStringBuilder.addOption("cache-writer");
        commandStringBuilder.addOption("gateway-sender-id");
        commandStringBuilder.addOption("region-idle-time-expiration");
        commandStringBuilder.addOption("region-idle-time-expiration-action");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        String stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)0, (int)attributes.getEvictionAttributes().getMaximum());
                TestCase.assertEquals((int)0, (int)attributes.getEntryIdleTimeout().getTimeout());
                TestCase.assertTrue((boolean)attributes.getEntryIdleTimeout().getAction().isDestroy());
                TestCase.assertEquals((int)7563, (int)attributes.getEntryTimeToLive().getTimeout());
                TestCase.assertTrue((boolean)attributes.getEntryTimeToLive().getAction().isInvalidate());
                TestCase.assertEquals((int)0, (int)attributes.getRegionIdleTimeout().getTimeout());
                TestCase.assertTrue((boolean)attributes.getRegionIdleTimeout().getAction().isInvalidate());
                TestCase.assertEquals((int)4562, (int)attributes.getRegionTimeToLive().getTimeout());
                TestCase.assertTrue((boolean)attributes.getRegionTimeToLive().getAction().isDestroy());
                TestCase.assertEquals((int)0, (int)attributes.getAsyncEventQueueIds().size());
                TestCase.assertEquals((int)0, (int)attributes.getGatewaySenderIds().size());
                TestCase.assertEquals((int)0, (int)attributes.getCacheListeners().length);
            }
        });
    }

    private void regionAlterManipulatePlugInsTest() {
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId1);
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId2);
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId3);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId1);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId2);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId3);
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerA");
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerB");
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerC");
        CommandResult cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)3, (int)attributes.getAsyncEventQueueIds().size());
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue1"));
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue2"));
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue3"));
                TestCase.assertEquals((int)3, (int)attributes.getGatewaySenderIds().size());
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender1"));
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender2"));
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender3"));
                TestCase.assertEquals((int)3, (int)attributes.getCacheListeners().length);
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerA", (String)attributes.getCacheListeners()[0].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerB", (String)attributes.getCacheListeners()[1].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerC", (String)attributes.getCacheListeners()[2].getClass().getName());
            }
        });
        commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId1);
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId2);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId1);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId3);
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerB");
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerC");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)2, (int)attributes.getAsyncEventQueueIds().size());
                Iterator iterator = attributes.getAsyncEventQueueIds().iterator();
                TestCase.assertEquals((Object)"testAlterRegionQueue1", iterator.next());
                TestCase.assertEquals((Object)"testAlterRegionQueue2", iterator.next());
                TestCase.assertEquals((int)2, (int)attributes.getGatewaySenderIds().size());
                iterator = attributes.getGatewaySenderIds().iterator();
                TestCase.assertEquals((Object)"testAlterRegionSender1", iterator.next());
                TestCase.assertEquals((Object)"testAlterRegionSender3", iterator.next());
                TestCase.assertEquals((int)2, (int)attributes.getCacheListeners().length);
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerB", (String)attributes.getCacheListeners()[0].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerC", (String)attributes.getCacheListeners()[1].getClass().getName());
            }
        });
        commandStringBuilder = new CommandStringBuilder("alter region");
        commandStringBuilder.addOption("name", "/" + this.alterRegionName);
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId1);
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId2);
        commandStringBuilder.addOption("async-event-queue-id", this.alterAsyncEventQueueId3);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId1);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId3);
        commandStringBuilder.addOption("gateway-sender-id", this.alterGatewaySenderId2);
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerB");
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerC");
        commandStringBuilder.addOption("cache-listener", "com.cadrdunit.RegionAlterCacheListenerA");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((int)4, (int)this.countLinesInString(stringResult, false));
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm1Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        CreateAlterDestroyRegionCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, this.alterVm2Name + ".*Region \"/" + this.alterRegionName + "\" altered.*"));
        this.alterVm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionAttributes attributes = CreateAlterDestroyRegionCommandsDUnitTest.this.getCache().getRegion("testAlterRegionRegion").getAttributes();
                TestCase.assertEquals((int)3, (int)attributes.getAsyncEventQueueIds().size());
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue1"));
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue2"));
                TestCase.assertTrue((boolean)attributes.getAsyncEventQueueIds().contains("testAlterRegionQueue3"));
                TestCase.assertEquals((int)3, (int)attributes.getGatewaySenderIds().size());
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender1"));
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender3"));
                TestCase.assertTrue((boolean)attributes.getGatewaySenderIds().contains("testAlterRegionSender2"));
                TestCase.assertEquals((int)3, (int)attributes.getCacheListeners().length);
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerB", (String)attributes.getCacheListeners()[0].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerC", (String)attributes.getCacheListeners()[1].getClass().getName());
                TestCase.assertEquals((String)"com.cadrdunit.RegionAlterCacheListenerA", (String)attributes.getCacheListeners()[2].getClass().getName());
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        for (String path : this.filesToBeDeleted) {
            try {
                File fileToDelete = new File(path);
                FileUtil.delete((File)fileToDelete);
                if (!path.endsWith(".jar")) continue;
                this.executeCommand("undeploy --jar=" + fileToDelete.getName());
            }
            catch (IOException e) {
                CreateAlterDestroyRegionCommandsDUnitTest.getLogWriter().error("Unable to delete file", (Throwable)e);
            }
        }
        this.filesToBeDeleted.clear();
        super.tearDown2();
    }

    private void deployJarFilesForRegionAlter() throws IOException {
        ClassBuilder classBuilder = new ClassBuilder();
        File jarFile1 = new File(new File(".").getAbsolutePath(), "testAlterRegion1.jar");
        this.filesToBeDeleted.add(jarFile1.getAbsolutePath());
        File jarFile2 = new File(new File(".").getAbsolutePath(), "testAlterRegion2.jar");
        this.filesToBeDeleted.add(jarFile2.getAbsolutePath());
        File jarFile3 = new File(new File(".").getAbsolutePath(), "testAlterRegion3.jar");
        this.filesToBeDeleted.add(jarFile3.getAbsolutePath());
        File jarFile4 = new File(new File(".").getAbsolutePath(), "testAlterRegion4.jar");
        this.filesToBeDeleted.add(jarFile4.getAbsolutePath());
        File jarFile5 = new File(new File(".").getAbsolutePath(), "testAlterRegion5.jar");
        this.filesToBeDeleted.add(jarFile5.getAbsolutePath());
        byte[] jarBytes = classBuilder.createJarFromClassContent("com/cadrdunit/RegionAlterCacheListenerA", "package com.cadrdunit;import com.gemstone.gemfire.cache.util.CacheListenerAdapter;public class RegionAlterCacheListenerA extends CacheListenerAdapter {}");
        this.writeJarBytesToFile(jarFile1, jarBytes);
        CommandResult cmdResult = this.executeCommand("deploy --jar=testAlterRegion1.jar");
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        jarBytes = classBuilder.createJarFromClassContent("com/cadrdunit/RegionAlterCacheListenerB", "package com.cadrdunit;import com.gemstone.gemfire.cache.util.CacheListenerAdapter;public class RegionAlterCacheListenerB extends CacheListenerAdapter {}");
        this.writeJarBytesToFile(jarFile2, jarBytes);
        cmdResult = this.executeCommand("deploy --jar=testAlterRegion2.jar");
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        jarBytes = classBuilder.createJarFromClassContent("com/cadrdunit/RegionAlterCacheListenerC", "package com.cadrdunit;import com.gemstone.gemfire.cache.util.CacheListenerAdapter;public class RegionAlterCacheListenerC extends CacheListenerAdapter {}");
        this.writeJarBytesToFile(jarFile3, jarBytes);
        cmdResult = this.executeCommand("deploy --jar=testAlterRegion3.jar");
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        jarBytes = classBuilder.createJarFromClassContent("com/cadrdunit/RegionAlterCacheLoader", "package com.cadrdunit;import com.gemstone.gemfire.cache.CacheLoader;import com.gemstone.gemfire.cache.CacheLoaderException;import com.gemstone.gemfire.cache.LoaderHelper;public class RegionAlterCacheLoader implements CacheLoader {public void close() {}public Object load(LoaderHelper helper) throws CacheLoaderException {return null;}}");
        this.writeJarBytesToFile(jarFile4, jarBytes);
        cmdResult = this.executeCommand("deploy --jar=testAlterRegion4.jar");
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        jarBytes = classBuilder.createJarFromClassContent("com/cadrdunit/RegionAlterCacheWriter", "package com.cadrdunit;import com.gemstone.gemfire.cache.util.CacheWriterAdapter;public class RegionAlterCacheWriter extends CacheWriterAdapter {}");
        this.writeJarBytesToFile(jarFile5, jarBytes);
        cmdResult = this.executeCommand("deploy --jar=testAlterRegion5.jar");
        CreateAlterDestroyRegionCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
    }

    private void writeJarBytesToFile(File jarFile, byte[] jarBytes) throws IOException {
        FileOutputStream outStream = new FileOutputStream(jarFile);
        ((OutputStream)outStream).write(jarBytes);
        outStream.flush();
        ((OutputStream)outStream).close();
    }
}

