/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.remote.CommandProcessor;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;

public class ConfigCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    private static final String LOG__LEVEL = "info";
    private static final int LOG__FILE__SIZE__LIMIT = 50;
    private static final int ARCHIVE__DISK__SPACE__LIMIT = 32;
    private static final int ARCHIVE__FILE__SIZE__LIMIT = 49;
    private static final int STATISTIC__SAMPLE__RATE = 2000;
    private static final String STATISTIC__ARCHIVE__FILE = "stat.gfs";
    private static final boolean STATISTIC__SAMPLING__ENABLED = true;
    private static final int LOG__DISK__SPACE__LIMIT = 10;
    File managerConfigFile = new File("Manager-cache.xml");
    File managerPropsFile = new File("Manager-gf.properties");
    File vm1ConfigFile = new File("VM1-cache.xml");
    File vm1PropsFile = new File("VM1-gf.properties");
    File vm2ConfigFile = new File("VM2-cache.xml");
    File vm2PropsFile = new File("VM2-gf.properties");
    File shellConfigFile = new File("Shell-cache.xml");
    File shellPropsFile = new File("Shell-gf.properties");
    File subDir = new File("ConfigCommandsDUnitTestSubDir");
    File subManagerConfigFile = new File(this.subDir, this.managerConfigFile.getName());

    public ConfigCommandsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        this.deleteTestFiles();
        super.tearDown2();
    }

    public void testDescribeConfig() throws ClassNotFoundException, IOException {
        this.createDefaultSetup(null);
        VM vm1 = Host.getHost(0).getVM(1);
        String vm1Name = "Member1";
        String controllerName = "Member2";
        Properties localProps = new Properties();
        localProps.setProperty("mcast-port", "0");
        localProps.setProperty("log-level", LOG__LEVEL);
        localProps.setProperty("statistic-sampling-enabled", "true");
        localProps.setProperty("enable-time-statistics", "true");
        localProps.setProperty("name", "Member2");
        localProps.setProperty("groups", "G1");
        this.getSystem(localProps);
        Cache cache = this.getCache();
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        CacheServer cs = this.getCache().addCacheServer();
        cs.setPort(ports[0]);
        cs.setMaxThreads(10);
        cs.setMaxConnections(9);
        cs.start();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeBean.getInputArguments();
        ConfigCommandsDUnitTest.getLogWriter().info("#SB Actual JVM Args : ");
        for (String jvmArg : jvmArgs) {
            ConfigCommandsDUnitTest.getLogWriter().info("#SB JVM " + jvmArg);
        }
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DistributionConfig config = system.getConfig();
        config.setArchiveFileSizeLimit(1000);
        String command = "describe config --member=Member2";
        CommandProcessor cmdProcessor = new CommandProcessor();
        cmdProcessor.createCommandStatement(command, Collections.EMPTY_MAP).process();
        CommandResult cmdResult = this.executeCommand(command);
        String resultStr = this.commandResultToString(cmdResult);
        ConfigCommandsDUnitTest.getLogWriter().info("#SB Hiding the defaults\n" + resultStr);
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)cmdResult.getStatus().equals((Object)Result.Status.OK));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultStr.contains("G1"));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultStr.contains("Member2"));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultStr.contains("archive-file-size-limit"));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (!resultStr.contains("copy-on-read") ? 1 : 0) != 0);
        cmdResult = this.executeCommand(command + " --" + "hide-defaults" + "=false");
        resultStr = this.commandResultToString(cmdResult);
        ConfigCommandsDUnitTest.getLogWriter().info("#SB No hiding of defaults\n" + resultStr);
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)cmdResult.getStatus().equals((Object)Result.Status.OK));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultStr.contains("is-server"));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultStr.contains("Member2"));
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)resultStr.contains("copy-on-read"));
        cs.stop();
    }

    public void testExportConfig() throws IOException {
        Properties localProps = new Properties();
        localProps.setProperty("name", "Manager");
        localProps.setProperty("groups", "Group1");
        this.createDefaultSetup(localProps);
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", "VM1");
                localProps.setProperty("groups", "Group2");
                ConfigCommandsDUnitTest.this.getSystem(localProps);
                ConfigCommandsDUnitTest.this.getCache();
            }
        });
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", "VM2");
                localProps.setProperty("groups", "Group2");
                ConfigCommandsDUnitTest.this.getSystem(localProps);
                ConfigCommandsDUnitTest.this.getCache();
            }
        });
        localProps = new Properties();
        localProps.setProperty("name", "Shell");
        this.getSystem(localProps);
        Cache cache = this.getCache();
        this.deleteTestFiles();
        CommandResult cmdResult = this.executeCommand("export config");
        ConfigCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.managerConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.managerPropsFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.vm1ConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.vm1PropsFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.vm2ConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.vm2PropsFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.shellConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.shellPropsFile.exists());
        this.deleteTestFiles();
        cmdResult = this.executeCommand("export config --member=Manager");
        ConfigCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.managerConfigFile.exists());
        ConfigCommandsDUnitTest.assertFalse((boolean)this.vm1ConfigFile.exists());
        ConfigCommandsDUnitTest.assertFalse((boolean)this.vm2ConfigFile.exists());
        ConfigCommandsDUnitTest.assertFalse((boolean)this.shellConfigFile.exists());
        this.deleteTestFiles();
        cmdResult = this.executeCommand("export config --group=Group2");
        ConfigCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        ConfigCommandsDUnitTest.assertFalse((boolean)this.managerConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.vm1ConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.vm2ConfigFile.exists());
        ConfigCommandsDUnitTest.assertFalse((boolean)this.shellConfigFile.exists());
        this.deleteTestFiles();
        cmdResult = this.executeCommand("export config --dir=" + this.subDir.getAbsolutePath());
        ConfigCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        ConfigCommandsDUnitTest.assertFalse((boolean)this.managerConfigFile.exists());
        ConfigCommandsDUnitTest.assertTrue((boolean)this.subManagerConfigFile.exists());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        CacheXmlGenerator.generate((Cache)cache, (PrintWriter)printWriter, (boolean)false, (boolean)false, (boolean)false);
        String configToMatch = stringWriter.toString();
        this.deleteTestFiles();
        cmdResult = this.executeCommand("export config --member=Shell");
        ConfigCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        char[] fileContents = new char[configToMatch.length()];
        try {
            FileReader reader = new FileReader(this.shellConfigFile);
            reader.read(fileContents);
        }
        catch (Exception ex) {
            ConfigCommandsDUnitTest.fail("Unable to read file contents for comparison", ex);
        }
        ConfigCommandsDUnitTest.assertEquals((String)configToMatch, (String)new String(fileContents));
    }

    public void testAlterRuntimeConfig() throws ClassNotFoundException, IOException {
        String controller = "controller";
        this.createDefaultSetup(null);
        Properties localProps = new Properties();
        localProps.setProperty("name", "controller");
        localProps.setProperty("log-level", "error");
        this.getSystem(localProps);
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        DistributionConfig config = cache.getSystem().getConfig();
        CommandStringBuilder csb = new CommandStringBuilder("alter runtime");
        csb.addOption("member", "controller");
        csb.addOption("log-level", LOG__LEVEL);
        csb.addOption("log-file-size-limit", Integer.toString(50));
        csb.addOption("archive-disk-space-limit", Integer.toString(32));
        csb.addOption("archive-file-size-limit", Integer.toString(49));
        csb.addOption("statistic-sample-rate", Integer.toString(2000));
        csb.addOption("statistic-archive-file", STATISTIC__ARCHIVE__FILE);
        csb.addOption("enable-statistics", Boolean.toString(true));
        csb.addOption("log-disk-space-limit", Integer.toString(10));
        CommandResult cmdResult = this.executeCommand(csb.getCommandString());
        String resultString = this.commandResultToString(cmdResult);
        ConfigCommandsDUnitTest.getLogWriter().info("Result\n");
        ConfigCommandsDUnitTest.getLogWriter().info(resultString);
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)cmdResult.getStatus().equals((Object)Result.Status.OK));
        ConfigCommandsDUnitTest.assertEquals((int)800, (int)config.getLogLevel());
        ConfigCommandsDUnitTest.assertEquals((int)50, (int)config.getLogFileSizeLimit());
        ConfigCommandsDUnitTest.assertEquals((int)32, (int)config.getArchiveDiskSpaceLimit());
        ConfigCommandsDUnitTest.assertEquals((int)49, (int)config.getArchiveFileSizeLimit());
        ConfigCommandsDUnitTest.assertEquals((int)2000, (int)config.getStatisticSampleRate());
        ConfigCommandsDUnitTest.assertEquals((String)STATISTIC__ARCHIVE__FILE, (String)config.getStatisticArchiveFile().getName());
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)config.getStatisticSamplingEnabled());
        ConfigCommandsDUnitTest.assertEquals((int)10, (int)config.getLogDiskSpaceLimit());
        CommandProcessor commandProcessor = new CommandProcessor();
        Result result = commandProcessor.createCommandStatement("alter runtime", Collections.EMPTY_MAP).process();
    }

    public void testAlterRuntimeConfigRandom() {
        String member1 = "VM1";
        String controller = "controller";
        this.createDefaultSetup(null);
        Properties localProps = new Properties();
        localProps.setProperty("name", "controller");
        localProps.setProperty("log-level", "error");
        this.getSystem(localProps);
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        DistributionConfig config = cache.getSystem().getConfig();
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", "VM1");
                ConfigCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = ConfigCommandsDUnitTest.this.getCache();
            }
        });
        CommandStringBuilder csb = new CommandStringBuilder("alter runtime");
        CommandResult cmdResult = this.executeCommand(csb.getCommandString());
        String resultAsString = this.commandResultToString(cmdResult);
        ConfigCommandsDUnitTest.getLogWriter().info(resultAsString);
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)cmdResult.getStatus().equals((Object)Result.Status.ERROR));
        ConfigCommandsDUnitTest.assertTrue((boolean)resultAsString.contains("Please provide a relevant parameter(s)"));
        csb = new CommandStringBuilder("alter runtime");
        csb.addOption("log-disk-space-limit", "2000000000");
        cmdResult = this.executeCommand(csb.getCommandString());
        resultAsString = this.commandResultToString(cmdResult);
        ConfigCommandsDUnitTest.getLogWriter().info("#SB Result\n");
        ConfigCommandsDUnitTest.getLogWriter().info(resultAsString);
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)cmdResult.getStatus().equals((Object)Result.Status.ERROR));
    }

    public void testAlterRuntimeConfigOnAllMembers() {
        String member1 = "VM1";
        String controller = "controller";
        this.createDefaultSetup(null);
        Properties localProps = new Properties();
        localProps.setProperty("name", "controller");
        localProps.setProperty("log-level", "error");
        this.getSystem(localProps);
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        DistributionConfig config = cache.getSystem().getConfig();
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", "VM1");
                ConfigCommandsDUnitTest.this.getSystem(localProps);
                Cache cache = ConfigCommandsDUnitTest.this.getCache();
            }
        });
        CommandStringBuilder csb = new CommandStringBuilder("alter runtime");
        csb.addOption("log-level", LOG__LEVEL);
        csb.addOption("log-file-size-limit", Integer.toString(50));
        csb.addOption("archive-disk-space-limit", Integer.toString(32));
        csb.addOption("archive-file-size-limit", Integer.toString(49));
        csb.addOption("statistic-sample-rate", Integer.toString(2000));
        csb.addOption("statistic-archive-file", STATISTIC__ARCHIVE__FILE);
        csb.addOption("enable-statistics", Boolean.toString(true));
        csb.addOption("log-disk-space-limit", Integer.toString(10));
        CommandResult cmdResult = this.executeCommand(csb.getCommandString());
        String resultString = this.commandResultToString(cmdResult);
        ConfigCommandsDUnitTest.getLogWriter().info(resultString);
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)cmdResult.getStatus().equals((Object)Result.Status.OK));
        ConfigCommandsDUnitTest.assertEquals((int)800, (int)config.getLogLevel());
        ConfigCommandsDUnitTest.assertEquals((int)50, (int)config.getLogFileSizeLimit());
        ConfigCommandsDUnitTest.assertEquals((int)32, (int)config.getArchiveDiskSpaceLimit());
        ConfigCommandsDUnitTest.assertEquals((int)49, (int)config.getArchiveFileSizeLimit());
        ConfigCommandsDUnitTest.assertEquals((int)2000, (int)config.getStatisticSampleRate());
        ConfigCommandsDUnitTest.assertEquals((String)STATISTIC__ARCHIVE__FILE, (String)config.getStatisticArchiveFile().getName());
        ConfigCommandsDUnitTest.assertEquals((boolean)true, (boolean)config.getStatisticSamplingEnabled());
        ConfigCommandsDUnitTest.assertEquals((int)10, (int)config.getLogDiskSpaceLimit());
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GemFireCacheImpl cacheVM1 = (GemFireCacheImpl)ConfigCommandsDUnitTest.this.getCache();
                DistributionConfig configVM1 = cacheVM1.getSystem().getConfig();
                TestCase.assertEquals((int)800, (int)configVM1.getLogLevel());
                TestCase.assertEquals((int)50, (int)configVM1.getLogFileSizeLimit());
                TestCase.assertEquals((int)49, (int)configVM1.getArchiveFileSizeLimit());
                TestCase.assertEquals((int)32, (int)configVM1.getArchiveDiskSpaceLimit());
                TestCase.assertEquals((int)2000, (int)configVM1.getStatisticSampleRate());
                TestCase.assertEquals((String)ConfigCommandsDUnitTest.STATISTIC__ARCHIVE__FILE, (String)configVM1.getStatisticArchiveFile().getName());
                TestCase.assertEquals((boolean)true, (boolean)configVM1.getStatisticSamplingEnabled());
                TestCase.assertEquals((int)10, (int)configVM1.getLogDiskSpaceLimit());
            }
        });
    }

    private final void deleteTestFiles() throws IOException {
        this.managerConfigFile.delete();
        this.managerPropsFile.delete();
        this.vm1ConfigFile.delete();
        this.vm1PropsFile.delete();
        this.vm2ConfigFile.delete();
        this.vm2PropsFile.delete();
        this.shellConfigFile.delete();
        this.shellPropsFile.delete();
        FileUtils.deleteDirectory((File)this.subDir);
    }
}

