/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.result.CommandResultException;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import java.util.Properties;
import java.util.Set;

public class CliUtilDUnitTest
extends CacheTestCase {
    public static final String COMMON_REGION = "region1";
    public static final String COMMON_REGION_GROUP1 = "region_group1";
    public static final String COMMON_REGION_GROUP2 = "region_group2";
    public static final String REGION_MEMBER1_GROUP1 = "region_member1_group1";
    public static final String REGION_MEMBER2_GROUP1 = "region_member2_group1";
    public static final String REGION_MEMBER1_GROUP2 = "region_member1_group2";
    public static final String REGION_MEMBER2_GROUP2 = "region_member2_group2";
    public static final String MEMBER_1_GROUP1 = "member1_group1";
    public static final String MEMBER_2_GROUP1 = "member2_group1";
    public static final String MEMBER_1_GROUP2 = "member1_group2";
    public static final String MEMBER_2_GROUP2 = "member2_group2";
    public static final String GROUP1 = "group1";
    public static final String GROUP2 = "group2";
    private static final long serialVersionUID = 1L;

    public CliUtilDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        this.destroySetup();
        super.tearDown2();
    }

    protected final void destroySetup() {
        CliUtilDUnitTest.disconnectAllFromDS();
    }

    void setupMembersWithIdsAndGroups() {
        VM vm1 = Host.getHost(0).getVM(0);
        VM vm2 = Host.getHost(0).getVM(1);
        VM vm3 = Host.getHost(0).getVM(2);
        VM vm4 = Host.getHost(0).getVM(3);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.createCacheWithMemberIdAndGroup(CliUtilDUnitTest.MEMBER_1_GROUP1, CliUtilDUnitTest.GROUP1);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.REGION_MEMBER1_GROUP1);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION_GROUP1);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION);
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.createCacheWithMemberIdAndGroup(CliUtilDUnitTest.MEMBER_2_GROUP1, CliUtilDUnitTest.GROUP1);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.REGION_MEMBER2_GROUP1);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION_GROUP1);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION);
            }
        });
        vm3.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.createCacheWithMemberIdAndGroup(CliUtilDUnitTest.MEMBER_1_GROUP2, CliUtilDUnitTest.GROUP2);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.REGION_MEMBER1_GROUP2);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION_GROUP2);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION);
            }
        });
        vm4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.createCacheWithMemberIdAndGroup(CliUtilDUnitTest.MEMBER_2_GROUP2, CliUtilDUnitTest.GROUP2);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.REGION_MEMBER2_GROUP2);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION_GROUP2);
                CliUtilDUnitTest.this.createRegion(CliUtilDUnitTest.COMMON_REGION);
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.startManager();
            }
        });
    }

    private void startManager() {
        final ManagementService service = ManagementService.getManagementService((Cache)this.getCache());
        service.startManager();
        CliUtilDUnitTest.assertEquals((boolean)true, (boolean)service.isManager());
        CliUtilDUnitTest.assertNotNull((Object)service.getManagerMXBean());
        CliUtilDUnitTest.assertTrue((boolean)service.getManagerMXBean().isRunning());
        DistributedTestCase.WaitCriterion waitForMaangerMBean = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                boolean flag;
                boolean bl = flag = this.checkBean(CliUtilDUnitTest.COMMON_REGION, 4) && this.checkBean(CliUtilDUnitTest.COMMON_REGION_GROUP1, 2) && this.checkBean(CliUtilDUnitTest.COMMON_REGION_GROUP2, 2) && this.checkBean(CliUtilDUnitTest.REGION_MEMBER1_GROUP1, 1) && this.checkBean(CliUtilDUnitTest.REGION_MEMBER2_GROUP1, 1) && this.checkBean(CliUtilDUnitTest.REGION_MEMBER1_GROUP2, 1) && this.checkBean(CliUtilDUnitTest.REGION_MEMBER2_GROUP2, 1);
                if (!flag) {
                    Log.getLogWriter().info("Still probing for mbeans");
                    return false;
                }
                Log.getLogWriter().info("All distributed region mbeans are federated to manager.");
                return true;
            }

            private boolean checkBean(String string, int memberCount) {
                DistributedRegionMXBean bean2 = service.getDistributedRegionMXBean("/" + string);
                Log.getLogWriter().info("DistributedRegionMXBean for region=" + string + " is " + bean2);
                if (bean2 == null) {
                    return false;
                }
                int members = bean2.getMemberCount();
                Log.getLogWriter().info("DistributedRegionMXBean for region=" + string + " is aggregated for " + memberCount + " expected count=" + memberCount);
                return members >= memberCount;
            }

            @Override
            public String description() {
                return "Probing for ManagerMBean";
            }
        };
        DistributedTestCase.waitForCriterion(waitForMaangerMBean, 120000L, 2000L, true);
        Log.getLogWriter().info("Manager federation is complete");
    }

    private void registerFunction() {
        DunitFunction funct = new DunitFunction("DunitFunction");
        FunctionService.registerFunction((Function)funct);
    }

    private Region createRegion(String regionName) {
        RegionFactory regionFactory = this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
        Region region = regionFactory.create(regionName);
        ManagementService service = ManagementService.getManagementService((Cache)this.getCache());
        CliUtilDUnitTest.assertNotNull((Object)service.getMemberMXBean());
        RegionMXBean bean = service.getLocalRegionMBean("/" + regionName);
        CliUtilDUnitTest.assertNotNull((Object)bean);
        Log.getLogWriter().info("Created region=" + regionName + " Bean=" + bean);
        return region;
    }

    public void createCacheWithMemberIdAndGroup(String memberName, String groupName) {
        Properties localProps = new Properties();
        localProps.setProperty("name", memberName);
        localProps.setProperty("groups", groupName);
        localProps.setProperty("jmx-manager", "true");
        localProps.setProperty("jmx-manager-start", "false");
        int jmxPort = AvailablePortHelper.getRandomAvailableTCPPort();
        localProps.setProperty("jmx-manager-port", "" + jmxPort);
        Log.getLogWriter().info("Set jmx-port=" + jmxPort);
        this.getSystem(localProps);
        this.getCache();
        ManagementService service = ManagementService.getManagementService((Cache)this.getCache());
        CliUtilDUnitTest.assertNotNull((Object)service.getMemberMXBean());
    }

    public void testFileToBytes() {
    }

    public void testCliUtilMethods() {
        this.setupMembersWithIdsAndGroups();
        VM vm1 = Host.getHost(0).getVM(0);
        Log.getLogWriter().info("testFor - findAllMatchingMembers");
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.verifyFindAllMatchingMembers();
            }
        });
        final String id = (String)vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = CliUtilDUnitTest.this.getCache();
                return cache.getDistributedSystem().getDistributedMember().getId();
            }
        });
        Log.getLogWriter().info("testFor - getDistributedMemberByNameOrId");
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.getDistributedMemberByNameOrId(CliUtilDUnitTest.MEMBER_1_GROUP1, id);
            }
        });
        Log.getLogWriter().info("testFor - executeFunction");
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.verifyExecuteFunction();
            }
        });
        Log.getLogWriter().info("testFor - getRegionAssociatedMembers");
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CliUtilDUnitTest.this.getRegionAssociatedMembers();
            }
        });
    }

    public void verifyFindAllMatchingMembers() {
        try {
            Set set = CliUtil.findAllMatchingMembers((String)GROUP1, null);
            CliUtilDUnitTest.assertNotNull((Object)set);
            CliUtilDUnitTest.assertEquals((int)2, (int)set.size());
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP1));
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP1));
            set = CliUtil.findAllMatchingMembers((String)"group1,group2", null);
            CliUtilDUnitTest.assertNotNull((Object)set);
            CliUtilDUnitTest.assertEquals((int)4, (int)set.size());
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP1));
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP1));
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP2));
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP2));
            set = CliUtil.findAllMatchingMembers(null, (String)MEMBER_1_GROUP1);
            CliUtilDUnitTest.assertNotNull((Object)set);
            CliUtilDUnitTest.assertEquals((int)1, (int)set.size());
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP1));
            set = CliUtil.findAllMatchingMembers(null, (String)"member1_group1,member2_group2");
            CliUtilDUnitTest.assertNotNull((Object)set);
            CliUtilDUnitTest.assertEquals((int)2, (int)set.size());
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP1));
            CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP2));
        }
        catch (CommandResultException e) {
            CliUtilDUnitTest.fail("CliUtil failed with exception", e);
        }
    }

    private Object containsMember(Set<DistributedMember> set, String string) {
        boolean returnValue = false;
        for (DistributedMember member : set) {
            if (!member.getName().equals(string)) continue;
            return true;
        }
        return returnValue;
    }

    public void getDistributedMemberByNameOrId(String name, String id) {
        DistributedMember member = CliUtil.getDistributedMemberByNameOrId((String)name);
        CliUtilDUnitTest.assertNotNull((Object)member);
        member = CliUtil.getDistributedMemberByNameOrId((String)id);
        CliUtilDUnitTest.assertNotNull((Object)member);
    }

    public void verifyExecuteFunction() {
        DunitFunction function = new DunitFunction("myfunction");
        try {
            Region region1 = CacheFactory.getAnyInstance().getRegion(COMMON_REGION);
            region1.clear();
            Set set = CliUtil.findAllMatchingMembers((String)GROUP1, null);
            CliUtilDUnitTest.assertEquals((int)2, (int)set.size());
            ResultCollector collector = CliUtil.executeFunction((Function)function, (Object)"executeOnGroup", (Set)set);
            collector.getResult();
            CliUtilDUnitTest.assertEquals((int)2, (int)region1.size());
            CliUtilDUnitTest.assertTrue((boolean)region1.containsKey((Object)MEMBER_1_GROUP1));
            CliUtilDUnitTest.assertTrue((boolean)region1.containsKey((Object)MEMBER_2_GROUP1));
            CliUtilDUnitTest.assertEquals((Object)"executeOnGroup", (Object)region1.get((Object)MEMBER_1_GROUP1));
            CliUtilDUnitTest.assertEquals((Object)"executeOnGroup", (Object)region1.get((Object)MEMBER_2_GROUP1));
        }
        catch (CommandResultException e) {
            CliUtilDUnitTest.fail("Error during querying members", e);
        }
    }

    public void getRegionAssociatedMembers() {
        String region_group1 = "/region_group1";
        String region1 = "/region1";
        String region_member2_group1 = "/region_member2_group1";
        Cache cache = this.getCache();
        Set set = CliUtil.getRegionAssociatedMembers((String)region1, (Cache)cache, (boolean)true);
        CliUtilDUnitTest.assertNotNull((Object)set);
        CliUtilDUnitTest.assertEquals((int)4, (int)set.size());
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP1));
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP1));
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP2));
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP2));
        set = CliUtil.getRegionAssociatedMembers((String)region_group1, (Cache)cache, (boolean)true);
        CliUtilDUnitTest.assertNotNull((Object)set);
        CliUtilDUnitTest.assertEquals((int)2, (int)set.size());
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_1_GROUP1));
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP1));
        set = CliUtil.getRegionAssociatedMembers((String)region_member2_group1, (Cache)cache, (boolean)true);
        CliUtilDUnitTest.assertNotNull((Object)set);
        CliUtilDUnitTest.assertEquals((int)1, (int)set.size());
        CliUtilDUnitTest.assertEquals((Object)true, (Object)this.containsMember(set, MEMBER_2_GROUP1));
    }

    public static class DunitFunction
    extends FunctionAdapter {
        private static final long serialVersionUID = 1L;
        private String id;

        public DunitFunction(String fid) {
            this.id = fid;
        }

        public void execute(FunctionContext context) {
            Object object = context.getArguments();
            Cache cache = CacheFactory.getAnyInstance();
            Region region = cache.getRegion(CliUtilDUnitTest.COMMON_REGION);
            String id = cache.getDistributedSystem().getDistributedMember().getName();
            region.put((Object)id, object);
            Log.getLogWriter().info("Completed executeFunction on member : " + id);
            context.getResultSender().lastResult((Object)true);
        }

        public String getId() {
            return this.id;
        }
    }
}

