/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.LocatorMXBean;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import junit.framework.TestCase;

public class LocatorManagementDUnitTest
extends ManagementTestBase {
    public static final String DEFAULT_LOG_FILE = "locator.log";
    private static final int MAX_WAIT = 16000;
    private static Properties props = new Properties();
    private VM locator;
    protected int mCastPort;
    private static final long serialVersionUID = 1L;

    public LocatorManagementDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.locator = managedNode1;
        this.mCastPort = AvailablePort.getRandomAvailablePort((int)1);
    }

    @Override
    public void tearDown2() throws Exception {
        this.stopLocator(this.locator);
        super.tearDown2();
    }

    public void testPeerLocation() throws Exception {
        int locPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.startLocator(this.locator, true, locPort);
        this.locatorMBeanExist(this.locator, locPort, true);
        Host host = Host.getHost(0);
        String host0 = LocatorManagementDUnitTest.getServerHostName(host);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", host0 + "[" + locPort + "]");
        props.setProperty("jmx-manager", "true");
        props.setProperty("jmx-manager-start", "false");
        props.setProperty("jmx-manager-port", "0");
        props.setProperty("jmx-manager-http-port", "0");
        this.createCache(managingNode, props);
        this.startManagingNode(managingNode);
        DistributedMember locatorMember = this.getMember(this.locator);
        this.remoteLocatorMBeanExist(managingNode, locatorMember);
    }

    public void testColocatedLocator() throws Exception {
        this.initManagement(false);
        int locPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.startLocator(this.locator, false, locPort);
        this.locatorMBeanExist(this.locator, locPort, false);
    }

    public void testListManagers() throws Exception {
        this.initManagement(false);
        int locPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.startLocator(this.locator, false, locPort);
        this.listManagers(this.locator, locPort, false);
    }

    public void testWillingManagers() throws Exception {
        int locPort = AvailablePortHelper.getRandomAvailableTCPPort();
        this.startLocator(this.locator, true, locPort);
        Host host = Host.getHost(0);
        String host0 = LocatorManagementDUnitTest.getServerHostName(host);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", host0 + "[" + locPort + "]");
        props.setProperty("jmx-manager", "true");
        this.createCache(managedNode2, props);
        this.createCache(managedNode3, props);
        this.listWillingManagers(this.locator, locPort, false);
    }

    protected String startLocator(final VM vm, final boolean isPeer, final int port) {
        return (String)vm.invoke(new SerializableCallable("Start Locator In VM"){

            public Object call() throws Exception {
                TestCase.assertFalse((boolean)InternalLocator.hasLocator());
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                InetAddress bindAddr = null;
                try {
                    bindAddr = InetAddress.getByName(LocatorManagementDUnitTest.getServerHostName(vm.getHost()));
                }
                catch (UnknownHostException uhe) {
                    DistributedTestCase.fail("While resolving bind address ", uhe);
                }
                try {
                    File logFile = new File(DistributedTestCase.testName + "-locator" + port + ".log");
                    Locator locator = Locator.startLocatorAndDS((int)port, (File)logFile, (InetAddress)bindAddr, (Properties)props, (boolean)isPeer, (boolean)true, null);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port, ex);
                }
                TestCase.assertTrue((boolean)InternalLocator.hasLocator());
                return null;
            }
        });
    }

    protected String stopLocator(VM vm) {
        return (String)vm.invoke(new SerializableCallable("Stop Locator In VM"){

            public Object call() throws Exception {
                TestCase.assertTrue((boolean)InternalLocator.hasLocator());
                InternalLocator.getLocator().stop();
                return null;
            }
        });
    }

    protected void locatorMBeanExist(VM vm, final int locPort, final boolean isPeer) {
        vm.invoke(new SerializableCallable("Locator MBean created"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
                TestCase.assertNotNull((Object)service);
                LocatorMXBean bean = service.getLocalLocatorMXBean();
                TestCase.assertNotNull((Object)bean);
                TestCase.assertEquals((int)locPort, (int)bean.getPort());
                DistributedTestCase.getLogWriter().info("Log of Locator" + bean.viewLog());
                DistributedTestCase.getLogWriter().info("BindAddress" + bean.getBindAddress());
                TestCase.assertEquals((boolean)isPeer, (boolean)bean.isPeerLocator());
                return null;
            }
        });
    }

    protected void remoteLocatorMBeanExist(VM vm, final DistributedMember member) {
        vm.invoke(new SerializableCallable("Locator MBean created"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
                TestCase.assertNotNull((Object)service);
                LocatorMXBean bean = MBeanUtil.getLocatorMbeanProxy(member);
                TestCase.assertNotNull((Object)bean);
                DistributedTestCase.getLogWriter().info("Log of Locator" + bean.viewLog());
                DistributedTestCase.getLogWriter().info("BindAddress" + bean.getBindAddress());
                return null;
            }
        });
    }

    protected void listManagers(VM vm, int locPort, boolean isPeer) {
        vm.invoke(new SerializableCallable("List Managers"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
                TestCase.assertNotNull((Object)service);
                final LocatorMXBean bean = service.getLocalLocatorMXBean();
                TestCase.assertNotNull((Object)bean);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for the managers List";
                    }

                    @Override
                    public boolean done() {
                        boolean done = bean.listManagers().length == 1;
                        return done;
                    }
                }, 16000L, 500L, true);
                return null;
            }
        });
    }

    protected void listWillingManagers(VM vm, int locPort, boolean isPeer) {
        vm.invoke(new SerializableCallable("List Willing Managers"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
                TestCase.assertNotNull((Object)service);
                final LocatorMXBean bean = service.getLocalLocatorMXBean();
                TestCase.assertNotNull((Object)bean);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for the Willing managers List";
                    }

                    @Override
                    public boolean done() {
                        boolean done = bean.listPotentialManagers().length == 3;
                        return done;
                    }
                }, 16000L, 500L, true);
                return null;
            }
        });
    }

    public static String getServerHostName(Host host) {
        return System.getProperty("gemfire.server-bind-address") != null ? System.getProperty("gemfire.server-bind-address") : host.getHostName();
    }
}

