/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.GemFireProperties;
import com.gemstone.gemfire.management.JVMMetrics;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.ManagerMXBean;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.OSMetrics;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class CacheManagementDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private final String VERIFY_CONFIG_METHOD = "verifyConfigData";
    private final String VERIFY_REMOTE_CONFIG_METHOD = "verifyConfigDataRemote";
    static final String REGION_NAME = "MANAGEMENT_TEST_REGION";
    static final String PARTITIONED_REGION_NAME = "MANAGEMENT_PAR_REGION";
    static final String FIXED_PR_NAME = "MANAGEMENT_FIXED_PR";
    static List<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
    static final List<Notification> notifList = new ArrayList<Notification>();
    private static final int MAX_WAIT = 70000;

    public CacheManagementDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testGemFireConfigData() throws Exception {
        this.initManagement(false);
        HashMap configMap = new HashMap();
        for (VM vm : CacheManagementDUnitTest.getManagedNodeList()) {
            Map configMapMember = (Map)vm.invoke(CacheManagementDUnitTest.class, "verifyConfigData");
            configMap.putAll(configMapMember);
        }
        Object[] args = new Object[]{configMap};
        CacheManagementDUnitTest.getManagingNode().invoke(CacheManagementDUnitTest.class, "verifyConfigDataRemote", args);
    }

    public void testMemberMBeanOperations() throws Exception {
        this.initManagement(false);
        for (VM vm : managedNodeList) {
            this.createLocalRegion(vm, "testRegion");
            String log = (String)vm.invoke(CacheManagementDUnitTest.class, "fetchLog");
            CacheManagementDUnitTest.assertNotNull((Object)log);
            CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> Log Of Member is " + log.toString() + "</ExpectedString> ");
            vm.invoke(CacheManagementDUnitTest.class, "fetchJVMMetrics");
            vm.invoke(CacheManagementDUnitTest.class, "fetchOSMetrics");
            vm.invoke(CacheManagementDUnitTest.class, "shutDownMember");
        }
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        Object[] args = new Object[]{1};
        managingNode.invoke(CacheManagementDUnitTest.class, "assertExpectedMembers", args);
    }

    public void testMemberMBeanOpsRemote() throws Exception {
        this.initManagement(false);
        CacheManagementDUnitTest.getManagingNode().invoke(CacheManagementDUnitTest.class, "invokeRemoteOps");
    }

    public void testManager() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createCache(node1);
        this.createCache(node2);
        this.createManagementCache(node3);
        this.createManagementCache(managingNode);
        node3.invoke(CacheManagementDUnitTest.class, "startManager");
        DistributedMember member = this.getMember(node3);
        this.startManagingNode(managingNode);
        this.checkManagerView(managingNode, member);
        this.stopManagingNode(managingNode);
    }

    public void testManagerShutdown() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createCache(node1);
        this.createCache(node2);
        this.createCache(node3);
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        DistributedMember member = this.getMember(managingNode);
        this.checkManagerView(managingNode, member);
        this.stopManagingNode(managingNode);
        this.checkNonManagerView(managingNode);
    }

    public void testServiceCloseManagedNode() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createCache(node1);
        this.createCache(node2);
        this.createManagementCache(node3);
        this.createManagementCache(managingNode);
        node3.invoke(CacheManagementDUnitTest.class, "startManager");
        this.closeCache(node3);
        this.validateServiceResource(node3);
    }

    public void testGetMBean() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createCache(node1);
        this.createCache(node2);
        this.createCache(node3);
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.checkGetMBean(managingNode);
    }

    public void testQueryMBeans() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createCache(node1);
        this.createCache(node2);
        this.createCache(node3);
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.checkQueryMBeans(managingNode);
    }

    protected void checkQueryMBeans(VM vm) {
        SerializableRunnable validateServiceResource = new SerializableRunnable("Check Query MBeans"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMembers = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                HashSet superSet = new HashSet();
                for (DistributedMember member : otherMembers) {
                    ObjectName memberMBeanName = ManagementTestBase.managementService.getMemberMBeanName(member);
                    CacheManagementDUnitTest.this.waitForProxy(memberMBeanName, MemberMXBean.class);
                    Set names = ManagementTestBase.managementService.queryMBeanNames(member);
                    superSet.addAll(names);
                    TestCase.assertTrue((boolean)names.contains(memberMBeanName));
                }
                Set names = ManagementTestBase.managementService.queryMBeanNames((DistributedMember)cache.getDistributedSystem().getDistributedMember());
                TestCase.assertTrue((!superSet.contains(names) ? 1 : 0) != 0);
            }
        };
        vm.invoke(validateServiceResource);
    }

    protected void checkGetMBean(VM vm) {
        SerializableRunnable validateServiceResource = new SerializableRunnable("Check Get MBean"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMembers = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMembers) {
                    ObjectName memberMBeanName = ManagementTestBase.managementService.getMemberMBeanName(member);
                    CacheManagementDUnitTest.this.waitForProxy(memberMBeanName, MemberMXBean.class);
                    MemberMXBean bean = (MemberMXBean)ManagementTestBase.managementService.getMBeanInstance(memberMBeanName, MemberMXBean.class);
                    TestCase.assertNotNull((Object)bean);
                }
                InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
                ObjectName memberMBeanName = ManagementTestBase.managementService.getMemberMBeanName((DistributedMember)thisMember);
                MemberMXBean bean = (MemberMXBean)ManagementTestBase.managementService.getMBeanInstance(memberMBeanName, MemberMXBean.class);
                TestCase.assertNotNull((Object)bean);
            }
        };
        vm.invoke(validateServiceResource);
    }

    protected void validateServiceResource(VM vm) {
        SerializableRunnable validateServiceResource = new SerializableRunnable("Valideate Management Service Resource"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertNull((Object)cache);
                TestCase.assertFalse((boolean)ManagementTestBase.managementService.isManager());
                SystemManagementService service = (SystemManagementService)ManagementTestBase.managementService;
                TestCase.assertNull((Object)service.getLocalManager());
            }
        };
        vm.invoke(validateServiceResource);
    }

    protected AsyncInvocation checkManagerView(VM vm, final DistributedMember oneManager) {
        SerializableRunnable createRegion = new SerializableRunnable("Check Manager View"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                ObjectName memberMBeanName = service.getMemberMBeanName(oneManager);
                MemberMXBean bean = (MemberMXBean)service.getMBeanProxy(memberMBeanName, MemberMXBean.class);
                TestCase.assertNotNull((Object)bean);
                long t1 = bean.getMemberUpTime();
                try {
                    this.wait(6000L);
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)"interrupted");
                }
                long t2 = bean.getMemberUpTime();
                TestCase.assertTrue((t2 > t1 ? 1 : 0) != 0);
            }
        };
        return vm.invokeAsync(createRegion);
    }

    protected void checkNonManagerView(VM vm) {
        SerializableRunnable checkNonManagerView = new SerializableRunnable("Check Non Manager View"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                TestCase.assertNotNull((Object)cache);
                TestCase.assertFalse((boolean)ManagementTestBase.managementService.isManager());
                SystemManagementService service = (SystemManagementService)ManagementTestBase.managementService;
                TestCase.assertTrue((boolean)service.getLocalManager().isRunning());
                TestCase.assertFalse((boolean)service.getLocalManager().getFederationSheduler().isShutdown());
                Set otherMembers = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                TestCase.assertTrue((otherMembers.size() > 0 ? 1 : 0) != 0);
                for (DistributedMember member : otherMembers) {
                    Set proxyNames = service.getFederatingManager().getProxyFactory().findAllProxies(member);
                    TestCase.assertTrue((boolean)proxyNames.isEmpty());
                    ObjectName proxyMBeanName = service.getMemberMBeanName(member);
                    TestCase.assertFalse((boolean)MBeanJMXAdapter.mbeanServer.isRegistered(proxyMBeanName));
                }
            }
        };
        vm.invoke(checkNonManagerView);
    }

    public static Map<DistributedMember, DistributionConfig> verifyConfigData() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        ManagementService service = CacheManagementDUnitTest.getManagementService();
        DistributionConfig config = cache.getDistributedSystem().getConfig();
        MemberMXBean bean = service.getMemberMXBean();
        GemFireProperties data = bean.listGemFireProperties();
        CacheManagementDUnitTest.assertEquals(config, data);
        HashMap<DistributedMember, DistributionConfig> configMap = new HashMap<DistributedMember, DistributionConfig>();
        configMap.put((DistributedMember)cache.getMyId(), config);
        return configMap;
    }

    public static void verifyConfigDataRemote(Map<DistributedMember, DistributionConfig> configMap) throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
        for (DistributedMember member : otherMemberSet) {
            MemberMXBean bean = MBeanUtil.getMemberMbeanProxy(member);
            GemFireProperties data = bean.listGemFireProperties();
            DistributionConfig config = configMap.get(member);
            CacheManagementDUnitTest.assertEquals(config, data);
        }
    }

    public static void assertEquals(DistributionConfig config, GemFireProperties data) {
        CacheManagementDUnitTest.assertEquals((String)data.getMemberName(), (String)config.getName());
        Object memberGroups = null;
        CacheManagementDUnitTest.assertEquals((int)data.getMcastPort(), (int)config.getMcastPort());
        CacheManagementDUnitTest.assertEquals((String)data.getMcastAddress(), (String)config.getMcastAddress().getHostAddress());
        CacheManagementDUnitTest.assertEquals((String)data.getBindAddress(), (String)config.getBindAddress());
        CacheManagementDUnitTest.assertEquals((int)data.getTcpPort(), (int)config.getTcpPort());
        CacheManagementDUnitTest.assertEquals((String)data.getCacheXMLFile(), (String)config.getCacheXmlFile().getAbsolutePath());
        Object configFile = null;
        Object configFile1 = null;
        CacheManagementDUnitTest.assertEquals((int)data.getMcastTTL(), (int)config.getMcastTtl());
        CacheManagementDUnitTest.assertEquals((String)data.getServerBindAddress(), (String)config.getServerBindAddress());
        CacheManagementDUnitTest.assertEquals((String)data.getLocators(), (String)config.getLocators());
        CacheManagementDUnitTest.assertEquals((String)data.getStartLocator(), (String)config.getStartLocator());
        CacheManagementDUnitTest.assertEquals((String)data.getLogFile(), (String)config.getLogFile().getAbsolutePath());
        CacheManagementDUnitTest.assertEquals((int)data.getLogLevel(), (int)config.getLogLevel());
        CacheManagementDUnitTest.assertEquals((boolean)data.isStatisticSamplingEnabled(), (boolean)config.getStatisticSamplingEnabled());
        CacheManagementDUnitTest.assertEquals((String)data.getStatisticArchiveFile(), (String)config.getStatisticArchiveFile().getAbsolutePath());
        Object includeFile = null;
        CacheManagementDUnitTest.assertEquals((int)data.getAckWaitThreshold(), (int)config.getAckWaitThreshold());
        CacheManagementDUnitTest.assertEquals((int)data.getAckSevereAlertThreshold(), (int)config.getAckSevereAlertThreshold());
        CacheManagementDUnitTest.assertEquals((int)data.getArchiveFileSizeLimit(), (int)config.getArchiveFileSizeLimit());
        CacheManagementDUnitTest.assertEquals((int)data.getArchiveDiskSpaceLimit(), (int)config.getArchiveDiskSpaceLimit());
        CacheManagementDUnitTest.assertEquals((int)data.getLogFileSizeLimit(), (int)config.getLogFileSizeLimit());
        CacheManagementDUnitTest.assertEquals((int)data.getLogDiskSpaceLimit(), (int)config.getLogDiskSpaceLimit());
        CacheManagementDUnitTest.assertEquals((boolean)data.isSslEnabled(), (boolean)config.getSSLEnabled());
        CacheManagementDUnitTest.assertEquals((String)data.getSslCiphers(), (String)config.getSSLCiphers());
        CacheManagementDUnitTest.assertEquals((String)data.getSslProtocols(), (String)config.getSSLProtocols());
        CacheManagementDUnitTest.assertEquals((boolean)data.isSslRequireAuthentication(), (boolean)config.getSSLRequireAuthentication());
        CacheManagementDUnitTest.assertEquals((int)data.getSocketLeaseTime(), (int)config.getSocketLeaseTime());
        CacheManagementDUnitTest.assertEquals((int)data.getSocketBufferSize(), (int)config.getSocketBufferSize());
        CacheManagementDUnitTest.assertEquals((int)data.getMcastSendBufferSize(), (int)config.getMcastSendBufferSize());
        CacheManagementDUnitTest.assertEquals((int)data.getMcastRecvBufferSize(), (int)config.getMcastRecvBufferSize());
        CacheManagementDUnitTest.assertEquals((int)data.getMcastByteAllowance(), (int)config.getMcastFlowControl().getByteAllowance());
        CacheManagementDUnitTest.assertEquals((Object)Float.valueOf(data.getMcastRechargeThreshold()), (Object)Float.valueOf(config.getMcastFlowControl().getRechargeThreshold()));
        CacheManagementDUnitTest.assertEquals((int)data.getMcastRechargeBlockMs(), (int)config.getMcastFlowControl().getRechargeBlockMs());
        CacheManagementDUnitTest.assertEquals((int)data.getUdpFragmentSize(), (int)config.getUdpFragmentSize());
        CacheManagementDUnitTest.assertEquals((int)data.getUdpSendBufferSize(), (int)config.getUdpSendBufferSize());
        CacheManagementDUnitTest.assertEquals((int)data.getUdpRecvBufferSize(), (int)config.getUdpRecvBufferSize());
        CacheManagementDUnitTest.assertEquals((boolean)data.isDisableTcp(), (boolean)config.getDisableTcp());
        CacheManagementDUnitTest.assertEquals((boolean)data.isEnableTimeStatistics(), (boolean)config.getEnableTimeStatistics());
        CacheManagementDUnitTest.assertEquals((boolean)data.isEnableNetworkPartitionDetection(), (boolean)config.getEnableNetworkPartitionDetection());
        CacheManagementDUnitTest.assertEquals((int)data.getMemberTimeout(), (int)config.getMemberTimeout());
        int[] configPortRange = config.getMembershipPortRange();
        int[] dataPortRange = data.getMembershipPortRange();
        CacheManagementDUnitTest.assertEquals((int)dataPortRange.length, (int)configPortRange.length);
        for (int i = 0; i < dataPortRange.length; ++i) {
            CacheManagementDUnitTest.assertEquals((int)dataPortRange[i], (int)configPortRange[i]);
        }
        CacheManagementDUnitTest.assertEquals((boolean)data.isConserveSockets(), (boolean)config.getConserveSockets());
        CacheManagementDUnitTest.assertEquals((String)data.getRoles(), (String)config.getRoles());
        CacheManagementDUnitTest.assertEquals((int)data.getMaxWaitTimeForReconnect(), (int)config.getMaxWaitTimeForReconnect());
        CacheManagementDUnitTest.assertEquals((int)data.getMaxNumReconnectTries(), (int)config.getMaxNumReconnectTries());
        CacheManagementDUnitTest.assertEquals((int)data.getAsyncDistributionTimeout(), (int)config.getAsyncDistributionTimeout());
        CacheManagementDUnitTest.assertEquals((int)data.getAsyncQueueTimeout(), (int)config.getAsyncQueueTimeout());
        CacheManagementDUnitTest.assertEquals((int)data.getAsyncMaxQueueSize(), (int)config.getAsyncMaxQueueSize());
        CacheManagementDUnitTest.assertEquals((String)data.getClientConflation(), (String)config.getClientConflation());
        CacheManagementDUnitTest.assertEquals((String)data.getDurableClientId(), (String)config.getDurableClientId());
        CacheManagementDUnitTest.assertEquals((int)data.getDurableClientTimeout(), (int)config.getDurableClientTimeout());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityClientAuthInit(), (String)config.getSecurityClientAuthInit());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityClientAuthenticator(), (String)config.getSecurityClientAuthenticator());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityClientDHAlgo(), (String)config.getSecurityClientDHAlgo());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityPeerAuthInit(), (String)config.getSecurityPeerAuthInit());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityClientAuthenticator(), (String)config.getSecurityPeerAuthenticator());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityClientAccessor(), (String)config.getSecurityClientAccessor());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityClientAccessorPP(), (String)config.getSecurityClientAccessorPP());
        CacheManagementDUnitTest.assertEquals((int)data.getSecurityLogLevel(), (int)config.getSecurityLogLevel());
        CacheManagementDUnitTest.assertEquals((String)data.getSecurityLogFile(), (String)config.getSecurityLogFile().getAbsolutePath());
        CacheManagementDUnitTest.assertEquals((int)data.getSecurityPeerMembershipTimeout(), (int)config.getSecurityPeerMembershipTimeout());
        CacheManagementDUnitTest.assertEquals((boolean)data.isRemoveUnresponsiveClient(), (boolean)config.getRemoveUnresponsiveClient());
        CacheManagementDUnitTest.assertEquals((boolean)data.isDeltaPropagation(), (boolean)config.getDeltaPropagation());
        CacheManagementDUnitTest.assertEquals((String)data.getRedundancyZone(), (String)config.getRedundancyZone());
        CacheManagementDUnitTest.assertEquals((boolean)data.isEnforceUniqueHost(), (boolean)config.getEnforceUniqueHost());
        CacheManagementDUnitTest.assertEquals((int)data.getStatisticSampleRate(), (int)config.getStatisticSampleRate());
    }

    public static void startManager() {
        MemberMXBean bean = CacheManagementDUnitTest.getManagementService().getMemberMXBean();
        if (!bean.isManagerCreated()) {
            if (!bean.createManager()) {
                CacheManagementDUnitTest.fail((String)"Could not create Manager");
            } else if (!bean.isManagerCreated()) {
                CacheManagementDUnitTest.fail((String)"Should have been a manager after createManager returned true.");
            }
        }
        ManagerMXBean mngrBean = CacheManagementDUnitTest.getManagementService().getManagerMXBean();
        try {
            mngrBean.start();
        }
        catch (JMException e) {
            CacheManagementDUnitTest.fail((String)("Could not start Manager " + e));
        }
        CacheManagementDUnitTest.assertTrue((boolean)mngrBean.isRunning());
        CacheManagementDUnitTest.assertTrue((boolean)CacheManagementDUnitTest.getManagementService().isManager());
        CacheManagementDUnitTest.assertTrue((boolean)bean.isManager());
    }

    public static void isManager() {
        MemberMXBean bean = CacheManagementDUnitTest.getManagementService().getMemberMXBean();
        if (bean.createManager()) {
            ManagerMXBean mngrBean = CacheManagementDUnitTest.getManagementService().getManagerMXBean();
            try {
                mngrBean.start();
            }
            catch (JMException e) {
                CacheManagementDUnitTest.fail((String)("Could not start Manager " + e));
            }
        } else {
            CacheManagementDUnitTest.fail((String)" Could not create Manager");
        }
    }

    public static String fetchLog() {
        MemberMXBean bean = CacheManagementDUnitTest.getManagementService().getMemberMXBean();
        String log = bean.showLog(30);
        return log;
    }

    public static void fetchJVMMetrics() {
        MemberMXBean bean = CacheManagementDUnitTest.getManagementService().getMemberMXBean();
        JVMMetrics metrics = bean.showJVMMetrics();
        CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> JVMMetrics is " + metrics.toString() + "</ExpectedString> ");
    }

    public static void fetchOSMetrics() {
        MemberMXBean bean = CacheManagementDUnitTest.getManagementService().getMemberMXBean();
        OSMetrics metrics = bean.showOSMetrics();
        CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> OSMetrics is " + metrics.toString() + "</ExpectedString> ");
    }

    public static void shutDownMember() {
        MemberMXBean bean = CacheManagementDUnitTest.getManagementService().getMemberMXBean();
        bean.shutDownMember();
    }

    public static void assertExpectedMembers(int expectedMemberCount) {
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Waiting all nodes to shutDown";
            }

            @Override
            public boolean done() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set setOfOtherMembers = cache.getDistributedSystem().getAllOtherMembers();
                boolean done = setOfOtherMembers != null && setOfOtherMembers.size() == 1;
                return done;
            }
        }, 70000L, 500L, true);
    }

    public static void invokeRemoteOps() throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
        for (DistributedMember member : otherMemberSet) {
            MemberMXBean bean = MBeanUtil.getMemberMbeanProxy(member);
            String log = bean.showLog(5);
            CacheManagementDUnitTest.assertNotNull((Object)log);
            CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> Log Of Reomote Member is " + log.toString() + "</ExpectedString> ");
            JVMMetrics metrics = bean.showJVMMetrics();
            CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> JVMMetrics is " + metrics.toString() + "</ExpectedString> ");
            CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> OSMetrics is " + metrics.toString() + "</ExpectedString> ");
            CacheManagementDUnitTest.getLogWriter().info("<ExpectedString> Boolean Data Check " + bean.isManager() + "</ExpectedString> ");
        }
    }

    public void verifyStatistics() {
    }

    public void invokeOperations() {
    }

    public void testNotification() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createCache(node1);
        this.createCache(node2);
        this.createCache(node3);
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.attchListenerToDSMBean(managingNode);
        this.countNotificationsAndCheckRegionSize(node1, node2, node3, managingNode);
    }

    public void testNotificationManagingNodeFirst() throws Exception {
        List<VM> managedNodeList = CacheManagementDUnitTest.getManagedNodeList();
        VM node1 = managedNodeList.get(0);
        VM node2 = managedNodeList.get(1);
        VM node3 = managedNodeList.get(2);
        VM managingNode = CacheManagementDUnitTest.getManagingNode();
        this.createManagementCache(managingNode);
        this.startManagingNode(managingNode);
        this.attchListenerToDSMBean(managingNode);
        this.createCache(node1);
        this.createCache(node2);
        this.createCache(node3);
        this.countNotificationsAndCheckRegionSize(node1, node2, node3, managingNode);
    }

    protected void attchListenerToDSMBean(VM vm) {
        SerializableRunnable attchListenerToDSMBean = new SerializableRunnable("Attach Listener to DS MBean"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)ManagementTestBase.managementService.isManager());
                DistributedSystemMXBean dsMBean = ManagementTestBase.managementService.getDistributedSystemMXBean();
                notifList.clear();
                NotificationListener nt = new NotificationListener(){

                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        if (notification.getType().equals("gemfire.distributedsystem.cache.region.created")) {
                            notifList.add(notification);
                        }
                    }
                };
                try {
                    ManagementTestBase.mbeanServer.addNotificationListener(MBeanJMXAdapter.getDistributedSystemName(), nt, null, null);
                }
                catch (InstanceNotFoundException e) {
                    TestCase.fail((String)("Failed With Exception " + e));
                }
            }
        };
        vm.invoke(attchListenerToDSMBean);
    }

    public void waitForManagerToRegisterListener() {
        SystemManagementService service = (SystemManagementService)CacheManagementDUnitTest.getManagementService();
        final Map hubMap = service.getNotificationHub().getListenerObjectMap();
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Waiting for manager to register the listener";
            }

            @Override
            public boolean done() {
                boolean done = 1 == hubMap.size();
                return done;
            }
        }, 70000L, 500L, true);
    }

    public void countNotificationsAndCheckRegionSize(VM node1, VM node2, VM node3, VM managingNode) {
        DistributedMember member1 = this.getMember(node1);
        DistributedMember member2 = this.getMember(node2);
        DistributedMember member3 = this.getMember(node3);
        final String appender1 = MBeanJMXAdapter.getUniqueIDForMember((DistributedMember)member1);
        final String appender2 = MBeanJMXAdapter.getUniqueIDForMember((DistributedMember)member2);
        final String appender3 = MBeanJMXAdapter.getUniqueIDForMember((DistributedMember)member3);
        node1.invoke(new SerializableRunnable("Create Regions"){

            @Override
            public void run() {
                Cache cache = CacheManagementDUnitTest.this.getCache();
                CacheManagementDUnitTest.this.waitForManagerToRegisterListener();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                for (int i = 1; i <= 15; ++i) {
                    rf.create("NotifTestRegion_" + i);
                }
                Region member1NotifRegion = cache.getRegion("_notificationRegion_" + appender1);
                TestCase.assertEquals((int)0, (int)member1NotifRegion.size());
            }
        });
        node2.invoke(new SerializableRunnable("Create Regions"){

            @Override
            public void run() {
                Cache cache = CacheManagementDUnitTest.this.getCache();
                CacheManagementDUnitTest.this.waitForManagerToRegisterListener();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                for (int i = 1; i <= 15; ++i) {
                    rf.create("NotifTestRegion_" + i);
                }
                Region member2NotifRegion = cache.getRegion("_notificationRegion_" + appender2);
                TestCase.assertEquals((int)0, (int)member2NotifRegion.size());
            }
        });
        node3.invoke(new SerializableRunnable("Create Regions"){

            @Override
            public void run() {
                Cache cache = CacheManagementDUnitTest.this.getCache();
                CacheManagementDUnitTest.this.waitForManagerToRegisterListener();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                for (int i = 1; i <= 15; ++i) {
                    rf.create("NotifTestRegion_" + i);
                }
                Region member3NotifRegion = cache.getRegion("_notificationRegion_" + appender3);
                TestCase.assertEquals((int)0, (int)member3NotifRegion.size());
            }
        });
        managingNode.invoke(new SerializableRunnable("Validate Notification Count"){

            @Override
            public void run() {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for all the RegionCreated notification to reach the manager " + notifList.size();
                    }

                    @Override
                    public boolean done() {
                        boolean done = 45 == notifList.size();
                        return done;
                    }
                }, 70000L, 500L, true);
                TestCase.assertEquals((int)45, (int)notifList.size());
                Cache cache = CacheManagementDUnitTest.this.getCache();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                Region member1NotifRegion = cache.getRegion("_notificationRegion_" + appender1);
                Region member2NotifRegion = cache.getRegion("_notificationRegion_" + appender2);
                Region member3NotifRegion = cache.getRegion("_notificationRegion_" + appender3);
                TestCase.assertEquals((int)10, (int)member1NotifRegion.size());
                TestCase.assertEquals((int)10, (int)member2NotifRegion.size());
                TestCase.assertEquals((int)10, (int)member3NotifRegion.size());
            }
        });
    }
}

