/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.statistics;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.RegionMembershipListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.StatArchiveReader;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.statistics.SampleCollector;
import com.gemstone.gemfire.internal.statistics.StatArchiveHandler;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class StatisticsDUnitTest
extends CacheTestCase {
    private static final String dir = "StatisticsDUnitTest";
    private static final int MAX_PUTS = 1000;
    private static final int NUM_KEYS = 100;
    private static final int NUM_PUB_THREADS = 2;
    private static final int NUM_PUBS = 2;
    private static final boolean RANDOMIZE_PUTS = true;
    private static AtomicInteger updateEvents = new AtomicInteger();
    private static AtomicInteger puts = new AtomicInteger();
    private static AtomicReference<PubSubStats> subStatsRef = new AtomicReference();
    private static AtomicReferenceArray<PubSubStats> pubStatsRef = new AtomicReferenceArray(2);
    private static AtomicReference<RegionMembershipListener> rmlRef = new AtomicReference();

    private static void cleanup() {
        updateEvents.set(0);
        rmlRef.set(null);
    }

    private static int getUpdateEvents() {
        return updateEvents.get();
    }

    private static int getPuts() {
        return puts.get();
    }

    public StatisticsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        StatisticsDUnitTest.invokeInEveryVM(this.getClass(), "cleanup");
        StatisticsDUnitTest.disconnectAllFromDS();
    }

    public void testPubAndSubCustomStats() throws Exception {
        String testName = "testPubAndSubCustomStats";
        String regionName = "region_testPubAndSubCustomStats";
        VM[] pubs = new VM[2];
        for (int pubVM = 0; pubVM < 2; ++pubVM) {
            pubs[pubVM] = Host.getHost(0).getVM(pubVM);
        }
        VM sub = Host.getHost(0).getVM(2);
        final String subArchive = dir + File.separator + "testPubAndSubCustomStats" + "_sub.gfs";
        final String[] pubArchives = new String[2];
        for (int pubVM = 0; pubVM < 2; ++pubVM) {
            pubArchives[pubVM] = dir + File.separator + "testPubAndSubCustomStats" + "_pub-" + pubVM + ".gfs";
        }
        int i = 0;
        while (i < 2) {
            final int pubVM = i++;
            pubs[pubVM].invoke(new CacheSerializableRunnable("pub-connect-and-create-data-" + pubVM){

                @Override
                public void run2() throws CacheException {
                    new File(StatisticsDUnitTest.dir).mkdir();
                    Properties props = new Properties();
                    props.setProperty("statistic-sampling-enabled", "true");
                    props.setProperty("statistic-sample-rate", "1000");
                    props.setProperty("statistic-archive-file", pubArchives[pubVM]);
                    InternalDistributedSystem system = StatisticsDUnitTest.this.getSystem(props);
                    final GemFireStatSampler sampler = system.getStatSampler();
                    TestCase.assertTrue((boolean)sampler.isSamplingEnabled());
                    TestCase.assertTrue((boolean)sampler.isAlive());
                    TestCase.assertEquals((Object)new File(pubArchives[pubVM]), (Object)sampler.getArchiveFileName());
                    DistributedTestCase.WaitCriterion waitForSampleCollector = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return sampler.getSampleCollector() != null;
                        }

                        @Override
                        public String description() {
                            return "sampler.getSampleCollector() is still null!";
                        }
                    };
                    DistributedTestCase.waitForCriterion(waitForSampleCollector, 4000L, 10L, true);
                    SampleCollector sampleCollector = sampler.getSampleCollector();
                    TestCase.assertNotNull((Object)sampleCollector);
                    StatArchiveHandler archiveHandler = sampleCollector.getStatArchiveHandler();
                    TestCase.assertNotNull((Object)archiveHandler);
                    TestCase.assertTrue((boolean)archiveHandler.isArchiving());
                    Cache cache = StatisticsDUnitTest.this.getCache();
                    RegionFactory factory = cache.createRegionFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    RegionMembershipListener rml = new RegionMembershipListener();
                    rmlRef.set(rml);
                    factory.addCacheListener((CacheListener)rml);
                    Region region = factory.create("region_testPubAndSubCustomStats");
                    if (region.getAttributes().getScope() == Scope.DISTRIBUTED_ACK) {
                        for (int key = 0; key < 100; ++key) {
                            region.create((Object)("KEY-" + key), null);
                        }
                    }
                }
            });
        }
        final DistributedMember subMember = (DistributedMember)sub.invoke(new SerializableCallable("sub-connect-and-create-keys"){

            public Object call() throws Exception {
                new File(StatisticsDUnitTest.dir).mkdir();
                Properties props = new Properties();
                props.setProperty("statistic-sampling-enabled", "true");
                props.setProperty("statistic-sample-rate", "1000");
                props.setProperty("statistic-archive-file", subArchive);
                InternalDistributedSystem system = StatisticsDUnitTest.this.getSystem(props);
                PubSubStats statistics = new PubSubStats((StatisticsFactory)system, "sub-1", 1);
                subStatsRef.set(statistics);
                final GemFireStatSampler sampler = system.getStatSampler();
                TestCase.assertTrue((boolean)sampler.isSamplingEnabled());
                TestCase.assertTrue((boolean)sampler.isAlive());
                TestCase.assertEquals((Object)new File(subArchive), (Object)sampler.getArchiveFileName());
                DistributedTestCase.WaitCriterion waitForSampleCollector = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return sampler.getSampleCollector() != null;
                    }

                    @Override
                    public String description() {
                        return "sampler.getSampleCollector() is still null!";
                    }
                };
                DistributedTestCase.waitForCriterion(waitForSampleCollector, 2000L, 10L, true);
                SampleCollector sampleCollector = sampler.getSampleCollector();
                TestCase.assertNotNull((Object)sampleCollector);
                StatArchiveHandler archiveHandler = sampleCollector.getStatArchiveHandler();
                TestCase.assertNotNull((Object)archiveHandler);
                TestCase.assertTrue((boolean)archiveHandler.isArchiving());
                Cache cache = StatisticsDUnitTest.this.getCache();
                RegionFactory factory = cache.createRegionFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                UpdateListener cl = new UpdateListener(statistics);
                factory.addCacheListener((CacheListener)cl);
                Region region = factory.create("region_testPubAndSubCustomStats");
                if (region.getAttributes().getScope() == Scope.DISTRIBUTED_ACK) {
                    for (int key = 0; key < 100; ++key) {
                        region.create((Object)("KEY-" + key), null);
                    }
                }
                TestCase.assertEquals((int)0, (int)statistics.getUpdateEvents());
                return system.getDistributedMember();
            }
        });
        for (int i2 = 0; i2 < 2; ++i2) {
            final int pubVM = i2;
            AsyncInvocation[] publishers = new AsyncInvocation[2];
            int j = 0;
            while (j < 2) {
                final int pubThread = j++;
                publishers[pubThread] = pubs[pubVM].invokeAsync(new CacheSerializableRunnable("pub-connect-and-put-data-" + pubVM + "-thread-" + pubThread){

                    @Override
                    public void run2() throws CacheException {
                        PubSubStats statistics = new PubSubStats((StatisticsFactory)DistributedTestCase.system, "pub-" + pubThread, pubVM);
                        pubStatsRef.set(pubThread, statistics);
                        final RegionMembershipListener rml = (RegionMembershipListener)((Object)rmlRef.get());
                        Region region = StatisticsDUnitTest.this.getCache().getRegion("region_testPubAndSubCustomStats");
                        TestCase.assertNotNull((Object)((Object)rml));
                        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                return rml.contains(subMember) && rml.size() == 2;
                            }

                            @Override
                            public String description() {
                                return rml.members + " should contain " + subMember;
                            }
                        };
                        DistributedTestCase.waitForCriterion(wc, 4000L, 10L, true);
                        TestCase.assertEquals((int)0, (int)statistics.getPuts());
                        Random randomGenerator = new Random();
                        int key = 0;
                        for (int i = 0; i < 1000; ++i) {
                            long start = statistics.startPut();
                            key = randomGenerator.nextInt(100);
                            region.put((Object)("KEY-" + key), (Object)i);
                            statistics.endPut(start);
                        }
                        TestCase.assertEquals((int)1000, (int)statistics.getPuts());
                        StatisticsType statSamplerType = StatisticsDUnitTest.this.getSystem().findType("StatSampler");
                        Statistics[] statsArray = StatisticsDUnitTest.this.getSystem().findStatisticsByType(statSamplerType);
                        TestCase.assertEquals((int)1, (int)statsArray.length);
                        final Statistics statSamplerStats = statsArray[0];
                        final int initialSampleCount = statSamplerStats.getInt("sampleCount");
                        wc = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                return statSamplerStats.getInt("sampleCount") >= initialSampleCount + 2;
                            }

                            @Override
                            public String description() {
                                return "Waiting for sampleCount >= " + initialSampleCount + 2;
                            }
                        };
                        DistributedTestCase.waitForCriterion(wc, 4000L, 10L, true);
                    }
                });
            }
            for (int pubThread = 0; pubThread < publishers.length; ++pubThread) {
                publishers[pubThread].join();
                if (!publishers[pubThread].exceptionOccurred()) continue;
                StatisticsDUnitTest.fail("Test failed", publishers[pubThread].getException());
            }
        }
        sub.invoke(new CacheSerializableRunnable("sub-wait-for-samples"){

            @Override
            public void run2() throws CacheException {
                StatisticsType statSamplerType = StatisticsDUnitTest.this.getSystem().findType("StatSampler");
                Statistics[] statsArray = StatisticsDUnitTest.this.getSystem().findStatisticsByType(statSamplerType);
                TestCase.assertEquals((int)1, (int)statsArray.length);
                final Statistics statSamplerStats = statsArray[0];
                final int initialSampleCount = statSamplerStats.getInt("sampleCount");
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return statSamplerStats.getInt("sampleCount") >= initialSampleCount + 2;
                    }

                    @Override
                    public String description() {
                        return "Waiting for sampleCount >= " + initialSampleCount + 2;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 4000L, 10L, true);
                PubSubStats statistics = (PubSubStats)subStatsRef.get();
                TestCase.assertNotNull((Object)statistics);
                updateEvents.set(statistics.getUpdateEvents());
            }
        });
        final int totalUpdateEvents = sub.invokeInt(this.getClass(), "getUpdateEvents");
        int i3 = 0;
        while (i3 < 2) {
            final int pubIdx = i3++;
            pubs[pubIdx].invoke(new CacheSerializableRunnable("pub-validation"){

                @Override
                public void run2() throws CacheException {
                    TestCase.assertEquals((int)2, (int)pubStatsRef.length());
                    int totalPuts = 0;
                    for (int pubThreadIdx = 0; pubThreadIdx < 2; ++pubThreadIdx) {
                        PubSubStats statistics = (PubSubStats)pubStatsRef.get(pubThreadIdx);
                        TestCase.assertNotNull((Object)statistics);
                        totalPuts += statistics.getPuts();
                    }
                    TestCase.assertEquals((int)2000, (int)totalPuts);
                    File archive = new File(pubArchives[pubIdx]);
                    TestCase.assertTrue((boolean)archive.exists());
                    StatArchiveReader reader = null;
                    try {
                        reader = new StatArchiveReader(new File[]{archive}, null, false);
                    }
                    catch (IOException e) {
                        TestCase.fail((String)("Failed to read " + archive));
                    }
                    double combinedPuts = 0.0;
                    List resources = reader.getResourceInstList();
                    TestCase.assertNotNull((Object)resources);
                    TestCase.assertFalse((boolean)resources.isEmpty());
                    for (StatArchiveReader.ResourceInst ri : resources) {
                        if (!ri.getType().getName().equals("PubSubStats")) continue;
                        StatArchiveReader.StatValue[] statValues = ri.getStatValues();
                        for (int i = 0; i < statValues.length; ++i) {
                            String statName = ri.getType().getStats()[i].getName();
                            TestCase.assertNotNull((Object)statName);
                            if (!statName.equals("puts")) continue;
                            StatArchiveReader.StatValue sv = statValues[i];
                            sv.setFilter(0);
                            double mostRecent = sv.getSnapshotsMostRecent();
                            double min = sv.getSnapshotsMinimum();
                            double max = sv.getSnapshotsMaximum();
                            double maxMinusMin = sv.getSnapshotsMaximum() - sv.getSnapshotsMinimum();
                            double mean = sv.getSnapshotsAverage();
                            double stdDev = sv.getSnapshotsStandardDeviation();
                            TestCase.assertEquals((Object)mostRecent, (Object)max);
                            double summation = 0.0;
                            double[] rawSnapshots = sv.getRawSnapshots();
                            for (int j = 0; j < rawSnapshots.length; ++j) {
                                summation += rawSnapshots[j];
                            }
                            TestCase.assertEquals((Object)mean, (Object)(summation / (double)sv.getSnapshotsSize()));
                            combinedPuts += mostRecent;
                        }
                    }
                    TestCase.assertEquals((Object)totalPuts, (Object)combinedPuts);
                    puts.getAndAdd(totalPuts);
                }
            });
        }
        int totalCombinedPuts = 0;
        int i4 = 0;
        while (i4 < 2) {
            int pubIdx = i4++;
            int totalPuts = pubs[pubIdx].invokeInt(this.getClass(), "getPuts");
            StatisticsDUnitTest.assertEquals((int)2000, (int)totalPuts);
            totalCombinedPuts += totalPuts;
        }
        StatisticsDUnitTest.assertEquals((int)totalCombinedPuts, (int)totalUpdateEvents);
        StatisticsDUnitTest.assertEquals((int)4000, (int)totalCombinedPuts);
        final int totalPuts = totalCombinedPuts;
        sub.invoke(new CacheSerializableRunnable("sub-validation"){

            @Override
            public void run2() throws CacheException {
                PubSubStats statistics = (PubSubStats)subStatsRef.get();
                TestCase.assertNotNull((Object)statistics);
                int updateEvents = statistics.getUpdateEvents();
                TestCase.assertEquals((int)totalPuts, (int)updateEvents);
                TestCase.assertEquals((int)totalUpdateEvents, (int)updateEvents);
                TestCase.assertEquals((int)4000, (int)updateEvents);
                File archive = new File(subArchive);
                TestCase.assertTrue((boolean)archive.exists());
                StatArchiveReader reader = null;
                try {
                    reader = new StatArchiveReader(new File[]{archive}, null, false);
                }
                catch (IOException e) {
                    TestCase.fail((String)("Failed to read " + archive));
                }
                double combinedUpdateEvents = 0.0;
                List resources = reader.getResourceInstList();
                for (StatArchiveReader.ResourceInst ri : resources) {
                    if (!ri.getType().getName().equals("PubSubStats")) continue;
                    StatArchiveReader.StatValue[] statValues = ri.getStatValues();
                    for (int i = 0; i < statValues.length; ++i) {
                        String statName = ri.getType().getStats()[i].getName();
                        TestCase.assertNotNull((Object)statName);
                        if (!statName.equals("updateEvents")) continue;
                        StatArchiveReader.StatValue sv = statValues[i];
                        sv.setFilter(0);
                        double mostRecent = sv.getSnapshotsMostRecent();
                        double min = sv.getSnapshotsMinimum();
                        double max = sv.getSnapshotsMaximum();
                        double maxMinusMin = sv.getSnapshotsMaximum() - sv.getSnapshotsMinimum();
                        double mean = sv.getSnapshotsAverage();
                        double stdDev = sv.getSnapshotsStandardDeviation();
                        TestCase.assertEquals((Object)mostRecent, (Object)max);
                        double summation = 0.0;
                        double[] rawSnapshots = sv.getRawSnapshots();
                        for (int j = 0; j < rawSnapshots.length; ++j) {
                            summation += rawSnapshots[j];
                        }
                        TestCase.assertEquals((Object)mean, (Object)(summation / (double)sv.getSnapshotsSize()));
                        combinedUpdateEvents += mostRecent;
                    }
                }
                TestCase.assertEquals((Object)totalUpdateEvents, (Object)combinedUpdateEvents);
            }
        });
        int updateEvents = sub.invokeInt(this.getClass(), "readIntStat", new Object[]{new File(subArchive), "PubSubStats", "updateEvents"});
        StatisticsDUnitTest.assertTrue((updateEvents > 0 ? 1 : 0) != 0);
        StatisticsDUnitTest.assertEquals((int)4000, (int)updateEvents);
        int puts = 0;
        for (int pubVM = 0; pubVM < 2; ++pubVM) {
            int vmPuts = pubs[pubVM].invokeInt(this.getClass(), "readIntStat", new Object[]{new File(pubArchives[pubVM]), "PubSubStats", "puts"});
            StatisticsDUnitTest.assertTrue((vmPuts > 0 ? 1 : 0) != 0);
            StatisticsDUnitTest.assertEquals((int)2000, (int)vmPuts);
            puts += vmPuts;
        }
        StatisticsDUnitTest.assertTrue((puts > 0 ? 1 : 0) != 0);
        StatisticsDUnitTest.assertEquals((int)4000, (int)puts);
        MultipleArchiveReader reader = new MultipleArchiveReader(".*testPubAndSubCustomStats.*\\.gfs");
        int combinedUpdateEvents = reader.readIntStat("PubSubStats", "updateEvents");
        StatisticsDUnitTest.assertTrue((String)"Failed to read updateEvents stat values", (combinedUpdateEvents > 0 ? 1 : 0) != 0);
        int combinedPuts = reader.readIntStat("PubSubStats", "puts");
        StatisticsDUnitTest.assertTrue((String)"Failed to read puts stat values", (combinedPuts > 0 ? 1 : 0) != 0);
        StatisticsDUnitTest.assertTrue((String)("updateEvents is " + combinedUpdateEvents + " but puts is " + combinedPuts), (combinedUpdateEvents == combinedPuts ? 1 : 0) != 0);
    }

    static int readIntStat(File archive, String typeName, String statName) throws IOException {
        MultipleArchiveReader reader = new MultipleArchiveReader(archive);
        return reader.readIntStat(typeName, statName);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            String statType = args[0];
            String statName = args[1];
            MultipleArchiveReader reader = new MultipleArchiveReader();
            int value = reader.readIntStat(statType, statName);
            System.out.println(statType + "#" + statName + "=" + value);
        } else if (args.length == 3) {
            String archiveName = args[0];
            String statType = args[1];
            String statName = args[2];
            File archive = new File(archiveName).getAbsoluteFile();
            StatisticsDUnitTest.assertTrue((String)("File " + archive + " does not exist!"), (boolean)archive.exists());
            StatisticsDUnitTest.assertTrue((String)(archive + " exists but is not a file!"), (boolean)archive.isFile());
            MultipleArchiveReader reader = new MultipleArchiveReader(archive);
            int value = reader.readIntStat(statType, statName);
            System.out.println(archive + ": " + statType + "#" + statName + "=" + value);
        } else if (args.length == 4) {
            String statType1 = args[0];
            String statName1 = args[1];
            String statType2 = args[2];
            String statName2 = args[3];
            MultipleArchiveReader reader = new MultipleArchiveReader();
            int value1 = reader.readIntStat(statType1, statName1);
            int value2 = reader.readIntStat(statType2, statName2);
            StatisticsDUnitTest.assertTrue((String)(statType1 + "#" + statName1 + "=" + value1 + " does not equal " + statType2 + "#" + statName2 + "=" + value2), (value1 == value2 ? 1 : 0) != 0);
        } else {
            StatisticsDUnitTest.assertEquals((String)"Miminum two args are required: statType statName", (int)2, (int)args.length);
        }
    }

    static class MultipleArchiveReader {
        private final File dir;
        private final String regex;

        MultipleArchiveReader(File dir, String regex) {
            this.dir = dir;
            this.regex = regex;
        }

        MultipleArchiveReader(File dir) {
            this.dir = dir;
            this.regex = null;
        }

        MultipleArchiveReader(String regex) {
            this(new File(System.getProperty("user.dir")).getAbsoluteFile(), regex);
        }

        MultipleArchiveReader() {
            this(new File(System.getProperty("user.dir")).getAbsoluteFile(), null);
        }

        int readIntStat(String typeName, String statName) throws IOException {
            if (this.dir.exists() && this.dir.isDirectory()) {
                List<File> archives = MultipleArchiveReader.findFilesWithSuffix(this.dir, this.regex, ".gfs");
                return this.readIntStatFromArchives(archives, typeName, statName);
            }
            if (this.dir.exists() && this.dir.isFile()) {
                ArrayList<File> archives = new ArrayList<File>();
                archives.add(this.dir);
                return this.readIntStatFromArchives(archives, typeName, statName);
            }
            throw new IllegalStateException(this.dir + " does not exist!");
        }

        private int readIntStatFromArchives(List<File> archives, String typeName, String statName) throws IOException {
            StatArchiveReader.StatValue[] statValues = MultipleArchiveReader.readStatValues(archives, typeName, statName);
            TestCase.assertNotNull((String)"statValues is null!", (Object)statValues);
            TestCase.assertTrue((String)"statValues is empty!", (statValues.length > 0 ? 1 : 0) != 0);
            int value = 0;
            for (int i = 0; i < statValues.length; ++i) {
                statValues[i].setFilter(0);
                value += (int)statValues[i].getSnapshotsMaximum();
            }
            return value;
        }

        private static List<File> findFilesWithSuffix(File dir, final String regex, final String suffix) {
            Pattern p = null;
            if (regex != null) {
                p = Pattern.compile(regex);
            }
            final Pattern pattern = p;
            return MultipleArchiveReader.findFiles(dir, new FileFilter(){

                @Override
                public boolean accept(File file) {
                    boolean accept = true;
                    if (regex != null) {
                        Matcher matcher = pattern.matcher(file.getName());
                        accept = matcher.matches();
                    }
                    if (suffix != null) {
                        accept = accept && file.getName().endsWith(suffix);
                    }
                    return accept;
                }
            }, true);
        }

        private static List<File> findFiles(File dir, FileFilter filter, boolean recursive) {
            File[] files;
            File[] tmpfiles = dir.listFiles(filter);
            ArrayList<Object> matches = tmpfiles == null ? new ArrayList() : new ArrayList<File>(Arrays.asList(tmpfiles));
            if (recursive && (files = dir.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.isDirectory()) continue;
                    matches.addAll(MultipleArchiveReader.findFiles(file, filter, recursive));
                }
            }
            return matches;
        }

        private static StatArchiveReader.StatValue[] readStatValues(List<File> archives, final String typeName, final String statName) throws IOException {
            System.out.println("\nKIRK readStatValues reading archives:\n\n" + archives + "\n");
            StatArchiveReader.StatSpec statSpec = new StatArchiveReader.StatSpec(){

                public boolean archiveMatches(File value) {
                    return true;
                }

                public boolean typeMatches(String value) {
                    return typeName.equals(value);
                }

                public boolean statMatches(String value) {
                    return statName.equals(value);
                }

                public boolean instanceMatches(String textId, long numericId) {
                    return true;
                }

                public int getCombineType() {
                    return 1;
                }
            };
            File[] archiveFiles = archives.toArray(new File[archives.size()]);
            StatArchiveReader.StatSpec[] filters = new StatArchiveReader.StatSpec[]{statSpec};
            StatArchiveReader reader = new StatArchiveReader(archiveFiles, (StatArchiveReader.ValueFilter[])filters, true);
            StatArchiveReader.StatValue[] values = reader.matchSpec(statSpec);
            return values;
        }
    }

    static class RegionMembershipListener
    extends RegionMembershipListenerAdapter<String, Number> {
        private final List<DistributedMember> members = new ArrayList<DistributedMember>();

        RegionMembershipListener() {
        }

        int size() {
            return this.members.size();
        }

        List<DistributedMember> getMembers() {
            return Collections.unmodifiableList(new ArrayList<DistributedMember>(this.members));
        }

        boolean containsId(DistributedMember member) {
            for (DistributedMember peer : this.getMembers()) {
                if (!peer.getId().equals(member.getId())) continue;
                return true;
            }
            return false;
        }

        boolean contains(DistributedMember member) {
            return this.members.contains(member);
        }

        String debugContains(DistributedMember member) {
            StringBuffer sb = new StringBuffer();
            for (DistributedMember peer : this.getMembers()) {
                if (peer.equals(member)) continue;
                InternalDistributedMember peerIDM = (InternalDistributedMember)peer;
                InternalDistributedMember memberIDM = (InternalDistributedMember)member;
                sb.append("peer port=").append(peerIDM.getPort()).append(" ");
                sb.append("member port=").append(memberIDM.getPort()).append(" ");
            }
            return sb.toString();
        }

        public void initialMembers(Region<String, Number> region, DistributedMember[] initialMembers) {
            for (int i = 0; i < initialMembers.length; ++i) {
                this.members.add(initialMembers[i]);
            }
        }

        public void afterRemoteRegionCreate(RegionEvent<String, Number> event) {
            this.members.add(event.getDistributedMember());
        }

        public void afterRemoteRegionDeparture(RegionEvent<String, Number> event) {
            this.members.remove(event.getDistributedMember());
        }

        public void afterRemoteRegionCrash(RegionEvent<String, Number> event) {
            this.members.remove(event.getDistributedMember());
        }
    }

    static class UpdateListener
    extends CacheListenerAdapter<String, Number> {
        private final PubSubStats statistics;

        UpdateListener(PubSubStats statistics) {
            this.statistics = statistics;
        }

        public void afterUpdate(EntryEvent<String, Number> event) {
            this.statistics.incUpdateEvents(1);
        }
    }

    static class PubSubStats {
        private static final String TYPE_NAME = "PubSubStats";
        private static final String TYPE_DESCRIPTION = "Statistics for StatisticsDUnitTest with Pub/Sub.";
        private static final String INSTANCE_PREFIX = "pubSubStats_";
        private static final String PUTS = "puts";
        private static final String PUT_TIME = "putTime";
        private static final String UPDATE_EVENTS = "updateEvents";
        private final Statistics statistics;

        private static StatisticsType createType(StatisticsFactory f) {
            StatisticsTypeFactory stf = StatisticsTypeFactoryImpl.singleton();
            StatisticsType type = stf.createType(TYPE_NAME, TYPE_DESCRIPTION, PubSubStats.createDescriptors(f));
            return type;
        }

        private static StatisticDescriptor[] createDescriptors(StatisticsFactory f) {
            boolean largerIsBetter = true;
            return new StatisticDescriptor[]{f.createIntCounter(PUTS, "Number of puts completed.", "operations", largerIsBetter), f.createLongCounter(PUT_TIME, "Total time spent doing puts.", "nanoseconds", !largerIsBetter), f.createIntCounter(UPDATE_EVENTS, "Number of update events.", "events", largerIsBetter)};
        }

        PubSubStats(StatisticsFactory f, String name, int id) {
            this.statistics = f.createAtomicStatistics(PubSubStats.createType(f), "pubSubStats__" + name, (long)id);
        }

        Statistics statistics() {
            return this.statistics;
        }

        void close() {
            this.statistics.close();
        }

        int getUpdateEvents() {
            return this.statistics().getInt(UPDATE_EVENTS);
        }

        void incUpdateEvents() {
            this.incUpdateEvents(1);
        }

        void incUpdateEvents(int amount) {
            this.incStat(UPDATE_EVENTS, amount);
        }

        int getPuts() {
            return this.statistics().getInt(PUTS);
        }

        void incPuts() {
            this.incPuts(1);
        }

        void incPuts(int amount) {
            this.incStat(PUTS, amount);
        }

        void incPutTime(long amount) {
            this.incStat(PUT_TIME, amount);
        }

        long startPut() {
            return NanoTimer.getTime();
        }

        void endPut(long start) {
            this.endPut(start, 1);
        }

        void endPut(long start, int amount) {
            long elapsed = NanoTimer.getTime() - start;
            this.incPuts(amount);
            this.incPutTime(elapsed);
        }

        private void incStat(String statName, int intValue) {
            this.statistics().incInt(statName, intValue);
        }

        private void incStat(String statName, long longValue) {
            this.statistics().incLong(statName, longValue);
        }
    }
}

