/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.process.FileAlreadyExistsException;
import com.gemstone.gemfire.internal.process.LocalProcessLauncher;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;

public class LocalProcessLauncherDUnitTest
extends DistributedTestCase {
    public LocalProcessLauncherDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        new File(this.getClass().getSimpleName()).mkdir();
    }

    @Override
    public void tearDown2() throws Exception {
    }

    public void testExistingPidFileThrows() throws Exception {
        final File pidFile = new File(this.getClass().getSimpleName() + File.separator + "testExistingPidFileThrows.pid");
        final String absolutePath = pidFile.getAbsolutePath();
        LocalProcessLauncherDUnitTest.assertFalse((boolean)pidFile.exists());
        new LocalProcessLauncher(pidFile, false);
        LocalProcessLauncherDUnitTest.assertTrue((boolean)pidFile.exists());
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable("LocalProcessLauncherDUnitTest#testExistingPidFileThrows"){

            @Override
            public void run() {
                try {
                    new LocalProcessLauncher(new File(absolutePath), false);
                    TestCase.fail((String)("Two processes both succeeded in creating " + pidFile));
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IllegalStateException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                catch (PidUnavailableException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    public void testForceReplacesExistingPidFile() throws Exception {
        File pidFile = new File(this.getClass().getSimpleName() + File.separator + "testForceReplacesExistingPidFile.pid");
        final String absolutePath = pidFile.getAbsolutePath();
        LocalProcessLauncherDUnitTest.assertFalse((boolean)pidFile.exists());
        LocalProcessLauncher launcher = new LocalProcessLauncher(pidFile, false);
        LocalProcessLauncherDUnitTest.assertTrue((boolean)pidFile.exists());
        LocalProcessLauncherDUnitTest.assertNotNull((Object)launcher);
        final int pid = launcher.getPid();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable("LocalProcessLauncherDUnitTest#testForceReplacesExistingPidFile"){

            @Override
            public void run() {
                try {
                    LocalProcessLauncher launcher = new LocalProcessLauncher(new File(absolutePath), true);
                    TestCase.assertNotSame((Object)pid, (Object)launcher.getPid());
                    TestCase.assertFalse((pid == launcher.getPid() ? 1 : 0) != 0);
                    FileReader fr = new FileReader(absolutePath);
                    BufferedReader br = new BufferedReader(fr);
                    int pidFromFile = Integer.parseInt(br.readLine());
                    br.close();
                    TestCase.assertNotSame((Object)pid, (Object)pidFromFile);
                    TestCase.assertFalse((pid == pidFromFile ? 1 : 0) != 0);
                    TestCase.assertEquals((int)launcher.getPid(), (int)pidFromFile);
                }
                catch (IllegalStateException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                catch (FileAlreadyExistsException e) {
                    throw new AssertionError((Object)e);
                }
                catch (PidUnavailableException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    public void testPidFileReadByOtherProcess() throws Exception {
        File pidFile = new File(this.getClass().getSimpleName() + File.separator + "testPidFileReadByOtherProcess.pid");
        final String absolutePath = pidFile.getAbsolutePath();
        LocalProcessLauncherDUnitTest.assertFalse((boolean)pidFile.exists());
        LocalProcessLauncher launcher = new LocalProcessLauncher(pidFile, false);
        LocalProcessLauncherDUnitTest.assertTrue((boolean)pidFile.exists());
        LocalProcessLauncherDUnitTest.assertNotNull((Object)launcher);
        final int pid = launcher.getPid();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable("LocalProcessLauncherDUnitTest#testPidFileReadByOtherProcess"){

            @Override
            public void run() {
                try {
                    FileReader fr = new FileReader(absolutePath);
                    BufferedReader br = new BufferedReader(fr);
                    int pidFromFile = Integer.parseInt(br.readLine());
                    br.close();
                    TestCase.assertEquals((int)pid, (int)pidFromFile);
                }
                catch (FileNotFoundException e) {
                    throw new Error(e);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        });
    }
}

