/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import com.gemstone.gemfire.OutOfOffHeapMemoryException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.util.StopWatch;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class OutOfOffHeapMemoryDUnitTest
extends CacheTestCase {
    private static final String EXPECTED_EXCEPTIONS = "com.gemstone.gemfire.OutOfOffHeapMemoryException";
    private static final String ADD_EXPECTED_EXCEPTIONS = "<ExpectedException action=add>com.gemstone.gemfire.OutOfOffHeapMemoryException</ExpectedException>";
    private static final String REMOVE_EXPECTED_EXCEPTIONS = "<ExpectedException action=remove>com.gemstone.gemfire.OutOfOffHeapMemoryException</ExpectedException>";
    protected static final AtomicReference<Cache> cache = new AtomicReference();
    protected static final AtomicReference<DistributedSystem> system = new AtomicReference();
    protected static final AtomicBoolean isSmallerVM = new AtomicBoolean();

    public OutOfOffHeapMemoryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        long begin = System.currentTimeMillis();
        Cache gfc = null;
        while (gfc == null) {
            try {
                gfc = this.getCache();
                break;
            }
            catch (IllegalStateException e) {
                if (System.currentTimeMillis() > begin + 60000L) {
                    OutOfOffHeapMemoryDUnitTest.fail("OutOfOffHeapMemoryDUnitTest waited too long to getCache", e);
                    continue;
                }
                if (e.getMessage().contains("A connection to a distributed system already exists in this VM.  It has the following configuration")) {
                    InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
                    if (ids == null || !ids.isConnected()) continue;
                    ids.getLogWriter().warning("OutOfOffHeapMemoryDUnitTest found DistributedSystem connection from previous test", (Throwable)e);
                    ids.disconnect();
                    continue;
                }
                throw e;
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        OutOfOffHeapMemoryDUnitTest.invokeInEveryVM(this.getClass(), "cleanup");
    }

    private static void cleanup() {
        try {
            OutOfOffHeapMemoryDUnitTest.getLogWriter().info(REMOVE_EXPECTED_EXCEPTIONS);
        }
        finally {
            OutOfOffHeapMemoryDUnitTest.disconnectFromDS();
            SimpleMemoryAllocatorImpl.freeOffHeapMemory();
            cache.set(null);
            system.set(null);
            isSmallerVM.set(false);
        }
    }

    protected String getOffHeapMemorySize() {
        return "2m";
    }

    protected String getSmallerOffHeapMemorySize() {
        return "1m";
    }

    protected RegionShortcut getRegionShortcut() {
        return RegionShortcut.REPLICATE;
    }

    protected String getRegionName() {
        return "region1";
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = new Properties();
        props.put("statistic-sampling-enabled", "true");
        if (isSmallerVM.get()) {
            props.setProperty("off-heap-memory-size", this.getSmallerOffHeapMemorySize());
        } else {
            props.setProperty("off-heap-memory-size", this.getOffHeapMemorySize());
        }
        return props;
    }

    public void testSimpleOutOfOffHeapMemoryMemberDisconnects() {
        final Cache cache = this.getCache();
        InternalDistributedSystem system = this.getSystem();
        Region region = cache.createRegionFactory(this.getRegionShortcut()).setEnableOffHeapMemory(true).create(this.getRegionName());
        try {
            int i = 0;
            while (true) {
                region.put((Object)("key-" + i), (Object)new Byte[1024]);
                ++i;
            }
        }
        catch (OutOfOffHeapMemoryException e) {
            block7: {
                OutOfOffHeapMemoryException ooohme = e;
                OutOfOffHeapMemoryDUnitTest.assertNotNull((Object)((Object)ooohme));
                DistributedTestCase.WaitCriterion waitForDisconnect = new DistributedTestCase.WaitCriterion((DistributedSystem)system){
                    final /* synthetic */ DistributedSystem val$system;
                    {
                        this.val$system = distributedSystem;
                    }

                    @Override
                    public boolean done() {
                        return cache.isClosed() && !this.val$system.isConnected();
                    }

                    @Override
                    public String description() {
                        return "Waiting for disconnect to complete";
                    }
                };
                OutOfOffHeapMemoryDUnitTest.waitForCriterion(waitForDisconnect, 10000L, 100L, true);
                OutOfOffHeapMemoryDUnitTest.assertTrue((boolean)cache.isClosed());
                OutOfOffHeapMemoryDUnitTest.assertFalse((boolean)system.isConnected());
                try {
                    CacheFactory.getAnyInstance();
                    OutOfOffHeapMemoryDUnitTest.fail((String)"CacheFactory.getAnyInstance() should throw CacheClosedException");
                }
                catch (CacheClosedException cacheClosedException) {
                }
                catch (DistributedSystemDisconnectedException e2) {
                    boolean passed = false;
                    Throwable cause = e2.getCause();
                    while (cause != null) {
                        if (!(cause instanceof CacheClosedException)) continue;
                        passed = true;
                        break;
                    }
                    if (passed) break block7;
                    throw e2;
                }
            }
            OutOfOffHeapMemoryDUnitTest.assertFalse((boolean)InternalDistributedSystem.getAnyInstance().isConnected());
            return;
        }
    }

    protected static Region createRegion(Cache cache, RegionShortcut shortcut, String name) {
        return cache.createRegionFactory(shortcut).setEnableOffHeapMemory(true).create(name);
    }

    public void testOtherMembersSeeOutOfOffHeapMemoryMemberDisconnects() {
        int i;
        OutOfOffHeapMemoryDUnitTest.assertEquals((int)4, (int)Host.getHost(0).getVMCount());
        final String name = this.getRegionName();
        final RegionShortcut shortcut = this.getRegionShortcut();
        boolean smallerVM = true;
        final int count = Host.getHost(0).getVMCount();
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                isSmallerVM.set(true);
            }
        });
        for (i = 0; i < Host.getHost(0).getVMCount(); ++i) {
            Host.getHost(0).getVM(i).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    cache.set(OutOfOffHeapMemoryDUnitTest.this.getCache());
                    system.set((DistributedSystem)OutOfOffHeapMemoryDUnitTest.this.getSystem());
                    Region region = cache.get().createRegionFactory(shortcut).setEnableOffHeapMemory(true).create(name);
                    TestCase.assertNotNull((Object)region);
                }
            });
        }
        for (i = 0; i < count; ++i) {
            Host.getHost(0).getVM(i).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    TestCase.assertFalse((boolean)cache.get().isClosed());
                    TestCase.assertTrue((boolean)system.get().isConnected());
                    int countMembersPlusLocator = count + 2;
                    int countOtherMembers = count - 1;
                    TestCase.assertEquals((int)countMembersPlusLocator, (int)((InternalDistributedSystem)system.get()).getDistributionManager().getDistributionManagerIds().size());
                    TestCase.assertEquals((int)countOtherMembers, (int)((DistributedRegion)cache.get().getRegion(name)).getDistributionAdvisor().getNumProfiles());
                }
            });
        }
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info(OutOfOffHeapMemoryDUnitTest.ADD_EXPECTED_EXCEPTIONS);
            }
        });
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                long TIME_LIMIT = 30000L;
                StopWatch stopWatch = new StopWatch(true);
                int i = 0;
                int countOtherMembers = count - 1;
                Region region = cache.get().getRegion(name);
                i = 0;
                while (countOtherMembers > count - 2) {
                    region.put((Object)("key-" + i), (Object)new byte[1024]);
                    countOtherMembers = ((DistributedRegion)cache.get().getRegion(name)).getDistributionAdvisor().getNumProfiles();
                    TestCase.assertTrue((String)"puts failed to push member out of off-heap memory within time limit", (stopWatch.elapsedTimeMillis() < 30000L ? 1 : 0) != 0);
                    ++i;
                }
                TestCase.assertEquals((String)"Member did not depart from OutOfOffHeapMemory", (int)(count - 2), (int)countOtherMembers);
            }
        });
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.WaitCriterion waitForDisconnect = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return cache.get().isClosed() && !system.get().isConnected();
                    }

                    @Override
                    public String description() {
                        return "Waiting for disconnect to complete";
                    }
                };
                DistributedTestCase.waitForCriterion(waitForDisconnect, 10000L, 100L, true);
            }
        });
        for (i = 0; i < count; ++i) {
            if (i == 1) continue;
            Host.getHost(0).getVM(i).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    int countMembersPlusLocator = count + 2 - 1;
                    int countOtherMembers = count - 1 - 1;
                    TestCase.assertEquals((int)countMembersPlusLocator, (int)((InternalDistributedSystem)system.get()).getDistributionManager().getDistributionManagerIds().size());
                    TestCase.assertEquals((int)countOtherMembers, (int)((DistributedRegion)cache.get().getRegion(name)).getDistributionAdvisor().getNumProfiles());
                }
            });
        }
    }
}

