/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;

public class CompressionRegionOperationsDUnitTest
extends CacheTestCase {
    public static final String REGION_NAME = "compressedRegion";
    public static final int TEST_VM = 0;
    public static final String KEY_1 = "key1";
    public static final String KEY_2 = "key2";
    public static final String KEY_3 = "key3";
    public static final String VALUE_1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam auctor bibendum tempus. Suspendisse potenti. Ut enim neque, mattis et mattis ac, vulputate quis leo. Cras a metus metus, eget cursus ipsum. Aliquam sagittis condimentum massa aliquet rhoncus. Aliquam sed luctus neque. In hac habitasse platea dictumst.";
    private static final String VALUE_2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent sit amet lorem consequat est commodo lacinia. Duis tortor sem, facilisis quis tempus in, luctus lacinia metus. Vivamus augue justo, porttitor in vulputate accumsan, adipiscing sit amet sem. Quisque faucibus porta ipsum in pellentesque. Donec malesuada ultrices sapien sit amet tempus. Sed fringilla ipsum at tellus condimentum et hendrerit arcu pretium. Nulla non leo ligula. Etiam commodo tempor ligula non placerat. Vivamus vestibulum varius arcu a varius. Duis sit amet erat imperdiet dui mattis auctor et id orci. Suspendisse non elit augue. Quisque ac orci turpis, nec sollicitudin justo. Sed bibendum justo ut lacus aliquet lacinia et et neque. Proin hendrerit varius mauris vel lacinia. Proin pellentesque lacus vitae nisl euismod bibendum.";
    private static final String VALUE_3 = "In ut nisi nisi, eu malesuada mauris. Vestibulum nec tellus felis. Pellentesque mauris ligula, pretium nec consequat ut, adipiscing non lorem. Vivamus pulvinar viverra nisl, sit amet vestibulum tellus lobortis in. Pellentesque blandit ipsum sed neque rhoncus eu tristique risus porttitor. Vivamus molestie dapibus mi in lacinia. Suspendisse bibendum, purus at gravida accumsan, libero turpis elementum leo, eget posuere purus nibh ac dolor.";
    private static Map<String, String> putAllMap = new HashMap<String, String>();
    private static Map<String, Object> putAllMap2 = new HashMap<String, Object>();
    private static Map<String, byte[]> putAllMap3 = new HashMap<String, byte[]>();
    private static Collection<String> getAllCollection = new HashSet<String>();

    public CompressionRegionOperationsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createRegion();
    }

    protected void createRegion() {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        this.createCompressedRegionOnVm(this.getVM(0), REGION_NAME, (Compressor)compressor);
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            SnappyCompressor.getDefaultInstance();
            this.cleanup(this.getVM(0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.tearDown2();
    }

    public void testGetPutOperations() {
        this.testGetPutOperationsOnVM(this.getVM(0));
    }

    private void testGetPutOperationsOnVM(VM vm) {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionRegionOperationsDUnitTest.this.getCache().getRegion(CompressionRegionOperationsDUnitTest.REGION_NAME);
                String oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1);
                TestCase.assertNull((Object)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_2);
                if (null != oldValue) {
                    TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                }
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                oldValue = (String)region.putIfAbsent((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_3);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                region.putAll(putAllMap);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_2);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_3);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_3, (String)oldValue);
                Map getAllMap = region.getAll(getAllCollection);
                TestCase.assertTrue((boolean)getAllMap.containsValue(CompressionRegionOperationsDUnitTest.VALUE_1));
                TestCase.assertTrue((boolean)getAllMap.containsValue(CompressionRegionOperationsDUnitTest.VALUE_2));
                TestCase.assertTrue((boolean)getAllMap.containsValue(CompressionRegionOperationsDUnitTest.VALUE_3));
            }
        });
    }

    public void testKeysAndValuesOperations() {
        this.testKeysAndValuesOperationsOnVM(this.getVM(0));
    }

    private void testKeysAndValuesOperationsOnVM(VM vm) {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionRegionOperationsDUnitTest.this.getCache().getRegion(CompressionRegionOperationsDUnitTest.REGION_NAME);
                String oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1);
                TestCase.assertNull((Object)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                region.invalidate((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertNull((Object)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1));
                oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1);
                TestCase.assertNull((Object)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                TestCase.assertTrue((boolean)region.containsKey((Object)CompressionRegionOperationsDUnitTest.KEY_1));
                TestCase.assertTrue((boolean)region.containsValue((Object)CompressionRegionOperationsDUnitTest.VALUE_1));
                region.destroy((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertNull((Object)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1));
                oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1);
                TestCase.assertNull((Object)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.remove((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1);
                TestCase.assertNull((Object)oldValue);
                TestCase.assertTrue((boolean)region.remove((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1));
                oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1);
                TestCase.assertNull((Object)oldValue);
                oldValue = (String)region.replace((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_2);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                TestCase.assertTrue((boolean)region.replace((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_2, (Object)CompressionRegionOperationsDUnitTest.VALUE_3));
                TestCase.assertTrue((boolean)region.values().contains(CompressionRegionOperationsDUnitTest.VALUE_3));
                TestCase.assertTrue((boolean)region.keySet().contains(CompressionRegionOperationsDUnitTest.KEY_1));
            }
        });
    }

    public void testGetPutOperationsWithCachedDeserializable() {
        this.testGetPutOperationsWithCachedDeserializableOnVM(this.getVM(0));
    }

    private void testGetPutOperationsWithCachedDeserializableOnVM(VM vm) {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionRegionOperationsDUnitTest.this.getCache().getRegion(CompressionRegionOperationsDUnitTest.REGION_NAME);
                String oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CachedDeserializableFactory.create((byte[])EntryEventImpl.serialize((Object)CompressionRegionOperationsDUnitTest.VALUE_1)));
                TestCase.assertNull((Object)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CachedDeserializableFactory.create((byte[])EntryEventImpl.serialize((Object)CompressionRegionOperationsDUnitTest.VALUE_2)));
                if (null != oldValue) {
                    TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                }
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                oldValue = (String)region.putIfAbsent((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CachedDeserializableFactory.create((byte[])EntryEventImpl.serialize((Object)CompressionRegionOperationsDUnitTest.VALUE_3)));
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                region.putAll(putAllMap2);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_2);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)oldValue);
                oldValue = (String)region.get((Object)CompressionRegionOperationsDUnitTest.KEY_3);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_3, (String)oldValue);
                Map getAllMap = region.getAll(getAllCollection);
                TestCase.assertTrue((boolean)getAllMap.containsValue(CompressionRegionOperationsDUnitTest.VALUE_1));
                TestCase.assertTrue((boolean)getAllMap.containsValue(CompressionRegionOperationsDUnitTest.VALUE_2));
                TestCase.assertTrue((boolean)getAllMap.containsValue(CompressionRegionOperationsDUnitTest.VALUE_3));
            }
        });
    }

    public void testGetPutOperationsWithByteArrays() {
        this.testGetPutOperationsWithByteArraysOnVM(this.getVM(0));
    }

    private void testGetPutOperationsWithByteArraysOnVM(VM vm) {
        try {
            SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionRegionOperationsDUnitTest.this.getCache().getRegion(CompressionRegionOperationsDUnitTest.REGION_NAME);
                byte[] oldValue = (byte[])region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_1.getBytes());
                TestCase.assertNull((Object)oldValue);
                oldValue = (byte[])region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)new String(oldValue));
                oldValue = (byte[])region.put((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_2.getBytes());
                if (null != oldValue) {
                    TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)new String(oldValue));
                }
                oldValue = (byte[])region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)new String(oldValue));
                oldValue = (byte[])region.putIfAbsent((Object)CompressionRegionOperationsDUnitTest.KEY_1, (Object)CompressionRegionOperationsDUnitTest.VALUE_3.getBytes());
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)new String(oldValue));
                region.putAll(putAllMap3);
                oldValue = (byte[])region.get((Object)CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)new String(oldValue));
                oldValue = (byte[])region.get((Object)CompressionRegionOperationsDUnitTest.KEY_2);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)new String(oldValue));
                oldValue = (byte[])region.get((Object)CompressionRegionOperationsDUnitTest.KEY_3);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_3, (String)new String(oldValue));
                Map getAllMap = region.getAll(getAllCollection);
                oldValue = (byte[])getAllMap.get(CompressionRegionOperationsDUnitTest.KEY_1);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_1, (String)new String(oldValue));
                oldValue = (byte[])getAllMap.get(CompressionRegionOperationsDUnitTest.KEY_2);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_2, (String)new String(oldValue));
                oldValue = (byte[])getAllMap.get(CompressionRegionOperationsDUnitTest.KEY_3);
                TestCase.assertEquals((String)CompressionRegionOperationsDUnitTest.VALUE_3, (String)new String(oldValue));
            }
        });
    }

    protected VM getVM(int vm) {
        return Host.getHost(0).getVM(vm);
    }

    private void cleanup(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionRegionOperationsDUnitTest.this.getCache().getRegion(CompressionRegionOperationsDUnitTest.REGION_NAME).destroyRegion();
            }
        });
    }

    private boolean createCompressedRegionOnVm(VM vm, String name, Compressor compressor) {
        return this.createCompressedRegionOnVm(vm, name, compressor, false);
    }

    protected boolean createCompressedRegionOnVm(VM vm, final String name, final Compressor compressor, final boolean offHeap) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    CompressionRegionOperationsDUnitTest.this.createRegion(name, compressor, offHeap);
                }
                catch (IllegalStateException e) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private Region createRegion(String name, Compressor compressor, boolean offHeap) {
        return this.getCache().createRegionFactory().setDataPolicy(DataPolicy.REPLICATE).setCompressor(compressor).setEnableOffHeapMemory(offHeap).create(name);
    }

    static {
        putAllMap.put(KEY_1, VALUE_1);
        putAllMap.put(KEY_2, VALUE_2);
        putAllMap.put(KEY_3, VALUE_3);
        putAllMap2.put(KEY_1, CachedDeserializableFactory.create((byte[])EntryEventImpl.serialize((Object)VALUE_1)));
        putAllMap2.put(KEY_2, CachedDeserializableFactory.create((byte[])EntryEventImpl.serialize((Object)VALUE_2)));
        putAllMap2.put(KEY_3, CachedDeserializableFactory.create((byte[])EntryEventImpl.serialize((Object)VALUE_3)));
        putAllMap3.put(KEY_1, VALUE_1.getBytes());
        putAllMap3.put(KEY_2, VALUE_2.getBytes());
        putAllMap3.put(KEY_3, VALUE_3.getBytes());
        getAllCollection.add(KEY_1);
        getAllCollection.add(KEY_2);
        getAllCollection.add(KEY_3);
    }
}

