/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.List;
import java.util.Properties;

public class WanCommandGatewayReceiverStopDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandGatewayReceiverStopDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testStopGatewayReceiver_ErrorConditions() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        String command = "stop gateway-receiver --member=" + vm1Member.getId() + " --" + "group" + "=RG1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewayReceiver_ErrorConditions stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
            WanCommandGatewayReceiverStopDUnitTest.assertTrue((boolean)strCmdResult.contains("Please provide either \"member\" or \"group\" option."));
        } else {
            WanCommandGatewayReceiverStopDUnitTest.fail((String)"testStopGatewayReceiver_ErrorConditions failed as did not get CommandResult");
        }
    }

    public void testStopGatewayReceiver() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        WanCommandGatewayReceiverStopDUnitTest.pause(10000);
        String command = "stop gateway-receiver";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewayReceiverStopDUnitTest.assertTrue((boolean)status.contains("Error"));
            WanCommandGatewayReceiverStopDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewayReceiverStopDUnitTest.fail((String)"testStopGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
    }

    public void testStopGatewayReceiver_onMember() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandGatewayReceiverStopDUnitTest.pause(10000);
        String command = "stop gateway-receiver --member=" + vm1Member.getId();
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewayReceiver_onMember stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            WanCommandGatewayReceiverStopDUnitTest.assertTrue((boolean)strCmdResult.contains("stopped on member"));
        } else {
            WanCommandGatewayReceiverStopDUnitTest.fail((String)"testStopGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
    }

    public void testStopGatewayReceiver_Group() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        WanCommandGatewayReceiverStopDUnitTest.pause(10000);
        String command = "stop gateway-receiver --group=RG1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewayReceiver_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((int)3, (int)status.size());
            WanCommandGatewayReceiverStopDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewayReceiverStopDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewayReceiverStopDUnitTest.fail((String)"testStopGatewayReceiver_Group failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
    }

    public void testStopGatewayReceiver_MultipleGroup() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG1, RG2"});
        vm7.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{punePort, "RG3"});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm6.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm7.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        WanCommandGatewayReceiverStopDUnitTest.pause(10000);
        String command = "stop gateway-receiver --group=RG1,RG2";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewayReceiver_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewayReceiverStopDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewayReceiverStopDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewayReceiverStopDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewayReceiverStopDUnitTest.fail((String)"testStopGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm6.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm7.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
    }
}

