/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.List;
import java.util.Properties;

public class WanCommandGatewayReceiverStartDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandGatewayReceiverStartDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testStartGatewayReceiver_ErrorConditions() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        String command = "start gateway-receiver --member=" + vm1Member.getId() + " --" + "group" + "=RG1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewayReceiver_ErrorConditions stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
            WanCommandGatewayReceiverStartDUnitTest.assertTrue((boolean)strCmdResult.contains("Please provide either \"member\" or \"group\" option."));
        } else {
            WanCommandGatewayReceiverStartDUnitTest.fail((String)"testStartGatewayReceiver_ErrorConditions failed as did not get CommandResult");
        }
    }

    public void testStartGatewayReceiver() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        WanCommandGatewayReceiverStartDUnitTest.pause(10000);
        String command = "start gateway-receiver";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewayReceiverStartDUnitTest.assertTrue((boolean)status.contains("Error"));
        } else {
            WanCommandGatewayReceiverStartDUnitTest.fail((String)"testStartGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
    }

    public void testStartGatewayReceiver_onMember() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createReceiver", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandGatewayReceiverStartDUnitTest.pause(10000);
        String command = "start gateway-receiver --member=" + vm1Member.getId();
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewayReceiver_onMember stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            WanCommandGatewayReceiverStartDUnitTest.assertTrue((boolean)strCmdResult.contains("is started on member"));
        } else {
            WanCommandGatewayReceiverStartDUnitTest.fail((String)"testStartGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
    }

    public void testStartGatewayReceiver_Group() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm4.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm5.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        WanCommandGatewayReceiverStartDUnitTest.pause(10000);
        String command = "start gateway-receiver --group=RG1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewayReceiver_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((int)3, (int)status.size());
            WanCommandGatewayReceiverStartDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewayReceiverStartDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewayReceiverStartDUnitTest.fail((String)"testStartGatewayReceiver_Group failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
    }

    public void testStartGatewayReceiver_MultipleGroup() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm4.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1"});
        vm5.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1, RG2"});
        vm6.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG1, RG2"});
        vm7.invoke(WANCommandTestBase.class, "createReceiverWithGroup", new Object[]{punePort, "RG3"});
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm6.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        vm7.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
        WanCommandGatewayReceiverStartDUnitTest.pause(10000);
        String command = "start gateway-receiver --group=RG1,RG2";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStartGatewayReceiver_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewayReceiverStartDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewayReceiverStartDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewayReceiverStartDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewayReceiverStartDUnitTest.fail((String)"testStartGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm6.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{true});
        vm7.invoke(WANCommandTestBase.class, "verifyReceiverState", new Object[]{false});
    }
}

