/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class WanCommandCreateGatewayReceiverDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandCreateGatewayReceiverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testCreateGatewayReceiverWithDefault() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-receiver";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 5000, 5500, "", 60000, 524288, null});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 5000, 5500, "", 60000, 524288, null});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 5000, 5500, "", 60000, 524288, null});
    }

    public void testCreateGatewayReceiver() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
    }

    public void testCreateGatewayReceiverWithGatewayTransportFilter() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --gateway-transport-filter=com.gemstone.gemfire.cache30.MyGatewayTransportFilter1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        ArrayList<String> transportFilters = new ArrayList<String>();
        transportFilters.add("com.gemstone.gemfire.cache30.MyGatewayTransportFilter1");
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, transportFilters});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, transportFilters});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, transportFilters});
    }

    public void testCreateGatewayReceiverWithMultipleGatewayTransportFilters() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --gateway-transport-filter=com.gemstone.gemfire.cache30.MyGatewayTransportFilter1,com.gemstone.gemfire.cache30.MyGatewayTransportFilter2";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        ArrayList<String> transportFilters = new ArrayList<String>();
        transportFilters.add("com.gemstone.gemfire.cache30.MyGatewayTransportFilter1");
        transportFilters.add("com.gemstone.gemfire.cache30.MyGatewayTransportFilter2");
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, transportFilters});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, transportFilters});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, transportFilters});
    }

    public void testCreateGatewayReceiver_Error() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        String command = "create gateway-receiver --bind-address=localhost --start-port=11000 --end-port=10000 --maximum-time-between-pings=100000 --socket-buffer-size=512000";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)4, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)"GatewayReceiver creation should have failed", (((String)status.get(i)).indexOf("ERROR:") != -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
    }

    public void testCreateGatewayReceiver_onMember() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        DistributedMember vm3Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --member=" + vm3Member.getId();
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)1, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
    }

    public void testCreateGatewayReceiver_onMultipleMembers() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        DistributedMember vm3Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        DistributedMember vm4Member = (DistributedMember)vm4.invoke(WANCommandTestBase.class, "getMember");
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --member=" + vm3Member.getId() + "," + vm4Member.getId();
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)2, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
    }

    public void testCreateGatewayReceiver_onGroup() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --group=receiverGroup1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)3, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
    }

    public void testCreateGatewayReceiver_onGroup_Scenario2() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup2"});
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --group=receiverGroup1";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)2, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
    }

    public void testCreateGatewayReceiver_onMultipleGroups() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "receiverGroup2"});
        String command = "create gateway-receiver --bind-address=localhost --start-port=10000 --end-port=11000 --maximum-time-between-pings=100000 --socket-buffer-size=512000 --group=receiverGroup1,receiverGroup2";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testCreateGatewayReceiver stringResult : " + strCmdResult + ">>>>");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Status");
            WanCommandCreateGatewayReceiverDUnitTest.assertEquals((int)3, (int)status.size());
            for (int i = 0; i < status.size(); ++i) {
                WanCommandCreateGatewayReceiverDUnitTest.assertTrue((String)("GatewayReceiver creation failed with: " + (String)status.get(i)), (((String)status.get(i)).indexOf("ERROR:") == -1 ? 1 : 0) != 0);
            }
        } else {
            WanCommandCreateGatewayReceiverDUnitTest.fail((String)"testCreateGatewayReceiver failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm4.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
        vm5.invoke(WANCommandTestBase.class, "verifyReceiverCreationWithAttributes", new Object[]{false, 10000, 11000, "localhost", 100000, 512000, null});
    }
}

