/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache30.MyGatewayTransportFilter1;
import com.gemstone.gemfire.cache30.MyGatewayTransportFilter2;
import com.gemstone.gemfire.internal.cache.wan.Filter70;
import com.gemstone.gemfire.internal.cache.wan.MyGatewayTransportFilter3;
import com.gemstone.gemfire.internal.cache.wan.MyGatewayTransportFilter4;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import java.util.ArrayList;
import java.util.Map;

public class WanValidationsDUnitTest
extends WANTestBase {
    public WanValidationsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testSameSerialGatewaySenderIdAcrossSameDistributedRegion() throws Exception {
        block2: {
            try {
                Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
                Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
                vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, false, 10, 100, false, false, null, true});
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, false, 10, 100, false, false, null, true});
                vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, false, 10, 100, false, false, null, true});
                vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln3", 2, false, 10, 100, false, false, null, true});
                vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1,ln2", this.isOffHeap()});
                vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln2,ln3", this.isOffHeap()});
                WanValidationsDUnitTest.fail((String)"Expected IllegalStateException with incompatible gateway sender ids message");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("Cannot create Region")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException with incompatible gateway sender ids message", e);
            }
        }
    }

    public void testParallelGatewaySenderForDistributedRegion() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
            vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, false});
            vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, true, 10, 100, false, false, null, false});
            vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
            vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
        }
        catch (Exception e) {
            WanValidationsDUnitTest.fail("Caught Exception", e);
        }
    }

    public void testSameSerialGatewaySenderIdAcrossSamePartitionedRegion() throws Exception {
        block2: {
            try {
                Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
                vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, false, 10, 100, false, false, null, true});
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, false, 10, 100, false, false, null, true});
                vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, false, 10, 100, false, false, null, true});
                vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln3", 2, false, 10, 100, false, false, null, true});
                vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
                vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln2,ln3", 1, 100, this.isOffHeap()});
                WanValidationsDUnitTest.fail((String)"Expected IllegalStateException with incompatible gateway sender ids message");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("Cannot create Region")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException with incompatible gateway sender ids message", e);
            }
        }
    }

    public void testReplicatedSerialAsyncEventQueueWithPeristenceEnabled() {
        block2: {
            try {
                Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
                vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm4.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln1", this.isOffHeap()});
                vm5.invoke(WANTestBase.class, "createReplicatedRegionWithAsyncEventQueue", new Object[]{testName + "_RR", "ln2", this.isOffHeap()});
                WanValidationsDUnitTest.fail((String)"Expected IllegalStateException with incompatible gateway sender ids message");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("Cannot create Region")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException with incompatible gateway sender ids message", e);
            }
        }
    }

    public void testSameParallelGatewaySenderIdAcrossSamePartitionedRegion() throws Exception {
        block2: {
            try {
                Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
                vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 100, false, false, null, true});
                vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, true, 10, 100, false, false, null, true});
                vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 2, true, 10, 100, false, false, null, true});
                vm5.invoke(WANTestBase.class, "createSender", new Object[]{"ln3", 2, true, 10, 100, false, false, null, true});
                vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln1,ln2", 1, 100, this.isOffHeap()});
                vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln2,ln3", 1, 100, this.isOffHeap()});
                WanValidationsDUnitTest.fail((String)"Expected IllegalStateException with incompatible gateway sender ids message");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("Cannot create Region")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException with incompatible gateway sender ids message", e);
            }
        }
    }

    public void testSameParallelGatewaySenderIdAcrossDifferentPartitionedRegion() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln2_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR1", null, "ln1_Parallel,ln2_Parallel", null, this.isOffHeap()});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR2", null, "ln1_Parallel,ln2_Parallel", null, this.isOffHeap()});
        }
        catch (Exception e) {
            WanValidationsDUnitTest.fail("UnExpected Exception while using same gateway sender with multiple PR ", e);
        }
    }

    public void testSameParallelGatewaySenderIdAcrossColocatedPartitionedRegion() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln2_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR1", null, "ln1_Parallel", null, this.isOffHeap()});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR2", null, "ln1_Parallel,ln2_Parallel", testName + "_PR1", this.isOffHeap()});
        }
        catch (Exception e) {
            WanValidationsDUnitTest.fail("UnExpected Exception with incompatible gateway sender ids in colocated regions", e);
        }
    }

    public void testSameParallelGatewaySenderIdAcrossColocatedPartitionedRegion2() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln2_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR1", null, "ln1_Parallel", null, this.isOffHeap()});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR2", null, null, testName + "_PR1", this.isOffHeap()});
        }
        catch (Exception e) {
            WanValidationsDUnitTest.fail("The tests caught Exception.", e);
        }
    }

    public void testSameParallelGatewaySenderIdAcrossColocatedPartitionedRegion3() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln2_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR1", null, "ln1_Parallel,ln2_Parallel", null, this.isOffHeap()});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR2", null, "ln1_Parallel", testName + "_PR1", this.isOffHeap()});
        }
        catch (Exception e) {
            WanValidationsDUnitTest.fail("The tests caught Exception.", e);
        }
    }

    public void testSameParallelGatewaySenderIdAcrossColocatedPartitionedRegion4() throws Exception {
        try {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln2_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln3_Parallel", 2, true, 10, 100, false, false, null, true});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR1", null, "ln1_Parallel,ln2_Parallel", null, this.isOffHeap()});
            vm1.invoke(WANTestBase.class, "createPartitionedRegionWithSerialParallelSenderIds", new Object[]{testName + "_PR2", null, "ln1_Parallel,ln2_Parallel,ln3_Parallel", testName + "_PR1", this.isOffHeap()});
        }
        catch (Exception e) {
            WanValidationsDUnitTest.fail("UnExpected Exception with incompatible gateway sender ids in colocated regions", e);
        }
    }

    public void testSerialGatewaySenderAndParallelGatewaySenderWithSameName() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, true, 100, false, false, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : Sender names should be different.");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("is already defined in this cache")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testSameRemoteDSAcrossSameSender() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 3, false, 100, false, false, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : Remote Ds Ids should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with remote ds id")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testSerialSenderOnBothCache() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, true, 100, false, false, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : is not serial Gateway Sender");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same sender as serial gateway sender")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testParallelSenderOnBothCache() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, true, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : is not parallel Gateway Sender");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same sender as parallel gateway sender")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testBatchConflation() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, true, false, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : isBatchConflation Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("another cache has the same Gateway Sender defined with isBatchConfaltionEnabled")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testisPersistentEnabled() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, true, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : isPersistentEnabled Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with isPersistentEnabled")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testAlertThreshold() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 50, false, false, null, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : alertThreshold Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with alertThreshold")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testManualStart() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, false, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : manualStart Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with manual start")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testGatewayEventFilters() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            ArrayList<GatewayEventFilter> eventFiletrs = new ArrayList<GatewayEventFilter>();
            eventFiletrs.add(new WANTestBase.MyGatewayEventFilter());
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, eventFiletrs, null, true, false});
            try {
                eventFiletrs = new ArrayList();
                eventFiletrs.add(new Filter70());
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, eventFiletrs, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : GatewayEventFileters Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with GatewayEventFilters")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testGatewayEventFilters2() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            ArrayList<GatewayEventFilter> eventFiletrs = new ArrayList<GatewayEventFilter>();
            eventFiletrs.add(new WANTestBase.MyGatewayEventFilter());
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, eventFiletrs, null, true, false});
            try {
                eventFiletrs = new ArrayList();
                eventFiletrs.add(new WANTestBase.MyGatewayEventFilter());
                eventFiletrs.add(new Filter70());
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, eventFiletrs, null, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : GatewayEventFileters Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with GatewayEventFilters")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testGatewayTransportFilters() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            ArrayList<Object> transportFiletrs = new ArrayList<Object>();
            transportFiletrs.add(new MyGatewayTransportFilter1());
            transportFiletrs.add(new MyGatewayTransportFilter2());
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, transportFiletrs, true, false});
            try {
                transportFiletrs = new ArrayList();
                transportFiletrs.add(new MyGatewayTransportFilter3());
                transportFiletrs.add(new MyGatewayTransportFilter4());
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, transportFiletrs, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : GatewayEventFileters Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with GatewayTransportFilters")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testGatewayTransportFiltersOrder() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            ArrayList<Object> transportFiletrs = new ArrayList<Object>();
            transportFiletrs.add(new MyGatewayTransportFilter1());
            transportFiletrs.add(new MyGatewayTransportFilter2());
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, transportFiletrs, true, false});
            try {
                transportFiletrs = new ArrayList();
                transportFiletrs.add(new MyGatewayTransportFilter2());
                transportFiletrs.add(new MyGatewayTransportFilter1());
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, transportFiletrs, true, false});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : GatewayEventFileters Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with GatewayTransportFilters")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testIsDiskSynchronous() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, false});
            try {
                vm2.invoke(WANTestBase.class, "createSenderForValidations", new Object[]{"ln", 2, false, 100, false, false, null, null, true, true});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : isDiskSynchronous Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with isDiskSynchronous")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void test_GetCacheServersDoesNotReturnReceivers() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createCacheServer", new Object[0]);
        Map cacheServers = (Map)vm4.invoke(WANTestBase.class, "getCacheServers", new Object[0]);
        WanValidationsDUnitTest.assertEquals((String)"Cache.getCacheServers returned incorrect BridgeServers: ", (Object)1, cacheServers.get("BridgeServer"));
        WanValidationsDUnitTest.assertEquals((String)"Cache.getCacheServers returned incorrect ReceiverServers: ", (Object)0, cacheServers.get("ReceiverServer"));
    }

    public void test_GetCacheServersDoesNotReturnReceivers_Scenario2() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm4.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCacheServer", new Object[0]);
        Map cacheServers_vm4 = (Map)vm4.invoke(WANTestBase.class, "getCacheServers", new Object[0]);
        Map cacheServers_vm5 = (Map)vm5.invoke(WANTestBase.class, "getCacheServers", new Object[0]);
        WanValidationsDUnitTest.assertEquals((String)"Cache.getCacheServers on vm4 returned incorrect BridgeServers: ", (Object)0, cacheServers_vm4.get("BridgeServer"));
        WanValidationsDUnitTest.assertEquals((String)"Cache.getCacheServers on vm4 returned incorrect ReceiverServers: ", (Object)0, cacheServers_vm4.get("ReceiverServer"));
        WanValidationsDUnitTest.assertEquals((String)"Cache.getCacheServers on vm5 returned incorrect BridgeServers: ", (Object)1, cacheServers_vm5.get("BridgeServer"));
        WanValidationsDUnitTest.assertEquals((String)"Cache.getCacheServers on vm5 returned incorrect ReceiverServers: ", (Object)0, cacheServers_vm5.get("ReceiverServer"));
    }

    public void _testDispatcherThreadsForParallelGatewaySender() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            try {
                vm2.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : dispatcher threads Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with dispatcherThread")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }

    public void testOrderPolicyForParallelGatewaySender() {
        block2: {
            Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
            vm1.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm2.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
            vm1.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
            try {
                vm2.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
                WanValidationsDUnitTest.fail((String)"Expected IllegateStateException : order policy Should match");
            }
            catch (Exception e) {
                if (e.getCause() instanceof IllegalStateException && e.getCause().getMessage().contains("because another cache has the same Gateway Sender defined with orderPolicy")) break block2;
                WanValidationsDUnitTest.fail("Expected IllegalStateException", e);
            }
        }
    }
}

