/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import java.util.Map;
import java.util.Properties;
import security.CredentialGenerator;

public class NewWanAuthenticationDUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public NewWanAuthenticationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testWanAuthValidCredentials() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        NewWanAuthenticationDUnitTest.getLogWriter().info("Created locator on local site");
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        NewWanAuthenticationDUnitTest.getLogWriter().info("Created locator on remote site");
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            String clientauthenticator = gen.getAuthenticator();
            String clientauthInit = gen.getAuthInit();
            Properties credentials1 = gen.getValidCredentials(1);
            if (extraProps != null) {
                credentials1.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps1 = gen.getJavaProperties();
            Properties credentials2 = gen.getValidCredentials(2);
            if (extraProps != null) {
                credentials2.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps2 = gen.getJavaProperties();
            Properties props1 = NewWanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials1, null);
            Properties props2 = NewWanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials2, null);
            vm2.invoke(WANTestBase.class, "createSecuredCache", new Object[]{props1, javaProps1, lnPort});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created secured cache in vm2");
            vm3.invoke(WANTestBase.class, "createSecuredCache", new Object[]{props2, javaProps2, nyPort});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created secured cache in vm3");
            vm2.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created sender in vm2");
            vm3.invoke(WANTestBase.class, "createReceiverInSecuredCache", new Object[]{nyPort});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created receiver in vm3");
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created RR in vm2");
            vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created RR in vm3");
            vm2.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
            vm2.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Done successfully.");
        }
    }

    public void testWanAuthInvalidCredentials() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        NewWanAuthenticationDUnitTest.getLogWriter().info("Created locator on local site");
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        NewWanAuthenticationDUnitTest.getLogWriter().info("Created locator on remote site");
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            NewWanAuthenticationDUnitTest.getLogWriter().info("Picked up credential: " + gen);
            Properties extraProps = gen.getSystemProperties();
            String clientauthenticator = gen.getAuthenticator();
            String clientauthInit = gen.getAuthInit();
            Properties credentials1 = gen.getInvalidCredentials(1);
            if (extraProps != null) {
                credentials1.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps1 = gen.getJavaProperties();
            Properties credentials2 = gen.getInvalidCredentials(2);
            if (extraProps != null) {
                credentials2.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps2 = gen.getJavaProperties();
            Properties props1 = NewWanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials1, null);
            Properties props2 = NewWanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials2, null);
            NewWanAuthenticationDUnitTest.getLogWriter().info("Done building auth properties");
            vm2.invoke(WANTestBase.class, "createSecuredCache", new Object[]{props1, javaProps1, lnPort});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created secured cache in vm2");
            vm3.invoke(WANTestBase.class, "createSecuredCache", new Object[]{props2, javaProps2, nyPort});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created secured cache in vm3");
            vm2.invoke(WANTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created sender in vm2");
            vm3.invoke(WANTestBase.class, "createReceiverInSecuredCache", new Object[]{nyPort});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created receiver in vm3");
            vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created RR in vm2");
            vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
            NewWanAuthenticationDUnitTest.getLogWriter().info("Created RR in vm3");
            try {
                vm2.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
                NewWanAuthenticationDUnitTest.fail((String)"Authentication Failed: While starting the sender, an exception should have been thrown");
            }
            catch (Exception e) {
                if (e.getCause().getCause() instanceof AuthenticationFailedException) continue;
                NewWanAuthenticationDUnitTest.fail((String)"Authentication is not working as expected");
            }
        }
    }

    private static Properties buildProperties(String clientauthenticator, String clientAuthInit, String accessor, Properties extraAuthProps, Properties extraAuthzProps) {
        Properties authProps = new Properties();
        if (clientauthenticator != null) {
            authProps.setProperty("security-client-authenticator", clientauthenticator);
        }
        if (accessor != null) {
            authProps.setProperty("security-client-accessor", accessor);
        }
        if (clientAuthInit != null) {
            authProps.setProperty("security-client-auth-init", clientAuthInit);
        }
        if (extraAuthProps != null) {
            authProps.putAll((Map<?, ?>)extraAuthProps);
        }
        if (extraAuthzProps != null) {
            authProps.putAll((Map<?, ?>)extraAuthzProps);
        }
        return authProps;
    }
}

