/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.misc;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import java.util.HashMap;
import junit.framework.TestCase;

public class NewWANConcurrencyCheckForDestroyDUnitTest
extends WANTestBase {
    static long destroyTimeStamp;
    static int destroyingMember;

    public NewWANConcurrencyCheckForDestroyDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testVersionTagTimestampForDestroy() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer lnRecPort = (Integer)vm1.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        Integer nyPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        Integer tkPort = (Integer)vm4.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{3, lnPort});
        Integer tkRecPort = (Integer)vm5.invoke(WANTestBase.class, "createReceiver", new Object[]{tkPort});
        NewWANConcurrencyCheckForDestroyDUnitTest.getLogWriter().info("Created locators and receivers in 3 distributed systems");
        vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, true, 10, 1, false, false, null, true});
        vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln2", 3, true, 10, 1, false, false, null, true});
        vm1.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{"repRegion", "ln1,ln2", 0, 1, this.isOffHeap()});
        vm1.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
        vm1.invoke(WANTestBase.class, "startSender", new Object[]{"ln2"});
        vm1.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln1"});
        vm1.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln2"});
        vm3.invoke(WANTestBase.class, "createSender", new Object[]{"ny1", 1, true, 10, 1, false, false, null, true});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{"repRegion", "ny1", 0, 1, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "startSender", new Object[]{"ny1"});
        vm3.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ny1"});
        vm5.invoke(WANTestBase.class, "createSender", new Object[]{"tk1", 1, true, 10, 1, false, false, null, true});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{"repRegion", "tk1", 0, 1, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"tk1"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"tk1"});
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(2000);
        vm1.invoke(new CacheSerializableRunnable("Putting an entry in ds1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                Region region = cache.getRegion("/repRegion");
                region.put((Object)"testKey", (Object)"testValue");
                TestCase.assertEquals((int)1, (int)region.size());
            }
        });
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(2000);
        destroyTimeStamp = (Long)vm3.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterOp");
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(2000);
        vm5.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "verifyTimestampAfterOp", new Object[]{destroyTimeStamp, 1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutAllEventSequenceOnSerialGatewaySenderWithRR() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer lnRecPort = (Integer)vm1.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        Integer nyPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        NewWANConcurrencyCheckForDestroyDUnitTest.getLogWriter().info("Created locators and receivers in 2 distributed systems");
        vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, false, 10, 1, false, false, null, true});
        vm1.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{"repRegion", "ln1", this.isOffHeap()});
        vm1.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
        vm1.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln1"});
        vm3.invoke(WANTestBase.class, "createSender", new Object[]{"ny1", 1, false, 10, 1, false, false, null, true});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{"repRegion", "ny1", this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "startSender", new Object[]{"ny1"});
        vm3.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ny1"});
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(2000);
        AsyncInvocation asynch1 = vm1.invokeAsync(new CacheSerializableRunnable("Putting an entry in ds1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 2000L;
                Region region = cache.getRegion("/repRegion");
                HashMap<String, String> testMap = new HashMap<String, String>();
                testMap.put("testKey", "testValue1");
                region.putAll(testMap);
                TestCase.assertEquals((int)1, (int)region.size());
                TestCase.assertEquals((Object)"testValue2", (Object)region.get((Object)"testKey"));
            }
        });
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(1000);
        AsyncInvocation asynch2 = vm1.invokeAsync(new CacheSerializableRunnable("Putting an entry in ds1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                Region region = cache.getRegion("/repRegion");
                while (!region.containsKey((Object)"testKey")) {
                    DistributedTestCase.pause(10);
                }
                DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 0L;
                region.put((Object)"testKey", (Object)"testValue2");
                TestCase.assertEquals((int)1, (int)region.size());
                TestCase.assertEquals((Object)"testValue2", (Object)region.get((Object)"testKey"));
            }
        });
        try {
            asynch1.join(5000L);
            asynch2.join(5000L);
            vm1.invoke(new CacheSerializableRunnable("Reset Test Hook"){

                @Override
                public void run2() throws CacheException {
                    DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 0L;
                }
            });
        }
        catch (InterruptedException e) {
            try {
                e.printStackTrace();
                vm1.invoke(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                vm1.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(1000);
        long putAllTimeStampVm1 = (Long)vm1.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterPutAllOp");
        long putAllTimeStampVm3 = (Long)vm3.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterPutAllOp");
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((long)putAllTimeStampVm1, (long)putAllTimeStampVm3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutAllEventSequenceOnSerialGatewaySenderWithPR() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer lnRecPort = (Integer)vm1.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        Integer nyPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        NewWANConcurrencyCheckForDestroyDUnitTest.getLogWriter().info("Created locators and receivers in 2 distributed systems");
        vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, false, 10, 1, false, false, null, true});
        vm1.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{"repRegion", "ln1", 0, 1, this.isOffHeap()});
        vm1.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
        vm1.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln1"});
        vm3.invoke(WANTestBase.class, "createSender", new Object[]{"ny1", 1, false, 10, 1, false, false, null, true});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{"repRegion", "ny1", 0, 1, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "startSender", new Object[]{"ny1"});
        vm3.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ny1"});
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(2000);
        AsyncInvocation asynch1 = vm1.invokeAsync(new CacheSerializableRunnable("Putting an entry in ds1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 2000L;
                Region region = cache.getRegion("/repRegion");
                HashMap<String, String> testMap = new HashMap<String, String>();
                testMap.put("testKey", "testValue1");
                region.putAll(testMap);
                TestCase.assertEquals((int)1, (int)region.size());
                TestCase.assertEquals((Object)"testValue2", (Object)region.get((Object)"testKey"));
            }
        });
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(1000);
        AsyncInvocation asynch2 = vm1.invokeAsync(new CacheSerializableRunnable("Putting an entry in ds1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                Region region = cache.getRegion("/repRegion");
                while (!region.containsKey((Object)"testKey")) {
                    DistributedTestCase.pause(10);
                }
                DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 0L;
                region.put((Object)"testKey", (Object)"testValue2");
                TestCase.assertEquals((int)1, (int)region.size());
                TestCase.assertEquals((Object)"testValue2", (Object)region.get((Object)"testKey"));
            }
        });
        try {
            asynch1.join(5000L);
            asynch2.join(5000L);
            vm1.invoke(new CacheSerializableRunnable("Reset Test Hook"){

                @Override
                public void run2() throws CacheException {
                    DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 0L;
                }
            });
        }
        catch (InterruptedException e) {
            try {
                e.printStackTrace();
                vm1.invoke(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                vm1.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(1000);
        long putAllTimeStampVm1 = (Long)vm1.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterPutAllOp");
        long putAllTimeStampVm3 = (Long)vm3.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterPutAllOp");
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((long)putAllTimeStampVm1, (long)putAllTimeStampVm3);
    }

    public void testConflicChecksBasedOnDsidAndTimeStamp() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer lnRecPort = (Integer)vm1.invoke(WANTestBase.class, "createReceiver", new Object[]{lnPort});
        Integer nyPort = (Integer)vm2.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        NewWANConcurrencyCheckForDestroyDUnitTest.getLogWriter().info("Created locators and receivers in 2 distributed systems");
        vm1.invoke(WANTestBase.class, "createSender", new Object[]{"ln1", 2, false, 10, 1, false, false, null, true});
        vm1.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{"repRegion", "ln1", this.isOffHeap()});
        vm1.invoke(WANTestBase.class, "startSender", new Object[]{"ln1"});
        vm1.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln1"});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{"repRegion", "ny1", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createSender", new Object[]{"ny1", 1, false, 10, 1, false, false, null, true});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{"repRegion", "ny1", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ny1"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ny1"});
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(2000);
        vm1.invoke(new CacheSerializableRunnable("Putting an entry in ds1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                Region region = cache.getRegion("/repRegion");
                region.put((Object)"testKey", (Object)"testValue1");
                TestCase.assertEquals((int)1, (int)region.size());
            }
        });
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(300);
        AsyncInvocation asynch = vm4.invokeAsync(new CacheSerializableRunnable("Putting an entry in ds2 in vm4"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)cache);
                Region region = cache.getRegion("/repRegion");
                region.put((Object)"testKey", (Object)"testValue2");
                TestCase.assertEquals((int)1, (int)region.size());
                TestCase.assertEquals((Object)"testValue2", (Object)region.get((Object)"testKey"));
            }
        });
        try {
            asynch.join(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        NewWANConcurrencyCheckForDestroyDUnitTest.pause(1000);
        vm3.invoke(new CacheSerializableRunnable("Check dsid"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("repRegion");
                Region.Entry entry = ((LocalRegion)region).getEntry((Object)"testKey", null, true);
                RegionEntry re = null;
                if (entry instanceof EntrySnapshot) {
                    re = ((EntrySnapshot)entry).getRegionEntry();
                } else if (entry instanceof LocalRegion.NonTXEntry) {
                    re = ((LocalRegion.NonTXEntry)entry).getRegionEntry();
                }
                VersionTag tag = re.getVersionStamp().asVersionTag();
                TestCase.assertEquals((int)2, (int)tag.getDistributedSystemId());
            }
        });
        long putAllTimeStampVm1 = (Long)vm4.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterPutAllOp");
        long putAllTimeStampVm3 = (Long)vm3.invoke(NewWANConcurrencyCheckForDestroyDUnitTest.class, "getVersionTimestampAfterPutAllOp");
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((long)putAllTimeStampVm1, (long)putAllTimeStampVm3);
    }

    public static long getVersionTimestampAfterPutAllOp() {
        Region region = cache.getRegion("repRegion");
        while (!region.containsKey((Object)"testKey")) {
            NewWANConcurrencyCheckForDestroyDUnitTest.pause(10);
        }
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((int)1, (int)region.size());
        Region.Entry entry = ((LocalRegion)region).getEntry((Object)"testKey", null, true);
        RegionEntry re = null;
        if (entry instanceof EntrySnapshot) {
            re = ((EntrySnapshot)entry).getRegionEntry();
        } else if (entry instanceof LocalRegion.NonTXEntry) {
            re = ((LocalRegion.NonTXEntry)entry).getRegionEntry();
        }
        if (re != null) {
            NewWANConcurrencyCheckForDestroyDUnitTest.getLogWriter().fine("RegionEntry for testKey: " + re.getKey() + " " + re.getValueInVM((RegionEntryContext)((LocalRegion)region)));
            VersionTag tag = re.getVersionStamp().asVersionTag();
            return tag.getVersionTimeStamp();
        }
        return -1L;
    }

    public static long getVersionTimestampAfterOp() {
        Region region = cache.getRegion("repRegion");
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((int)1, (int)region.size());
        region.destroy((Object)"testKey");
        Region.Entry entry = ((LocalRegion)region).getEntry((Object)"testKey", null, true);
        RegionEntry re = ((EntrySnapshot)entry).getRegionEntry();
        NewWANConcurrencyCheckForDestroyDUnitTest.getLogWriter().fine("RegionEntry for testKey: " + re.getKey() + " " + re.getValueInVM((RegionEntryContext)((LocalRegion)region)));
        NewWANConcurrencyCheckForDestroyDUnitTest.assertTrue((boolean)(re.getValueInVM((RegionEntryContext)((LocalRegion)region)) instanceof Token.Tombstone));
        VersionTag tag = re.getVersionStamp().asVersionTag();
        return tag.getVersionTimeStamp();
    }

    public static void verifyTimestampAfterOp(long timestamp, int memberid) {
        Region region = cache.getRegion("repRegion");
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((int)0, (int)region.size());
        Region.Entry entry = ((LocalRegion)region).getEntry((Object)"testKey", null, true);
        RegionEntry re = ((EntrySnapshot)entry).getRegionEntry();
        NewWANConcurrencyCheckForDestroyDUnitTest.assertTrue((boolean)(re.getValueInVM((RegionEntryContext)((LocalRegion)region)) instanceof Token.Tombstone));
        VersionTag tag = re.getVersionStamp().asVersionTag();
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((long)timestamp, (long)tag.getVersionTimeStamp());
        NewWANConcurrencyCheckForDestroyDUnitTest.assertEquals((int)memberid, (int)tag.getDistributedSystemId());
    }
}

