/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.EventIDVerificationInP2PDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class VerifyEventIDGenerationInP2PDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    static VM vm0 = null;
    private static final String REGION_NAME = "VerifyEventIDGenerationInP2PDUnitTest_region";
    protected static EventID eventId;
    static boolean testEventIDResult;
    static boolean receiver;
    static boolean gotCallback;

    public VerifyEventIDGenerationInP2PDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        VerifyEventIDGenerationInP2PDUnitTest.createServerCache();
        vm0.invoke(VerifyEventIDGenerationInP2PDUnitTest.class, "createServerCache");
        receiver = false;
    }

    public void _testEventIDGeneration() throws Exception {
        VerifyEventIDGenerationInP2PDUnitTest.createEntry();
        vm0.invoke(VerifyEventIDGenerationInP2PDUnitTest.class, "get");
        Boolean pass = (Boolean)vm0.invoke(VerifyEventIDGenerationInP2PDUnitTest.class, "verifyResult");
        VerifyEventIDGenerationInP2PDUnitTest.assertFalse((boolean)pass);
    }

    public void testDummy() throws Exception {
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        VerifyEventIDGenerationInP2PDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        VerifyEventIDGenerationInP2PDUnitTest.assertNotNull((Object)cache);
    }

    public static void setEventIDData(Object evID) {
        eventId = (EventID)evID;
    }

    public static void createServerCache() throws Exception {
        new VerifyEventIDGenerationInP2PDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.NONE);
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if (!receiver) {
                    vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                } else {
                    testEventIDResult = ((EntryEventImpl)event).getEventId().equals((Object)eventId);
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void createEntry() {
        try {
            Region r = cache.getRegion("/VerifyEventIDGenerationInP2PDUnitTest_region");
            VerifyEventIDGenerationInP2PDUnitTest.assertNotNull((Object)r);
            if (!r.containsKey((Object)"key-1")) {
                r.create((Object)"key-1", (Object)"key-1");
            }
            VerifyEventIDGenerationInP2PDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"key-1");
        }
        catch (Exception ex) {
            VerifyEventIDGenerationInP2PDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void get() {
        try {
            Region r = cache.getRegion("/VerifyEventIDGenerationInP2PDUnitTest_region");
            VerifyEventIDGenerationInP2PDUnitTest.assertNotNull((Object)r);
            r.get((Object)"key-1");
        }
        catch (Exception ex) {
            VerifyEventIDGenerationInP2PDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static Boolean verifyResult() {
        boolean temp = testEventIDResult;
        testEventIDResult = false;
        return new Boolean(temp);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        VerifyEventIDGenerationInP2PDUnitTest.closeCache();
        vm0.invoke(VerifyEventIDGenerationInP2PDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        testEventIDResult = true;
        receiver = true;
        gotCallback = false;
    }
}

