/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;

public class UnregisterInterestDUnitTest
extends DistributedTestCase {
    private VM server0 = null;
    private VM client1 = null;
    private VM client2 = null;
    private static GemFireCache cache = null;
    private static final String regionname = "UnregisterInterestDUnitTest_region";
    private static final int all_keys = 0;
    private static final int list = 1;
    private static final int regex = 2;
    private static final int filter = 3;
    private static final boolean receiveValuesConstant = true;

    public UnregisterInterestDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        this.server0 = host.getVM(0);
        this.client1 = host.getVM(1);
        this.client2 = host.getVM(2);
        int port = (Integer)this.server0.invoke(UnregisterInterestDUnitTest.class, "createCacheAndStartServer");
        this.client1.invoke(UnregisterInterestDUnitTest.class, "createClientCache", new Object[]{this.client1.getHost(), port});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "createClientCache", new Object[]{this.client2.getHost(), port});
    }

    @Override
    public void tearDown2() throws Exception {
        UnregisterInterestDUnitTest.closeCache();
        this.server0.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.client1.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.client2.invoke(UnregisterInterestDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null) {
            cache.close();
            cache = null;
        }
    }

    public void testUnregisterInterestAllKeys() throws Exception {
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{0, 0, 0});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{0, true, null});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{0, false, null});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{0, 1, 1});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.client2.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{0, 0, 0});
    }

    public void testUnregisterInterestKeys() throws Exception {
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{1, 0, 0});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{1, true, new String[]{"key_1", "key_2", "key_3", "key_4", "key_5"}});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{1, false, new String[]{"key_1", "key_2", "key_3", "key_4", "key_5"}});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{1, 1, 1});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.client2.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{1, 0, 0});
    }

    public void testUnregisterInterestPatterns() throws Exception {
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{2, 0, 0});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{2, true, new String[]{"[a-z]*[0-9]"}});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{2, false, new String[]{"[a-z]*[0-9]"}});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{2, 1, 1});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.client2.invoke(UnregisterInterestDUnitTest.class, "closeCache");
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{2, 0, 0});
    }

    public void testUnregisterInterestKeysInvForOneClientDoesNotAffectOtherClient() throws Exception {
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{1, 0, 0});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{1, false, new String[]{"key_1", "key_2", "key_3", "key_4", "key_5"}});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{1, false, new String[]{"key_1", "key_2", "key_3", "key_4", "key_5"}});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{1, 0, 2});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "unregisterInterest", new Object[]{new String[]{"key_1", "key_2", "key_3"}});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "updateKeys", new Object[]{new String[]{"key_1", "key_2", "key_3", "key_4", "key_5"}});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "timedWaitForInvalidates", new Object[]{2});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "timedWaitForInvalidates", new Object[]{5});
    }

    public void testUnregisterInterestRegexInvForOneClientDoesNotAffectOtherClient() throws Exception {
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{2, 0, 0});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{2, false, new String[]{"[a-z]*[0-9]"}});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "registerInterest", new Object[]{2, false, new String[]{"[a-z]*[0-9]"}});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "checkRIArtifacts", new Object[]{2, 0, 2});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "unregisterInterestRegex", new Object[]{new String[]{"[a-z]*[0-9]"}});
        this.server0.invoke(UnregisterInterestDUnitTest.class, "updateKeys", new Object[]{new String[]{"key1", "key2", "key3", "key4", "key5"}});
        this.client1.invoke(UnregisterInterestDUnitTest.class, "timedWaitForInvalidates", new Object[]{0});
        this.client2.invoke(UnregisterInterestDUnitTest.class, "timedWaitForInvalidates", new Object[]{5});
    }

    public void _testUnregisterInterestFilters() throws Exception {
    }

    public static void checkRIArtifacts(Integer interestType, Integer value, Integer valueInv) {
        switch (interestType) {
            case 0: {
                UnregisterInterestDUnitTest.checkAllKeys(value, valueInv);
                break;
            }
            case 1: {
                UnregisterInterestDUnitTest.checkKeyList(value, valueInv);
                break;
            }
            case 2: {
                UnregisterInterestDUnitTest.checkPatterns(value, valueInv);
                break;
            }
            case 3: {
                UnregisterInterestDUnitTest.checkFilters(value, valueInv);
                break;
            }
            default: {
                UnregisterInterestDUnitTest.fail("Invalid interest type: " + interestType, new IllegalArgumentException("Invalid interest type: " + interestType));
            }
        }
    }

    public static void checkAllKeys(Integer value, Integer valueInv) {
        FilterProfile fp = ((GemFireCacheImpl)cache).getFilterProfile(regionname);
        UnregisterInterestDUnitTest.assertEquals((int)value, (int)fp.getAllKeyClientsSize());
        UnregisterInterestDUnitTest.assertEquals((int)valueInv, (int)fp.getAllKeyClientsInvSize());
    }

    public static void checkKeyList(Integer value, Integer valueInv) {
        FilterProfile fp = ((GemFireCacheImpl)cache).getFilterProfile(regionname);
        UnregisterInterestDUnitTest.assertEquals((int)value, (int)fp.getKeysOfInterestSize());
        UnregisterInterestDUnitTest.assertEquals((int)valueInv, (int)fp.getKeysOfInterestInvSize());
    }

    public static void checkPatterns(Integer value, Integer valueInv) {
        FilterProfile fp = ((GemFireCacheImpl)cache).getFilterProfile(regionname);
        UnregisterInterestDUnitTest.assertEquals((int)value, (int)fp.getPatternsOfInterestSize());
        UnregisterInterestDUnitTest.assertEquals((int)valueInv, (int)fp.getPatternsOfInterestInvSize());
    }

    public static void checkFilters(Integer value, Integer valueInv) {
    }

    public static void registerInterest(Integer interestType, Boolean receiveValues, String[] values) {
        Region region = cache.getRegion(regionname);
        switch (interestType) {
            case 0: {
                region.registerInterest((Object)"ALL_KEYS", false, receiveValues.booleanValue());
                break;
            }
            case 1: {
                ArrayList<String> keys = new ArrayList<String>();
                for (String key : values) {
                    keys.add(key);
                }
                region.registerInterest(keys, false, receiveValues.booleanValue());
                break;
            }
            case 2: {
                region.registerInterestRegex(values[0], false, receiveValues.booleanValue());
                break;
            }
            case 3: {
                break;
            }
            default: {
                UnregisterInterestDUnitTest.fail("Invalid interest type: " + interestType, new IllegalArgumentException("Invalid interest type: " + interestType));
            }
        }
    }

    public static void unregisterInterest(String[] keys) {
        Region region = cache.getRegion(regionname);
        for (String key : keys) {
            region.unregisterInterest((Object)key);
        }
    }

    public static void unregisterInterestRegex(String[] patterns) {
        Region region = cache.getRegion(regionname);
        for (String pattern : patterns) {
            region.unregisterInterestRegex(pattern);
        }
    }

    public static void updateKeys(String[] keys) {
        Region region = cache.getRegion(regionname);
        for (String key : keys) {
            region.put((Object)key, (Object)(key + "_VALUE"));
        }
    }

    public static void timedWaitForInvalidates(Integer invalidates) {
        final int inv = invalidates;
        final PoolImpl pool = (PoolImpl)PoolManager.find((Region)cache.getRegion(regionname));
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return pool.getInvalidateCount() == inv;
            }

            @Override
            public String description() {
                return "Expected to receive " + inv + " invalidates but received " + pool.getInvalidateCount();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
    }

    public static Integer createCacheAndStartServer() throws Exception {
        InternalDistributedSystem ds = new UnregisterInterestDUnitTest("UnregisterInterestDUnitTest").getSystem();
        ds.disconnect();
        Properties props = new Properties();
        props.setProperty("locators", "");
        props.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        CacheFactory cf = new CacheFactory(props);
        cache = cf.create();
        RegionFactory rf = ((GemFireCacheImpl)cache).createRegionFactory(RegionShortcut.REPLICATE);
        rf.create(regionname);
        CacheServer server = ((GemFireCacheImpl)cache).addCacheServer();
        server.setPort(AvailablePort.getRandomAvailablePort((int)0));
        server.start();
        return server.getPort();
    }

    public static void createClientCache(Host host, Integer port) throws Exception {
        InternalDistributedSystem ds = new UnregisterInterestDUnitTest("UnregisterInterestDUnitTest").getSystem();
        ds.disconnect();
        Properties props = new Properties();
        props.setProperty("locators", "");
        props.setProperty("mcast-port", "0");
        ClientCacheFactory ccf = new ClientCacheFactory(props);
        ccf.setPoolSubscriptionEnabled(true);
        ccf.addPoolServer(host.getHostName(), port.intValue());
        cache = ccf.create();
        ClientRegionFactory crf = ((GemFireCacheImpl)cache).createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY);
        crf.create(regionname);
    }
}

