/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;

public class InterestResultPolicyDUnitTest
extends DistributedTestCase {
    VM vm0;
    VM vm1 = null;
    static final int PREPOPULATED_ENTRIES = 10;
    private static Cache cache = null;
    private static int PORT;
    private static final String REGION_NAME = "InterestResultPolicyDUnitTest_region";
    private DistributedTestCase.ExpectedException expectedEx;

    public InterestResultPolicyDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        InterestResultPolicyDUnitTest.disconnectAllFromDS();
        InterestResultPolicyDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        PORT = (Integer)this.vm0.invoke(InterestResultPolicyDUnitTest.class, "createServerCache");
        this.vm0.invoke(InterestResultPolicyDUnitTest.class, "populateServerCache");
    }

    @Override
    public void tearDown2() throws Exception {
        this.expectedEx = InterestResultPolicyDUnitTest.addExpectedException(ServerConnectivityException.class.getName());
        this.vm0.invoke(InterestResultPolicyDUnitTest.class, "closeCache");
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "closeCache");
    }

    @Override
    protected void realTearDown() throws Exception {
        super.realTearDown();
        if (this.expectedEx != null) {
            this.expectedEx.remove();
        }
    }

    public void testPolicyNone() {
        LogWriter logger = this.getSystem().getLogWriter();
        logger.fine("testPolicyNone BEGIN");
        Object[] objArr = new Object[]{InterestResultPolicy.NONE, new Integer(10)};
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "createClientCache", new Object[]{InterestResultPolicyDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "registerInterest", objArr);
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "verifyResult", objArr);
        logger.fine("testPolicyNone END");
    }

    public void testPolicyKeys() {
        LogWriter logger = this.getSystem().getLogWriter();
        logger.fine("testPolicyKeys BEGIN");
        Object[] objArr = new Object[]{InterestResultPolicy.KEYS, new Integer(10)};
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "createClientCache", new Object[]{InterestResultPolicyDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "registerInterest", objArr);
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "verifyResult", objArr);
        logger.fine("testPolicyKeys END");
    }

    public void testPolicyKeysValues() {
        LogWriter logger = this.getSystem().getLogWriter();
        logger.fine("testPolicyKeyValues BEGIN");
        Object[] objArr = new Object[]{InterestResultPolicy.KEYS_VALUES, new Integer(10)};
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "createClientCache", new Object[]{InterestResultPolicyDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "registerInterest", objArr);
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "verifyResult", objArr);
        logger.fine("testPolicyKeyValues END");
    }

    public void testBug35358() {
        LogWriter logger = this.getSystem().getLogWriter();
        logger.fine("testBug35358 BEGIN");
        Object[] objArr = new Object[]{InterestResultPolicy.KEYS, new Integer(15)};
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "createClientCache", new Object[]{InterestResultPolicyDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "registerInterest", objArr);
        this.vm1.invoke(InterestResultPolicyDUnitTest.class, "verifyResult", objArr);
        Integer cnt = (Integer)this.vm0.invoke(InterestResultPolicyDUnitTest.class, "getEntryCount");
        InterestResultPolicyDUnitTest.assertEquals((int)cnt, (int)10);
        logger.fine("testBug35358 END");
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static Integer createServerCache() throws Exception {
        InterestResultPolicyDUnitTest test = new InterestResultPolicyDUnitTest("temp");
        cache = test.createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.setSocketBufferSize(32768);
        server.start();
        return new Integer(port);
    }

    public static void populateServerCache() throws Exception {
        Region region1 = cache.getRegion("/InterestResultPolicyDUnitTest_region");
        for (int i = 0; i < 10; ++i) {
            region1.put((Object)("key-" + i), (Object)("val-" + i));
        }
    }

    public static void createClientCache(String host, Integer port) throws Exception {
        PORT = port;
        InterestResultPolicyDUnitTest test = new InterestResultPolicyDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        cache = test.createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(10000).setThreadLocalConnections(true).setSocketBufferSize(32768).setMinConnections(3).create("InterestResultPolicyDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void registerInterest(Object interestPolicy, Object totalKeysToRegister) {
        InterestResultPolicy policy = (InterestResultPolicy)interestPolicy;
        int totalKeys = (Integer)totalKeysToRegister;
        Region region1 = cache.getRegion("/InterestResultPolicyDUnitTest_region");
        LogWriter logger = cache.getLogger();
        logger.fine("Registering interest in " + totalKeys + " keys");
        ArrayList<String> keylist = new ArrayList<String>();
        for (int i = 0; i < totalKeys; ++i) {
            keylist.add("key-" + i);
        }
        try {
            region1.registerInterest(keylist, policy);
        }
        catch (CacheWriterException e) {
            InterestResultPolicyDUnitTest.fail("failed to register interestlist for the client", e);
        }
    }

    public static void verifyResult(Object interestPolicy, Object totalKeysRegistered) {
        Region region1 = cache.getRegion("/InterestResultPolicyDUnitTest_region");
        int entriesSize = region1.entrySet(false).size();
        int keysSize = region1.keySet().size();
        int valuesSize = region1.values().size();
        InterestResultPolicy policy = (InterestResultPolicy)interestPolicy;
        LogWriter logger = cache.getLogger();
        logger.fine("policy = " + policy + " ==> entries = " + entriesSize + " ;keys = " + keysSize + ";values = " + valuesSize);
        if (policy.isNone()) {
            InterestResultPolicyDUnitTest.assertEquals((int)0, (int)entriesSize);
            InterestResultPolicyDUnitTest.assertEquals((int)0, (int)keysSize);
            InterestResultPolicyDUnitTest.assertEquals((int)0, (int)valuesSize);
        } else if (policy.isKeys()) {
            InterestResultPolicyDUnitTest.assertEquals((int)10, (int)entriesSize);
            InterestResultPolicyDUnitTest.assertEquals((int)10, (int)keysSize);
            InterestResultPolicyDUnitTest.assertEquals((int)0, (int)valuesSize);
        } else if (policy.isKeysValues()) {
            InterestResultPolicyDUnitTest.assertEquals((int)10, (int)entriesSize);
            InterestResultPolicyDUnitTest.assertEquals((int)10, (int)keysSize);
            InterestResultPolicyDUnitTest.assertEquals((int)10, (int)valuesSize);
        }
    }

    public static Object getEntryCount() {
        Region region1 = cache.getRegion("/InterestResultPolicyDUnitTest_region");
        int keysSize = region1.keySet().size();
        return new Integer(keysSize);
    }
}

