/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;

public class InterestListFailoverDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "InterestListFailoverDUnitTest_region";

    public InterestListFailoverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        InterestListFailoverDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
    }

    public void createServersAndClients(int redundancyLevel) {
        Host host = Host.getHost(0);
        Integer mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        PORT1 = (Integer)this.vm0.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{REGION_NAME, new Boolean(true), mcastPort});
        PORT2 = (Integer)this.vm3.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{REGION_NAME, new Boolean(true), mcastPort});
        this.vm1.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.vm2.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.vm1.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(InterestListFailoverDUnitTest.getServerHostName(host), redundancyLevel), REGION_NAME});
        this.vm2.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(InterestListFailoverDUnitTest.getServerHostName(host), 0), REGION_NAME});
    }

    public void testInterestListRecoveryHA() {
        this.doTestInterestListRecovery(-1);
    }

    public void testInterestListRecoveryNonHA() {
        this.doTestInterestListRecovery(0);
    }

    public void doTestInterestListRecovery(int redundancyLevel) {
        this.createServersAndClients(redundancyLevel);
        this.vm1.invoke(InterestListFailoverDUnitTest.class, "createEntries");
        this.vm2.invoke(InterestListFailoverDUnitTest.class, "createEntries");
        this.vm0.invoke(InterestListFailoverDUnitTest.class, "createEntries");
        Integer primaryPort = (Integer)this.vm1.invoke(InterestListFailoverDUnitTest.class, "registerInterestList");
        VM primaryVM = primaryPort == PORT1 ? this.vm0 : this.vm3;
        this.vm2.invoke(InterestListFailoverDUnitTest.class, "putA");
        this.vm1.invoke(InterestListFailoverDUnitTest.class, "validateEntriesA");
        primaryVM.invoke(InterestListFailoverDUnitTest.class, "stopServer");
        this.vm2.invoke(InterestListFailoverDUnitTest.class, "putB");
        this.vm1.invoke(InterestListFailoverDUnitTest.class, "validateEntriesB");
    }

    public static void createEntries() {
        try {
            Region r = CacheServerTestUtil.getCache().getRegion("/InterestListFailoverDUnitTest_region");
            InterestListFailoverDUnitTest.assertNotNull((Object)r);
            if (!r.containsKey((Object)"key-1")) {
                r.create((Object)"key-1", (Object)"key-1");
            }
            if (!r.containsKey((Object)"key-6")) {
                r.create((Object)"key-6", (Object)"key-6");
            }
            InterestListFailoverDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"key-1");
            InterestListFailoverDUnitTest.assertEquals((Object)r.getEntry((Object)"key-6").getValue(), (Object)"key-6");
        }
        catch (Exception ex) {
            InterestListFailoverDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void verifyEntries() {
        try {
            Region r = CacheServerTestUtil.getCache().getRegion("/InterestListFailoverDUnitTest_region");
            InterestListFailoverDUnitTest.assertNotNull((Object)r);
            if (r.getEntry((Object)"key-1") != null) {
                InterestListFailoverDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"key-1");
            }
            if (r.getEntry((Object)"key-6") != null) {
                InterestListFailoverDUnitTest.assertEquals((Object)r.getEntry((Object)"key-6").getValue(), (Object)"key-6");
            }
        }
        catch (Exception ex) {
            InterestListFailoverDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static Integer registerInterestList() {
        try {
            Region r = CacheServerTestUtil.getCache().getRegion("/InterestListFailoverDUnitTest_region");
            InterestListFailoverDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"key-1");
            r.registerInterest((Object)"key-2");
            r.registerInterest((Object)"key-3");
            r.registerInterest((Object)"key-4");
            r.registerInterest((Object)"key-5");
            PoolImpl p = (PoolImpl)PoolManager.find((String)r.getAttributes().getPoolName());
            return new Integer(p.getPrimaryPort());
        }
        catch (Exception ex) {
            InterestListFailoverDUnitTest.fail("failed while registering keys k1 to k5", ex);
            return null;
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = CacheServerTestUtil.getCache().getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            InterestListFailoverDUnitTest.fail((String)("failed while stopServer()" + e));
        }
    }

    private Pool getClientPool(String host, int redundancyLevel) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setReadTimeout(500).setSocketBufferSize(32768).setMinConnections(4).setSubscriptionRedundancy(redundancyLevel);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    public static void _put(String v) {
        try {
            Region r = CacheServerTestUtil.getCache().getRegion("/InterestListFailoverDUnitTest_region");
            InterestListFailoverDUnitTest.assertNotNull((Object)r);
            r.put((Object)"key-1", (Object)("vm2-key-1" + v));
            r.put((Object)"key-6", (Object)("vm2-key-6" + v));
            InterestListFailoverDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)("vm2-key-1" + v));
            InterestListFailoverDUnitTest.assertEquals((Object)r.getEntry((Object)"key-6").getValue(), (Object)("vm2-key-6" + v));
        }
        catch (Exception ex) {
            InterestListFailoverDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void putA() {
        InterestListFailoverDUnitTest._put("A");
    }

    public static void putB() {
        InterestListFailoverDUnitTest._put("B");
    }

    public static void validateEntriesA() {
        InterestListFailoverDUnitTest._validateEntries("A");
    }

    public static void validateEntriesB() {
        InterestListFailoverDUnitTest._validateEntries("B");
    }

    public static void _validateEntries(final String v) {
        try {
            final Region r = CacheServerTestUtil.getCache().getRegion("/InterestListFailoverDUnitTest_region");
            String key1 = "key-1";
            InterestListFailoverDUnitTest.assertNotNull((Object)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Region.Entry e = r.getEntry((Object)"key-1");
                    if (e == null) {
                        return false;
                    }
                    Object val = e.getValue();
                    if (val == null) {
                        return false;
                    }
                    return val.equals("vm2-key-1" + v);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 40000L, 1000L, true);
            InterestListFailoverDUnitTest.assertEquals((Object)"key-6", (Object)r.getEntry((Object)"key-6").getValue());
        }
        catch (Exception ex) {
            InterestListFailoverDUnitTest.fail("failed while r.put()", ex);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.closeAll();
    }

    public void closeAll() {
        this.vm1.invoke(CacheServerTestUtil.class, "closeCache");
        this.vm2.invoke(CacheServerTestUtil.class, "closeCache");
        this.vm0.invoke(CacheServerTestUtil.class, "closeCache");
        this.vm3.invoke(CacheServerTestUtil.class, "closeCache");
        CacheServerTestUtil.closeCache();
    }
}

