/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.internal.cache.tier.sockets.HAInterestBaseTest;
import dunit.VM;

public class HAInterestPart1DUnitTest
extends HAInterestBaseTest {
    public HAInterestPart1DUnitTest(String name) {
        super(name);
    }

    public void testInterestRegistrationOnBothPrimaryAndSecondary() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart1DUnitTest.registerK1AndK2();
        server1.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server2.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server3.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testInterestRegistrationResponseOnBothPrimaryAndSecondary() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart1DUnitTest.registerK1AndK2OnPrimaryAndSecondaryAndVerifyResponse();
    }

    public void testRERegistrationWillNotCreateDuplicateKeysOnServerInterstMaps() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart1DUnitTest.reRegisterK1AndK2();
        server1.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server2.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server3.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testPrimaryFailureInRegisterInterest() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        VM oldPrimary = HAInterestPart1DUnitTest.getPrimaryVM();
        HAInterestPart1DUnitTest.stopPrimaryAndRegisterK1AndK2AndVerifyResponse();
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(1, 2);
        VM newPrimary = HAInterestPart1DUnitTest.getPrimaryVM(oldPrimary);
        newPrimary.invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        newPrimary.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testSecondaryFailureInRegisterInterest() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        VM primary = HAInterestPart1DUnitTest.getPrimaryVM();
        HAInterestPart1DUnitTest.stopSecondaryAndRegisterK1AndK2AndVerifyResponse();
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(1, 2);
        primary.invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        primary.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testBothPrimaryAndSecondaryFailureInRegisterInterest() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        VM oldPrimary = HAInterestPart1DUnitTest.getPrimaryVM();
        HAInterestPart1DUnitTest.stopBothPrimaryAndSecondaryAndRegisterK1AndK2AndVerifyResponse();
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(2, 1);
        VM newPrimary = HAInterestPart1DUnitTest.getPrimaryVM(oldPrimary);
        newPrimary.invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        newPrimary.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testProbablePrimaryFailureInRegisterInterest() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        VM oldPrimary = HAInterestPart1DUnitTest.getPrimaryVM();
        HAInterestPart1DUnitTest.stopPrimaryAndRegisterK1AndK2AndVerifyResponse();
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(1, 2);
        VM newPrimary = HAInterestPart1DUnitTest.getPrimaryVM(oldPrimary);
        newPrimary.invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        newPrimary.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testInterstRegistrationOnRecoveredEPbyDSM() throws Exception {
        HAInterestPart1DUnitTest.createClientPoolCache(this.getName(), HAInterestPart1DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart1DUnitTest.createEntriesK1andK2();
        HAInterestPart1DUnitTest.registerK1AndK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server1.invoke(HAInterestBaseTest.class, "stopServer");
        server2.invoke(HAInterestBaseTest.class, "stopServer");
        server3.invoke(HAInterestBaseTest.class, "stopServer");
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(3, 0);
        server2.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(2, 1);
        server2.invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        server2.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server1.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(1, 2);
        server1.invoke(HAInterestBaseTest.class, "verifyDispatcherIsNotAlive");
        server1.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server3.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart1DUnitTest.verifyDeadAndLiveServers(0, 3);
        server3.invoke(HAInterestBaseTest.class, "verifyDispatcherIsNotAlive");
        server3.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }
}

