/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class HAInterestBaseTest
extends DistributedTestCase {
    private static int MAX_WAIT = 60000;
    protected static Cache cache = null;
    protected static PoolImpl pool = null;
    protected static Connection conn = null;
    protected static int PORT1;
    protected static int PORT2;
    protected static int PORT3;
    protected static final String k1 = "k1";
    protected static final String k2 = "k2";
    protected static final String client_k1 = "client-k1";
    protected static final String client_k2 = "client-k2";
    protected static final String server_k1 = "server-k1";
    protected static final String server_k2 = "server-k2";
    protected static final String server_k1_updated = "server_k1_updated";
    protected static boolean isBeforeRegistrationCallbackCalled;
    protected static boolean isBeforeInterestRecoveryCallbackCalled;
    protected static boolean isAfterRegistrationCallbackCalled;
    protected static final String REGION_NAME = "HAInterestBaseTest_region";
    protected static Host host;
    protected static VM server1;
    protected static VM server2;
    protected static VM server3;
    protected static volatile boolean exceptionOccured;

    public HAInterestBaseTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        server3 = host.getVM(2);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        PORT1 = (Integer)server1.invoke(HAInterestBaseTest.class, "createServerCache");
        PORT2 = (Integer)server2.invoke(HAInterestBaseTest.class, "createServerCache");
        PORT3 = (Integer)server3.invoke(HAInterestBaseTest.class, "createServerCache");
        exceptionOccured = false;
    }

    public static VM getPrimaryVM() {
        return HAInterestBaseTest.getPrimaryVM(null);
    }

    public static VM getPrimaryVM(final VM oldPrimary) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int primaryPort = pool.getPrimaryPort();
                if (primaryPort == -1) {
                    return false;
                }
                VM currentPrimary = HAInterestBaseTest.getServerVM(primaryPort);
                return currentPrimary != oldPrimary;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
        int primaryPort = pool.getPrimaryPort();
        HAInterestBaseTest.assertTrue((primaryPort != -1 ? 1 : 0) != 0);
        VM currentPrimary = HAInterestBaseTest.getServerVM(primaryPort);
        HAInterestBaseTest.assertTrue((currentPrimary != oldPrimary ? 1 : 0) != 0);
        return currentPrimary;
    }

    public static VM getBackupVM() {
        return HAInterestBaseTest.getBackupVM(null);
    }

    public static VM getBackupVM(VM stoppedBackup) {
        VM currentPrimary = HAInterestBaseTest.getPrimaryVM(null);
        if (currentPrimary != server2 && server2 != stoppedBackup) {
            return server2;
        }
        if (currentPrimary != server3 && server3 != stoppedBackup) {
            return server3;
        }
        if (currentPrimary != server1 && server1 != stoppedBackup) {
            return server1;
        }
        HAInterestBaseTest.fail((String)("expected currentPrimary " + currentPrimary + " to be " + server1 + ", or " + server2 + ", or " + server3));
        return null;
    }

    public static int getServerPort(VM vm) {
        if (vm == server1) {
            return PORT1;
        }
        if (vm == server2) {
            return PORT2;
        }
        if (vm == server3) {
            return PORT3;
        }
        HAInterestBaseTest.fail((String)("expected vm " + vm + " to be " + server1 + ", or " + server2 + ", or " + server3));
        return -1;
    }

    public static VM getServerVM(int port) {
        if (port == PORT1) {
            return server1;
        }
        if (port == PORT2) {
            return server2;
        }
        if (port == PORT3) {
            return server3;
        }
        HAInterestBaseTest.fail((String)("expected port " + port + " to be " + PORT1 + ", or " + PORT2 + ", or " + PORT3));
        return null;
    }

    public static void verifyRefreshedEntriesFromServer() {
        final Region r1 = cache.getRegion("/HAInterestBaseTest_region");
        HAInterestBaseTest.assertNotNull((Object)r1);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Region.Entry re = r1.getEntry((Object)HAInterestBaseTest.k1);
                if (re == null) {
                    return false;
                }
                Object val = re.getValue();
                return HAInterestBaseTest.client_k1.equals(val);
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
        wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Region.Entry re = r1.getEntry((Object)HAInterestBaseTest.k2);
                if (re == null) {
                    return false;
                }
                Object val = re.getValue();
                return HAInterestBaseTest.client_k2.equals(val);
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
    }

    public static void verifyDeadAndLiveServers(int expectedDeadServers, final int expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String description;

            @Override
            public boolean done() {
                return pool.getConnectedServerCount() == expectedLiveServers;
            }

            @Override
            public String description() {
                return this.description;
            }
        };
        DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
    }

    public static void putK1andK2() {
        Region r1 = cache.getRegion("/HAInterestBaseTest_region");
        HAInterestBaseTest.assertNotNull((Object)r1);
        try {
            r1.put((Object)k1, (Object)server_k1);
            r1.put((Object)k2, (Object)server_k2);
        }
        catch (Exception e) {
            HAInterestBaseTest.fail((String)("Test failed due to Exception in putK1andK2 ::" + e));
        }
    }

    public static void setBridgeObserverForBeforeInterestRecoveryFailure() {
        PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeInterestRecovery() {
                Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
                synchronized (HAInterestBaseTest.class) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            HAInterestBaseTest.getBackupVM().invoke(HAInterestBaseTest.class, "startServer");
                            HAInterestBaseTest.getPrimaryVM().invoke(HAInterestBaseTest.class, "stopServer");
                        }
                    };
                    t.start();
                    try {
                        DistributedTestCase.join(t, 30000L, DistributedTestCase.getLogWriter());
                    }
                    catch (Exception ignore) {
                        exceptionOccured = true;
                    }
                    isBeforeInterestRecoveryCallbackCalled = true;
                    HAInterestBaseTest.class.notify();
                    PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static void setBridgeObserverForBeforeInterestRecovery() {
        PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeInterestRecovery() {
                Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
                synchronized (HAInterestBaseTest.class) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            Region r1 = cache.getRegion("/HAInterestBaseTest_region");
                            TestCase.assertNotNull((Object)r1);
                            try {
                                r1.put((Object)HAInterestBaseTest.k1, (Object)HAInterestBaseTest.server_k1_updated);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestCase.fail((String)("Test Failed due to ..." + e));
                            }
                        }
                    };
                    t.start();
                    isBeforeInterestRecoveryCallbackCalled = true;
                    HAInterestBaseTest.class.notify();
                    PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBeforeInterestRecoveryCallBack() {
        HAInterestBaseTest.assertNotNull((Object)cache);
        Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
        synchronized (HAInterestBaseTest.class) {
            while (!isBeforeInterestRecoveryCallbackCalled) {
                try {
                    HAInterestBaseTest.class.wait();
                }
                catch (InterruptedException e) {
                    HAInterestBaseTest.fail((String)"Test failed due to InterruptedException in waitForBeforeInterstRecovery()");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setBridgeObserverForBeforeRegistration(final VM vm) {
        PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeInterestRegistration() {
                Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
                synchronized (HAInterestBaseTest.class) {
                    vm.invoke(HAInterestBaseTest.class, "startServer");
                    isBeforeRegistrationCallbackCalled = true;
                    HAInterestBaseTest.class.notify();
                    PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBeforeRegistrationCallback() {
        HAInterestBaseTest.assertNotNull((Object)cache);
        Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
        synchronized (HAInterestBaseTest.class) {
            while (!isBeforeRegistrationCallbackCalled) {
                try {
                    HAInterestBaseTest.class.wait();
                }
                catch (InterruptedException e) {
                    HAInterestBaseTest.fail((String)"Test failed due to InterruptedException in waitForBeforeRegistrationCallback()");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setBridgeObserverForAfterRegistration(final VM vm) {
        PoolImpl.AFTER_REGISTER_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterInterestRegistration() {
                Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
                synchronized (HAInterestBaseTest.class) {
                    vm.invoke(HAInterestBaseTest.class, "startServer");
                    isAfterRegistrationCallbackCalled = true;
                    HAInterestBaseTest.class.notify();
                    PoolImpl.AFTER_REGISTER_CALLBACK_FLAG = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void waitForAfterRegistrationCallback() {
        HAInterestBaseTest.assertNotNull((Object)cache);
        if (isAfterRegistrationCallbackCalled) return;
        Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
        synchronized (HAInterestBaseTest.class) {
            while (!isAfterRegistrationCallbackCalled) {
                try {
                    HAInterestBaseTest.class.wait();
                }
                catch (InterruptedException e) {
                    HAInterestBaseTest.fail((String)"Test failed due to InterruptedException in waitForAfterRegistrationCallback()");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unSetBridgeObserverForRegistrationCallback() {
        Class<HAInterestBaseTest> clazz = HAInterestBaseTest.class;
        synchronized (HAInterestBaseTest.class) {
            PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = false;
            PoolImpl.AFTER_REGISTER_CALLBACK_FLAG = false;
            isBeforeRegistrationCallbackCalled = false;
            isAfterRegistrationCallbackCalled = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void verifyDispatcherIsAlive() {
        try {
            HAInterestBaseTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor());
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;
                Iterator iter_prox;
                CacheClientProxy proxy;

                @Override
                public boolean done() {
                    this.iter_prox = ccn.getClientProxies().iterator();
                    if (this.iter_prox.hasNext()) {
                        this.proxy = (CacheClientProxy)this.iter_prox.next();
                        return this.proxy._messageDispatcher.isAlive();
                    }
                    return false;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while setting verifyDispatcherIsAlive  " + ex));
        }
    }

    public static void verifyDispatcherIsNotAlive() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor());
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                CacheClientProxy proxy = (CacheClientProxy)iter_prox.next();
                HAInterestBaseTest.assertFalse((String)"Dispatcher on secondary should not be alive", (boolean)proxy._messageDispatcher.isAlive());
            }
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while setting verifyDispatcherIsNotAlive  " + ex));
        }
    }

    public static void createEntriesK1andK2OnServer() {
        try {
            Region r1 = cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)k1)) {
                r1.create((Object)k1, (Object)server_k1);
            }
            if (!r1.containsKey((Object)k2)) {
                r1.create((Object)k2, (Object)server_k2);
            }
            HAInterestBaseTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)server_k1);
            HAInterestBaseTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)server_k2);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while createEntries()", ex);
        }
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)k1)) {
                r1.create((Object)k1, (Object)client_k1);
            }
            if (!r1.containsKey((Object)k2)) {
                r1.create((Object)k2, (Object)client_k2);
            }
            HAInterestBaseTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
            HAInterestBaseTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while createEntries()", ex);
        }
    }

    public static void createServerEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)k1)) {
                r1.create((Object)k1, (Object)server_k1);
            }
            if (!r1.containsKey((Object)k2)) {
                r1.create((Object)k2, (Object)server_k2);
            }
            HAInterestBaseTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)server_k1);
            HAInterestBaseTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)server_k2);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while createEntries()", ex);
        }
    }

    public static void registerK1AndK2() {
        try {
            Region r = cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            r.registerInterest(list, InterestResultPolicy.KEYS_VALUES);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HAInterestBaseTest.fail("failed while region.registerK1AndK2()", ex);
        }
    }

    public static void reRegisterK1AndK2() {
        try {
            Region r = cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            r.registerInterest(list);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.reRegisterK1AndK2()", ex);
        }
    }

    public static void startServer() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            HAInterestBaseTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            bs.start();
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while startServer()  " + ex));
        }
    }

    public static void startServerAndPause() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            HAInterestBaseTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            bs.start();
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while startServer()  " + ex));
        }
    }

    public static void stopServer() {
        try {
            HAInterestBaseTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            bs.stop();
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while setting stopServer  " + ex));
        }
    }

    public static void stopPrimaryAndRegisterK1AndK2AndVerifyResponse() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ServerRegionProxy srp = new ServerRegionProxy((Region)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return pool.getConnectedServerCount() == 3;
                }

                @Override
                public String description() {
                    return "connected server count never became 3";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
            HAInterestBaseTest.getPrimaryVM().invoke(HAInterestBaseTest.class, "stopServer");
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            List serverKeys = srp.registerInterest(list, 0, InterestResultPolicy.KEYS, false, r.getAttributes().getDataPolicy().ordinal);
            HAInterestBaseTest.assertNotNull((Object)serverKeys);
            List resultKeys = (List)serverKeys.get(0);
            HAInterestBaseTest.assertEquals((int)2, (int)resultKeys.size());
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k1));
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k2));
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.stopPrimaryAndRegisterK1AndK2AndVerifyResponse()", ex);
        }
    }

    public static void stopPrimaryAndUnregisterRegisterK1() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ServerRegionProxy srp = new ServerRegionProxy((Region)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return pool.getConnectedServerCount() == 3;
                }

                @Override
                public String description() {
                    return "connected server count never became 3";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
            HAInterestBaseTest.getPrimaryVM().invoke(HAInterestBaseTest.class, "stopServer");
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            srp.unregisterInterest(list, 0, false, false);
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.stopPrimaryAndUnregisterRegisterK1()", ex);
        }
    }

    public static void stopBothPrimaryAndSecondaryAndRegisterK1AndK2AndVerifyResponse() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ServerRegionProxy srp = new ServerRegionProxy((Region)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return pool.getConnectedServerCount() == 3;
                }

                @Override
                public String description() {
                    return "connected server count never became 3";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
            VM backup = HAInterestBaseTest.getBackupVM();
            HAInterestBaseTest.getPrimaryVM().invoke(HAInterestBaseTest.class, "stopServer");
            backup.invoke(HAInterestBaseTest.class, "stopServer");
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            List serverKeys = srp.registerInterest(list, 0, InterestResultPolicy.KEYS, false, r.getAttributes().getDataPolicy().ordinal);
            HAInterestBaseTest.assertNotNull((Object)serverKeys);
            List resultKeys = (List)serverKeys.get(0);
            HAInterestBaseTest.assertEquals((int)2, (int)resultKeys.size());
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k1));
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k2));
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.stopBothPrimaryAndSecondaryAndRegisterK1AndK2AndVerifyResponse()", ex);
        }
    }

    public static VM stopSecondaryAndRegisterK1AndK2AndVerifyResponse() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ServerRegionProxy srp = new ServerRegionProxy((Region)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return pool.getConnectedServerCount() == 3;
                }

                @Override
                public String description() {
                    return "Never got three connected servers";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 90000L, 1000L, true);
            VM result = HAInterestBaseTest.getBackupVM();
            result.invoke(HAInterestBaseTest.class, "stopServer");
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            List serverKeys = srp.registerInterest(list, 0, InterestResultPolicy.KEYS, false, r.getAttributes().getDataPolicy().ordinal);
            HAInterestBaseTest.assertNotNull((Object)serverKeys);
            List resultKeys = (List)serverKeys.get(0);
            HAInterestBaseTest.assertEquals((int)2, (int)resultKeys.size());
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k1));
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k2));
            return result;
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.stopSecondaryAndRegisterK1AndK2AndVerifyResponse()", ex);
            return null;
        }
    }

    public static VM stopSecondaryAndUNregisterK1() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ServerRegionProxy srp = new ServerRegionProxy((Region)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return pool.getConnectedServerCount() == 3;
                }

                @Override
                public String description() {
                    return "connected server count never became 3";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
            VM result = HAInterestBaseTest.getBackupVM();
            result.invoke(HAInterestBaseTest.class, "stopServer");
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            srp.unregisterInterest(list, 0, false, false);
            return result;
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.stopSecondaryAndUNregisterK1()", ex);
            return null;
        }
    }

    public static void registerK1AndK2OnPrimaryAndSecondaryAndVerifyResponse() {
        try {
            ServerLocation primary = pool.getPrimary();
            ServerLocation secondary = (ServerLocation)pool.getRedundants().get(0);
            LocalRegion r = (LocalRegion)cache.getRegion("/HAInterestBaseTest_region");
            HAInterestBaseTest.assertNotNull((Object)r);
            ServerRegionProxy srp = new ServerRegionProxy((Region)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add(k1);
            list.add(k2);
            List serverKeys1 = srp.registerInterestOn(primary, list, 0, InterestResultPolicy.KEYS, false, r.getAttributes().getDataPolicy().ordinal);
            HAInterestBaseTest.assertNotNull((Object)serverKeys1);
            List resultKeys = (List)serverKeys1.get(0);
            HAInterestBaseTest.assertEquals((int)2, (int)resultKeys.size());
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k1));
            HAInterestBaseTest.assertTrue((boolean)resultKeys.contains(k2));
            List serverKeys2 = srp.registerInterestOn(secondary, list, 0, InterestResultPolicy.KEYS, false, r.getAttributes().getDataPolicy().ordinal);
            if (serverKeys2 != null) {
                HAInterestBaseTest.assertTrue((boolean)serverKeys2.isEmpty());
            }
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail("failed while region.registerK1AndK2OnPrimaryAndSecondaryAndVerifyResponse()", ex);
        }
    }

    public static void verifyInterestRegistration() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor());
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                final CacheClientProxy ccp = (CacheClientProxy)iter_prox.next();
                wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        Set keysMap = ccp.cils[0].getProfile("/HAInterestBaseTest_region").getKeysOfInterestFor((Object)ccp.getProxyID());
                        return keysMap != null && keysMap.size() == 2;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
                Set keysMap = ccp.cils[0].getProfile("/HAInterestBaseTest_region").getKeysOfInterestFor((Object)ccp.getProxyID());
                HAInterestBaseTest.assertNotNull((Object)keysMap);
                HAInterestBaseTest.assertEquals((int)2, (int)keysMap.size());
                HAInterestBaseTest.assertTrue((boolean)keysMap.contains(k1));
                HAInterestBaseTest.assertTrue((boolean)keysMap.contains(k2));
            }
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while setting verifyInterestRegistration  " + ex));
        }
    }

    public static void verifyInterestUNRegistration() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAInterestBaseTest.assertNotNull((Object)bs);
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor());
            HAInterestBaseTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                final CacheClientProxy ccp = (CacheClientProxy)iter_prox.next();
                wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        Set keysMap = ccp.cils[0].getProfile("/HAInterestBaseTest_region").getKeysOfInterestFor((Object)ccp.getProxyID());
                        return keysMap != null;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, MAX_WAIT, 1000L, true);
                Set keysMap = ccp.cils[0].getProfile("/HAInterestBaseTest_region").getKeysOfInterestFor((Object)ccp.getProxyID());
                HAInterestBaseTest.assertNotNull((Object)keysMap);
                HAInterestBaseTest.assertEquals((int)1, (int)keysMap.size());
                HAInterestBaseTest.assertFalse((boolean)keysMap.contains(k1));
                HAInterestBaseTest.assertTrue((boolean)keysMap.contains(k2));
            }
        }
        catch (Exception ex) {
            HAInterestBaseTest.fail((String)("while setting verifyInterestUNRegistration  " + ex));
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAInterestBaseTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAInterestBaseTest.assertNotNull((Object)cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientPoolCache(String testName, String host) throws Exception {
        PoolImpl p;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAInterestBaseTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).addServer(host, PORT3).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(1000).setPingInterval(1000L).create("HAInterestBaseTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        factory.setPoolName(p.getName());
        cache.createRegion(REGION_NAME, factory.create());
        pool = p;
        conn = pool.acquireConnection();
        HAInterestBaseTest.assertNotNull((Object)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientPoolCacheWithSmallRetryInterval(String testName, String host) throws Exception {
        PoolImpl p;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAInterestBaseTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(1000).setSocketBufferSize(32768).setMinConnections(6).setPingInterval(200L).create("HAInterestBaseTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        factory.setPoolName(p.getName());
        cache.createRegion(REGION_NAME, factory.create());
        pool = p;
        conn = pool.acquireConnection();
        HAInterestBaseTest.assertNotNull((Object)conn);
    }

    public static void createClientPoolCacheConnectionToSingleServer(String testName, String hostName) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAInterestBaseTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(hostName, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(1000).create("HAInterestBaseTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        factory.setPoolName(p.getName());
        cache.createRegion(REGION_NAME, factory.create());
        pool = p;
        conn = pool.acquireConnection();
        HAInterestBaseTest.assertNotNull((Object)conn);
    }

    public static Integer createServerCache() throws Exception {
        new HAInterestBaseTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        factory.setConcurrencyChecksEnabled(true);
        cache.createRegion(REGION_NAME, factory.create());
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setMaximumTimeBetweenPings(180000);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static Integer createServerCacheWithLocalRegion() throws Exception {
        new HAInterestBaseTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.setMaximumTimeBetweenPings(180000);
        server.start();
        return new Integer(server.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        HAInterestBaseTest.closeCache();
        server1.invoke(HAInterestBaseTest.class, "closeCache");
        server2.invoke(HAInterestBaseTest.class, "closeCache");
        server3.invoke(HAInterestBaseTest.class, "closeCache");
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }

    public static void closeCache() {
        PoolImpl.AFTER_REGISTER_CALLBACK_FLAG = false;
        PoolImpl.BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
        PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = false;
        PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = false;
        isAfterRegistrationCallbackCalled = false;
        isBeforeInterestRecoveryCallbackCalled = false;
        isBeforeRegistrationCallbackCalled = false;
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        isBeforeRegistrationCallbackCalled = false;
        isBeforeInterestRecoveryCallbackCalled = false;
        isAfterRegistrationCallbackCalled = false;
        host = null;
        server1 = null;
        server2 = null;
        server3 = null;
        exceptionOccured = false;
    }
}

