/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DurableClientReconnectDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static VM server3 = null;
    private static VM server4 = null;
    private static PoolImpl pool = null;
    private static Connection conn = null;
    private static Integer PORT1;
    private static Integer PORT2;
    private static Integer PORT3;
    private static Integer PORT4;
    private static String SERVER1;
    private static String SERVER2;
    private static String SERVER3;
    private static String SERVER4;
    private static final String REGION_NAME = "DurableClientReconnectDUnitTest_region";
    private DurableClientReconnectDUnitTest instance = null;

    public DurableClientReconnectDUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        DistributedTestCase.disconnectAllFromDS();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        server3 = host.getVM(2);
        server4 = host.getVM(3);
        PORT1 = (Integer)server1.invoke(DurableClientReconnectDUnitTest.class, "createServerCache");
        PORT2 = (Integer)server2.invoke(DurableClientReconnectDUnitTest.class, "createServerCache");
        PORT3 = (Integer)server3.invoke(DurableClientReconnectDUnitTest.class, "createServerCache");
        PORT4 = (Integer)server4.invoke(DurableClientReconnectDUnitTest.class, "createServerCache");
        SERVER1 = DurableClientReconnectDUnitTest.getServerHostName(host) + PORT1;
        SERVER2 = DurableClientReconnectDUnitTest.getServerHostName(host) + PORT2;
        SERVER3 = DurableClientReconnectDUnitTest.getServerHostName(host) + PORT3;
        SERVER4 = DurableClientReconnectDUnitTest.getServerHostName(host) + PORT4;
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "false");
    }

    public void testDurableReconnectSingleServer() throws Exception {
        this.createCacheClientAndConnectToSingleServer(DurableClientReconnectDUnitTest.getServerHostName(Host.getHost(0)), 0);
        List redundantServers = pool.getRedundantNames();
        String primaryName = pool.getPrimaryName();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers.isEmpty());
        this.closeCache(true);
        DurableClientReconnectDUnitTest.pause(2000);
        this.createCacheClientAndConnectToSingleServer(DurableClientReconnectDUnitTest.getServerHostName(Host.getHost(0)), 0);
        List redundantServers2 = pool.getRedundantNames();
        String primaryName2 = pool.getPrimaryName();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers2.isEmpty());
        DurableClientReconnectDUnitTest.assertTrue((boolean)primaryName2.equals(primaryName));
    }

    public void testDurableReconnectSingleServerWithZeroConnPerServer() throws Exception {
        this.createCacheClientAndConnectToSingleServerWithZeroConnPerServer(DurableClientReconnectDUnitTest.getServerHostName(Host.getHost(0)), 0);
        List redundantServers = pool.getRedundantNames();
        String primaryName = pool.getPrimaryName();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers.isEmpty());
        this.closeCache(true);
        this.createCacheClientAndConnectToSingleServerWithZeroConnPerServer(DurableClientReconnectDUnitTest.getServerHostName(Host.getHost(0)), 0);
        List redundantServers2 = pool.getRedundantNames();
        String primaryName2 = pool.getPrimaryName();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers2.isEmpty());
        DurableClientReconnectDUnitTest.assertTrue((boolean)primaryName2.equals(primaryName));
    }

    public void testDurableReconnectNonHA() throws Exception {
        this.createCacheClient(0);
        List redundantServers = pool.getRedundantNames();
        String primaryName = pool.getPrimaryName();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers.isEmpty());
        this.closeCache(true);
        DurableClientReconnectDUnitTest.pause(2000);
        this.createCacheClient(0);
        List redundantServers2 = pool.getRedundantNames();
        String primaryName2 = pool.getPrimaryName();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers2.isEmpty());
        DurableClientReconnectDUnitTest.assertTrue((boolean)primaryName2.equals(primaryName));
    }

    public void testDurableReconnect() throws Exception {
        this.createCacheClient();
        HashSet<String> redundantServers = new HashSet<String>(pool.getRedundantNames());
        redundantServers.add(pool.getPrimaryName());
        this.instance.determineAndVerfiyRedundantServers(redundantServers);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServers);
        this.closeCache(true);
        DurableClientReconnectDUnitTest.pause(2000);
        this.createCacheClient();
        HashSet<String> redundantServersAfterReconnect = new HashSet<String>(pool.getRedundantNames());
        redundantServersAfterReconnect.add(pool.getPrimaryName());
        this.instance.determineAndVerfiyRedundantServers(redundantServersAfterReconnect);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersAfterReconnect);
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers.equals(redundantServersAfterReconnect));
    }

    public void testDurableReconnect_DiffernetPrimary() throws Exception {
        this.createCacheClient();
        HashSet<String> redundantServers = new HashSet<String>(pool.getRedundantNames());
        String primaryBefore = pool.getPrimaryName();
        redundantServers.add(primaryBefore);
        this.instance.determineAndVerfiyRedundantServers(redundantServers);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServers);
        this.closeCache(true);
        DurableClientReconnectDUnitTest.pause(2000);
        this.createCacheClient();
        HashSet<String> redundantServersAfterReconnect = new HashSet<String>(pool.getRedundantNames());
        String primaryAfter = pool.getPrimaryName();
        redundantServersAfterReconnect.add(primaryAfter);
        this.instance.determineAndVerfiyRedundantServers(redundantServersAfterReconnect);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersAfterReconnect);
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers.equals(redundantServersAfterReconnect));
        DurableClientReconnectDUnitTest.assertFalse((boolean)primaryBefore.equals(primaryAfter));
    }

    public void testDurableReconnectWithOneRedundantServerDown() throws Exception {
        this.createCacheClient();
        List redundantServers = pool.getRedundantNames();
        redundantServers.add(pool.getPrimaryName());
        DurableClientReconnectDUnitTest.assertTrue((redundantServers.size() == 2 ? 1 : 0) != 0);
        this.instance.determineAndVerfiyRedundantServers(redundantServers);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServers);
        this.closeCache(true);
        Object[] serverArray = redundantServers.toArray();
        String rServer1 = (String)serverArray[0];
        String rServer2 = (String)serverArray[1];
        this.instance.closeServer(rServer1);
        this.createCacheClient();
        List redundantServersAfterReconnect = pool.getRedundantNames();
        redundantServersAfterReconnect.add(pool.getPrimaryName());
        this.instance.determineAndVerfiyRedundantServers(redundantServersAfterReconnect);
        ArrayList<String> redundantServersHistory = new ArrayList<String>();
        redundantServersHistory.addAll(redundantServersAfterReconnect);
        redundantServersHistory.add(rServer1);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersHistory);
        DurableClientReconnectDUnitTest.assertFalse((boolean)redundantServers.equals(redundantServersAfterReconnect));
        DurableClientReconnectDUnitTest.assertTrue((redundantServersAfterReconnect.size() == 2 ? 1 : 0) != 0);
        DurableClientReconnectDUnitTest.assertFalse((boolean)redundantServersAfterReconnect.contains(rServer1));
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServersAfterReconnect.contains(rServer2));
    }

    public void testDurableReconnectWithBothRedundantServersDown() throws Exception {
        this.createCacheClient();
        List redundantServers = pool.getRedundantNames();
        redundantServers.add(pool.getPrimaryName());
        DurableClientReconnectDUnitTest.assertTrue((redundantServers.size() == 2 ? 1 : 0) != 0);
        this.instance.determineAndVerfiyRedundantServers(redundantServers);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServers);
        this.closeCache(true);
        Object[] serverArray = redundantServers.toArray();
        String rServer1 = (String)serverArray[0];
        String rServer2 = (String)serverArray[1];
        this.instance.closeServer(rServer1);
        this.instance.closeServer(rServer2);
        this.createCacheClient();
        LinkedList<String> redundantServersAfterReconnect = pool.getRedundantNames();
        if (redundantServersAfterReconnect.isEmpty()) {
            redundantServersAfterReconnect = new LinkedList<String>();
        }
        redundantServersAfterReconnect.add(pool.getPrimaryName());
        ArrayList<String> redundantServersHistory = new ArrayList<String>();
        redundantServersHistory.addAll(redundantServersAfterReconnect);
        redundantServersHistory.add(rServer1);
        redundantServersHistory.add(rServer2);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersHistory);
        DurableClientReconnectDUnitTest.assertFalse((boolean)redundantServers.equals(redundantServersAfterReconnect));
        DurableClientReconnectDUnitTest.assertTrue((redundantServersAfterReconnect.size() == 2 ? 1 : 0) != 0);
        DurableClientReconnectDUnitTest.assertFalse((boolean)redundantServersAfterReconnect.contains(rServer1));
        DurableClientReconnectDUnitTest.assertFalse((boolean)redundantServersAfterReconnect.contains(rServer2));
    }

    public void testDurableReconnectWithBothNonRedundantServersDown() throws Exception {
        this.createCacheClient();
        HashSet<String> redundantServers = new HashSet<String>(pool.getRedundantNames());
        redundantServers.add(pool.getPrimaryName());
        DurableClientReconnectDUnitTest.assertTrue((redundantServers.size() == 2 ? 1 : 0) != 0);
        this.instance.determineAndVerfiyRedundantServers(redundantServers);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServers);
        this.closeCache(true);
        HashSet<String> nonRedundantSet = new HashSet<String>();
        nonRedundantSet.add(SERVER1);
        nonRedundantSet.add(SERVER2);
        nonRedundantSet.add(SERVER3);
        nonRedundantSet.add(SERVER4);
        nonRedundantSet.removeAll(redundantServers);
        Object[] serverArray = nonRedundantSet.toArray();
        String rServer1 = (String)serverArray[0];
        String rServer2 = (String)serverArray[1];
        DistributedTestCase.ExpectedException expectedEx = DurableClientReconnectDUnitTest.addExpectedException(SocketException.class.getName());
        this.instance.closeServer(rServer1);
        this.instance.closeServer(rServer2);
        this.createCacheClient();
        HashSet<String> redundantServersAfterReconnect = new HashSet<String>(pool.getRedundantNames());
        redundantServersAfterReconnect.add(pool.getPrimaryName());
        ArrayList<String> redundantServersHistory = new ArrayList<String>();
        redundantServersHistory.addAll(redundantServersAfterReconnect);
        redundantServersHistory.add(rServer1);
        redundantServersHistory.add(rServer2);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersHistory);
        expectedEx.remove();
        DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServers.equals(redundantServersAfterReconnect));
        DurableClientReconnectDUnitTest.assertTrue((redundantServersAfterReconnect.size() == 2 ? 1 : 0) != 0);
        DurableClientReconnectDUnitTest.assertFalse((String)("redundantServersAfterReconnect contains " + rServer1), (boolean)redundantServersAfterReconnect.contains(rServer1));
        DurableClientReconnectDUnitTest.assertFalse((String)("redundantServersAfterReconnect contains " + rServer2), (boolean)redundantServersAfterReconnect.contains(rServer2));
    }

    public void testBug39332() {
        this.createCacheClient(2, 20);
        HashSet<String> redundantServers = new HashSet<String>(pool.getRedundantNames());
        redundantServers.add(pool.getPrimaryName());
        this.instance.determineAndVerfiyRedundantServers(redundantServers);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServers);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - Durable client initialially has servers " + redundantServers);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - Closing durable client for the first time");
        this.closeCache(true);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - Durable client closed for the first time");
        DurableClientReconnectDUnitTest.pause(2000);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - Creating the durable client with one fewer servers");
        this.createCacheClient(2, 20, false);
        HashSet<String> redundantServers2 = new HashSet<String>(pool.getRedundantNames());
        redundantServers2.add(pool.getPrimaryName());
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - Durable client created again, now with servers " + redundantServers2);
        Host host = Host.getHost(0);
        pool.acquireConnection(new ServerLocation(DurableClientReconnectDUnitTest.getServerHostName(host), PORT1.intValue()));
        pool.acquireConnection(new ServerLocation(DurableClientReconnectDUnitTest.getServerHostName(host), PORT2.intValue()));
        pool.acquireConnection(new ServerLocation(DurableClientReconnectDUnitTest.getServerHostName(host), PORT3.intValue()));
        pool.acquireConnection(new ServerLocation(DurableClientReconnectDUnitTest.getServerHostName(host), PORT4.intValue()));
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - All pool connections are now aquired");
        this.closeCache(true);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - closed durable client for the second time");
        DurableClientReconnectDUnitTest.pause(2000);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - creating durable client for the third time");
        this.createCacheClient(2, 20);
        HashSet<String> redundantServersAfterReconnect = new HashSet<String>(pool.getRedundantNames());
        redundantServersAfterReconnect.add(pool.getPrimaryName());
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - durable client created for the third time, now with servers " + redundantServersAfterReconnect);
        this.instance.determineAndVerfiyRedundantServers(redundantServersAfterReconnect);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersAfterReconnect);
        DurableClientReconnectDUnitTest.assertEquals(redundantServers, redundantServersAfterReconnect);
        DurableClientReconnectDUnitTest.pause(25000);
        DurableClientReconnectDUnitTest.getLogWriter().info("TEST - Finished waiting for durable client expiration task");
        redundantServersAfterReconnect = new HashSet(pool.getRedundantNames());
        redundantServersAfterReconnect.add(pool.getPrimaryName());
        this.instance.determineAndVerfiyRedundantServers(redundantServersAfterReconnect);
        this.instance.determineAndVerfiyNonRedundantServers(redundantServersAfterReconnect);
        DurableClientReconnectDUnitTest.assertEquals(redundantServers, redundantServersAfterReconnect);
    }

    private static void verifyRedundantServers(Set redundantServers, Set redundantServersAfterReconnect) {
        try {
            for (Object endpointName : redundantServers) {
                DurableClientReconnectDUnitTest.assertTrue((boolean)redundantServersAfterReconnect.contains(endpointName));
            }
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to", e);
        }
    }

    private static void verifyNoDurableClientOnServer() {
        try {
            DurableClientReconnectDUnitTest.checkNumberOfClientProxies(0);
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to", e);
        }
    }

    public static Integer createServerCache() throws Exception {
        Properties props = new Properties();
        new DurableClientReconnectDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        Region r = cache.createRegion(REGION_NAME, attrs);
        DurableClientReconnectDUnitTest.assertNotNull((Object)r);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    private void determineAndVerfiyRedundantServers(Collection redundantServers) {
        if (redundantServers.contains(SERVER1)) {
            server1.invoke(DurableClientReconnectDUnitTest.class, "verifyDurableClientOnServer");
        }
        if (redundantServers.contains(SERVER2)) {
            server2.invoke(DurableClientReconnectDUnitTest.class, "verifyDurableClientOnServer");
        }
        if (redundantServers.contains(SERVER3)) {
            server3.invoke(DurableClientReconnectDUnitTest.class, "verifyDurableClientOnServer");
        }
        if (redundantServers.contains(SERVER4)) {
            server4.invoke(DurableClientReconnectDUnitTest.class, "verifyDurableClientOnServer");
        }
    }

    private void determineAndVerfiyNonRedundantServers(Collection redundantServers) {
        if (!redundantServers.contains(SERVER1)) {
            server1.invoke(DurableClientReconnectDUnitTest.class, "verifyNoDurableClientOnServer");
        }
        if (!redundantServers.contains(SERVER2)) {
            server2.invoke(DurableClientReconnectDUnitTest.class, "verifyNoDurableClientOnServer");
        }
        if (!redundantServers.contains(SERVER3)) {
            server3.invoke(DurableClientReconnectDUnitTest.class, "verifyNoDurableClientOnServer");
        }
        if (!redundantServers.contains(SERVER4)) {
            server4.invoke(DurableClientReconnectDUnitTest.class, "verifyNoDurableClientOnServer");
        }
    }

    private void closeServer(String server) {
        if (server.equals(SERVER1)) {
            server1.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        }
        if (server.equals(SERVER2)) {
            server2.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        }
        if (server.equals(SERVER3)) {
            server3.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        }
        if (server.equals(SERVER4)) {
            server4.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        }
    }

    private static void verifyDurableClientOnServer() {
        try {
            DurableClientReconnectDUnitTest.checkNumberOfClientProxies(1);
            CacheClientProxy proxy = DurableClientReconnectDUnitTest.getClientProxy();
            DurableClientReconnectDUnitTest.assertNotNull((Object)proxy);
            DurableClientReconnectDUnitTest.assertTrue((boolean)proxy.isDurable());
            DurableClientReconnectDUnitTest.assertEquals((String)"DurableClientReconnectDUnitTest_client", (String)proxy.getDurableId());
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to", e);
        }
    }

    private static CacheClientProxy getClientProxy() {
        CacheClientNotifier notifier = DurableClientReconnectDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
        CacheClientProxy proxy = null;
        Iterator i = notifier.getClientProxies().iterator();
        if (i.hasNext()) {
            proxy = (CacheClientProxy)i.next();
        }
        return proxy;
    }

    private static void checkNumberOfClientProxies(final int expected) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return expected == DurableClientReconnectDUnitTest.getNumberOfClientProxies();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 15000L, 200L, true);
    }

    protected static int getNumberOfClientProxies() {
        return DurableClientReconnectDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier().getClientProxies().size();
    }

    private static BridgeServerImpl getBridgeServer() {
        BridgeServerImpl bridgeServer = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
        DurableClientReconnectDUnitTest.assertNotNull((Object)bridgeServer);
        return bridgeServer;
    }

    private void createCache(Properties props) {
        try {
            InternalDistributedSystem ds = this.getSystem(props);
            DurableClientReconnectDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            DurableClientReconnectDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to ", e);
        }
    }

    private void createCacheClient() {
        this.createCacheClient(1);
    }

    protected PoolFactory getPoolFactory() {
        Host host = Host.getHost(0);
        PoolFactory factory = PoolManager.createFactory().addServer(DurableClientReconnectDUnitTest.getServerHostName(host), PORT1.intValue()).addServer(DurableClientReconnectDUnitTest.getServerHostName(host), PORT2.intValue()).addServer(DurableClientReconnectDUnitTest.getServerHostName(host), PORT3.intValue()).addServer(DurableClientReconnectDUnitTest.getServerHostName(host), PORT4.intValue());
        return factory;
    }

    private void createCacheClient(int redundancyLevel) {
        this.createCacheClient(redundancyLevel, 60);
    }

    private void createCacheClient(int redundancyLevel, int durableClientTimeout) {
        this.createCacheClient(redundancyLevel, durableClientTimeout, true);
    }

    private void createCacheClient(int redundancyLevel, int durableClientTimeout, boolean queueEnabled) {
        try {
            String durableClientId = "DurableClientReconnectDUnitTest_client";
            Properties props = this.getClientDistributedSystemProperties("DurableClientReconnectDUnitTest_client", durableClientTimeout);
            this.instance = new DurableClientReconnectDUnitTest("temp");
            this.instance.createCache(props);
            PoolImpl p = (PoolImpl)this.getPoolFactory().setSubscriptionEnabled(queueEnabled).setReadTimeout(10000).setSubscriptionRedundancy(redundancyLevel).create("DurableClientReconnectDUnitTestPool");
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setPoolName(p.getName());
            RegionAttributes attrs = factory.create();
            Region r = cache.createRegion(REGION_NAME, attrs);
            DurableClientReconnectDUnitTest.assertNotNull((Object)r);
            pool = p;
            conn = pool.acquireConnection();
            DurableClientReconnectDUnitTest.assertNotNull((Object)conn);
            cache.readyForEvents();
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to ", e);
        }
    }

    private void createCacheClientAndConnectToSingleServer(String host, int redundancyLevel) {
        try {
            String durableClientId = "DurableClientReconnectDUnitTest_client";
            int durableClientTimeout = 60;
            Properties props = this.getClientDistributedSystemProperties("DurableClientReconnectDUnitTest_client", 60);
            this.instance = new DurableClientReconnectDUnitTest("temp");
            this.instance.createCache(props);
            PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1.intValue()).setSubscriptionEnabled(true).setReadTimeout(10000).setSubscriptionRedundancy(redundancyLevel).create("DurableClientReconnectDUnitTestPool");
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setPoolName(p.getName());
            RegionAttributes attrs = factory.create();
            Region r = cache.createRegion(REGION_NAME, attrs);
            DurableClientReconnectDUnitTest.assertNotNull((Object)r);
            pool = p;
            conn = pool.acquireConnection();
            DurableClientReconnectDUnitTest.assertNotNull((Object)conn);
            cache.readyForEvents();
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to ", e);
        }
    }

    private void createCacheClientAndConnectToSingleServerWithZeroConnPerServer(String host, int redundancyLevel) {
        try {
            String durableClientId = "DurableClientReconnectDUnitTest_client";
            int durableClientTimeout = 60;
            Properties props = this.getClientDistributedSystemProperties("DurableClientReconnectDUnitTest_client", 60);
            this.instance = new DurableClientReconnectDUnitTest("temp");
            this.instance.createCache(props);
            PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1.intValue()).setSubscriptionEnabled(true).setReadTimeout(10000).setMinConnections(0).setSubscriptionRedundancy(redundancyLevel).create("DurableClientReconnectDUnitTestPool");
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setPoolName(p.getName());
            RegionAttributes attrs = factory.create();
            Region r = cache.createRegion(REGION_NAME, attrs);
            DurableClientReconnectDUnitTest.assertNotNull((Object)r);
            pool = p;
            conn = pool.acquireConnection();
            DurableClientReconnectDUnitTest.assertNotNull((Object)conn);
            cache.readyForEvents();
        }
        catch (Exception e) {
            DurableClientReconnectDUnitTest.fail("test failed due to ", e);
        }
    }

    private Properties getClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DurableClientReconnectDUnitTest.closeCache();
        server1.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        server2.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        server3.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
        server4.invoke(DurableClientReconnectDUnitTest.class, "closeCache");
    }

    public void closeCache(boolean keepAlive) {
        if (cache != null && !cache.isClosed()) {
            cache.close(keepAlive);
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }
}

