/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerRefusedConnectionException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import util.TestException;

public class DurableClientDUnitTest
extends DistributedTestCase {
    protected VM server1VM;
    protected VM server2VM;
    protected VM durableClientVM;
    protected VM publisherClientVM;
    protected String regionName;
    protected static volatile boolean isPrimaryRecovered = false;

    public DurableClientDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        this.server1VM = host.getVM(0);
        this.server2VM = host.getVM(1);
        this.durableClientVM = host.getVM(2);
        this.publisherClientVM = host.getVM(3);
        this.regionName = this.getName() + "_region";
    }

    @Override
    public void tearDown2() throws Exception {
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testSimpleDurableClient() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.disconnectDurableClient();
        this.verifySimpleDurableClient();
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.closeDurableClient();
    }

    public void closeDurableClient() {
    }

    public void disconnectDurableClient() {
        this.disconnectDurableClient(false);
    }

    public void disconnectDurableClient(boolean keepAlive) {
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(keepAlive)});
    }

    public void verifySimpleDurableClient() {
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNull((Object)proxy);
            }
        });
    }

    public void testStartStopStartDurableClient() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.disconnectDurableClient(true);
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.restartDurableClient(new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void test39630() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.disconnectDurableClient(true);
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                Assert.assertNotNull((Object)proxy._socket);
                long end = System.currentTimeMillis() + 60000L;
                while (!proxy._socket.isClosed() && System.currentTimeMillis() <= end) {
                }
                Assert.assertTrue((boolean)proxy._socket.isClosed());
            }
        });
        this.restartDurableClient(new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60)});
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void restartDurableClient(Object[] args) {
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", args);
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
    }

    public void testStartStopTimeoutDurableClient() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 5;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 5)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)5, (int)proxy.getDurableTimeout());
            }
        });
        this.disconnectDurableClient(true);
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNull((Object)proxy);
            }
        });
        this.restartDurableClient(new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(Host.getHost(0)), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 5)});
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testDurableClientPrimaryUpdate() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 120;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 120), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        boolean numberOfEntries = true;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.verifyListenerUpdates(1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.disconnectDurableClient(true);
        this.server1VM.invoke(new CacheSerializableRunnable("Wait for paused"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                        return proxy != null && proxy.isPaused();
                    }

                    @Override
                    public String description() {
                        return "Proxy was not paused: " + DurableClientDUnitTest.getClientProxy();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                        if (proxy == null) {
                            this.excuse = "No CacheClientProxy";
                            return false;
                        }
                        int sz = proxy.getQueueSize();
                        if (1 != sz) {
                            this.excuse = "expected = 1, actual = " + sz;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            }
        });
        this.verifyListenerUpdatesDisconnected(1);
        this.restartDurableClient(new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.verifyListenerUpdates(1, 1);
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testStartStopStartDurableClientUpdate() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        boolean numberOfEntries = true;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.verifyListenerUpdates(1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.disconnectDurableClient(true);
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                final CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return proxy.isPaused();
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 1000L, 200L, true);
                TestCase.assertTrue((boolean)proxy.isPaused());
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish more entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertEquals((int)1, (int)proxy.getQueueSize());
            }
        });
        this.verifyListenerUpdatesDisconnected(1);
        this.restartDurableClient(new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.verifyListenerUpdates(1, 1);
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void verifyListenerUpdates(int numEntries) {
        this.verifyListenerUpdatesEntries(numEntries, 0);
    }

    public void verifyListenerUpdates(int numEntries, int numEntriesBeforeDisconnect) {
        this.verifyListenerUpdatesEntries(numEntries, 0);
    }

    public void verifyListenerUpdatesEntries(final int numEntries, final int numEntriesBeforeDisconnect) {
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(60000L, numEntries + numEntriesBeforeDisconnect);
                TestCase.assertEquals((int)(numEntries + numEntriesBeforeDisconnect), (int)listener.events.size());
            }
        });
    }

    public void verifyListenerUpdatesDisconnected(int numberOfEntries) {
    }

    public void testMultipleBridgeClientsInSingleDurableVM() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        String regionName1 = this.regionName + "1";
        String regionName2 = this.regionName + "2";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClients", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), regionName1, regionName2, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)2, (int)PoolManager.getAll().size());
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                String firstProxyRegionName = null;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                    TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
                    if (firstProxyRegionName == null) {
                        firstProxyRegionName = proxy.getHARegionName();
                        continue;
                    }
                    TestCase.assertTrue((!firstProxyRegionName.equals(proxy.getHARegionName()) ? 1 : 0) != 0);
                }
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void XtestMultipleVMsWithSameDurableId() {
        final int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Create another durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.this.getSystem(DurableClientDUnitTest.this.getClientDistributedSystemProperties(durableClientId));
                PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
                pf.init(DurableClientDUnitTest.this.getClientPool(DistributedTestCase.getServerHostName(DurableClientDUnitTest.this.publisherClientVM.getHost()), serverPort, true));
                try {
                    pf.create("uncreatablePool");
                    TestCase.fail((String)"Should not have been able to create the pool");
                }
                catch (ServerRefusedConnectionException e) {
                    DistributedTestCase.disconnectFromDS();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Should not have gotten here", e);
                }
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNull((Object)proxy);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testSimpleTwoDurableClients() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        VM durableClient2VM = this.publisherClientVM;
        final String durableClientId2 = this.getName() + "_client2";
        durableClient2VM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(durableClient2VM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId2)});
        durableClient2VM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                boolean durableClient1Found = false;
                boolean durableClient2Found = false;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    if (proxy.getDurableId().equals(durableClientId)) {
                        durableClient1Found = true;
                    }
                    if (proxy.getDurableId().equals(durableClientId2)) {
                        durableClient2Found = true;
                    }
                    TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
                }
                TestCase.assertTrue((boolean)durableClient1Found);
                TestCase.assertTrue((boolean)durableClient2Found);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        durableClient2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testReadyForEventsNotCalledImplicitly() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("check readyForEvents not called"){

            @Override
            public void run2() throws CacheException {
                for (Pool p : PoolManager.getAll().values()) {
                    TestCase.assertEquals((boolean)false, (boolean)((PoolImpl)p).getReadyForEventsCalled());
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                boolean durableClient1Found = false;
                boolean durableClient2Found = false;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    if (proxy.getDurableId().equals(durableClientId)) {
                        durableClient1Found = true;
                    }
                    TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
                }
                TestCase.assertTrue((boolean)durableClient1Found);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testReadyForEventsNotCalledImplicitlyWithCacheXML() {
        String cqName = "cqTest";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerFromXml", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-server-cache.xml")});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXml", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.FALSE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("check readyForEvents not called"){

            @Override
            public void run2() throws CacheException {
                for (Pool p : PoolManager.getAll().values()) {
                    TestCase.assertEquals((boolean)false, (boolean)((PoolImpl)p).getReadyForEventsCalled());
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register Cq"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CacheServerTestUtil.ControlCqListener()};
                cqAf.initCqListeners(cqListeners);
                CqAttributes cqa = cqAf.create();
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                try {
                    CqQuery query = queryService.newCq("cqTest", "Select * from /" + DurableClientDUnitTest.this.regionName, cqa, true);
                    query.execute();
                }
                catch (CqExistsException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (CqException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (RegionNotFoundException e) {
                    TestCase.fail((String)("Could not find specified region:" + DurableClientDUnitTest.this.regionName + ":" + (Object)((Object)e)));
                }
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("publish updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                CqQuery cqQuery = queryService.getCq("cqTest");
                CacheServerTestUtil.ControlCqListener cqlistener = (CacheServerTestUtil.ControlCqListener)cqQuery.getCqAttributes().getCqListener();
                cqlistener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)cqlistener.events.size());
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            DurableClientDUnitTest.fail((String)("interrupted" + e));
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish additional updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)(keyAndValue + "lkj"));
                }
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXml", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.FALSE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register cq"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CacheServerTestUtil.ControlCqListener()};
                cqAf.initCqListeners(cqListeners);
                CqAttributes cqa = cqAf.create();
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                try {
                    CqQuery query = queryService.newCq("cqTest", "Select * from /" + DurableClientDUnitTest.this.regionName, cqa, true);
                    query.execute();
                }
                catch (CqExistsException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (CqException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (RegionNotFoundException e) {
                    TestCase.fail((String)("Could not find specified region:" + DurableClientDUnitTest.this.regionName + ":" + (Object)((Object)e)));
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                CqQuery cqQuery = queryService.getCq("cqTest");
                CacheServerTestUtil.ControlCqListener cqlistener = (CacheServerTestUtil.ControlCqListener)cqQuery.getCqAttributes().getCqListener();
                cqlistener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)cqlistener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testReadyForEventsNotCalledImplicitlyForRegisterInterestWithCacheXML() {
        String cqName = "cqTest";
        this.regionName = "testReadyForEventsNotCalledImplicitlyWithCacheXML_region";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerFromXmlN", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-server-cache.xml")});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXmlN", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("check readyForEvents not called"){

            @Override
            public void run2() throws CacheException {
                for (Pool p : PoolManager.getAll().values()) {
                    TestCase.assertEquals((boolean)false, (boolean)((PoolImpl)p).getReadyForEventsCalled());
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register Interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES, true);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("publish updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            DurableClientDUnitTest.fail((String)("interrupted" + e));
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish additional updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)(keyAndValue + "lkj"));
                }
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXmlN", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES, true);
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testSimpleDurableClientMultipleServers() {
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int server1Port = ports[0];
        int mcastPort = ports[1];
        int server2Port = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        int durableClientTimeout = 60;
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                DurableClientDUnitTest.checkProxyIsAlive(proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.verifySimpleDurableClientMultipleServers();
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void verifySimpleDurableClientMultipleServers() {
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNull((Object)proxy);
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNull((Object)proxy);
            }
        });
    }

    public void testDurableClientConnectServerStopStart() {
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(serverPort)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testDurableNonHAFailover() throws InterruptedException {
        this.durableFailover(0);
        this.durableFailoverAfterReconnect(0);
    }

    public void testDurableHAFailover() throws InterruptedException {
        this.durableFailover(1);
        this.durableFailoverAfterReconnect(1);
    }

    public void durableFailover(int redundancyLevel) throws InterruptedException {
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int server1Port = ports[0];
        int mcastPort = ports[1];
        int server2Port = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        Pool clientPool = redundancyLevel == 1 ? this.getClientPool(DurableClientDUnitTest.getServerHostName(Host.getHost(0)), server1Port, server2Port, true) : this.getClientPool(DurableClientDUnitTest.getServerHostName(Host.getHost(0)), server1Port, server2Port, true, 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{clientPool, this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(server2Port)});
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), server1Port, server2Port, false), this.regionName});
        boolean numberOfEntries = true;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.verifyListenerUpdates(1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.disconnectDurableClient(true);
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.restartDurableClient(new Object[]{clientPool, this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries before failover"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 1; i < 2; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.verifyListenerUpdates(2, 1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.setPrimaryRecoveryCheck();
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                TestCase.assertNull((Object)region.getEntry((Object)"0"));
            }
        });
        this.checkPrimaryRecovery();
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries after failover"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 2; i < 3; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.verifyListenerUpdates(3, 1);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void durableFailoverAfterReconnect(int redundancyLevel) {
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int server1Port = ports[0];
        int mcastPort = ports[1];
        int server2Port = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        Pool clientPool = redundancyLevel == 1 ? this.getClientPool(DurableClientDUnitTest.getServerHostName(Host.getHost(0)), server1Port, server2Port, true) : this.getClientPool(DurableClientDUnitTest.getServerHostName(Host.getHost(0)), server1Port, server2Port, true, 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{clientPool, this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.publisherClientVM.getHost()), server1Port, server2Port, false), this.regionName});
        boolean numberOfEntries = true;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            DurableClientDUnitTest.fail((String)"interrupted");
        }
        this.verifyListenerUpdates(1);
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
            }
        });
        this.disconnectDurableClient(true);
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.restartDurableClient(new Object[]{clientPool, this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries before failover"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 1; i < 2; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        if (redundancyLevel == 1) {
            this.verifyListenerUpdates(2, 1);
        } else {
            this.verifyListenerUpdates(1, 1);
        }
        this.durableClientVM.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                TestCase.assertNull((Object)region.getEntry((Object)"0"));
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish entries after failover"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientDUnitTest.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 2; i < 3; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        if (redundancyLevel == 1) {
            this.verifyListenerUpdates(3, 1);
        } else {
            this.verifyListenerUpdates(2, 1);
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    protected CqQuery createCq(String cqName, String cqQuery, boolean durable) throws CqException, CqExistsException {
        QueryService qs = CacheServerTestUtil.getCache().getQueryService();
        CqAttributesFactory cqf = new CqAttributesFactory();
        CqListener[] cqListeners = new CqListener[]{new CacheServerTestUtil.ControlCqListener()};
        cqf.initCqListeners(cqListeners);
        CqAttributes cqa = cqf.create();
        return qs.newCq(cqName, cqQuery, cqa, durable);
    }

    protected Pool getClientPool(String host, int serverPort, boolean establishCallbackConnection) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, serverPort).setSubscriptionEnabled(establishCallbackConnection).setSubscriptionAckInterval(1);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    protected Pool getClientPool(String host, int server1Port, int server2Port, boolean establishCallbackConnection) {
        return this.getClientPool(host, server1Port, server2Port, establishCallbackConnection, 1);
    }

    protected Properties getClientDistributedSystemProperties(String durableClientId) {
        return this.getClientDistributedSystemProperties(durableClientId, 300);
    }

    protected Properties getClientDistributedSystemPropertiesNonDurable(String durableClientId) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        return properties;
    }

    protected Properties getClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    protected static CacheClientProxy getClientProxy() {
        CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
        CacheClientProxy proxy = null;
        Iterator i = notifier.getClientProxies().iterator();
        if (i.hasNext()) {
            proxy = (CacheClientProxy)i.next();
        }
        return proxy;
    }

    protected static void checkNumberOfClientProxies(final int expected) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return expected == DurableClientDUnitTest.getNumberOfClientProxies();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
    }

    protected static void checkProxyIsAlive(final CacheClientProxy proxy) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return proxy.isAlive();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 15000L, 200L, true);
    }

    protected static int getNumberOfClientProxies() {
        return DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier().getClientProxies().size();
    }

    protected static BridgeServerImpl getBridgeServer() {
        BridgeServerImpl bridgeServer = (BridgeServerImpl)CacheServerTestUtil.getCache().getBridgeServers().iterator().next();
        DurableClientDUnitTest.assertNotNull((Object)bridgeServer);
        return bridgeServer;
    }

    protected Pool getClientPool(String host, int server1Port, int server2Port, boolean establishCallbackConnection, int redundancyLevel) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, server1Port).addServer(host, server2Port).setSubscriptionEnabled(establishCallbackConnection).setSubscriptionRedundancy(redundancyLevel).setSubscriptionAckInterval(1);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    protected static String getHARegionQueueName() {
        DurableClientDUnitTest.checkNumberOfClientProxies(1);
        CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
        DurableClientDUnitTest.assertNotNull((Object)proxy);
        return proxy.getHARegionName();
    }

    public static void verifyReceivedMarkerAck(final CacheClientProxy proxy) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                GemFireCacheImpl.getInstance().getLoggerI18n().fine("DurableClientDUnitTest->WaitCriterion :: done called");
                return DurableClientDUnitTest.checkForAck(proxy);
            }

            @Override
            public String description() {
                return "never received marker ack";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 180000L, 200L, true);
    }

    protected static boolean checkForAck(CacheClientProxy proxy) {
        return HARegionQueue.isTestMarkerMessageRecieved();
    }

    protected static void setTestFlagToVerifyActForMarker(Boolean flag) {
        HARegionQueue.setUsedByTest((boolean)flag);
    }

    public static void setBridgeObeserverForAfterPrimaryRecovered() {
        isPrimaryRecovered = false;
        PoolImpl.AFTER_PRIMARY_RECOVERED_CALLBACK_FLAG = true;
        BridgeObserver bo = BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void afterPrimaryRecovered(ServerLocation location) {
                isPrimaryRecovered = true;
                PoolImpl.AFTER_PRIMARY_RECOVERED_CALLBACK_FLAG = false;
            }
        });
    }

    public void setPrimaryRecoveryCheck() {
        this.durableClientVM.invoke(new CacheSerializableRunnable("Set observer"){

            @Override
            public void run2() {
                DurableClientDUnitTest.setBridgeObeserverForAfterPrimaryRecovered();
            }
        });
    }

    public void checkPrimaryRecovery() {
        this.durableClientVM.invoke(new CacheSerializableRunnable("Check observer"){

            @Override
            public void run2() {
                DistributedTestCase.WaitCriterion waitForPrimaryRecovery = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return isPrimaryRecovered;
                    }

                    @Override
                    public String description() {
                        return "Did not detect primary recovery event during wait period";
                    }
                };
                DistributedTestCase.waitForCriterion(waitForPrimaryRecovery, 30000L, 1000L, true);
            }
        });
    }

    protected void sendClientReady(VM vm) {
        vm.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
    }

    protected void registerInterest(VM vm, final String regionName, final boolean durable) {
        vm.invoke(new CacheSerializableRunnable("Register interest on region : " + regionName){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, durable);
            }
        });
    }

    protected void createCq(VM vm, final String cqName, final String cqQuery, final boolean durable) {
        vm.invoke(new CacheSerializableRunnable("Register cq " + cqName){

            @Override
            public void run2() throws CacheException {
                try {
                    DurableClientDUnitTest.this.createCq(cqName, cqQuery, durable).execute();
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    protected void publishEntries(VM vm, final String regionName, final int numEntries) {
        vm.invoke(new CacheSerializableRunnable("publish " + numEntries + " entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < numEntries; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)new Portfolio(i));
                }
            }
        });
    }

    protected void flushEntries(VM server, VM client, final String regionName) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.registerInterest(client, regionName, false);
        server.invoke(new CacheSerializableRunnable("flush entries"){

            @Override
            public void run2() throws CacheException {
                CqService service = CqService.getRunningCqService();
                Region region = CacheServerTestUtil.getCache().getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                region.put((Object)"LAST", (Object)"ENTRY");
            }
        });
    }

    protected void checkCqStatOnServer(VM server, final String durableClientId, final String cqName, final int expectedNumber) {
        server.invoke(new CacheSerializableRunnable("Check ha queued cq stats for durable client " + durableClientId + " cq: " + cqName){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                CqService cqService = CqService.getCqService((Cache)CacheServerTestUtil.getCache());
                final CqQueryImpl cqQuery = (CqQueryImpl)cqService.getClientCqFromServer(proxyId, cqName);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return cqQuery.getVsdStats().getNumHAQueuedEvents() == (long)expectedNumber;
                    }

                    @Override
                    public String description() {
                        return "cq numHAQueuedEvents stat was expected to be " + expectedNumber + " but was instead " + cqQuery.getVsdStats().getNumHAQueuedEvents();
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertEquals((long)expectedNumber, (long)cqQuery.getVsdStats().getNumHAQueuedEvents());
            }
        });
    }

    protected void checkHAQueueSize(VM server, final String durableClientId, final int expectedNumber, final int remaining) {
        server.invoke(new CacheSerializableRunnable("Check ha queued size for durable client " + durableClientId){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                final CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return clientProxy.getQueueSizeStat() == expectedNumber || clientProxy.getQueueSizeStat() == remaining;
                    }

                    @Override
                    public String description() {
                        return "queue size stat was expected to be " + expectedNumber + " but was instead " + clientProxy.getQueueSizeStat();
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((clientProxy.getQueueSizeStat() == expectedNumber || clientProxy.getQueueSizeStat() == remaining ? 1 : 0) != 0);
            }
        });
    }

    protected void checkNumDurableCqs(VM server, final String durableClientId, final int expectedNumber) {
        server.invoke(new CacheSerializableRunnable("check number of durable cqs on server for durable client: " + durableClientId){

            @Override
            public void run2() throws CacheException {
                try {
                    CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                    CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                    ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                    CqService cqService = CqService.getCqService((Cache)CacheServerTestUtil.getCache());
                    List cqNames = cqService.getAllDurableClientCqs(proxyId);
                    TestCase.assertEquals((int)expectedNumber, (int)cqNames.size());
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    protected void checkCqListenerEvents(VM vm, final String cqName, final int numEvents, final int numEventsToWaitFor, final int secondsToWait) {
        vm.invoke(new CacheSerializableRunnable("Verify events for cq: " + cqName){

            @Override
            public void run2() throws CacheException {
                QueryService qs = CacheServerTestUtil.getCache().getQueryService();
                CqQuery cq = qs.getCq(cqName);
                CacheServerTestUtil.ControlCqListener listener = (CacheServerTestUtil.ControlCqListener)cq.getCqAttributes().getCqListener();
                listener.waitWhileNotEnoughEvents(secondsToWait * 1000, numEventsToWaitFor);
                TestCase.assertEquals((int)numEvents, (int)listener.events.size());
            }
        });
    }

    protected void checkInterestEvents(VM vm, final String regionName, final int numEvents) {
        vm.invoke(new CacheSerializableRunnable("Verify interest events"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(regionName);
                CacheServerTestUtil.ControlListener clistener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                clistener.waitWhileNotEnoughEvents(30000L, numEvents);
                TestCase.assertEquals((int)numEvents, (int)clistener.events.size());
            }
        });
    }

    protected void startDurableClient(VM vm, String durableClientId, int serverPort1, String regionName, int durableTimeoutInSeconds) {
        vm.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort1, true), regionName, this.getClientDistributedSystemProperties(durableClientId, durableTimeoutInSeconds), Boolean.TRUE});
    }

    protected void startDurableClient(VM vm, String durableClientId, int serverPort1, String regionName) {
        vm.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(this.durableClientVM.getHost()), serverPort1, true), regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
    }

    protected void startDurableClient(VM vm, String durableClientId, int serverPort1, int serverPort2, String regionName) {
        vm.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(vm.getHost()), serverPort1, serverPort2, true), regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
    }

    protected void startClient(VM vm, int serverPort1, String regionName) {
        vm.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(vm.getHost()), serverPort1, false), regionName});
    }

    protected void startClient(VM vm, int serverPort1, int serverPort2, String regionName) {
        vm.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientDUnitTest.getServerHostName(vm.getHost()), serverPort1, serverPort2, false), regionName});
    }

    protected void verifyDurableClientOnServer(VM server, final String durableClientId) {
        server.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
    }

    protected void checkPrimaryUpdater(VM vm) {
        vm.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return CacheServerTestUtil.getPool().isPrimaryUpdaterAlive();
                    }

                    @Override
                    public String description() {
                        return "No primary updater";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
                TestCase.assertTrue((boolean)CacheServerTestUtil.getPool().isPrimaryUpdaterAlive());
            }
        });
    }

    protected void closeCache(VM vm) {
        vm.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public class CqExceptionDueToActivatingClientTestHook
    implements CacheClientProxy.TestHook {
        CountDownLatch unblockDrain = new CountDownLatch(1);
        CountDownLatch unblockClient = new CountDownLatch(1);
        CountDownLatch finish = new CountDownLatch(1);

        public void doTestHook(String spot) {
            if (spot.equals("PRE_DRAIN_IN_PROGRESS")) {
                try {
                    this.unblockClient.countDown();
                    if (!this.unblockDrain.await(120L, TimeUnit.SECONDS)) {
                        throw new TestException("client never got far enough reconnected to unlatch lock.");
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            if (spot.equals("PRE_RELEASE_DRAIN_LOCK")) {
                this.unblockDrain.countDown();
                try {
                    if (!this.finish.await(30L, TimeUnit.SECONDS)) {
                        throw new TestException("Test did not complete, server never finished attempting to close cq");
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            if (spot.equals("DRAIN_COMPLETE")) {
                this.finish.countDown();
            }
        }
    }

    public class RejectClientReconnectTestHook
    implements CacheClientProxy.TestHook {
        CountDownLatch reconnectLatch = new CountDownLatch(1);
        CountDownLatch continueDrain = new CountDownLatch(1);
        boolean clientWasRejected = false;
        CountDownLatch clientConnected = new CountDownLatch(1);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void doTestHook(String spot) {
            System.out.println("JASON " + spot);
            try {
                if (spot.equals("CLIENT_PRE_RECONNECT")) {
                    if (this.reconnectLatch.await(60L, TimeUnit.SECONDS)) return;
                    throw new TestException("reonnect latch was never released.");
                }
                if (spot.equals("DRAIN_IN_PROGRESS_BEFORE_DRAIN_LOCK_CHECK")) {
                    this.reconnectLatch.countDown();
                    if (this.continueDrain.await(120L, TimeUnit.SECONDS)) return;
                    throw new TestException("Latch was never released.");
                }
                if (spot.equals("CLIENT_REJECTED_DUE_TO_CQ_BEING_DRAINED")) {
                    this.clientWasRejected = true;
                    this.continueDrain.countDown();
                    return;
                }
                if (!spot.equals("DRAIN_COMPLETE")) return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }

        public boolean wasClientRejected() {
            return this.clientWasRejected;
        }
    }
}

