/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;

public class ClientConflationDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    private static Cache cacheClient = null;
    private static Cache cacheFeeder = null;
    private static Cache cacheServer = null;
    private static int PORT;
    private static int poolNameCounter;
    private static final String REGION_NAME1 = "ClientConflationDUnitTest_region1";
    private static final String REGION_NAME2 = "ClientConflationDUnitTest_region2";
    static volatile int counterCreate1;
    static volatile int counterUpdate1;
    static volatile int counterCreate2;
    static volatile int counterUpdate2;

    public ClientConflationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        ClientConflationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        ClientConflationDUnitTest.setIsSlowStart();
        this.vm0.invoke(ClientConflationDUnitTest.class, "setIsSlowStart");
        PORT = (Integer)this.vm0.invoke(ClientConflationDUnitTest.class, "createServerCache");
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public static void setIsSlowStart() {
        CacheClientProxy.isSlowStartForTesting = true;
        System.setProperty("slowStartTimeForTesting", "15000");
    }

    public void testConflationDefault() {
        try {
            this.performSteps("server");
        }
        catch (Exception e) {
            ClientConflationDUnitTest.fail("testConflationDefault failed due to exception", e);
        }
    }

    public void testConflationOn() {
        try {
            this.performSteps("true");
        }
        catch (Exception e) {
            ClientConflationDUnitTest.fail("testConflationOn failed due to exception", e);
        }
    }

    public void testConflationOff() {
        try {
            this.performSteps("false");
        }
        catch (Exception e) {
            ClientConflationDUnitTest.fail("testConflationOff failed due to exception", e);
        }
    }

    private void performSteps(String conflation) throws Exception {
        ClientConflationDUnitTest.createClientCacheFeeder(ClientConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT));
        this.vm1.invoke(ClientConflationDUnitTest.class, "createClientCache", new Object[]{ClientConflationDUnitTest.getServerHostName(this.vm1.getHost()), new Integer(PORT), conflation});
        this.vm1.invoke(ClientConflationDUnitTest.class, "setBridgeObserverForBeforeInterestRecovery");
        this.vm1.invoke(ClientConflationDUnitTest.class, "setAllCountersZero");
        this.vm1.invoke(ClientConflationDUnitTest.class, "assertAllCountersZero");
        this.vm1.invoke(ClientConflationDUnitTest.class, "registerInterest");
        ClientConflationDUnitTest.putEntries();
        this.vm0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        Thread.sleep(20000L);
        this.vm0.invoke(ClientConflationDUnitTest.class, "assertAllQueuesEmpty");
        this.vm1.invoke(ClientConflationDUnitTest.class, "assertCounterSizes", new Object[]{conflation});
        this.vm1.invoke(ClientConflationDUnitTest.class, "assertValue");
    }

    private static Properties createProperties1(String conflation) {
        Properties props = new Properties();
        props.setProperty("delta-propagation", "false");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("conflate-events", conflation);
        return props;
    }

    private static void createPool2(String host, AttributesFactory factory, Integer port) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, port.intValue()).setSubscriptionEnabled(true).setThreadLocalConnections(true).setReadTimeout(10000).setSocketBufferSize(32768).setPingInterval(1000L).setMinConnections(3).setSubscriptionRedundancy(-1);
        Pool pool = pf.create("superpoolish" + poolNameCounter++);
        factory.setPoolName(pool.getName());
    }

    public static void createClientCache(String host, Integer port, String conflation) throws Exception {
        ClientConflationDUnitTest test = new ClientConflationDUnitTest("temp");
        cacheClient = test.createCache(ClientConflationDUnitTest.createProperties1(conflation));
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        ClientConflationDUnitTest.createPool2(host, factory, port);
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                Class<ClientConflationDUnitTest> clazz = ClientConflationDUnitTest.class;
                synchronized (ClientConflationDUnitTest.class) {
                    ++counterCreate1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    ++counterUpdate1;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cacheClient.createRegion(REGION_NAME1, attrs);
        ClientConflationDUnitTest.createPool2(host, factory, port);
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                Class<ClientConflationDUnitTest> clazz = ClientConflationDUnitTest.class;
                synchronized (ClientConflationDUnitTest.class) {
                    ++counterCreate2;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    ++counterUpdate2;
                }
            }
        });
        attrs = factory.create();
        cacheClient.createRegion(REGION_NAME2, attrs);
    }

    public static void createClientCacheFeeder(String host, Integer port) throws Exception {
        ClientConflationDUnitTest test = new ClientConflationDUnitTest("temp");
        cacheFeeder = test.createCache(ClientConflationDUnitTest.createProperties1("server"));
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        ClientConflationDUnitTest.createPool2(host, factory, port);
        RegionAttributes attrs = factory.create();
        cacheFeeder.createRegion(REGION_NAME1, attrs);
        attrs = factory.create();
        cacheFeeder.createRegion(REGION_NAME2, attrs);
    }

    public static void assertAllCountersZero() {
        ClientConflationDUnitTest.assertEquals((int)counterCreate1, (int)0);
        ClientConflationDUnitTest.assertEquals((int)counterUpdate1, (int)0);
        ClientConflationDUnitTest.assertEquals((int)counterCreate2, (int)0);
        ClientConflationDUnitTest.assertEquals((int)counterUpdate2, (int)0);
    }

    public static void setAllCountersZero() {
        counterCreate1 = 0;
        counterUpdate1 = 0;
        counterCreate2 = 0;
        counterUpdate2 = 0;
    }

    public static void setBridgeObserverForBeforeInterestRecovery() {
        PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void beforeInterestRecovery() {
                ClientConflationDUnitTest.setAllCountersZero();
            }
        });
    }

    public static void assertAllQueuesEmpty() {
        Iterator servers = cacheServer.getBridgeServers().iterator();
        while (servers.hasNext()) {
            Iterator proxies = ((BridgeServerImpl)servers.next()).getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
            while (proxies.hasNext()) {
                int qsize = ((CacheClientProxy)proxies.next()).getQueueSize();
                ClientConflationDUnitTest.assertTrue((String)("Queue size expected to be zero but is " + qsize), (qsize == 0 ? 1 : 0) != 0);
            }
        }
    }

    public static void assertCounterSizes(String conflation) {
        boolean create1 = true;
        int update1 = 1;
        boolean create2 = true;
        int update2 = 4;
        if (conflation.equals("true")) {
            update2 = 1;
        } else if (conflation.equals("false")) {
            update1 = 4;
        }
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterCreate1 == 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        final int u1 = update1;
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterUpdate1 == u1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterCreate2 == 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        final int u2 = update2;
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterUpdate2 == u2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    public static void assertValue() {
        try {
            Region r1 = cacheClient.getRegion("/ClientConflationDUnitTest_region1");
            Region r2 = cacheClient.getRegion("/ClientConflationDUnitTest_region2");
            ClientConflationDUnitTest.assertTrue((boolean)r1.containsKey((Object)"key-1"));
            ClientConflationDUnitTest.assertTrue((boolean)r1.get((Object)"key-1").equals("55"));
            ClientConflationDUnitTest.assertTrue((boolean)r2.containsKey((Object)"key-1"));
            ClientConflationDUnitTest.assertTrue((boolean)r2.get((Object)"key-1").equals("55"));
        }
        catch (Exception e) {
            ClientConflationDUnitTest.fail((String)("Exception in trying to get due to " + e));
        }
    }

    public static Integer createServerCache() throws Exception {
        Properties props = new Properties();
        props.setProperty("delta-propagation", "false");
        ClientConflationDUnitTest test = new ClientConflationDUnitTest("temp");
        cacheServer = test.createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        RegionAttributes attrs1 = factory.create();
        factory.setEnableConflation(false);
        RegionAttributes attrs2 = factory.create();
        cacheServer.createRegion(REGION_NAME1, attrs1);
        cacheServer.createRegion(REGION_NAME2, attrs2);
        BridgeServer server = cacheServer.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.setSocketBufferSize(32768);
        server.start();
        return new Integer(server.getPort());
    }

    public static void closeCacheClient() {
        if (cacheClient != null && !cacheClient.isClosed()) {
            cacheClient.close();
            cacheClient.getDistributedSystem().disconnect();
        }
    }

    public static void closeCacheFeeder() {
        if (cacheFeeder != null && !cacheFeeder.isClosed()) {
            cacheFeeder.close();
            cacheFeeder.getDistributedSystem().disconnect();
        }
    }

    public static void closeCacheServer() {
        if (cacheServer != null && !cacheServer.isClosed()) {
            cacheServer.close();
            cacheServer.getDistributedSystem().disconnect();
        }
    }

    public static void registerInterest() {
        try {
            Region region1 = cacheClient.getRegion("/ClientConflationDUnitTest_region1");
            Region region2 = cacheClient.getRegion("/ClientConflationDUnitTest_region2");
            ClientConflationDUnitTest.assertTrue((region1 != null ? 1 : 0) != 0);
            ClientConflationDUnitTest.assertTrue((region2 != null ? 1 : 0) != 0);
            region1.registerInterest((Object)"ALL_KEYS");
            region2.registerInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            ClientConflationDUnitTest.fail((String)("test failed due to " + (Object)((Object)e)));
        }
    }

    public static void unregisterInterest() {
        try {
            Region region1 = cacheClient.getRegion("/ClientConflationDUnitTest_region1");
            Region region2 = cacheClient.getRegion("/ClientConflationDUnitTest_region2");
            region1.unregisterInterest((Object)"ALL_KEYS");
            region2.unregisterInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            ClientConflationDUnitTest.fail((String)("test failed due to " + (Object)((Object)e)));
        }
    }

    public static void putEntries() {
        try {
            ClientConflationDUnitTest.getLogWriter().info("Putting entries...");
            Region r1 = cacheFeeder.getRegion("/ClientConflationDUnitTest_region1");
            Region r2 = cacheFeeder.getRegion("/ClientConflationDUnitTest_region2");
            r1.put((Object)"key-1", (Object)"11");
            r2.put((Object)"key-1", (Object)"11");
            r1.put((Object)"key-1", (Object)"22");
            r2.put((Object)"key-1", (Object)"22");
            r1.put((Object)"key-1", (Object)"33");
            r2.put((Object)"key-1", (Object)"33");
            r1.put((Object)"key-1", (Object)"44");
            r2.put((Object)"key-1", (Object)"44");
            r1.put((Object)"key-1", (Object)"55");
            r2.put((Object)"key-1", (Object)"55");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientConflationDUnitTest.fail("failed while region.put()", ex);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        ClientConflationDUnitTest.closeCacheFeeder();
        this.vm1.invoke(ClientConflationDUnitTest.class, "closeCacheClient");
        this.vm0.invoke(ClientConflationDUnitTest.class, "closeCacheServer");
    }

    static {
        poolNameCounter = 0;
        counterCreate1 = 0;
        counterUpdate1 = 0;
        counterCreate2 = 0;
        counterUpdate2 = 0;
    }
}

