/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;

public class ClearPropagationDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "ClearPropagationDUnitTest_region";
    protected static Cache cache;
    protected static boolean gotClear;
    protected static boolean gotDestroyed;

    public ClearPropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        ClearPropagationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        int PORT1 = (Integer)this.server1.invoke(ClearPropagationDUnitTest.class, "createServerCache");
        int PORT2 = (Integer)this.server2.invoke(ClearPropagationDUnitTest.class, "createServerCache");
        this.client1.invoke(ClearPropagationDUnitTest.class, "createClientCache", new Object[]{ClearPropagationDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
        this.client2.invoke(ClearPropagationDUnitTest.class, "createClientCache", new Object[]{ClearPropagationDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
        CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        ClearPropagationDUnitTest.assertNotNull((Object)cache);
    }

    public void testVerifyClearNotReceivedBySenderReceivedByOthers() {
        CacheSerializableRunnable resetFlags = new CacheSerializableRunnable("resetFlags"){

            @Override
            public void run2() throws CacheException {
                gotClear = false;
                gotDestroyed = false;
            }
        };
        this.server1.invoke(resetFlags);
        this.server2.invoke(resetFlags);
        this.client1.invoke(resetFlags);
        this.client2.invoke(resetFlags);
        this.client1.invoke(ClearPropagationDUnitTest.class, "createEntriesK1andK2");
        this.client2.invoke(ClearPropagationDUnitTest.class, "createEntriesK1andK2");
        this.client1.invoke(ClearPropagationDUnitTest.class, "registerKeysK1andK2");
        this.client2.invoke(ClearPropagationDUnitTest.class, "registerKeysK1andK2");
        this.server1.invoke(this.checkSizeRegion(2, false));
        this.server2.invoke(this.checkSizeRegion(2, false));
        this.client1.invoke(this.checkSizeRegion(2, false));
        this.client2.invoke(this.checkSizeRegion(2, false));
        this.client1.invoke(ClearPropagationDUnitTest.class, "acquireConnectionsAndClear", new Object[]{ClearPropagationDUnitTest.getServerHostName(this.client1.getHost())});
        this.client1.invoke(this.checkSizeRegion(2, false));
        this.client2.invoke(this.checkSizeRegion(0, true));
        this.server1.invoke(this.checkSizeRegion(0, false));
        this.server2.invoke(this.checkSizeRegion(0, false));
        this.client1.invoke(ClearPropagationDUnitTest.class, "verifyNoUpdates");
    }

    public void testEventIdGeneratedInDestroyRegionOperation() throws Exception {
        CacheSerializableRunnable resetFlags = new CacheSerializableRunnable("resetFlags"){

            @Override
            public void run2() throws CacheException {
                gotClear = false;
                gotDestroyed = false;
            }
        };
        this.server1.invoke(resetFlags);
        this.server2.invoke(resetFlags);
        this.client1.invoke(resetFlags);
        this.client2.invoke(resetFlags);
        this.client1.invoke(ClearPropagationDUnitTest.class, "createEntriesK1andK2");
        this.client2.invoke(ClearPropagationDUnitTest.class, "createEntriesK1andK2");
        this.client1.invoke(ClearPropagationDUnitTest.class, "registerKeysK1andK2");
        this.client2.invoke(ClearPropagationDUnitTest.class, "registerKeysK1andK2");
        this.server1.invoke(this.checkSizeRegion(2, false));
        this.server2.invoke(this.checkSizeRegion(2, false));
        this.client1.invoke(this.checkSizeRegion(2, false));
        this.client2.invoke(this.checkSizeRegion(2, false));
        this.client1.invoke(ClearPropagationDUnitTest.class, "acquireConnectionsAndDestroyRegion", new Object[]{ClearPropagationDUnitTest.getServerHostName(this.client1.getHost())});
        this.client1.invoke(this.checkSizeRegion(2, false));
        this.client2.invoke(this.checkDestroyRegion(true));
        this.server1.invoke(this.checkDestroyRegion(false));
        this.server2.invoke(this.checkDestroyRegion(false));
        this.client1.invoke(ClearPropagationDUnitTest.class, "verifyNoUpdates");
    }

    private CacheSerializableRunnable checkDestroyRegion(final boolean toBlock) {
        CacheSerializableRunnable checkRegion = new CacheSerializableRunnable("checkDestroyRegion"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run2() throws CacheException {
                if (toBlock) {
                    Class<ClearPropagationDUnitTest> clazz = ClearPropagationDUnitTest.class;
                    // MONITORENTER : com.gemstone.gemfire.internal.cache.tier.sockets.ClearPropagationDUnitTest.class
                    if (!gotDestroyed) {
                        try {
                            ClearPropagationDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            throw new CacheException(e){};
                        }
                    }
                    // MONITOREXIT : clazz
                }
                Region region = cache.getRegion("/ClearPropagationDUnitTest_region");
                TestCase.assertNull((Object)region);
            }
        };
        return checkRegion;
    }

    private CacheSerializableRunnable checkSizeRegion(final int size, final boolean toBlock) {
        CacheSerializableRunnable clearRegion = new CacheSerializableRunnable("checkSize"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/ClearPropagationDUnitTest_region");
                TestCase.assertNotNull((Object)region);
                Log.getLogWriter().info("Size of the region " + region.size());
                if (toBlock) {
                    Class<ClearPropagationDUnitTest> clazz = ClearPropagationDUnitTest.class;
                    // MONITORENTER : com.gemstone.gemfire.internal.cache.tier.sockets.ClearPropagationDUnitTest.class
                    if (!gotClear) {
                        try {
                            ClearPropagationDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            throw new CacheException(e){};
                        }
                    }
                    // MONITOREXIT : clazz
                }
                TestCase.assertEquals((int)size, (int)region.size());
            }
        };
        return clearRegion;
    }

    public static void acquireConnectionsAndClear(String host) {
        try {
            Region r1 = cache.getRegion("/ClearPropagationDUnitTest_region");
            ClearPropagationDUnitTest.assertNotNull((Object)r1);
            String poolName = r1.getAttributes().getPoolName();
            ClearPropagationDUnitTest.assertNotNull((Object)poolName);
            PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
            ClearPropagationDUnitTest.assertNotNull((Object)pool);
            Connection conn1 = pool.acquireConnection(new ServerLocation(host, PORT2));
            ClearPropagationDUnitTest.assertNotNull((Object)conn1);
            ClearPropagationDUnitTest.assertEquals((int)PORT2, (int)conn1.getServer().getPort());
            ServerRegionProxy srp = new ServerRegionProxy("/ClearPropagationDUnitTest_region", pool);
            srp.clearOnForTestsOnly(conn1, new EventID(new byte[]{1}, 1L, 1L), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClearPropagationDUnitTest.fail((String)("while setting acquireConnections  " + ex));
        }
    }

    public static void acquireConnectionsAndDestroyRegion(String host) {
        try {
            Region r1 = cache.getRegion("/ClearPropagationDUnitTest_region");
            ClearPropagationDUnitTest.assertNotNull((Object)r1);
            String poolName = r1.getAttributes().getPoolName();
            ClearPropagationDUnitTest.assertNotNull((Object)poolName);
            PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
            ClearPropagationDUnitTest.assertNotNull((Object)pool);
            Connection conn1 = pool.acquireConnection(new ServerLocation(host, PORT2));
            ClearPropagationDUnitTest.assertNotNull((Object)conn1);
            ClearPropagationDUnitTest.assertEquals((int)PORT2, (int)conn1.getServer().getPort());
            ServerRegionProxy srp = new ServerRegionProxy("/ClearPropagationDUnitTest_region", pool);
            srp.destroyRegionOnForTestsOnly(conn1, new EventID(new byte[]{1}, 1L, 1L), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClearPropagationDUnitTest.fail((String)("while setting acquireConnections  " + ex));
        }
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/ClearPropagationDUnitTest_region");
            ClearPropagationDUnitTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)"key1")) {
                r1.create((Object)"key1", (Object)"key-1");
            }
            if (!r1.containsKey((Object)"key2")) {
                r1.create((Object)"key2", (Object)"key-2");
            }
            ClearPropagationDUnitTest.assertEquals((Object)r1.getEntry((Object)"key1").getValue(), (Object)"key-1");
            ClearPropagationDUnitTest.assertEquals((Object)r1.getEntry((Object)"key2").getValue(), (Object)"key-2");
        }
        catch (Exception ex) {
            ClearPropagationDUnitTest.fail("failed while createEntriesK1andK2()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Pool p;
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new ClearPropagationDUnitTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(4).create("ClearPropagationDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRegionClear(RegionEvent re) {
                Class<ClearPropagationDUnitTest> clazz = ClearPropagationDUnitTest.class;
                synchronized (ClearPropagationDUnitTest.class) {
                    gotClear = true;
                    ClearPropagationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRegionDestroy(RegionEvent re) {
                Class<ClearPropagationDUnitTest> clazz = ClearPropagationDUnitTest.class;
                synchronized (ClearPropagationDUnitTest.class) {
                    gotDestroyed = true;
                    ClearPropagationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        new ClearPropagationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        ClearPropagationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void registerKeysK1andK2() {
        try {
            Region r = cache.getRegion("/ClearPropagationDUnitTest_region");
            ClearPropagationDUnitTest.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add("key1");
            list.add("key2");
            r.registerInterest(list);
        }
        catch (Exception ex) {
            ClearPropagationDUnitTest.fail("failed while registering interest", ex);
        }
    }

    public static void verifyNoUpdates() {
        try {
            Region r = cache.getRegion("/ClearPropagationDUnitTest_region");
            ClearPropagationDUnitTest.assertNotNull((Object)r);
            ClearPropagationDUnitTest.assertEquals((Object)"key-1", (Object)r.getEntry((Object)"key1").getValue());
            ClearPropagationDUnitTest.assertEquals((Object)"key-2", (Object)r.getEntry((Object)"key2").getValue());
        }
        catch (Exception ex) {
            ClearPropagationDUnitTest.fail("failed while verifyNoUpdates()", ex);
        }
    }

    public static void verifyUpdates() {
        try {
            Region r = cache.getRegion("/ClearPropagationDUnitTest_region");
            ClearPropagationDUnitTest.assertNotNull((Object)r);
            ClearPropagationDUnitTest.assertNull((Object)r.getEntry((Object)"key2").getValue());
            ClearPropagationDUnitTest.assertNull((Object)r.getEntry((Object)"key1").getValue());
        }
        catch (Exception ex) {
            ClearPropagationDUnitTest.fail("failed while region", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.client1.invoke(ClearPropagationDUnitTest.class, "closeCache");
        this.client2.invoke(ClearPropagationDUnitTest.class, "closeCache");
        this.server1.invoke(ClearPropagationDUnitTest.class, "closeCache");
        this.server2.invoke(ClearPropagationDUnitTest.class, "closeCache");
    }

    static {
        cache = null;
        gotClear = false;
        gotDestroyed = false;
    }
}

