/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Bug37210DUnitTest
extends DistributedTestCase {
    VM server = null;
    VM client = null;
    private static Cache cache = null;
    private static int PORT;
    private static final String REGION_NAME = "Bug37210DUnitTest_Region";

    public Bug37210DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server = host.getVM(0);
        this.client = host.getVM(2);
        PORT = (Integer)this.server.invoke(Bug37210DUnitTest.class, "createServerCache");
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client.invoke(Bug37210DUnitTest.class, "closeCache");
        this.server.invoke(Bug37210DUnitTest.class, "closeCache");
    }

    public void testHAStatsCleanup() throws Exception {
        Log.getLogWriter().info("testHAStatsCleanup : BEGIN");
        this.client.invoke(Bug37210DUnitTest.class, "createClientCache", new Object[]{Bug37210DUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
        this.server.invoke(Bug37210DUnitTest.class, "doEntryOperations");
        this.server.invoke(Bug37210DUnitTest.class, "closeCacheClientProxyAndVerifyStats");
        Log.getLogWriter().info("testHAStatsCleanup : END");
    }

    public static Integer createServerCache() throws Exception {
        Bug37210DUnitTest test = new Bug37210DUnitTest("temp");
        Properties props = new Properties();
        cache = test.createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(false);
        server.setSocketBufferSize(32768);
        server.setMaximumTimeBetweenPings(1000000);
        server.start();
        Log.getLogWriter().info("Server started at PORT = " + port);
        return new Integer(server.getPort());
    }

    public static void createClientCache(String host, Integer port) throws Exception {
        Bug37210DUnitTest test = new Bug37210DUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        cache = test.createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port.intValue()).setSubscriptionEnabled(true).setThreadLocalConnections(true).setReadTimeout(10000).setSocketBufferSize(32768).setMinConnections(3).setSubscriptionRedundancy(-1).create("Bug37210UnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS");
    }

    public static void closeCacheClientProxyAndVerifyStats() {
        Bug37210DUnitTest.assertEquals((String)"More than one BridgeServers found ", (int)1, (int)cache.getBridgeServers().size());
        BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
        Bug37210DUnitTest.assertNotNull((Object)bs);
        Bug37210DUnitTest.assertNotNull((Object)bs.getAcceptor());
        Bug37210DUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
        Iterator proxies = bs.getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
        Bug37210DUnitTest.assertTrue((String)"No proxy found", (boolean)proxies.hasNext());
        CacheClientProxy proxy = (CacheClientProxy)proxies.next();
        proxy.close();
        HARegionQueue rq = proxy.getHARegionQueue();
        Map dispatchedMsgMap = HARegionQueue.getDispatchedMessagesMapForTesting();
        Bug37210DUnitTest.assertTrue((String)"HARegionQueue stats were not closed on proxy.close()", (boolean)rq.getStatistics().isClosed());
        Bug37210DUnitTest.assertFalse((String)"HARegionQueue.dispatchedMessagesMap contains entry for the region even after proxy.close()", (boolean)dispatchedMsgMap.containsKey(rq.getRegion().getName()));
    }

    public static void doEntryOperations() throws Exception {
        Region r1 = cache.getRegion("/Bug37210DUnitTest_Region");
        String keyPrefix = "server-";
        for (int i = 0; i < 10; ++i) {
            r1.put((Object)(keyPrefix + i), (Object)(keyPrefix + "val-" + i));
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }
}

