/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;

public class Bug36457DUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static VM client1 = null;
    private static VM client2 = null;
    static boolean isFaileoverHappened = false;
    private static final String regionName = "Bug36457DUnitTest_Region";

    public Bug36457DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Bug36457DUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug36457DUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new Bug36457DUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).setSubscriptionEnabled(true).setMinConnections(4).create("Bug36457DUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region r = cache.createRegion(regionName, attrs);
        ArrayList<String> listOfKeys = new ArrayList<String>();
        listOfKeys.add("key-1");
        listOfKeys.add("key-2");
        listOfKeys.add("key-3");
        listOfKeys.add("key-4");
        listOfKeys.add("key-5");
        r.registerInterest(listOfKeys);
    }

    public static Integer createServerCache() throws Exception {
        new Bug36457DUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(Bug36457DUnitTest.class, "closeCache");
        client2.invoke(Bug36457DUnitTest.class, "closeCache");
        server1.invoke(Bug36457DUnitTest.class, "closeCache");
        server2.invoke(Bug36457DUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testBug36457() {
        Integer port1 = (Integer)server1.invoke(Bug36457DUnitTest.class, "createServerCache");
        Integer port2 = (Integer)server2.invoke(Bug36457DUnitTest.class, "createServerCache");
        client1.invoke(Bug36457DUnitTest.class, "createClientCache", new Object[]{Bug36457DUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client2.invoke(Bug36457DUnitTest.class, "createClientCache", new Object[]{Bug36457DUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client2.invoke(Bug36457DUnitTest.class, "setBridgeObserver");
        client1.invoke(Bug36457DUnitTest.class, "destroyRegion");
        isFaileoverHappened = (Boolean)client2.invoke(Bug36457DUnitTest.class, "isFaileoverHappened");
        if (isFaileoverHappened) {
            Bug36457DUnitTest.fail((String)"Test failed because of unregistration failed due to region  is destroyed on server");
        }
    }

    public static Boolean isFaileoverHappened() {
        return new Boolean(isFaileoverHappened);
    }

    public static void setBridgeObserver() {
        PoolImpl.AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void afterPrimaryIdentificationFromBackup(ServerLocation primaryEndpoint) {
                DistributedTestCase.getLogWriter().fine("TEST FAILED HERE YOGI ");
                isFaileoverHappened = true;
            }
        });
    }

    public static void unSetBridgeObserver() {
        PoolImpl.AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
    }

    public static void destroyRegion() {
        try {
            Region r = cache.getRegion("/Bug36457DUnitTest_Region");
            Bug36457DUnitTest.assertNotNull((Object)r);
            r.destroyRegion();
        }
        catch (Exception ex) {
            Bug36457DUnitTest.fail("failed while destroy region ", ex);
        }
    }
}

