/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.persistence.ConflictingPersistentDataException;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.cache.persistence.PersistentReplicatesOfflineException;
import com.gemstone.gemfire.cache.persistence.RevokedPersistentDataException;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.AbstractUpdateOperation;
import com.gemstone.gemfire.internal.cache.DestroyRegionOperation;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NoDataStoreAvailableException;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.persistence.PersistenceAdvisor;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistentReplicatedTestBase;
import com.gemstone.gemfire.internal.cache.persistence.PrepareNewPersistentMemberMessage;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class PersistentRecoveryOrderDUnitTest
extends PersistentReplicatedTestBase {
    private static final AtomicBoolean sawRequestImageMessage = new AtomicBoolean(false);

    public PersistentRecoveryOrderDUnitTest(String name) {
        super(name);
    }

    public static void resetAckWaitThreshold() {
        if (SAVED_ACK_WAIT_THRESHOLD != null) {
            System.setProperty("gemfire.ack_wait_threshold", SAVED_ACK_WAIT_THRESHOLD);
        }
    }

    public void testWaitForLatestMember() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeRegion(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation future = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future.isAlive());
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        future.join(60000L);
        if (future.isAlive()) {
            PersistentRecoveryOrderDUnitTest.fail((String)"Region not created within 60000");
        }
        if (future.exceptionOccurred()) {
            throw new Exception(future.getException());
        }
        this.checkForEntry(vm0);
        this.checkForEntry(vm1);
        this.checkForRecoveryStat(vm1, true);
        this.checkForRecoveryStat(vm0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRevokeAMember() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        vm0.invoke(new SerializableRunnable("Check for waiting regions"){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)PersistentRecoveryOrderDUnitTest.this.getCache();
                PersistentMemberManager mm = cache.getPersistentMemberManager();
                Map waitingRegions = mm.getWaitingRegions();
                TestCase.assertEquals((int)0, (int)waitingRegions.size());
            }
        });
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeCache(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation future = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future.isAlive());
        vm2.invoke(new SerializableRunnable("Revoke the member"){

            @Override
            public void run() {
                PersistentRecoveryOrderDUnitTest.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentRecoveryOrderDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Set missingIds = adminDS.getMissingPersistentMembers();
                    DistributedTestCase.getLogWriter().info("waiting members=" + missingIds);
                    TestCase.assertEquals((int)1, (int)missingIds.size());
                    PersistentID missingMember = (PersistentID)missingIds.iterator().next();
                    adminDS.revokePersistentMember(missingMember.getUUID());
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
        future.join(60000L);
        if (future.isAlive()) {
            PersistentRecoveryOrderDUnitTest.fail((String)"Region not created within60000");
        }
        if (future.exceptionOccurred()) {
            throw new Exception(future.getException());
        }
        this.checkForRecoveryStat(vm0, true);
        SerializableRunnable checkForEntry = new SerializableRunnable("check for the entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                TestCase.assertEquals((Object)"B", (Object)region.get((Object)"A"));
            }
        };
        vm0.invoke(checkForEntry);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        DistributedTestCase.ExpectedException e = PersistentRecoveryOrderDUnitTest.addExpectedException(RevokedPersistentDataException.class.getSimpleName(), vm1);
        try {
            this.createPersistentRegion(vm1);
            PersistentRecoveryOrderDUnitTest.fail((String)"We should have received a split distributed system exception");
        }
        catch (RuntimeException expected) {
            if (!(expected.getCause() instanceof RevokedPersistentDataException)) {
                throw expected;
            }
        }
        finally {
            e.remove();
        }
        this.closeCache(vm1);
        this.closeCache(vm0);
        this.createPersistentRegion(vm0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRevokeAHostBeforeInitialization() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        vm0.invoke(new SerializableRunnable("Check for waiting regions"){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)PersistentRecoveryOrderDUnitTest.this.getCache();
                PersistentMemberManager mm = cache.getPersistentMemberManager();
                Map waitingRegions = mm.getWaitingRegions();
                TestCase.assertEquals((int)0, (int)waitingRegions.size());
            }
        });
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeRegion(vm1);
        final File dirToRevoke = this.getDiskDirForVM(vm1);
        vm2.invoke(new SerializableRunnable("Revoke the member"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PersistentRecoveryOrderDUnitTest.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentRecoveryOrderDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    adminDS.revokePersistentMember(SocketCreator.getLocalHost(), dirToRevoke.getCanonicalPath());
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Unexpected exception", e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        this.checkForRecoveryStat(vm0, true);
        SerializableRunnable checkForEntry = new SerializableRunnable("check for the entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                TestCase.assertEquals((Object)"B", (Object)region.get((Object)"A"));
            }
        };
        vm0.invoke(checkForEntry);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        DistributedTestCase.ExpectedException e = PersistentRecoveryOrderDUnitTest.addExpectedException(RevokedPersistentDataException.class.getSimpleName(), vm1);
        try {
            this.createPersistentRegion(vm1);
            PersistentRecoveryOrderDUnitTest.fail((String)"We should have received a split distributed system exception");
        }
        catch (RuntimeException expected) {
            if (!(expected.getCause() instanceof RevokedPersistentDataException)) {
                throw expected;
            }
        }
        finally {
            e.remove();
        }
    }

    public void testWaitingMemberList() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.createPersistentRegion(vm2);
        this.putAnEntry(vm0);
        vm0.invoke(new SerializableRunnable("Check for waiting regions"){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)PersistentRecoveryOrderDUnitTest.this.getCache();
                PersistentMemberManager mm = cache.getPersistentMemberManager();
                Map waitingRegions = mm.getWaitingRegions();
                TestCase.assertEquals((int)0, (int)waitingRegions.size());
            }
        });
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeRegion(vm1);
        this.updateTheEntry(vm2, "D");
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm2");
        this.closeRegion(vm2);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation future0 = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future0.isAlive());
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        final AsyncInvocation future1 = this.createPersistentRegionAsync(vm1);
        this.waitForBlockedInitialization(vm1);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future1.isAlive());
        vm3.invoke(new SerializableRunnable("check waiting members"){

            @Override
            public void run() {
                PersistentRecoveryOrderDUnitTest.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentRecoveryOrderDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Set missingIds = adminDS.getMissingPersistentMembers();
                    DistributedTestCase.getLogWriter().info("waiting members=" + missingIds);
                    TestCase.assertEquals((int)1, (int)missingIds.size());
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("close cache"){

            @Override
            public void run() {
                PersistentRecoveryOrderDUnitTest.this.getCache().close();
            }
        });
        PersistentRecoveryOrderDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !future1.isAlive();
            }

            @Override
            public String description() {
                return "Waiting for blocked initialization to terminate because the cache was closed.";
            }
        }, 30000L, 500L, true);
        vm3.invoke(new SerializableRunnable("check waiting members again"){

            @Override
            public void run() {
                PersistentRecoveryOrderDUnitTest.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentRecoveryOrderDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    final AdminDistributedSystem connectedDS = adminDS;
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public String description() {
                            return "Waiting for waiting members to have 2 members";
                        }

                        @Override
                        public boolean done() {
                            Set missingIds;
                            try {
                                missingIds = connectedDS.getMissingPersistentMembers();
                            }
                            catch (AdminException e) {
                                throw new RuntimeException(e);
                            }
                            return 2 == missingIds.size();
                        }
                    }, 60000L, 500L, true);
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    public void testDontWaitForOldMember() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        this.closeRegion(vm1);
        this.createPersistentRegion(vm1);
        this.checkForEntry(vm1);
        this.checkForRecoveryStat(vm1, true);
    }

    public void testSimultaneousCrash() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        this.updateTheEntry(vm1);
        this.backupDir(vm0);
        this.backupDir(vm1);
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.restoreBackup(vm0);
        this.restoreBackup(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation future = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future.isAlive());
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        future.join(60000L);
        if (future.isAlive()) {
            PersistentRecoveryOrderDUnitTest.fail((String)"Region not created within60000");
        }
        if (future.exceptionOccurred()) {
            throw new Exception(future.getException());
        }
        this.checkForEntry(vm0);
        this.checkForEntry(vm1);
    }

    public void testTransmitCrashedMembers() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        this.closeRegion(vm0);
        this.createPersistentRegion(vm2);
        this.updateTheEntry(vm1);
        this.closeRegion(vm1);
        this.closeRegion(vm2);
        AsyncInvocation future = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future.isAlive());
        this.createPersistentRegion(vm2);
        future.getResult(60000L);
        this.checkForEntry(vm0);
        this.checkForEntry(vm2);
    }

    public void testRecoverFromNonPeristentRegion() throws Throwable {
        VM vm1;
        VM vm0;
        block2: {
            Host host = Host.getHost(0);
            vm0 = host.getVM(0);
            vm1 = host.getVM(1);
            this.createPersistentRegion(vm0);
            this.createNonPersistentRegion(vm1);
            this.putAnEntry(vm0);
            this.closeRegion(vm0);
            try {
                this.updateTheEntry(vm1);
                PersistentRecoveryOrderDUnitTest.fail((String)"expected PersistentReplicatesOfflineException not thrown");
            }
            catch (Exception expected) {
                if (expected.getCause() instanceof PersistentReplicatesOfflineException) break block2;
                throw expected;
            }
        }
        this.createPersistentRegion(vm0);
        this.checkForRecoveryStat(vm0, true);
        this.updateTheEntry(vm1);
        this.checkForEntry(vm0);
        this.checkForEntry(vm1);
    }

    HashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>> getAllMemberToVersion(RegionVersionVector rvv) {
        HashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>> allMemberToVersion = new HashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>>(rvv.getMemberToVersion());
        RegionVersionHolder localHolder = rvv.getLocalExceptions().clone();
        localHolder.setVersion(rvv.getCurrentVersion());
        allMemberToVersion.put((DiskStoreID)rvv.getOwnerId(), localHolder);
        return allMemberToVersion;
    }

    protected Object getEntry(VM vm, final String key) {
        SerializableCallable getEntry = new SerializableCallable("get entry"){

            public Object call() throws Exception {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                return region.get((Object)key);
            }
        };
        return vm.invoke(getEntry);
    }

    protected RegionVersionVector getRVV(VM vm) throws IOException, ClassNotFoundException {
        SerializableCallable createData = new SerializableCallable("getRVV"){

            public Object call() throws Exception {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                RegionVersionVector rvv = region.getVersionVector();
                rvv = rvv.getCloneForTransmission();
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)rvv, (DataOutput)hdos);
                return hdos.toByteArray();
            }
        };
        byte[] result = (byte[])vm.invoke(createData);
        ByteArrayInputStream bais = new ByteArrayInputStream(result);
        return (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
    }

    protected AsyncInvocation createPersistentRegionAsync(final VM vm, final boolean diskSynchronous) {
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File dir = PersistentRecoveryOrderDUnitTest.this.getDiskDirForVM(vm);
                dir.mkdirs();
                dsf.setDiskDirs(new File[]{dir});
                dsf.setMaxOplogSize(1L);
                DiskStore ds = dsf.create(PersistentReplicatedTestBase.REGION_NAME);
                RegionFactory rf = new RegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDiskSynchronous(diskSynchronous);
                rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(PersistentReplicatedTestBase.REGION_NAME);
            }
        };
        return vm.invokeAsync(createRegion);
    }

    public void testPersistConflictOperations() throws Throwable {
        this.doTestPersistConflictOperations(true);
    }

    public void testPersistConflictOperationsAsync() throws Throwable {
        this.doTestPersistConflictOperations(false);
    }

    public void doTestPersistConflictOperations(boolean diskSync) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable addObserver = new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof AbstractUpdateOperation.AbstractUpdateMessage) {
                            try {
                                Thread.sleep(2000L);
                                PersistentRecoveryOrderDUnitTest.this.getCache().getLogger().info("testPersistConflictOperations, beforeSendMessage");
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof AbstractUpdateOperation.AbstractUpdateMessage) {
                            PersistentRecoveryOrderDUnitTest.this.getCache().getLogger().info("testPersistConflictOperations, beforeSendMessage");
                            DistributionMessageObserver.setInstance(null);
                        }
                    }
                });
            }
        };
        vm0.invoke(addObserver);
        vm1.invoke(addObserver);
        AsyncInvocation future0 = this.createPersistentRegionAsync(vm0, diskSync);
        AsyncInvocation future1 = this.createPersistentRegionAsync(vm1, diskSync);
        future0.join(60000L);
        future1.join(60000L);
        AsyncInvocation ins0 = vm0.invokeAsync(new SerializableRunnable("change the entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.put((Object)"A", (Object)"vm0");
            }
        });
        AsyncInvocation ins1 = vm1.invokeAsync(new SerializableRunnable("change the entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.put((Object)"A", (Object)"vm1");
            }
        });
        ins0.join(60000L);
        ins1.join(60000L);
        RegionVersionVector rvv0 = this.getRVV(vm0);
        RegionVersionVector rvv1 = this.getRVV(vm1);
        this.assertSameRVV(rvv1, rvv0);
        Object value0 = this.getEntry(vm0, "A");
        Object value1 = this.getEntry(vm1, "A");
        PersistentRecoveryOrderDUnitTest.assertEquals((Object)value0, (Object)value1);
        this.closeRegion(vm0);
        this.closeRegion(vm1);
        future1 = this.createPersistentRegionAsync(vm1, diskSync);
        future0 = this.createPersistentRegionAsync(vm0, diskSync);
        future1.join(60000L);
        future0.join(60000L);
        value0 = this.getEntry(vm0, "A");
        value1 = this.getEntry(vm1, "A");
        PersistentRecoveryOrderDUnitTest.assertEquals((Object)value0, (Object)value1);
        rvv0 = this.getRVV(vm0);
        rvv1 = this.getRVV(vm1);
        this.assertSameRVV(rvv1, rvv0);
        vm0.invoke(addObserver);
        vm1.invoke(addObserver);
        ins0 = vm0.invokeAsync(new SerializableRunnable("change the entry at vm0"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)"A", (Object)("vm0-" + i));
                }
            }
        });
        ins1 = vm1.invokeAsync(new SerializableRunnable("change the entry at vm1"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)"A", (Object)("vm1-" + i));
                }
            }
        });
        ins0.join(60000L);
        ins1.join(60000L);
        rvv0 = this.getRVV(vm0);
        rvv1 = this.getRVV(vm1);
        this.assertSameRVV(rvv1, rvv0);
        value0 = this.getEntry(vm0, "A");
        value1 = this.getEntry(vm1, "A");
        PersistentRecoveryOrderDUnitTest.assertEquals((Object)value0, (Object)value1);
        this.closeCache(vm0);
        this.closeCache(vm1);
        future1 = this.createPersistentRegionAsync(vm1, diskSync);
        future0 = this.createPersistentRegionAsync(vm0, diskSync);
        future1.join(60000L);
        future0.join(60000L);
        value0 = this.getEntry(vm0, "A");
        value1 = this.getEntry(vm1, "A");
        PersistentRecoveryOrderDUnitTest.assertEquals((Object)value0, (Object)value1);
        rvv0 = this.getRVV(vm0);
        rvv1 = this.getRVV(vm1);
        this.assertSameRVV(rvv1, rvv0);
    }

    private void assertSameRVV(RegionVersionVector rvv1, RegionVersionVector rvv2) {
        if (!rvv1.sameAs(rvv2)) {
            PersistentRecoveryOrderDUnitTest.fail((String)("Expected " + rvv1 + " but was " + rvv2));
        }
    }

    public void testTransmitCrashedMembersWithNonPeristentRegion() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPersistentRegion(vm0);
        this.createNonPersistentRegion(vm1);
        this.putAnEntry(vm0);
        this.closeRegion(vm0);
        AsyncInvocation future = this.createPersistentRegionWithWait(vm2);
        this.createPersistentRegion(vm0);
        future.getResult(60000L);
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        this.closeRegion(vm1);
        this.closeRegion(vm2);
        this.createPersistentRegion(vm2);
        this.createPersistentRegion(vm0);
        this.checkForEntry(vm0);
        this.checkForEntry(vm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitBrain() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm0);
        this.putAnEntry(vm0);
        this.closeRegion(vm0);
        this.createPersistentRegion(vm1);
        this.updateTheEntry(vm1);
        this.closeRegion(vm1);
        this.createPersistentRegion(vm0);
        DistributedTestCase.ExpectedException e = PersistentRecoveryOrderDUnitTest.addExpectedException(ConflictingPersistentDataException.class.getSimpleName(), vm1);
        try {
            this.createPersistentRegion(vm1);
            PersistentRecoveryOrderDUnitTest.fail((String)"Should have thrown an exception, vm1 is from a 'different' distributed system");
        }
        catch (RuntimeException ok) {
            if (!(ok.getCause() instanceof ConflictingPersistentDataException)) {
                throw ok;
            }
        }
        finally {
            e.remove();
        }
    }

    public void testCrashDuringGII() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeRegion(vm0);
        this.updateTheEntry(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeRegion(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation future = this.createPersistentRegionAsync(vm0);
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future.isAlive());
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                sawRequestImageMessage.set(false);
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            DistributionMessageObserver.setInstance(null);
                            CacheTestCase.disconnectFromDS();
                            AtomicBoolean atomicBoolean = sawRequestImageMessage;
                            synchronized (atomicBoolean) {
                                sawRequestImageMessage.set(true);
                                sawRequestImageMessage.notifyAll();
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }
                });
            }
        });
        this.createPersistentRegion(vm1);
        vm1.invoke(new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = sawRequestImageMessage;
                synchronized (atomicBoolean) {
                    try {
                        while (!sawRequestImageMessage.get()) {
                            sawRequestImageMessage.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.waitForBlockedInitialization(vm0);
        PersistentRecoveryOrderDUnitTest.assertTrue((boolean)future.isAlive());
        this.createPersistentRegion(vm1);
        future.join(60000L);
        if (future.isAlive()) {
            PersistentRecoveryOrderDUnitTest.fail((String)"Region not created within60000");
        }
        if (future.exceptionOccurred()) {
            throw new Exception(future.getException());
        }
        this.checkForEntry(vm0);
        this.checkForEntry(vm1);
        this.checkForRecoveryStat(vm1, true);
        this.checkForRecoveryStat(vm0, false);
    }

    public void testGIIDuringDestroy() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final VM vm2 = host.getVM(2);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof DestroyRegionOperation.DestroyRegionMessage) {
                            PersistentRecoveryOrderDUnitTest.this.createPersistentRegionAsync(vm2);
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            finally {
                                DistributionMessageObserver.setInstance(null);
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                    }
                });
            }
        });
        this.createPersistentRegion(vm1);
        vm0.invoke(new SerializableRunnable("Destroy region"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.destroyRegion();
            }
        });
        vm1.invoke(new SerializableRunnable("check destroyed"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                TestCase.assertNull((Object)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME));
            }
        });
        vm2.invoke(new SerializableRunnable("Wait for region creation"){

            @Override
            public void run() {
                final Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for creation of region " + PersistentReplicatedTestBase.REGION_NAME;
                    }

                    @Override
                    public boolean done() {
                        Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                        return region != null;
                    }
                }, 60000L, 100L, true);
            }
        });
        vm2.invoke(new SerializableRunnable("Check offline members"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                DistributedRegion region = (DistributedRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                PersistenceAdvisor persistAdvisor = region.getPersistenceAdvisor();
                TestCase.assertEquals(Collections.emptySet(), (Object)persistAdvisor.getMembershipView().getOfflineMembers());
            }
        });
    }

    public void testCrashDuringPreparePersistentId() throws Throwable {
        VM vm1;
        VM vm0;
        block2: {
            Host host = Host.getHost(0);
            vm0 = host.getVM(0);
            vm1 = host.getVM(1);
            vm0.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                        public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                            if (message instanceof PrepareNewPersistentMemberMessage) {
                                DistributionMessageObserver.setInstance(null);
                                CacheTestCase.disconnectFromDS();
                            }
                        }

                        public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                        }
                    });
                }
            });
            this.createPersistentRegion(vm0);
            this.putAnEntry(vm0);
            this.updateTheEntry(vm0);
            AsyncInvocation async1 = this.createPersistentRegionAsync(vm1);
            this.waitForBlockedInitialization(vm1);
            this.closeCache(vm1);
            try {
                async1.getResult();
                PersistentRecoveryOrderDUnitTest.fail((String)"Should have seen a CacheClosedException");
            }
            catch (Exception e) {
                if (e.getCause().getCause() instanceof CacheClosedException) break block2;
                throw e;
            }
        }
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.checkForEntry(vm0);
        this.checkForEntry(vm1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitBrainWithNonPersistentRegion() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm1);
        this.updateTheEntry(vm1);
        this.closeRegion(vm1);
        this.createNonPersistentRegion(vm0);
        DistributedTestCase.ExpectedException e = PersistentRecoveryOrderDUnitTest.addExpectedException(IllegalStateException.class.getSimpleName(), vm1);
        try {
            this.createPersistentRegion(vm1);
            PersistentRecoveryOrderDUnitTest.fail((String)"Should have received an IllegalState exception");
        }
        catch (Exception expected) {
            if (!(expected.getCause() instanceof IllegalStateException)) {
                throw expected;
            }
        }
        finally {
            e.remove();
        }
        this.closeRegion(vm0);
        this.createPersistentRegion(vm1);
        this.checkForEntry(vm1);
        this.checkForRecoveryStat(vm1, true);
    }

    public void testMissingEntryOnDisk() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                            Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                            if (region == null) {
                                DistributedTestCase.getLogWriter().severe("removing listener for PersistentRecoveryOrderDUnitTest because region was not found: " + PersistentReplicatedTestBase.REGION_NAME);
                                DistributionMessageObserver old = DistributionMessageObserver.setInstance(null);
                                if (old != this) {
                                    DistributedTestCase.getLogWriter().severe("removed listener was not the invoked listener", (Throwable)new Exception("stack trace"));
                                }
                                return;
                            }
                            region.put((Object)"A", (Object)"B");
                            region.destroy((Object)"A");
                            region.put((Object)"A", (Object)"C");
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }
                });
            }
        });
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.checkForEntry(vm1);
        this.closeRegion(vm0);
        this.closeRegion(vm1);
        this.createPersistentRegion(vm1);
        this.checkForEntry(vm1);
    }

    public void testCompactFromAdmin() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPersistentRegionWithoutCompaction(vm0);
        this.createPersistentRegionWithoutCompaction(vm1);
        vm1.invoke(new SerializableRunnable("Create some data"){

            @Override
            public void run() {
                int i;
                GemFireCacheImpl cache = (GemFireCacheImpl)PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (i = 0; i < 1024; ++i) {
                    region.put((Object)i, (Object)new byte[1024]);
                }
                for (i = 2; i < 1024; ++i) {
                    TestCase.assertTrue((region.destroy((Object)i) != null ? 1 : 0) != 0);
                }
                DiskStoreImpl store = cache.findDiskStore(PersistentReplicatedTestBase.REGION_NAME);
                store.forceRoll();
            }
        });
        vm2.invoke(new SerializableRunnable("Compact"){

            @Override
            public void run() {
                PersistentRecoveryOrderDUnitTest.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentRecoveryOrderDUnitTest.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Map missingIds = adminDS.compactAllDiskStores();
                    TestCase.assertEquals((int)2, (int)missingIds.size());
                    for (Set value : missingIds.values()) {
                        TestCase.assertEquals((int)1, (int)value.size());
                    }
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
        SerializableRunnable compactVM = new SerializableRunnable("compact"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore(PersistentReplicatedTestBase.REGION_NAME);
                TestCase.assertFalse((boolean)ds.forceCompaction());
            }
        };
        vm0.invoke(compactVM);
        vm1.invoke(compactVM);
    }

    public void testCloseDuringRegionOperation() throws Throwable {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        final VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        SerializableCallable createData0 = new SerializableCallable(){

            public Object call() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                int i = 0;
                try {
                    while (true) {
                        region.put((Object)0, (Object)i);
                        ++i;
                    }
                }
                catch (RegionDestroyedException e) {
                }
                catch (CacheClosedException e) {
                }
                catch (NoDataStoreAvailableException ndsae) {
                }
                return i - 1;
            }
        };
        SerializableCallable createData1 = new SerializableCallable(){

            public Object call() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                int i = 0;
                try {
                    while (true) {
                        region.put((Object)1, (Object)i);
                        ++i;
                    }
                }
                catch (RegionDestroyedException e) {
                }
                catch (CacheClosedException e) {
                }
                catch (NoDataStoreAvailableException ndsae) {
                }
                return i - 1;
            }
        };
        AsyncInvocation asyncCreate0 = vm0.invokeAsync(createData0);
        AsyncInvocation asyncCreate1 = vm1.invokeAsync(createData1);
        Thread.sleep(500L);
        AsyncInvocation close0 = this.closeCacheAsync(vm0);
        AsyncInvocation close1 = this.closeCacheAsync(vm1);
        close0.getResult();
        close1.getResult();
        Integer lastSuccessfulInt0 = (Integer)asyncCreate0.getResult();
        Integer lastSuccessfulInt1 = (Integer)asyncCreate1.getResult();
        System.err.println("Cache was closed on 0->" + lastSuccessfulInt0 + ",1->" + lastSuccessfulInt1);
        AsyncInvocation create1 = this.createPersistentRegionAsync(vm0);
        AsyncInvocation create2 = this.createPersistentRegionAsync(vm1);
        create1.getResult();
        create2.getResult();
        String replName = "TEST_REPLICATE";
        SerializableCallable createRepl0 = new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = PersistentRecoveryOrderDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PROXY);
                rf.setConcurrencyChecksEnabled(false);
                rf.create("TEST_REPLICATE");
                return null;
            }
        };
        SerializableCallable createRepl1 = new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = PersistentRecoveryOrderDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                rf.setConcurrencyChecksEnabled(false);
                rf.create("TEST_REPLICATE");
                return null;
            }
        };
        vm0.invoke(createRepl1);
        vm1.invoke(createRepl1);
        createRepl0.call();
        final SerializableCallable shutdownVM = new SerializableCallable(){

            public Object call() {
                Cache cache = CacheFactory.getAnyInstance();
                cache.getDistributedSystem().disconnect();
                return null;
            }
        };
        SerializableCallable createReplData2 = new SerializableCallable(){

            public Object call() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion("TEST_REPLICATE");
                try {
                    region.put((Object)2, (Object)new TestDataCloseDuringRegionOp(shutdownVM, vm0, vm1));
                    return false;
                }
                catch (NoDataStoreAvailableException ndsae) {
                    return true;
                }
            }
        };
        Boolean outcome = (Boolean)createReplData2.call();
        PersistentRecoveryOrderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)outcome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoverAfterConflict() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        this.putAnEntry(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeCache(vm0);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.putAnEntry(vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM0");
        DistributedTestCase.ExpectedException ex = PersistentRecoveryOrderDUnitTest.addExpectedException("ConflictingPersistentDataException", vm0);
        try {
            this.createPersistentRegion(vm0);
            PersistentRecoveryOrderDUnitTest.fail((String)"Should have received a ConflictingPersistentDataException");
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof ConflictingPersistentDataException)) {
                throw e;
            }
        }
        finally {
            ex.remove();
        }
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeCache(vm1);
        this.createPersistentRegion(vm0);
        this.updateTheEntry(vm0);
        ex = PersistentRecoveryOrderDUnitTest.addExpectedException("ConflictingPersistentDataException", vm1);
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Creating region in VM1");
        try {
            this.createPersistentRegion(vm1);
            PersistentRecoveryOrderDUnitTest.fail((String)"Should have received a ConflictingPersistentDataException");
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof ConflictingPersistentDataException)) {
                throw e;
            }
        }
        finally {
            ex.remove();
        }
    }

    private void checkConcurrentCloseValue(VM vm0, VM vm1, final int key, int lastSuccessfulInt) {
        SerializableCallable getValue = new SerializableCallable(){

            public Object call() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                int value = (Integer)region.get((Object)key);
                return value;
            }
        };
        int vm1Value = (Integer)vm0.invoke(getValue);
        int vm2Value = (Integer)vm1.invoke(getValue);
        PersistentRecoveryOrderDUnitTest.assertEquals((int)vm1Value, (int)vm2Value);
        PersistentRecoveryOrderDUnitTest.assertTrue((String)("value = " + vm1Value + ", lastSuccessfulInt=" + lastSuccessfulInt), (vm1Value == lastSuccessfulInt || vm1Value == lastSuccessfulInt + 1 ? 1 : 0) != 0);
    }

    private void checkForEntry(VM vm) {
        SerializableRunnable checkForEntry = new SerializableRunnable("check for the entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                TestCase.assertEquals((Object)"C", (Object)region.get((Object)"A"));
            }
        };
        vm.invoke(checkForEntry);
    }

    protected void updateTheEntry(VM vm1) {
        this.updateTheEntry(vm1, "C");
    }

    protected void updateTheEntry(VM vm1, final String value) {
        vm1.invoke(new SerializableRunnable("change the entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.put((Object)"A", (Object)value);
            }
        });
    }

    protected void putAnEntry(VM vm0) {
        vm0.invoke(new SerializableRunnable("Put an entry"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.put((Object)"A", (Object)"B");
            }
        });
    }

    @Override
    public Properties getDistributedSystemProperties() {
        PersistentRecoveryOrderDUnitTest.getLogWriter().info("Looking for ack-wait-threshold");
        String s = System.getProperty("gemfire.ack-wait-threshold");
        if (s != null) {
            SAVED_ACK_WAIT_THRESHOLD = s;
            PersistentRecoveryOrderDUnitTest.getLogWriter().info("removing system property gemfire.ack-wait-threshold");
            System.getProperties().remove("gemfire.ack-wait-threshold");
        }
        Properties props = super.getDistributedSystemProperties();
        props.put("ack-wait-threshold", "5");
        return props;
    }

    private void checkForRecoveryStat(VM vm, final boolean localRecovery) {
        vm.invoke(new SerializableRunnable("check disk region stat"){

            @Override
            public void run() {
                Cache cache = PersistentRecoveryOrderDUnitTest.this.getCache();
                DistributedRegion region = (DistributedRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                DiskRegionStats stats = region.getDiskRegion().getStats();
                if (localRecovery) {
                    TestCase.assertEquals((int)1, (int)stats.getLocalInitializations());
                    TestCase.assertEquals((int)0, (int)stats.getRemoteInitializations());
                } else {
                    TestCase.assertEquals((int)0, (int)stats.getLocalInitializations());
                    TestCase.assertEquals((int)1, (int)stats.getRemoteInitializations());
                }
            }
        });
    }

    private static class TestDataCloseDuringRegionOp
    implements DataSerializable {
        private int field = 5;
        private SerializableCallable shutDownTask;
        private VM vm0;
        private VM vm1;

        public TestDataCloseDuringRegionOp() {
        }

        public TestDataCloseDuringRegionOp(SerializableCallable shutdownVM, VM vm0, VM vm1) {
            this.shutDownTask = shutdownVM;
            this.vm0 = vm0;
            this.vm1 = vm1;
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.field);
            this.vm0.invoke(this.shutDownTask);
            this.vm1.invoke(this.shutDownTask);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.field = in.readInt();
        }
    }
}

