/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.fixed;

import com.gemstone.gemfire.cache.DuplicatePrimaryPartitionException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.partition.PartitionNotAvailableException;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.FixedPartitioningTestBase;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.QuarterPartitionResolver;
import dunit.AsyncInvocation;
import dunit.Host;
import java.util.ArrayList;

public class FixedPartitioningDUnitTest
extends FixedPartitioningTestBase {
    private static final long serialVersionUID = 1L;

    public FixedPartitioningDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        member1 = host.getVM(0);
        member2 = host.getVM(1);
        member3 = host.getVM(2);
        member4 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testNullPartitionName() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa = FixedPartitionAttributes.createFixedPartition(null, (boolean)true, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 3, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException Expected");
            }
            catch (Exception illegal) {
                if (illegal.getCause() instanceof IllegalStateException && illegal.getCause().getMessage().contains("Fixed partition name cannot be null")) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", illegal);
            }
        }
    }

    public void testSamePartitionNameTwice() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 3, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException Expected");
            }
            catch (Exception illegal) {
                if (illegal.getCause() instanceof IllegalStateException && illegal.getCause().getMessage().contains("can be added only once in FixedPartitionAttributes")) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", illegal);
            }
        }
    }

    public void testFixedPartitionAttributes_Accessor() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 0, 3, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException Expected");
            }
            catch (Exception illegal) {
                if (illegal.getCause() instanceof IllegalStateException && illegal.getCause().getMessage().contains("can not be defined for accessor")) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", illegal);
            }
        }
    }

    public void testSamePartitionName_Primary_OnTwoMembers() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 9, new QuarterPartitionResolver(), null, false});
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 9, new QuarterPartitionResolver(), null, false});
                member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 9, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"DuplicatePrimaryPartitionException Expected");
            }
            catch (Exception duplicate) {
                if (duplicate.getCause() instanceof DuplicatePrimaryPartitionException && duplicate.getCause().getMessage().contains("can not be defined as primary on more than one node")) break block2;
                FixedPartitioningDUnitTest.fail("Expected DuplicatePrimaryPartitionException ", duplicate);
            }
        }
    }

    public void testSamePartitionName_DifferentNumBuckets() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 9, new QuarterPartitionResolver(), null, false});
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
                fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)8);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 9, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException Expected");
            }
            catch (Exception illegal) {
                if (illegal.getCause() instanceof IllegalStateException && illegal.getCause().getMessage().contains("num-buckets are not same")) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", illegal);
            }
        }
    }

    public void testNumberOfPartitions() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 0, 9, new QuarterPartitionResolver(), null, false});
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q11", (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q12", (boolean)false, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 9, new QuarterPartitionResolver(), null, false});
                member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q12", (boolean)true, (int)3);
                fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q13", (boolean)false, (int)3);
                FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"Q11", (boolean)false, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                fpaList.add(fpa3);
                member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 9, new QuarterPartitionResolver(), null, false});
                member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q13", (boolean)true, (int)3);
                fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q11", (boolean)false, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 9, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException && ex.getCause().getMessage().contains("should never exceed number of redundant copies")) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void testNumBuckets_totalNumBuckets() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 0, 5, new QuarterPartitionResolver(), null, false});
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 5, new QuarterPartitionResolver(), null, false});
                member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
                fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                fpaList.add(fpa2);
                member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 5, new QuarterPartitionResolver(), null, false});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException && ex.getCause().getMessage().contains("for different primary partitions should not be greater than total-num-buckets ")) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void testPut_PartitionNotAvailableException() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 0, 12, new QuarterPartitionResolver(), null, false});
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
                member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
                member1.invoke(FixedPartitioningTestBase.class, "putThorughAccessor", new Object[]{"Quarter"});
                FixedPartitioningDUnitTest.fail((String)"PartitionNotAvailableException Expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof PartitionNotAvailableException) break block2;
                FixedPartitioningDUnitTest.fail("Expected PartitionNotAvailableException ", ex);
            }
        }
    }

    public void test_DataStoreWithoutPartition_DataStoreWithPartition() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 40, 12, new QuarterPartitionResolver(), null, false});
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void test_DataStoreWithPartition_DataStoreWithoutPartition() {
        block2: {
            try {
                member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 40, 12, new QuarterPartitionResolver(), null, false});
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void testPut_ValidateDataOnMember_OnlyPrimary_Accessor() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 0, 0, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThorughAccessor", new Object[]{"Quarter"});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter1});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter2});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter3});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43283() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member1.invoke(FixedPartitioningTestBase.class, "setPRObserverBeforeCalculateStartingBucketId");
        member2.invoke(FixedPartitioningTestBase.class, "setPRObserverBeforeCalculateStartingBucketId");
        member3.invoke(FixedPartitioningTestBase.class, "setPRObserverBeforeCalculateStartingBucketId");
        member4.invoke(FixedPartitioningTestBase.class, "setPRObserverBeforeCalculateStartingBucketId");
        try {
            AsyncInvocation inv3;
            AsyncInvocation inv2;
            AsyncInvocation inv1;
            block7: {
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                inv1 = member1.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa2);
                inv2 = member2.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
                FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
                fpaList = new ArrayList();
                fpaList.add(fpa3);
                inv3 = member3.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
                member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 0, 0, 12, new QuarterPartitionResolver(), null, false});
                try {
                    member4.invoke(FixedPartitioningTestBase.class, "putThorughAccessor_Immediate", new Object[]{"Quarter"});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getCause() instanceof PartitionNotAvailableException) break block7;
                    FixedPartitioningDUnitTest.fail((String)"exception thrown is not PartitionNotAvailableException");
                }
            }
            try {
                inv1.join();
                inv2.join();
                inv3.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                FixedPartitioningDUnitTest.fail((String)"Unexpected Exception");
            }
        }
        finally {
            member1.invoke(FixedPartitioningTestBase.class, "resetPRObserverBeforeCalculateStartingBucketId");
            member2.invoke(FixedPartitioningTestBase.class, "resetPRObserverBeforeCalculateStartingBucketId");
            member3.invoke(FixedPartitioningTestBase.class, "resetPRObserverBeforeCalculateStartingBucketId");
            member4.invoke(FixedPartitioningTestBase.class, "resetPRObserverBeforeCalculateStartingBucketId");
        }
    }

    public void testPut_ValidateDataOnMember_OnlyPrimary_Datastore() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter2});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter4});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
    }

    public void testDelete_WithoutPut() {
        block2: {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
            try {
                member1.invoke(FixedPartitioningTestBase.class, "deleteOperation", new Object[]{"Quarter"});
                FixedPartitioningDUnitTest.fail((String)"EntryNotFoundException expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof EntryNotFoundException) break block2;
                FixedPartitioningDUnitTest.fail("Expected EntryNotFoundException ", ex);
            }
        }
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "getThroughDataStore", new Object[]{"Quarter"});
    }

    public void testPut_NoResolver() {
        block2: {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            try {
                member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore_NoResolver", new Object[]{"Quarter"});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void testPut_CallBackWithResolver() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore_CallBackWithResolver", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter2});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter4});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
    }

    public void testPut_WithResolver_NoFPAs() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
    }

    public void testPut_FixedPartitionResolver_NoResolver() {
        block2: {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            try {
                member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore_FixedPartitionResolver_NoResolver", new Object[]{"Quarter"});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void testPut_FixedPartitionResolver_PartitionResolver() {
        block2: {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, null, null, false});
            try {
                member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore_FixedPartitionResolver_PartitionResolver", new Object[]{"Quarter"});
                FixedPartitioningDUnitTest.fail((String)"IllegalStateException expected");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof IllegalStateException) break block2;
                FixedPartitioningDUnitTest.fail("Expected IllegalStateException ", ex);
            }
        }
    }

    public void testFPR_DefaultNumBuckets() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter2});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter4});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{1, 1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{1, 1});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{1, 1});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{1, 1});
    }

    public void testPut_ValidateDataOnMember_PrimarySecondary_Accessor() {
        FixedPartitioningDUnitTest.createCacheOnMember();
        FixedPartitioningDUnitTest.createRegionWithPartitionAttributes("Quarter", null, 3, 0, 12, (PartitionResolver)new QuarterPartitionResolver(), null, false);
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        FixedPartitioningDUnitTest.putThroughDataStore("Quarter");
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter3, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter4, false});
    }

    public void testPut_ValidateDataOnMember_PrimarySecondary_Datastore() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
    }

    public void testPut_ValidateDataOnMember_OnlySecondary_Datastore() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        FixedPartitioningDUnitTest.createCacheOnMember();
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        FixedPartitioningDUnitTest.createRegionWithPartitionAttributes("Quarter", fpaList, 3, 40, 12, (PartitionResolver)new QuarterPartitionResolver(), null, false);
        FixedPartitioningDUnitTest.pause(1000);
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 0});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        FixedPartitioningDUnitTest.checkPrimaryBucketsForQuarter(3, 3);
    }

    public void testPut_ValidateDataOnMember_PrimarySecondary_Accessor_CacheClosed() {
        FixedPartitioningDUnitTest.createCacheOnMember();
        FixedPartitioningDUnitTest.createRegionWithPartitionAttributes("Quarter", null, 3, 0, 12, (PartitionResolver)new QuarterPartitionResolver(), null, false);
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpa3 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        fpaList.add(fpa3);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 3, 40, 12, new QuarterPartitionResolver(), null, false});
        FixedPartitioningDUnitTest.putThroughDataStore("Quarter");
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter3, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter4, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{9, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{9, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{9, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{9, 3});
        member4.invoke(FixedPartitioningTestBase.class, "closeCache");
        FixedPartitioningDUnitTest.pause(1000);
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData_TwoSecondaries", new Object[]{Quarter3, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarterAfterCacheClosed", new Object[]{9, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarterAfterCacheClosed", new Object[]{9, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarterAfterCacheClosed", new Object[]{9, 3});
    }

    public void testPut_ValidateDataOnMember_PrimarySecondary_Datastore_CacheClosed() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "closeCache");
        FixedPartitioningDUnitTest.pause(1000);
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarterAfterCacheClosed", new Object[]{6, 6});
        member1.invoke(FixedPartitioningTestBase.class, "putHAData", new Object[]{"Quarter"});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        FixedPartitioningDUnitTest.pause(1000);
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, true});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, true});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, true});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, true});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
    }

    public void test_Bug46619_Put_ValidateDataOnMember_PrimarySecondary_Datastore_CacheClosed() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember_DisableMovePrimary");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember_DisableMovePrimary");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember_DisableMovePrimary");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember_DisableMovePrimary");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "closeCache");
        FixedPartitioningDUnitTest.pause(1000);
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarterAfterCacheClosed", new Object[]{6, 6});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarterAfterCacheClosed", new Object[]{6, 6});
        member1.invoke(FixedPartitioningTestBase.class, "putHAData", new Object[]{"Quarter"});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember_DisableMovePrimary");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember_DisableMovePrimary");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        FixedPartitioningDUnitTest.pause(1000);
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, true});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, true});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, true});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, true});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 0});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 0});
        member4.invoke(FixedPartitioningTestBase.class, "doRebalance");
        FixedPartitioningDUnitTest.pause(2000);
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
    }

    public void testPut_ValidateDataOnMember_MultiplePrimaries_Datastore_CacheClosed() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3));
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 2, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpaList = new ArrayList();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3));
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 2, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpaList = new ArrayList();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3));
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 2, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs");
        member2.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs");
        member3.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs");
        member3.invoke(FixedPartitioningTestBase.class, "closeCache");
        FixedPartitioningDUnitTest.pause(1000);
        member1.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs_Nodedown");
        member2.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs_Nodedown");
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 2, 40, 12, new QuarterPartitionResolver(), null, false});
        FixedPartitioningDUnitTest.pause(3000);
        member1.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs_Nodeup");
        member2.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs_Nodeup");
        member3.invoke(FixedPartitioningTestBase.class, "checkStartingBucketIDs_Nodeup");
    }
}

