/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.ha.HAContainerMap;
import com.gemstone.gemfire.internal.cache.ha.HAContainerRegion;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import com.gemstone.gemfire.internal.cache.tier.sockets.HAEventWrapper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import util.TestException;

public class HARQueueNewImplDUnitTest
extends DistributedTestCase {
    protected static Cache cache = null;
    protected static VM serverVM0 = null;
    private static VM serverVM1 = null;
    protected static VM clientVM1 = null;
    protected static VM clientVM2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String regionName = "HARQueueNewImplDUnitTest";
    private static final Map map;
    protected static LogWriter logger;
    protected static int numOfCreates;
    protected static int numOfUpdates;
    protected static int numOfInvalidates;
    private static Object[] deletedValues;

    public HARQueueNewImplDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        serverVM0 = host.getVM(0);
        serverVM1 = host.getVM(1);
        clientVM1 = host.getVM(2);
        clientVM2 = host.getVM(3);
        PORT1 = (Integer)serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createServerCache", new Object[]{"mem"});
        PORT2 = (Integer)serverVM1.invoke(HARQueueNewImplDUnitTest.class, "createServerCache", new Object[]{"entry"});
        numOfCreates = 0;
        numOfUpdates = 0;
        numOfInvalidates = 0;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        HARQueueNewImplDUnitTest.closeCache();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        HARQueueNewImplDUnitTest.disconnectAllFromDS();
    }

    private void createCache(Properties props) throws Exception {
        props.setProperty("delta-propagation", "false");
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        HARQueueNewImplDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        HARQueueNewImplDUnitTest.assertNotNull((Object)cache);
    }

    public static Integer createServerCache() throws Exception {
        return HARQueueNewImplDUnitTest.createServerCache(null);
    }

    public static Integer createServerCache(String ePolicy) throws Exception {
        return HARQueueNewImplDUnitTest.createServerCache(ePolicy, new Integer(1));
    }

    public static Integer createServerCache(String ePolicy, Integer cap) throws Exception {
        new HARQueueNewImplDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        logger = cache.getLogger();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        if (ePolicy != null) {
            File overflowDirectory = new File("bsi_overflow_" + port);
            overflowDirectory.mkdir();
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            File[] dirs1 = new File[]{overflowDirectory};
            server1.getClientSubscriptionConfig().setEvictionPolicy(ePolicy);
            server1.getClientSubscriptionConfig().setCapacity(cap.intValue());
            server1.getClientSubscriptionConfig().setDiskStoreName(dsf.setDiskDirs(dirs1).create("bsi").getName());
        }
        server1.start();
        return new Integer(server1.getPort());
    }

    public static Integer createOneMoreBridgeServer(Boolean notifyBySubscription) throws Exception {
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server1.getClientSubscriptionConfig().setEvictionPolicy("mem");
        server1.start();
        return new Integer(server1.getPort());
    }

    public static void createClientCache(String host, Integer port1, Integer port2, String rLevel, Boolean addListener) throws Exception {
        CacheServerTestUtil.disableShufflingOfEndpoints();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HARQueueNewImplDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        BridgeTestCase.configureConnectionPool(factory, host, port1, port2, true, Integer.parseInt(rLevel), 2, null, 1000, 250, false);
        factory.setScope(Scope.LOCAL);
        if (addListener.booleanValue()) {
            factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterInvalidate(EntryEvent event) {
                    logger.fine("Invalidate Event: <" + event.getKey() + ", " + event.getNewValue() + ">");
                    ++numOfInvalidates;
                }

                public void afterCreate(EntryEvent event) {
                    logger.fine("Create Event: <" + event.getKey() + ", " + event.getNewValue() + ">");
                    ++numOfCreates;
                }

                public void afterUpdate(EntryEvent event) {
                    logger.fine("Update Event: <" + event.getKey() + ", " + event.getNewValue() + ">");
                    ++numOfUpdates;
                }
            });
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        logger = cache.getLogger();
    }

    public static void createClientCache(String host, Integer port1, Integer port2, String rLevel) throws Exception {
        HARQueueNewImplDUnitTest.createClientCache(host, port1, port2, rLevel, Boolean.FALSE);
    }

    public static void registerInterestListAll() {
        try {
            Region r = cache.getRegion("/HARQueueNewImplDUnitTest");
            HARQueueNewImplDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"ALL_KEYS");
        }
        catch (Exception ex) {
            HARQueueNewImplDUnitTest.fail("failed in registerInterestListAll", ex);
        }
    }

    public static void registerInterestList() {
        try {
            Region r = cache.getRegion("/HARQueueNewImplDUnitTest");
            HARQueueNewImplDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"k1");
            r.registerInterest((Object)"k3");
            r.registerInterest((Object)"k5");
        }
        catch (Exception ex) {
            HARQueueNewImplDUnitTest.fail("failed while registering keys", ex);
        }
    }

    public static void putEntries() {
        try {
            Region r = cache.getRegion("/HARQueueNewImplDUnitTest");
            HARQueueNewImplDUnitTest.assertNotNull((Object)r);
            r.put((Object)"k1", (Object)"pv1");
            r.put((Object)"k2", (Object)"pv2");
            r.put((Object)"k3", (Object)"pv3");
            r.put((Object)"k4", (Object)"pv4");
            r.put((Object)"k5", (Object)"pv5");
        }
        catch (Exception ex) {
            HARQueueNewImplDUnitTest.fail("failed in putEntries()", ex);
        }
    }

    public static void createEntries() {
        try {
            Region r = cache.getRegion("/HARQueueNewImplDUnitTest");
            HARQueueNewImplDUnitTest.assertNotNull((Object)r);
            r.create((Object)"k1", (Object)"v1");
            r.create((Object)"k2", (Object)"v2");
            r.create((Object)"k3", (Object)"v3");
            r.create((Object)"k4", (Object)"v4");
            r.create((Object)"k5", (Object)"v5");
        }
        catch (Exception ex) {
            HARQueueNewImplDUnitTest.fail("failed in createEntries()", ex);
        }
    }

    public static void createEntries(Long num) {
        try {
            Region r = cache.getRegion("/HARQueueNewImplDUnitTest");
            HARQueueNewImplDUnitTest.assertNotNull((Object)r);
            for (long i = 0L; i < num; ++i) {
                r.create((Object)("k" + i), (Object)("v" + i));
            }
        }
        catch (Exception ex) {
            HARQueueNewImplDUnitTest.fail("failed in createEntries(Long)", ex);
        }
    }

    public static void putHeavyEntries(Integer num) {
        try {
            byte[] val = null;
            Region r = cache.getRegion("/HARQueueNewImplDUnitTest");
            HARQueueNewImplDUnitTest.assertNotNull((Object)r);
            for (long i = 0L; i < (long)num.intValue(); ++i) {
                val = new byte[0x500000];
                r.put((Object)"k0", (Object)val);
            }
        }
        catch (Exception ex) {
            HARQueueNewImplDUnitTest.fail("failed in putHeavyEntries(Long)", ex);
        }
    }

    public void testClientMsgsRegionSize() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        serverVM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "startServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(5), new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(5), new Integer(PORT2)});
    }

    public void testRefCountForNormalAndGIIPut() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        serverVM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "startServer");
        Thread.sleep(3000L);
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "updateMapForVM0");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "updateMapForVM1");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyQueueData", new Object[]{new Integer(5), new Integer(5), new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyQueueData", new Object[]{new Integer(5), new Integer(5), new Integer(PORT2)});
    }

    public void testRefCountForPeekAndRemove() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(5), new Integer(PORT1)});
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "waitTillMessagesAreDispatched", new Object[]{new Integer(PORT1), new Long(5000L)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(0), new Integer(PORT1)});
    }

    public void testRefCountForQRM() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "startServer");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(5), new Integer(PORT2)});
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(0), new Integer(PORT2)});
    }

    public void testRefCountForDestroy() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        serverVM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "startServer");
        Thread.sleep(3000L);
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        Thread.sleep(1000L);
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "updateMap1");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "updateMap1");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyQueueData", new Object[]{new Integer(5), new Integer(5), new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyQueueData", new Object[]{new Integer(5), new Integer(5), new Integer(PORT2)});
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "updateMap2");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "updateMap2");
        Thread.sleep(1000L);
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyQueueData", new Object[]{new Integer(5), new Integer(5), new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyQueueData", new Object[]{new Integer(5), new Integer(5), new Integer(PORT2)});
    }

    public void testConcurrentGIIAndDispatch() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"40000"});
        serverVM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"40000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestListAll");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestListAll");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "makeValuesOfSomeKeysNullInClientMsgsRegion", new Object[]{new Integer(PORT1), new String[]{"k1", "k3"}});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "startServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(3), new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyNullValuesInCMR", new Object[]{new Integer(3), new Integer(PORT2), new String[]{"k1", "k3"}});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(3), new Integer(PORT2)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "populateValuesOfSomeKeysInClientMsgsRegion", new Object[]{new Integer(PORT1), new String[]{"k1", "k3"}});
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
    }

    public void testTwoBridgeServersInOneVMDoShareCMR() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        Integer port3 = (Integer)serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createOneMoreBridgeServer", new Object[]{Boolean.TRUE});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), port3, "0");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(5), new Integer(PORT1)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRegionSize", new Object[]{new Integer(5), new Integer(5), port3});
    }

    public void testUpdatesWithTwoBridgeServersInOneVM() throws Exception {
        Integer port3 = (Integer)serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createOneMoreBridgeServer", new Object[]{Boolean.FALSE});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1", Boolean.TRUE);
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, port3, new Integer(PORT2), "1", Boolean.TRUE});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestListAll");
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "putEntries");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "waitTillMessagesAreDispatched", new Object[]{new Integer(PORT1), new Long(5000L)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "waitTillMessagesAreDispatched", new Object[]{port3, new Long(5000L)});
        HARQueueNewImplDUnitTest.verifyUpdatesReceived(new Integer(5), Boolean.TRUE, new Long(5000L));
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyUpdatesReceived", new Object[]{new Integer(5), Boolean.TRUE, new Long(5000L)});
    }

    public void testHAEventWrapperDoesNotHoldCUMOnceInsideCMR() throws Exception {
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopServer");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries", new Object[]{new Long(1000L)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "startServer");
        Thread.sleep(2000L);
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyNullCUMReference", new Object[]{new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyNullCUMReference", new Object[]{new Integer(PORT2)});
    }

    public void testCMRNotCreatedForNoneEvictionPolicy() throws Exception {
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        Thread.sleep(2000L);
        PORT1 = (Integer)serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createServerCache", new Object[]{"none"});
        PORT2 = (Integer)serverVM1.invoke(HARQueueNewImplDUnitTest.class, "createServerCache", new Object[]{"none"});
        Boolean isRegion = Boolean.FALSE;
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerType", new Object[]{isRegion, new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerType", new Object[]{isRegion, new Integer(PORT2)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "stopOneBridgeServer", new Object[]{new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopOneBridgeServer", new Object[]{new Integer(PORT2)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerDestroyed", new Object[]{isRegion, new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerDestroyed", new Object[]{isRegion, new Integer(PORT2)});
    }

    public void testCMRCreatedForMemOrEntryEvictionPolicy() throws Exception {
        Boolean isRegion = Boolean.TRUE;
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerType", new Object[]{isRegion, new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerType", new Object[]{isRegion, new Integer(PORT2)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "stopOneBridgeServer", new Object[]{new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "stopOneBridgeServer", new Object[]{new Integer(PORT2)});
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerDestroyed", new Object[]{isRegion, new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyHaContainerDestroyed", new Object[]{isRegion, new Integer(PORT2)});
    }

    public void testCMRNotReturnedByRootRegionsMethod() throws Exception {
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestList");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createEntries");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "verifyRootRegionsDoesNotReturnCMR", new Object[]{new Integer(PORT1)});
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "verifyRootRegionsDoesNotReturnCMR", new Object[]{new Integer(PORT2)});
    }

    public void _testMemoryFootprintOfHARegionQueuesWithAndWithoutOverflow() throws Exception {
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        serverVM1.invoke(HARQueueNewImplDUnitTest.class, "closeCache");
        Thread.sleep(2000L);
        Integer numOfEntries = new Integer(30);
        PORT1 = (Integer)serverVM0.invoke(HARQueueNewImplDUnitTest.class, "createServerCache", new Object[]{"mem", new Integer(30)});
        PORT2 = (Integer)serverVM1.invoke(HARQueueNewImplDUnitTest.class, "createServerCache", new Object[]{"none"});
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        serverVM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        HARQueueNewImplDUnitTest.createClientCache(HARQueueNewImplDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), "1");
        String client1Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM1.getHost());
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client1Host, new Integer(PORT1), new Integer(PORT2), "1"});
        String client2Host = HARQueueNewImplDUnitTest.getServerHostName(clientVM2.getHost());
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "createClientCache", new Object[]{client2Host, new Integer(PORT1), new Integer(PORT2), "1"});
        HARQueueNewImplDUnitTest.registerInterestListAll();
        clientVM1.invoke(HARQueueNewImplDUnitTest.class, "registerInterestListAll");
        clientVM2.invoke(HARQueueNewImplDUnitTest.class, "registerInterestListAll");
        serverVM0.invoke(HARQueueNewImplDUnitTest.class, "putHeavyEntries", new Object[]{numOfEntries});
        Long usedMemInVM0 = (Long)serverVM0.invoke(HARQueueNewImplDUnitTest.class, "getUsedMemoryAndVerifyRegionSize", new Object[]{new Integer(1), numOfEntries, new Integer(PORT1)});
        Long usedMemInVM1 = (Long)serverVM1.invoke(HARQueueNewImplDUnitTest.class, "getUsedMemoryAndVerifyRegionSize", new Object[]{new Integer(1), numOfEntries, new Integer(-1)});
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        logger.fine("Used Mem: " + usedMemInVM1 + "(without overflow), " + usedMemInVM0 + "(with overflow)");
        HARQueueNewImplDUnitTest.assertTrue((usedMemInVM0 < usedMemInVM1 ? 1 : 0) != 0);
    }

    private static void verifyNullCUMReference(Integer port) {
        Region r = cache.getRegion("/" + BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
        HARQueueNewImplDUnitTest.assertNotNull((Object)r);
        Object[] arr = r.keySet().toArray();
        for (int i = 0; i < arr.length; ++i) {
            HARQueueNewImplDUnitTest.assertNull((Object)((HAEventWrapper)arr[i]).getClientUpdateMessage());
        }
    }

    private static void verifyHaContainerDestroyed(Boolean isRegion, Integer port) {
        Object r = cache.getRegion("/" + BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
        if (isRegion.booleanValue()) {
            if (r != null) {
                HARQueueNewImplDUnitTest.assertTrue((boolean)r.isDestroyed());
            }
        } else {
            r = ((BridgeServerImpl)cache.getBridgeServers().toArray()[0]).getAcceptor().getCacheClientNotifier().getHaContainer();
            if (r != null) {
                HARQueueNewImplDUnitTest.assertTrue((boolean)r.isEmpty());
            }
        }
    }

    static Long getUsedMemoryAndVerifyRegionSize(Integer rSize, Integer haContainerSize, Integer port) {
        Long retVal = null;
        try {
            retVal = new Long(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            if (port != -1) {
                HARQueueNewImplDUnitTest.verifyRegionSize(rSize, haContainerSize, port);
            } else {
                HARQueueNewImplDUnitTest.verifyRegionSize(rSize, haContainerSize);
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in getUsedMemory()" + e));
        }
        return retVal;
    }

    private static void setHACapacity(Integer cap) {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.getClientSubscriptionConfig().setCapacity(cap.intValue());
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in setHACapacity()" + e));
        }
    }

    private static void stopOneBridgeServer(Integer port) {
        try {
            BridgeServer server;
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext() && (server = (BridgeServer)iter.next()).getPort() == port.intValue()) {
                server.stop();
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in stopOneBridgeServer()" + e));
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in stopServer()" + e));
        }
    }

    public static void updateMapForVM0() {
        try {
            map.put("k1", new Long(3L));
            map.put("k2", new Long(1L));
            map.put("k3", new Long(3L));
            map.put("k4", new Long(1L));
            map.put("k5", new Long(3L));
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in updateMapForVM0()" + e));
        }
    }

    public static void updateMap1() {
        try {
            map.put("k1", new Long(2L));
            map.put("k2", new Long(1L));
            map.put("k3", new Long(2L));
            map.put("k4", new Long(1L));
            map.put("k5", new Long(2L));
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in updateMap1()" + e));
        }
    }

    public static void updateMap2() {
        try {
            map.put("k1", new Long(1L));
            map.put("k2", new Long(1L));
            map.put("k3", new Long(1L));
            map.put("k4", new Long(1L));
            map.put("k5", new Long(1L));
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in updateMap2()" + e));
        }
    }

    public static void updateMapForVM1() {
        try {
            HARQueueNewImplDUnitTest.updateMapForVM0();
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in updateMapForVM1()" + e));
        }
    }

    public static void printMsg(String msg) {
        try {
            logger.fine(msg);
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in printMsg()" + e));
        }
    }

    public static void haQueuePut() {
        Set set = HARegionQueue.getDispatchedMessagesMapForTesting().keySet();
        Iterator iter = set.iterator();
        logger.fine("# of HAQueues: " + set.size());
        while (iter.hasNext()) {
            cache.getRegion("/" + (String)iter.next());
        }
    }

    public static void verifyNullValuesInCMR(final Integer numOfEntries, Integer port, String[] keys) {
        final Region msgsRegion = cache.getRegion(BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int sz = msgsRegion.size();
                return sz == numOfEntries;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        Set entries = msgsRegion.entrySet();
        for (Region.Entry entry : entries) {
            ClientUpdateMessage cum = (ClientUpdateMessage)entry.getValue();
            for (int i = 0; i < keys.length; ++i) {
                logger.fine("cum.key: " + cum.getKeyToConflate());
                HARQueueNewImplDUnitTest.assertTrue((!keys[i].equals(cum.getKeyToConflate()) ? 1 : 0) != 0);
            }
        }
    }

    public static void makeValuesOfSomeKeysNullInClientMsgsRegion(Integer port, String[] keys) {
        Region msgsRegion = cache.getRegion(BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
        HARQueueNewImplDUnitTest.assertNotNull((Object)msgsRegion);
        Set entries = msgsRegion.entrySet();
        Iterator iter = entries.iterator();
        deletedValues = new Object[keys.length];
        while (iter.hasNext()) {
            Region.Entry entry = (Region.Entry)iter.next();
            ClientUpdateMessage cum = (ClientUpdateMessage)entry.getValue();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].equals(cum.getKeyToConflate())) continue;
                logger.fine("HARQueueNewImplDUnit: Removing " + cum.getKeyOfInterest());
                HARQueueNewImplDUnitTest.deletedValues[i] = msgsRegion.remove(entry.getKey());
            }
        }
    }

    public static void populateValuesOfSomeKeysInClientMsgsRegion(Integer port, String[] keys) {
        Region msgsRegion = cache.getRegion(BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
        HARQueueNewImplDUnitTest.assertNotNull((Object)msgsRegion);
        for (int i = 0; i < keys.length; ++i) {
            logger.fine("HARQueueNewImplDUnit: populating " + deletedValues[i]);
            msgsRegion.put((Object)keys[1], deletedValues[i]);
        }
    }

    public static void startServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.start();
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in startServer()" + e));
        }
    }

    public static void verifyQueueData(Integer regionsize, Integer msgsRegionsize, Integer port) {
        try {
            Region msgsRegion = cache.getRegion(BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
            Region region = cache.getRegion("/HARQueueNewImplDUnitTest");
            logger.fine("size<serverRegion, clientMsgsRegion>: " + region.size() + ", " + msgsRegion.size());
            HARQueueNewImplDUnitTest.assertEquals((int)regionsize, (int)region.size());
            HARQueueNewImplDUnitTest.assertEquals((int)msgsRegionsize, (int)msgsRegion.size());
            for (Region.Entry entry : msgsRegion.entrySet()) {
                HAEventWrapper wrapper = (HAEventWrapper)entry.getKey();
                ClientUpdateMessage cum = (ClientUpdateMessage)entry.getValue();
                Object key = cum.getKeyOfInterest();
                logger.fine("key<feedCount, regionCount>: " + key + "<" + (Long)map.get(key) + ", " + wrapper.getReferenceCount() + ">");
                HARQueueNewImplDUnitTest.assertEquals((long)((Long)map.get(key)), (long)wrapper.getReferenceCount());
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in verifyQueueData()" + e));
        }
    }

    public static void verifyRegionSize(final Integer regionSize, final Integer msgsRegionsize, Integer port) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                try {
                    Region region = cache.getRegion("/HARQueueNewImplDUnitTest");
                    int sz = region.size();
                    if (regionSize != sz) {
                        this.excuse = "expected regionSize = " + regionSize + ", actual = " + sz;
                        return false;
                    }
                    Iterator iter = cache.getBridgeServers().iterator();
                    if (iter.hasNext()) {
                        BridgeServerImpl server = (BridgeServerImpl)iter.next();
                        Map msgsRegion = server.getAcceptor().getCacheClientNotifier().getHaContainer();
                        sz = msgsRegion.size();
                        if (msgsRegionsize != sz) {
                            this.excuse = "expected msgsRegionsize = " + msgsRegionsize + ", actual = " + sz;
                            return false;
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    this.excuse = "Caught exception " + e;
                    return false;
                }
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    public static void verifyRegionSize(final Integer regionSize, final Integer msgsRegionsize) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                try {
                    Region region = cache.getRegion("/HARQueueNewImplDUnitTest");
                    int sz = region.size();
                    if (regionSize != sz) {
                        this.excuse = "Expected regionSize = " + regionSize + ", actual = " + sz;
                        return false;
                    }
                    Iterator iter = cache.getBridgeServers().iterator();
                    if (!iter.hasNext()) {
                        return true;
                    }
                    BridgeServerImpl server = (BridgeServerImpl)iter.next();
                    sz = server.getAcceptor().getCacheClientNotifier().getHaContainer().size();
                    if (sz != msgsRegionsize) {
                        this.excuse = "Expected msgsRegionsize = " + msgsRegionsize + ", actual = " + sz;
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    this.excuse = "failed due to " + e;
                    return false;
                }
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    public static void verifyHaContainerType(Boolean isRegion, Integer port) {
        try {
            Object haMap = cache.getRegion(BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
            if (isRegion.booleanValue()) {
                HARQueueNewImplDUnitTest.assertNotNull((Object)haMap);
                HARQueueNewImplDUnitTest.assertTrue((boolean)(haMap instanceof LocalRegion));
                haMap = ((BridgeServerImpl)cache.getBridgeServers().toArray()[0]).getAcceptor().getCacheClientNotifier().getHaContainer();
                HARQueueNewImplDUnitTest.assertNotNull((Object)haMap);
                HARQueueNewImplDUnitTest.assertTrue((boolean)(haMap instanceof HAContainerRegion));
            } else {
                HARQueueNewImplDUnitTest.assertNull((Object)haMap);
                haMap = ((BridgeServerImpl)cache.getBridgeServers().toArray()[0]).getAcceptor().getCacheClientNotifier().getHaContainer();
                HARQueueNewImplDUnitTest.assertNotNull((Object)haMap);
                HARQueueNewImplDUnitTest.assertTrue((boolean)(haMap instanceof HAContainerMap));
            }
            logger.fine("haContainer: " + haMap);
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in verifyHaContainerType()" + e));
        }
    }

    public static void verifyRootRegionsDoesNotReturnCMR(Integer port) {
        try {
            String cmrName = BridgeServerImpl.generateNameForClientMsgsRegion((int)port);
            Region haMap = cache.getRegion(cmrName);
            HARQueueNewImplDUnitTest.assertNotNull((Object)haMap);
            String rName = "";
            Iterator iter = cache.rootRegions().iterator();
            while (iter.hasNext()) {
                rName = ((Region)iter.next()).getName();
                if (cmrName.equals(rName)) {
                    throw new TestException("Cache.rootRegions() method should not return the client_messages_region.");
                }
                logger.fine("Region name returned from cache.rootRegions(): " + rName);
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in verifyRootRegionsDoesNotReturnCMR()" + e));
        }
    }

    public static void verifyUpdatesReceived(final Integer num, Boolean isUpdate, Long waitLimit) {
        try {
            if (isUpdate.booleanValue()) {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return num == numOfUpdates;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, waitLimit, 200L, true);
            } else {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return num == numOfInvalidates;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, waitLimit, 200L, true);
            }
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in verifyUpdatesReceived()" + e));
        }
    }

    public static void waitTillMessagesAreDispatched(Integer port, Long waitLimit) {
        try {
            Object haContainer = null;
            haContainer = cache.getRegion("/" + BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
            if (haContainer == null) {
                Object[] servers = cache.getBridgeServers().toArray();
                for (int i = 0; i < servers.length; ++i) {
                    if (port.intValue() != ((BridgeServerImpl)servers[i]).getPort()) continue;
                    haContainer = ((BridgeServerImpl)servers[i]).getAcceptor().getCacheClientNotifier().getHaContainer();
                    break;
                }
            }
            Region m = haContainer;
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion((Map)m){
                final /* synthetic */ Map val$m;
                {
                    this.val$m = map;
                }

                @Override
                public boolean done() {
                    return this.val$m.size() == 0;
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, waitLimit, 200L, true);
        }
        catch (Exception e) {
            HARQueueNewImplDUnitTest.fail((String)("failed in waitTillMessagesAreDispatched()" + e));
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        map = new HashMap();
        logger = null;
        numOfCreates = 0;
        numOfUpdates = 0;
        numOfInvalidates = 0;
        deletedValues = null;
    }
}

