/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueStateImpl;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class HAEventIdPropagationDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM client1 = null;
    private static final String REGION_NAME = "HAEventIdPropagationDUnitTest_Region";
    private static Cache cache = null;
    static BridgeServerImpl server = null;
    private static PoolImpl pool = null;
    protected static EventID eventId = null;
    protected static EventID putAlleventId1 = null;
    protected static EventID putAlleventId2 = null;
    protected static EventID putAlleventId3 = null;
    protected static EventID putAlleventId4 = null;
    protected static EventID putAlleventId5 = null;
    protected static final String PUTALL_KEY1 = "putAllKey1";
    protected static final String PUTALL_KEY2 = "putAllKey2";
    protected static final String PUTALL_KEY3 = "putAllKey3";
    protected static final String PUTALL_KEY4 = "putAllKey4";
    protected static final String PUTALL_KEY5 = "putAllKey5";
    protected static Object lockObject = new Object();
    protected static volatile boolean receivedOperation = false;

    public HAEventIdPropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        this.client1 = host.getVM(2);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "closeCache");
        this.server1.invoke(HAEventIdPropagationDUnitTest.class, "closeCache");
    }

    private CacheSerializableRunnable stopServer() {
        CacheSerializableRunnable stopserver = new CacheSerializableRunnable("stopServer"){

            @Override
            public void run2() throws CacheException {
                server.stop();
            }
        };
        return stopserver;
    }

    private void createClientServerConfiguration() {
        int PORT1 = (Integer)this.server1.invoke(HAEventIdPropagationDUnitTest.class, "createServerCache");
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "createClientCache", new Object[]{HAEventIdPropagationDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1)});
    }

    public static Integer createServerCache() throws Exception {
        new HAEventIdPropagationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        HAEventIdPropagationListenerForServer clientListener = new HAEventIdPropagationListenerForServer();
        factory.setCacheListener((CacheListener)clientListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        server = (BridgeServerImpl)cache.addBridgeServer();
        HAEventIdPropagationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAEventIdPropagationDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAEventIdPropagationDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String hostName, Integer port1) throws Exception {
        int PORT1 = port1;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAEventIdPropagationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        PoolImpl pi = (PoolImpl)BridgeTestCase.configureConnectionPool(factory, hostName, new int[]{PORT1}, true, -1, 2, null);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        HAEventIdPropagationListenerForClient clientListener = new HAEventIdPropagationListenerForClient();
        factory.setCacheListener((CacheListener)clientListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
        HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        System.out.println("KKKKKK:[" + pi.getName() + "]");
        PoolImpl p2 = (PoolImpl)PoolManager.find((String)"testPool");
        System.out.println("QQQQ:" + p2);
        pool = pi;
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertThreadIdToSequenceIdMapisNotNullButEmpty() {
        final Map map = pool.getThreadIdToSequenceIdMap();
        HAEventIdPropagationDUnitTest.assertNotNull((Object)map);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean done() {
                Map map2 = map;
                synchronized (map2) {
                    return map.size() == 1;
                }
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        Map map2 = map;
        synchronized (map2) {
            HAEventIdPropagationDUnitTest.getLogWriter().info("assertThreadIdToSequenceIdMapisNotNullButEmpty: map size is " + map.size());
            HAEventIdPropagationDUnitTest.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        }
    }

    public static Object assertThreadIdToSequenceIdMapHasEntryId() {
        Map map = pool.getThreadIdToSequenceIdMap();
        HAEventIdPropagationDUnitTest.assertNotNull((Object)map);
        HAEventIdPropagationDUnitTest.assertTrue((map.size() != 0 ? 1 : 0) != 0);
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
        }
        ThreadIdentifier tid = (ThreadIdentifier)entry2.getKey();
        QueueStateImpl.SequenceIdAndExpirationObject seo = (QueueStateImpl.SequenceIdAndExpirationObject)entry2.getValue();
        long sequenceId = seo.getSequenceId();
        EventID evId = new EventID(tid.getMembershipID(), tid.getThreadID(), sequenceId);
        map.clear();
        return evId;
    }

    public static Object[] assertThreadIdToSequenceIdMapHasEntryIds() {
        Object[] evids = new EventID[5];
        Map map = pool.getThreadIdToSequenceIdMap();
        HAEventIdPropagationDUnitTest.assertNotNull((Object)map);
        evids[0] = putAlleventId1;
        evids[1] = putAlleventId2;
        evids[2] = putAlleventId3;
        evids[3] = putAlleventId4;
        evids[4] = putAlleventId5;
        HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[0]);
        HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[1]);
        HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[2]);
        HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[3]);
        HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[4]);
        return evids;
    }

    public void testEventIDPropagation() throws Exception {
        try {
            this.createClientServerConfiguration();
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapisNotNullButEmpty");
            Object eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "putKey1Val1");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
            Object eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
            if (!eventId1.equals(eventId2)) {
                HAEventIdPropagationDUnitTest.fail((String)"Test failed as the eventIds are not equal");
            }
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
            eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "updateKey1");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
            eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
            if (!eventId1.equals(eventId2)) {
                HAEventIdPropagationDUnitTest.fail((String)"Test failed as the eventIds are not equal");
            }
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
            eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "invalidateKey1");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
            eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
            if (!eventId1.equals(eventId2)) {
                HAEventIdPropagationDUnitTest.fail((String)"Test failed as the eventIds are not equal");
            }
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
            EventID[] eventIds1 = (EventID[])this.server1.invoke(HAEventIdPropagationDUnitTest.class, "putAll");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventIds1);
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
            EventID[] eventIds2 = (EventID[])this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryIds");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventIds2);
            for (int i = 0; i < 5; ++i) {
                HAEventIdPropagationDUnitTest.assertNotNull((Object)eventIds1[i]);
                HAEventIdPropagationDUnitTest.assertNotNull((Object)eventIds2[i]);
                if (eventIds1[i].equals((Object)eventIds2[i])) continue;
                HAEventIdPropagationDUnitTest.fail((String)" eventIds are not equal");
            }
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
            eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "removePUTALL_KEY1");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
            eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
            if (!eventId1.equals(eventId2)) {
                HAEventIdPropagationDUnitTest.fail((String)"Test failed as the eventIds are not equal");
            }
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
            eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "destroyKey1");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
            this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
            eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
            if (!eventId1.equals(eventId2)) {
                HAEventIdPropagationDUnitTest.fail((String)"Test failed as the eventIds are not equal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HAEventIdPropagationDUnitTest.fail("test failed due to " + e, e);
        }
    }

    public void testEventIDPropagationForClear() throws Exception {
        this.createClientServerConfiguration();
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapisNotNullButEmpty");
        Object eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "clearRg");
        HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
        Object eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
        HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
        if (!eventId1.equals(eventId2)) {
            HAEventIdPropagationDUnitTest.fail((String)"Test failed as the clear eventIds are not equal");
        }
    }

    public void _testEventIDPropagationForDestroyRegion() throws Exception {
        this.createClientServerConfiguration();
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "setReceivedOperationToFalse");
        Object eventId1 = this.server1.invoke(HAEventIdPropagationDUnitTest.class, "destroyRegion");
        HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId1);
        this.client1.invoke(HAEventIdPropagationDUnitTest.class, "waitTillOperationReceived");
        Object eventId2 = this.client1.invoke(HAEventIdPropagationDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryId");
        HAEventIdPropagationDUnitTest.assertNotNull((Object)eventId2);
        if (!eventId1.equals(eventId2)) {
            HAEventIdPropagationDUnitTest.fail((String)"Test failed as the eventIds are not equal");
        }
    }

    public static void setReceivedOperationToFalse() {
        receivedOperation = false;
    }

    public static Object putKey1Val1() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.create((Object)"key1", (Object)"value1");
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    public static Object updateKey1() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.put((Object)"key1", (Object)"value2");
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    public static Object[] putAll() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(PUTALL_KEY1, "value1");
            map.put(PUTALL_KEY2, "value1");
            map.put(PUTALL_KEY3, "value1");
            map.put(PUTALL_KEY4, "value1");
            map.put(PUTALL_KEY5, "value1");
            region.putAll(map);
            Thread.sleep(5000L);
            Object[] evids = new EventID[]{putAlleventId1, putAlleventId2, putAlleventId3, putAlleventId4, putAlleventId5};
            HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[0]);
            HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[1]);
            HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[2]);
            HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[3]);
            HAEventIdPropagationDUnitTest.assertNotNull((Object)evids[4]);
            return evids;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    public static Object invalidateKey1() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.invalidate((Object)"key1");
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    public static Object destroyKey1() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.destroy((Object)"key1");
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    public static Object removePUTALL_KEY1() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.remove((Object)PUTALL_KEY1);
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    public static Object clearRg() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.clear();
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("clear failed due to " + e));
            return null;
        }
    }

    public static Object destroyRegion() {
        try {
            Region region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNotNull((Object)region);
            region.destroyRegion();
            region = cache.getRegion("/HAEventIdPropagationDUnitTest_Region");
            HAEventIdPropagationDUnitTest.assertNull((Object)region);
            return eventId;
        }
        catch (Exception e) {
            HAEventIdPropagationDUnitTest.fail((String)("Destroy failed due to " + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitTillOperationReceived() {
        Object object = lockObject;
        synchronized (object) {
            if (!receivedOperation) {
                try {
                    lockObject.wait(10000L);
                }
                catch (InterruptedException e) {
                    HAEventIdPropagationDUnitTest.fail((String)"interrupted");
                }
            }
            if (!receivedOperation) {
                HAEventIdPropagationDUnitTest.fail((String)" operation should have been received but it has not been received yet");
            }
        }
    }

    static class HAEventIdPropagationListenerForServer
    extends CacheListenerAdapter {
        private int putAllReceivedCount = 0;

        HAEventIdPropagationListenerForServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine(" entered after created with " + event.getKey());
            boolean shouldNotify = false;
            Object key = event.getKey();
            if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY1)) {
                ++this.putAllReceivedCount;
                putAlleventId1 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId1);
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY2)) {
                ++this.putAllReceivedCount;
                putAlleventId2 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId2);
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY3)) {
                ++this.putAllReceivedCount;
                putAlleventId3 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId3);
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY4)) {
                ++this.putAllReceivedCount;
                putAlleventId4 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId4);
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY5)) {
                ++this.putAllReceivedCount;
                putAlleventId5 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId5);
            } else {
                shouldNotify = true;
                eventId = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)eventId);
            }
            if (this.putAllReceivedCount == 5) {
                shouldNotify = true;
            }
            if (shouldNotify) {
                Object object = lockObject;
                synchronized (object) {
                    receivedOperation = true;
                    lockObject.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent event) {
            eventId = ((EntryEventImpl)event).getEventId();
            TestCase.assertNotNull((Object)eventId);
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent event) {
            eventId = ((EntryEventImpl)event).getEventId();
            TestCase.assertNotNull((Object)eventId);
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent event) {
            eventId = ((EntryEventImpl)event).getEventId();
            TestCase.assertNotNull((Object)eventId);
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionDestroy(RegionEvent event) {
            Log.getLogWriter().info("Before Regionestroy in Server");
            eventId = ((RegionEventImpl)event).getEventId();
            TestCase.assertNotNull((Object)eventId);
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
            Log.getLogWriter().info("After RegionDestroy in Server");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionClear(RegionEvent event) {
            eventId = ((RegionEventImpl)event).getEventId();
            TestCase.assertNotNull((Object)eventId);
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }
    }

    static class HAEventIdPropagationListenerForClient
    extends CacheListenerAdapter {
        private int putAllReceivedCount = 0;

        HAEventIdPropagationListenerForClient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine(" entered after created with " + event.getKey());
            boolean shouldNotify = false;
            Object key = event.getKey();
            if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY1)) {
                ++this.putAllReceivedCount;
                putAlleventId1 = (EventID)HAEventIdPropagationDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY2)) {
                ++this.putAllReceivedCount;
                putAlleventId2 = (EventID)HAEventIdPropagationDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY3)) {
                ++this.putAllReceivedCount;
                putAlleventId3 = (EventID)HAEventIdPropagationDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY4)) {
                ++this.putAllReceivedCount;
                putAlleventId4 = (EventID)HAEventIdPropagationDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(HAEventIdPropagationDUnitTest.PUTALL_KEY5)) {
                ++this.putAllReceivedCount;
                putAlleventId5 = (EventID)HAEventIdPropagationDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else {
                shouldNotify = true;
            }
            if (this.putAllReceivedCount == 5) {
                shouldNotify = true;
            }
            if (shouldNotify) {
                Object object = lockObject;
                synchronized (object) {
                    receivedOperation = true;
                    lockObject.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent event) {
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent event) {
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent event) {
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionDestroy(RegionEvent event) {
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionClear(RegionEvent event) {
            Object object = lockObject;
            synchronized (object) {
                receivedOperation = true;
                lockObject.notify();
            }
        }
    }
}

