/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Properties;
import junit.framework.Assert;

public class Bug36853EventsExpiryDUnitTest
extends CacheTestCase {
    VM server = null;
    VM client = null;
    private static final String REGION_NAME = "Bug36853EventsExpiryDUnitTest_region";
    protected static Cache cache = null;
    protected static volatile boolean proceedForValidation = false;
    protected static volatile int putsRecievedByClient;
    private static final String LAST_KEY = "LAST_KEY";
    private static final int DISPATCHER_SLOWSTART_TIME = 10000;
    private static final int TOTAL_PUTS = 5;

    public Bug36853EventsExpiryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Bug36853EventsExpiryDUnitTest.disconnectAllFromDS();
        super.setUp();
        Host host = Host.getHost(0);
        this.server = host.getVM(0);
        this.client = host.getVM(1);
        this.server.invoke(ConflationDUnitTest.class, "setIsSlowStart");
        int PORT2 = (Integer)this.server.invoke(Bug36853EventsExpiryDUnitTest.class, "createServerCache");
        this.client.invoke(Bug36853EventsExpiryDUnitTest.class, "createClientCache", new Object[]{Bug36853EventsExpiryDUnitTest.getServerHostName(host), new Integer(PORT2)});
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug36853EventsExpiryDUnitTest.assertNotNull((Object)cache);
    }

    public static Integer createServerCache() throws Exception {
        System.setProperty("gemfire.MessageTimeToLive", "1");
        System.setProperty("slowStartTimeForTesting", String.valueOf(10000));
        new Bug36853EventsExpiryDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        Bug36853EventsExpiryDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(String hostName, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new Bug36853EventsExpiryDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        BridgeTestCase.configureConnectionPool(factory, hostName, port, -1, true, -1, 2, null);
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                String key = (String)event.getKey();
                Log.getLogWriter().info("client2 : afterCreate : key =" + key);
                if (key.equals(Bug36853EventsExpiryDUnitTest.LAST_KEY)) {
                    Class<Bug36853EventsExpiryDUnitTest> clazz = Bug36853EventsExpiryDUnitTest.class;
                    synchronized (Bug36853EventsExpiryDUnitTest.class) {
                        Log.getLogWriter().info("Notifying client2 to proceed for validation");
                        proceedForValidation = true;
                        Bug36853EventsExpiryDUnitTest.class.notify();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                } else {
                    ++putsRecievedByClient;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS");
    }

    public static void generateEvents() throws Exception {
        int i;
        String regionName = "/Bug36853EventsExpiryDUnitTest_region";
        Region region = cache.getRegion(regionName);
        for (i = 0; i < 5; ++i) {
            region.put((Object)("key" + i), (Object)("val-" + i));
        }
        Thread.sleep(11000L);
        for (i = 0; i < 25; ++i) {
            region.put((Object)LAST_KEY, (Object)"LAST_VALUE");
        }
    }

    public void testEventsExpiryBug() throws Exception {
        this.server.invoke(Bug36853EventsExpiryDUnitTest.class, "generateEvents");
        this.client.invoke(Bug36853EventsExpiryDUnitTest.class, "validateEventCountAtClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void validateEventCountAtClient() throws Exception {
        if (!proceedForValidation) {
            Class<Bug36853EventsExpiryDUnitTest> clazz = Bug36853EventsExpiryDUnitTest.class;
            // MONITORENTER : com.gemstone.gemfire.internal.cache.ha.Bug36853EventsExpiryDUnitTest.class
            if (!proceedForValidation) {
                try {
                    Log.getLogWriter().info("Client2 going in wait before starting validation");
                    Bug36853EventsExpiryDUnitTest.class.wait(5000L);
                }
                catch (InterruptedException e) {
                    Bug36853EventsExpiryDUnitTest.fail((String)"interrupted");
                }
            }
            // MONITOREXIT : clazz
        }
        Log.getLogWriter().info("Starting validation on client2");
        Assert.assertEquals((String)"Puts recieved by client not equal to the puts done at server.", (int)5, (int)putsRecievedByClient);
        Log.getLogWriter().info("putsRecievedByClient = " + putsRecievedByClient);
        Log.getLogWriter().info("Validation complete on client2");
    }

    public static void closeCache() {
        System.setProperty("gemfire.MessageTimeToLive", "");
        CacheTestCase.closeCache();
    }

    @Override
    public void tearDown2() throws Exception {
        this.client.invoke(Bug36853EventsExpiryDUnitTest.class, "closeCache");
        this.server.invoke(Bug36853EventsExpiryDUnitTest.class, "closeCache");
    }
}

