/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.execute.DefaultResultCollector;
import com.gemstone.gemfire.internal.cache.execute.MonthBasedPartitionResolver;
import com.gemstone.gemfire.internal.cache.execute.PerformanceTestFunction;
import com.gemstone.gemfire.internal.cache.execute.TimeKeeper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;

public class PRPerformanceTestDUnitTest
extends PartitionedRegionDUnitTestCase {
    protected static Cache cache = null;
    Properties props = new Properties();
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    static final int totalNumBuckets = 13;
    static ArrayList listOfKeys = new ArrayList();
    protected static final byte[] valueArray = new byte[1024];
    SerializableRunnable createPrRegionWithPartitionResolver = new CacheSerializableRunnable("createPrRegionWithDS"){

        @Override
        public void run2() throws CacheException {
            AttributesFactory attr = new AttributesFactory();
            MonthBasedPartitionResolver resolver = MonthBasedPartitionResolver.getInstance();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setTotalNumBuckets(13);
            paf.setPartitionResolver((PartitionResolver)resolver);
            paf.setLocalMaxMemory(900);
            paf.setRedundantCopies(0);
            PartitionAttributes prAttr = paf.create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
            PerformanceTestFunction function = new PerformanceTestFunction();
            FunctionService.registerFunction((Function)function);
        }
    };
    SerializableRunnable createPrRegionOnlyAccessorWithPartitionResolver = new CacheSerializableRunnable("createPrRegionOnlyAccessor"){

        @Override
        public void run2() throws CacheException {
            AttributesFactory attr = new AttributesFactory();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            MonthBasedPartitionResolver resolver = MonthBasedPartitionResolver.getInstance();
            PartitionAttributes prAttr = paf.setLocalMaxMemory(0).setTotalNumBuckets(13).setPartitionResolver((PartitionResolver)resolver).setRedundantCopies(0).create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
        }
    };

    public PRPerformanceTestDUnitTest(String name) {
        super(name);
    }

    public static void createCacheInVm() throws Exception {
        Properties props = new Properties();
        new PRPerformanceTestDUnitTest("temp").createCache(props);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        PRPerformanceTestDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PRPerformanceTestDUnitTest.assertNotNull((Object)cache);
    }

    public static boolean searchForKey(PartitionedRegion par, Date key) {
        boolean foundIt = false;
        int numBucks = par.getTotalNumberOfBuckets();
        for (int b = 0; b < numBucks; ++b) {
            if (!par.getBucketKeys(b).contains(key)) continue;
            foundIt = true;
            break;
        }
        if (!foundIt) {
            PRPerformanceTestDUnitTest.getLogWriter().severe("Key " + key + " not found in any bucket");
        }
        return foundIt;
    }

    public void partitionedRegionTest(final String prName, final int noOfEntries) {
        this.vm0.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations1"){

            @Override
            public void run2() throws CacheException {
                Calendar cal = Calendar.getInstance();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                int size = 0;
                size = pr.size();
                TestCase.assertEquals((String)"Size doesnt return expected value", (int)0, (int)size);
                TestCase.assertEquals((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)true, (boolean)pr.isEmpty());
                TestCase.assertEquals((int)0, (int)pr.keySet().size());
                for (int entries = noOfEntries; entries > 0; --entries) {
                    int i = 0;
                    while (i <= 11) {
                        int yr = new Integer((int)(Math.random() * 2100.0));
                        int month = i++;
                        int date = new Integer((int)(Math.random() * 30.0));
                        cal.set(yr, month, date);
                        Date key = cal.getTime();
                        listOfKeys.add(key);
                        TestCase.assertNotNull((Object)pr);
                        pr.put((Object)key, (Object)valueArray);
                    }
                }
            }
        });
        this.vm0.invoke(new CacheSerializableRunnable("verifyKeysonVM0"){

            @Override
            public void run2() throws CacheException {
                Object val;
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                Iterator itr = listOfKeys.iterator();
                while (itr.hasNext()) {
                    TestCase.assertTrue((boolean)PRPerformanceTestDUnitTest.searchForKey(pr, (Date)itr.next()));
                }
                itr = listOfKeys.iterator();
                ArrayList<Object> vals = new ArrayList<Object>();
                while (itr.hasNext()) {
                    Object val2 = pr.get(itr.next());
                    TestCase.assertNotNull((Object)val2);
                    vals.add(val2);
                }
                PerformanceTestFunction function = new PerformanceTestFunction();
                FunctionService.registerFunction((Function)function);
                DefaultResultCollector drc = new DefaultResultCollector();
                HashSet singleKeySet = new HashSet();
                Execution dataSet = FunctionService.onRegion((Region)pr);
                vals.clear();
                ArrayList list = new ArrayList();
                itr = listOfKeys.iterator();
                while (itr.hasNext()) {
                    singleKeySet.add(itr.next());
                    dataSet = dataSet.withFilter(singleKeySet);
                    try {
                        ResultCollector rc = dataSet.execute(function.getId());
                        list = (ArrayList)rc.getResult();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("Exception Occured :" + ex.getMessage());
                        DistributedTestCase.fail("Test failed", ex);
                    }
                    Object val3 = list.get(0);
                    TestCase.assertNotNull(val3);
                    vals.add(val3);
                    singleKeySet.clear();
                }
                TestCase.assertEquals((int)vals.size(), (int)listOfKeys.size());
                itr = listOfKeys.iterator();
                TimeKeeper t = new TimeKeeper();
                vals.clear();
                t.start();
                while (itr.hasNext()) {
                    val = pr.get(itr.next());
                    TestCase.assertNotNull((Object)val);
                    vals.add(val);
                }
                t.stop();
                DistributedTestCase.getLogWriter().info("Time taken to iterate over " + vals.size() + " no. of keys: " + t.getTimeInMs() + " ms");
                vals.clear();
                t = new TimeKeeper();
                t.start();
                itr = listOfKeys.iterator();
                while (itr.hasNext()) {
                    singleKeySet.add(itr.next());
                    dataSet = dataSet.withFilter(singleKeySet);
                    try {
                        ResultCollector rc = dataSet.execute(function.getId());
                        list = (ArrayList)rc.getResult();
                    }
                    catch (Exception rc) {
                        // empty catch block
                    }
                    val = list.get(0);
                    TestCase.assertNotNull((Object)val);
                    vals.add(val);
                    singleKeySet.clear();
                }
                t.stop();
                TestCase.assertEquals((int)vals.size(), (int)listOfKeys.size());
                DistributedTestCase.getLogWriter().info("Time taken to iterate over " + vals.size() + " no. of keys using FunctionExecution: " + t.getTimeInMs() + " ms");
            }
        });
    }

    public void testPartitionedRegionOperationsCustomPartitioning() throws Exception {
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        VM accessor = this.vm0;
        accessor.invoke(PRPerformanceTestDUnitTest.class, "createCacheInVm");
        this.vm1.invoke(PRPerformanceTestDUnitTest.class, "createCacheInVm");
        this.vm2.invoke(PRPerformanceTestDUnitTest.class, "createCacheInVm");
        this.vm3.invoke(PRPerformanceTestDUnitTest.class, "createCacheInVm");
        accessor.invoke(this.createPrRegionOnlyAccessorWithPartitionResolver);
        this.vm1.invoke(this.createPrRegionWithPartitionResolver);
        this.vm2.invoke(this.createPrRegionWithPartitionResolver);
        this.vm3.invoke(this.createPrRegionWithPartitionResolver);
        this.partitionedRegionTest("/PR1", 50);
        this.destroyTheRegion("/PR1");
    }

    public void destroyTheRegion(final String name) {
        this.vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() throws CacheException {
                Region pr = cache.getRegion(name);
                if (pr == null) {
                    TestCase.fail((String)(name + " not created"));
                }
                pr.destroyRegion();
            }
        });
    }
}

