/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

class MonthBasedPartitionResolver
implements PartitionResolver,
Declarable2 {
    private static MonthBasedPartitionResolver mbrResolver = null;
    static final String id = "MonthBasedPartitionResolverid1";
    private Properties properties;
    private String resolverName;

    public static MonthBasedPartitionResolver getInstance() {
        if (mbrResolver == null) {
            mbrResolver = new MonthBasedPartitionResolver();
        }
        return mbrResolver;
    }

    public Serializable getRoutingObject(EntryOperation opDetails) {
        Serializable routingObj = (Serializable)opDetails.getKey();
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)routingObj);
        return new SerializableMonth(cal.get(2));
    }

    public void close() {
    }

    public void init(Properties props) {
        this.properties = props;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MonthBasedPartitionResolver) {
            return id.equals(id);
        }
        return false;
    }

    public String getName() {
        return this.resolverName;
    }

    public Properties getConfig() {
        return this.properties;
    }

    class SerializableMonth
    implements DataSerializable {
        private int month;

        public SerializableMonth(int month) {
            this.month = month;
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.month = in.readInt();
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.month);
        }

        public int hashCode() {
            if (this.month < 4) {
                return 1;
            }
            if (this.month >= 4 && this.month < 8) {
                return 2;
            }
            return 3;
        }
    }
}

