/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LonerDistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionExecutionException;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.Host;
import dunit.VM;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import util.ClassBuilder;

public class MemberFunctionExecutionDUnitTest
extends CacheTestCase {
    private static final String TEST_FUNCTION6 = "TestFunction6";
    private static final String TEST_FUNCTION5 = "TestFunction5";
    private static final long serialVersionUID = 1L;
    VM member1 = null;
    VM member2 = null;
    VM member3 = null;
    VM member4 = null;
    static InternalDistributedSystem ds = null;

    public MemberFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.member1 = host.getVM(0);
        this.member2 = host.getVM(1);
        this.member3 = host.getVM(2);
        this.member4 = host.getVM(3);
    }

    public void testRemoteMultiKeyExecution() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers", new Object[]{new Integer(5)});
    }

    public void testRemoteMultiKeyExecution_SendException1() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_SendException", new Object[]{new Integer(1)});
    }

    public void testRemoteMultiKeyExecution_SendException2() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_SendException", new Object[]{new Integer(4)});
    }

    public void testRemoteMultiKeyExecution_SendException3() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_SendException", new Object[]{new Integer(5)});
    }

    public void testRemoteMultiKeyExecution_NoLastResult() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_NoLastResult", new Object[]{new Integer(5)});
    }

    public void testLocalMultiKeyExecution_NoLastResult() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_NoLastResult", new Object[]{new Integer(1)});
    }

    public void testRemoteMultiKeyExecution_InlineFunction() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_InlineFunction", new Object[]{new Integer(5)});
    }

    public void testBug45328() throws Exception {
        block2: {
            this.createDistributedSystemAndRegisterFunction();
            ClassBuilder classBuilder = new ClassBuilder();
            String functionId = "MemberFunctionExecutionDUnitFunction";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("import java.util.Properties;import com.gemstone.gemfire.cache.Declarable;");
            stringBuffer.append("import com.gemstone.gemfire.cache.CacheFactory;");
            stringBuffer.append("import com.gemstone.gemfire.cache.execute.Function;");
            stringBuffer.append("import com.gemstone.gemfire.cache.execute.FunctionContext;");
            stringBuffer.append("public class ").append("MemberFunctionExecutionDUnitFunction").append(" implements Function, Declarable {");
            stringBuffer.append("public void init(Properties props) {}");
            stringBuffer.append("public boolean hasResult() {return true;}");
            stringBuffer.append("public void execute(FunctionContext context) {context.getResultSender().lastResult(\"GOOD\");}");
            stringBuffer.append("public String getId() {return \"MemberFunctionExecutionDUnitFunction\";}");
            stringBuffer.append("public boolean optimizeForWrite() {return false;}");
            stringBuffer.append("public boolean isHA() {return false;}}");
            ClassLoader classLoader = classBuilder.createClassLoaderFromContent("MemberFunctionExecutionDUnitFunction", stringBuffer.toString());
            Class<?> clazz = Class.forName("MemberFunctionExecutionDUnitFunction", true, classLoader);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Function function = (Function)constructor.newInstance(new Object[0]);
            InternalDistributedSystem distributedSystem = this.getSystem();
            Execution execution = FunctionService.onMembers((DistributedSystem)distributedSystem);
            ResultCollector resultCollector = execution.execute(function);
            try {
                resultCollector.getResult();
                MemberFunctionExecutionDUnitTest.fail((String)"Should have received FunctionException due to class not found");
            }
            catch (FunctionException expected) {
                MemberFunctionExecutionDUnitTest.getLogWriter().warning("received wrong exception cause", expected.getCause());
                if (expected.getCause() instanceof ClassNotFoundException) break block2;
                throw expected;
            }
        }
    }

    public void testBug40714() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "registerFunction");
        this.member2.invoke(MemberFunctionExecutionDUnitTest.class, "registerFunction");
        this.member3.invoke(MemberFunctionExecutionDUnitTest.class, "registerFunction");
        this.member4.invoke(MemberFunctionExecutionDUnitTest.class, "registerFunction");
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_InlineFunction", new Object[]{new Integer(5)});
    }

    public void testBug46129() throws Exception {
        Properties props = new Properties();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "connectToDistributedSystem", new Object[]{props});
        this.member2.invoke(MemberFunctionExecutionDUnitTest.class, "connectToDistributedSystem", new Object[]{props});
        this.member3.invoke(MemberFunctionExecutionDUnitTest.class, "connectToDistributedSystem", new Object[]{props});
        this.member4.invoke(MemberFunctionExecutionDUnitTest.class, "connectToDistributedSystem", new Object[]{props});
        MemberFunctionExecutionDUnitTest.connectToDistributedSystem(props);
        AbstractExecution exe = (AbstractExecution)FunctionService.onMembers((DistributedSystem)this.getSystem());
        exe.setIgnoreDepartedMembers(true);
        ResultCollector rs = exe.execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                try {
                    Object arg = context.getArguments();
                    if (arg == null || !(arg instanceof Map)) {
                        throw new IllegalArgumentException("dummy");
                    }
                    context.getResultSender().lastResult((Object)"ok");
                }
                catch (Exception e) {
                    context.getResultSender().sendException((Throwable)e);
                }
            }

            public String getId() {
                return "testBug46129";
            }
        });
        List resultList = (List)rs.getResult();
        Exception e = (Exception)resultList.get(0);
        MemberFunctionExecutionDUnitTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
        IllegalArgumentException ex = (IllegalArgumentException)e;
        MemberFunctionExecutionDUnitTest.assertEquals((String)"dummy", (String)ex.getMessage());
    }

    public static void registerFunction() {
        FunctionService.registerFunction((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Failure");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.FALSE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        });
    }

    public void testRemoteMultiKeyExecutionNoResult() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembersNoResult");
    }

    public void testRemoteMultiKeyExecutiononLocalMember() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers", new Object[]{new Integer(1)});
    }

    public void testRemoteMultiKeyExecutiononLocalMember_InlineFunction() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_InlineFunction", new Object[]{new Integer(1)});
    }

    public void testRemoteMultiKeyExecutiononOtherMembers() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers", new Object[]{new Integer(4)});
    }

    public void testRemoteMultiKeyExecutiononOtherMembers_InlineFunction() throws Exception {
        this.createDistributedSystemAndRegisterFunction();
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "excuteOnMembers_InlineFunction", new Object[]{new Integer(4)});
    }

    public void testBug41118() throws Exception {
        this.member1.invoke(MemberFunctionExecutionDUnitTest.class, "bug41118");
    }

    public static void bug41118() {
        ds = new MemberFunctionExecutionDUnitTest("temp").getSystem();
        MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        ds = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
        DM dm = ds.getDistributionManager();
        MemberFunctionExecutionDUnitTest.assertEquals((String)"Distributed System is not loner", (boolean)true, (boolean)(dm instanceof LonerDistributionManager));
        InternalDistributedMember localmember = ds.getDistributedMember();
        Execution memberExcution = null;
        memberExcution = FunctionService.onMember((DistributedSystem)ds, (DistributedMember)localmember);
        Execution executor = memberExcution.withArgs((Object)"Key");
        try {
            ResultCollector rc = executor.execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else {
                        context.getResultSender().lastResult((Object)"Failure");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            ArrayList li = (ArrayList)rc.getResult();
            MemberFunctionExecutionDUnitTest.getLogWriter().info("MemberFunctionExecutionDUnitTest#excuteOnMembers: Result : " + li);
            MemberFunctionExecutionDUnitTest.assertEquals((int)li.size(), (int)1);
            for (Object obj : li) {
                MemberFunctionExecutionDUnitTest.assertEquals(obj, (Object)"Success");
            }
            ds.disconnect();
        }
        catch (Exception e) {
            MemberFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + e.getMessage());
            e.printStackTrace();
            MemberFunctionExecutionDUnitTest.fail("Test failed", e);
        }
    }

    public static void excuteOnMembers(Integer noOfMembers) {
        HashSet memberSet;
        MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        TestFunction function = new TestFunction(true, "MemberFunction");
        InternalExecution memberExcution = null;
        InternalExecution executor = null;
        HashMap<String, String> memArgs = new HashMap<String, String>();
        if (noOfMembers == 1) {
            InternalDistributedMember localmember = ds.getDistributedMember();
            memberExcution = (InternalExecution)FunctionService.onMember((DistributedSystem)ds, (DistributedMember)localmember);
            memArgs.put(localmember.getId(), localmember.getId());
            MemberMappedArgument args = new MemberMappedArgument((Object)"Key", memArgs);
            executor = memberExcution.withMemberMappedArgument(args);
        } else if (noOfMembers == 5) {
            memberExcution = (InternalExecution)FunctionService.onMembers((DistributedSystem)ds);
            memberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
            for (InternalDistributedMember member : memberSet) {
                memArgs.put(member.getId(), member.getId());
            }
            MemberMappedArgument args = new MemberMappedArgument((Object)"Key", memArgs);
            executor = memberExcution.withMemberMappedArgument(args);
        } else {
            memberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
            InternalDistributedMember localVM = ds.getDistributionManager().getDistributionManagerId();
            memberSet.remove(localVM);
            for (InternalDistributedMember member : memberSet) {
                memArgs.put(member.getId(), member.getId());
            }
            MemberMappedArgument args = new MemberMappedArgument((Object)"Key", memArgs);
            memberExcution = (InternalExecution)FunctionService.onMembers((DistributedSystem)ds, memberSet);
            executor = memberExcution.withMemberMappedArgument(args);
        }
        try {
            ResultCollector rc = executor.execute(function.getId());
            ArrayList li = (ArrayList)rc.getResult();
            MemberFunctionExecutionDUnitTest.getLogWriter().info("MemberFunctionExecutionDUnitTest#excuteOnMembers: Result : " + li);
            MemberFunctionExecutionDUnitTest.assertEquals((int)li.size(), (int)noOfMembers);
            for (Object obj : li) {
                MemberFunctionExecutionDUnitTest.assertEquals(obj, (Object)"Success");
            }
        }
        catch (Exception e) {
            MemberFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + e.getMessage());
            e.printStackTrace();
            MemberFunctionExecutionDUnitTest.fail("Test failed", e);
        }
    }

    public static void excuteOnMembers_SendException(Integer noOfMembers) {
        MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        TestFunction function = new TestFunction(true, "executeFunction_SendException");
        InternalExecution memberExcution = null;
        new HashMap();
        if (noOfMembers == 1) {
            InternalDistributedMember localmember = ds.getDistributedMember();
            memberExcution = (InternalExecution)FunctionService.onMember((DistributedSystem)ds, (DistributedMember)localmember);
        } else if (noOfMembers == 5) {
            memberExcution = (InternalExecution)FunctionService.onMembers((DistributedSystem)ds);
        } else {
            HashSet memberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
            InternalDistributedMember localVM = ds.getDistributionManager().getDistributionManagerId();
            memberSet.remove(localVM);
            Iterator iter = memberSet.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            memberExcution = (InternalExecution)FunctionService.onMembers((DistributedSystem)ds, memberSet);
        }
        try {
            ResultCollector rc = memberExcution.withArgs((Object)Boolean.TRUE).execute((Function)function);
            ArrayList li = (ArrayList)rc.getResult();
            MemberFunctionExecutionDUnitTest.getLogWriter().info("MemberFunctionExecutionDUnitTest#excuteOnMembers: Result : " + li);
            MemberFunctionExecutionDUnitTest.assertEquals((int)noOfMembers, (int)li.size());
            for (Object obj : li) {
                MemberFunctionExecutionDUnitTest.assertTrue((boolean)(obj instanceof MyFunctionExecutionException));
            }
        }
        catch (Exception e) {
            MemberFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + e.getMessage());
            e.printStackTrace();
            MemberFunctionExecutionDUnitTest.fail("Test failed", e);
        }
    }

    public static void excuteOnMembers_NoLastResult(Integer noOfMembers) {
        HashSet memberSet;
        MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
        InternalExecution memberExcution = null;
        InternalExecution executor = null;
        HashMap<String, String> memArgs = new HashMap<String, String>();
        if (noOfMembers == 1) {
            InternalDistributedMember localmember = ds.getDistributedMember();
            memberExcution = (InternalExecution)FunctionService.onMember((DistributedSystem)ds, (DistributedMember)localmember);
            memArgs.put(localmember.getId(), localmember.getId());
            MemberMappedArgument args = new MemberMappedArgument((Object)"Key", memArgs);
            executor = memberExcution.withMemberMappedArgument(args);
        } else if (noOfMembers == 5) {
            memberExcution = (InternalExecution)FunctionService.onMembers((DistributedSystem)ds);
            memberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
            for (InternalDistributedMember member : memberSet) {
                memArgs.put(member.getId(), member.getId());
            }
            MemberMappedArgument args = new MemberMappedArgument((Object)"Key", memArgs);
            executor = memberExcution.withMemberMappedArgument(args);
        } else {
            memberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
            InternalDistributedMember localVM = ds.getDistributionManager().getDistributionManagerId();
            memberSet.remove(localVM);
            for (InternalDistributedMember member : memberSet) {
                memArgs.put(member.getId(), member.getId());
            }
            MemberMappedArgument args = new MemberMappedArgument((Object)"Key", memArgs);
            memberExcution = (InternalExecution)FunctionService.onMembers((DistributedSystem)ds, memberSet);
            executor = memberExcution.withMemberMappedArgument(args);
        }
        try {
            ResultCollector rc = executor.execute(function.getId());
            rc.getResult();
            MemberFunctionExecutionDUnitTest.fail((String)"Expcted FunctionException : Function did not send last result");
        }
        catch (Exception ex) {
            MemberFunctionExecutionDUnitTest.assertTrue((ex.getMessage().contains("did not send last result") || ex.getCause().getMessage().contains("did not send last result") ? 1 : 0) != 0);
        }
    }

    public static void excuteOnMembers_InlineFunction(Integer noOfMembers) {
        MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        Execution memberExcution = null;
        if (noOfMembers == 1) {
            InternalDistributedMember localmember = ds.getDistributedMember();
            memberExcution = FunctionService.onMember((DistributedSystem)ds, (DistributedMember)localmember);
        } else if (noOfMembers == 5) {
            memberExcution = FunctionService.onMembers((DistributedSystem)ds);
        } else {
            HashSet memberSet = new HashSet(ds.getDistributionManager().getNormalDistributionManagerIds());
            InternalDistributedMember localVM = ds.getDistributionManager().getDistributionManagerId();
            memberSet.remove(localVM);
            memberExcution = FunctionService.onMembers((DistributedSystem)ds, memberSet);
        }
        Execution executor = memberExcution.withArgs((Object)"Key");
        try {
            ResultCollector rc = executor.execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else {
                        context.getResultSender().lastResult((Object)"Failure");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            ArrayList li = (ArrayList)rc.getResult();
            MemberFunctionExecutionDUnitTest.getLogWriter().info("MemberFunctionExecutionDUnitTest#excuteOnMembers: Result : " + li);
            MemberFunctionExecutionDUnitTest.assertEquals((int)li.size(), (int)noOfMembers);
            for (Object obj : li) {
                MemberFunctionExecutionDUnitTest.assertEquals(obj, (Object)"Success");
            }
        }
        catch (Exception e) {
            MemberFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + e.getMessage());
            e.printStackTrace();
            MemberFunctionExecutionDUnitTest.fail("Test failed", e);
        }
    }

    public static void excuteOnMembersNoResult() {
        MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        TestFunction function = new TestFunction(false, TEST_FUNCTION6);
        Execution memberExcution = FunctionService.onMembers((DistributedSystem)ds);
        Execution executor = memberExcution.withArgs((Object)"Key");
        try {
            ResultCollector rc = executor.execute(function.getId());
            rc.getResult();
            MemberFunctionExecutionDUnitTest.fail((String)"Test Failed");
        }
        catch (Exception expected) {
            MemberFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + expected.getMessage());
            MemberFunctionExecutionDUnitTest.assertTrue((boolean)expected.getMessage().equals(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString(new Object[]{"return any"})));
        }
    }

    private void createDistributedSystemAndRegisterFunction() {
        Properties props = new Properties();
        MemberFunctionExecutionDUnitTest.connectToDistributedSystem(props);
        ArrayList<VM> members = new ArrayList<VM>(4);
        members.add(this.member1);
        members.add(this.member2);
        members.add(this.member3);
        members.add(this.member4);
        for (VM member : members) {
            member.invoke(MemberFunctionExecutionDUnitTest.class, "connectToDistributedSystem", new Object[]{props});
            member.invoke(MemberFunctionExecutionDUnitTest.class, "registerExpectedExceptions", new Object[]{Boolean.TRUE});
        }
    }

    public static void registerExpectedExceptions(boolean add) {
        String action = add ? "add" : "remove";
        LogWriterI18n log = InternalDistributedSystem.getLoggerI18n();
        if (log != null) {
            log.convertToLogWriter().info("<ExpectedException action=" + action + ">ClassNotFoundException</ExpectedException>");
        }
    }

    public static void connectToDistributedSystem(Properties props) {
        new MemberFunctionExecutionDUnitTest("temp").createSystem(props);
    }

    private InternalDistributedSystem createSystem(Properties props) {
        try {
            ds = this.getSystem(props);
            MemberFunctionExecutionDUnitTest.assertNotNull((Object)ds);
            FunctionService.registerFunction((Function)new TestFunction(true, TEST_FUNCTION5));
            FunctionService.registerFunction((Function)new TestFunction(false, TEST_FUNCTION6));
            FunctionService.registerFunction((Function)new TestFunction(true, "MemberFunction"));
            FunctionService.registerFunction((Function)new TestFunction(true, "executeFunctionWithoutLastResult"));
        }
        catch (Exception e) {
            MemberFunctionExecutionDUnitTest.fail("Failed while creating the Distribued System", e);
        }
        return ds;
    }

    @Override
    public void tearDown2() throws Exception {
        ArrayList<VM> members = new ArrayList<VM>(4);
        members.add(this.member1);
        members.add(this.member2);
        members.add(this.member3);
        members.add(this.member4);
        for (VM member : members) {
            member.invoke(MemberFunctionExecutionDUnitTest.class, "registerExpectedExceptions", new Object[]{Boolean.FALSE});
        }
        super.tearDown2();
        MemberFunctionExecutionDUnitTest.disconnectAllFromDS();
    }
}

