/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LonerDistributionManager;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionException;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionExecutionException;
import com.gemstone.gemfire.internal.cache.functions.DistribuedRegionFunctionFunctionInvocationException;
import com.gemstone.gemfire.internal.cache.functions.DistributedRegionFunction;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DistributedRegionFunctionExecutionDUnitTest
extends DistributedTestCase {
    VM replicate1 = null;
    VM replicate2 = null;
    VM replicate3 = null;
    VM normal = null;
    public static final String REGION_NAME = "DistributedRegionFunctionExecutionDUnitTest";
    public static Cache cache = null;
    public static Region region = null;
    public static final Function function = new DistributedRegionFunction();
    public static final Function functionWithNoResultThrowsException = new MyFunctionException();

    public DistributedRegionFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.replicate1 = host.getVM(0);
        this.replicate2 = host.getVM(1);
        this.replicate3 = host.getVM(2);
        this.normal = host.getVM(3);
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.executeFunction();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_SendException() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.executeFunction_SendException();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_NoLastResult() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.executeFunction_NoLastResult();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyNormal() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        try {
            this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunction");
            DistributedRegionFunctionExecutionDUnitTest.fail((String)"Function execution was expecting an Exception as it was executed on Region with DataPolicy.NORMAL");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunction");
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate_SendException() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunction_SendException");
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate_NoLastResult() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunction_NoLastResult");
    }

    public void testDistributedRegionFunctionExecutionWithFunctionInvocationTargetException() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(true), new Integer(5));
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunctionFunctionInvocationTargetException");
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionWithFunctionInvocationTargetException_WithoutHA() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(false), new Integer(0));
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunctionFunctionInvocationTargetExceptionWithoutHA");
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionWithFunctionInvocationTargetExceptionForEmptyDataPolicy() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(true), new Integer(5));
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionFunctionInvocationTargetException();
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionWithFunctionInvocationTargetExceptionForEmptyDataPolicy_WithoutHA() {
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(false), new Integer(0));
        DistributedRegionFunctionExecutionDUnitTest.createPeer(DataPolicy.EMPTY);
        DistributedRegionFunctionExecutionDUnitTest.populateRegion();
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionFunctionInvocationTargetExceptionWithoutHA();
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionHACacheClosedException() {
        VM empty = this.normal;
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "populateRegion");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        List l = (List)empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunctionHACacheClose");
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)5001, (int)l.size());
        for (int i = 0; i < 5001; ++i) {
            DistributedRegionFunctionExecutionDUnitTest.assertEquals(l.get(i), (Object)Boolean.TRUE);
        }
    }

    public void testDistributedRegionFunctionExecutionHANodeFailure() {
        VM empty = this.normal;
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "populateRegion");
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = empty.invokeAsync(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunctionHA");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "disconnect");
        DistributedTestCase.join(async[0], 50000L, DistributedRegionFunctionExecutionDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            DistributedRegionFunctionExecutionDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)5001, (int)l.size());
        for (int i = 0; i < 5001; ++i) {
            DistributedRegionFunctionExecutionDUnitTest.assertEquals(l.get(i), (Object)Boolean.TRUE);
        }
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_ClientServer() {
        VM empty1 = this.replicate3;
        VM empty2 = this.normal;
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        Integer port2 = (Integer)empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedRegionFunctionExecutionDUnitTest.executeFunction();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_ClientServer_SendException() {
        VM empty1 = this.replicate3;
        VM empty2 = this.normal;
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        Integer port2 = (Integer)empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedRegionFunctionExecutionDUnitTest.executeFunction_SendException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_ClientServer_NoLastResult() {
        VM empty1 = this.replicate3;
        VM empty2 = this.normal;
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        Integer port2 = (Integer)empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedTestCase.ExpectedException expectedEx = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("did not send last result", empty1);
        DistributedTestCase.ExpectedException expectedEx2 = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("did not send last result", empty2);
        try {
            DistributedRegionFunctionExecutionDUnitTest.executeFunction_NoLastResult();
        }
        finally {
            expectedEx.remove();
            expectedEx2.remove();
        }
    }

    public void testServerFailoverWithTwoServerAliveHA() throws InterruptedException {
        VM emptyServer1 = this.replicate1;
        VM client = this.normal;
        emptyServer1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        client.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInClientVm");
        Integer port1 = (Integer)emptyServer1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        this.replicate3.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        client.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createClientAndPopulateClientRegion", new Object[]{DataPolicy.EMPTY, port1, port2});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "stopServerHA");
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = client.invokeAsync(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunctionHA");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "startServerHA");
        emptyServer1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "closeCacheHA");
        DistributedTestCase.join(async[0], 240000L, DistributedRegionFunctionExecutionDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            DistributedRegionFunctionExecutionDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)5001, (int)l.size());
        for (int i = 0; i < 5001; ++i) {
            DistributedRegionFunctionExecutionDUnitTest.assertEquals(l.get(i), (Object)Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedRegionFunctionExecutionOnDataPolicyNormal_ClientServer() {
        VM normal1 = this.normal;
        VM normal2 = this.replicate3;
        VM empty = this.replicate2;
        normal1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        normal2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)normal1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.NORMAL});
        Integer port2 = (Integer)normal2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.NORMAL});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("DataPolicy.NORMAL is not supported");
        try {
            DistributedRegionFunctionExecutionDUnitTest.executeFunction();
            DistributedRegionFunctionExecutionDUnitTest.fail((String)"Function execution was expecting an Exception as it was executed on Region with DataPolicy.NORMAL");
        }
        catch (Exception expected) {
            DistributedRegionFunctionExecutionDUnitTest.assertTrue((String)("Got unexpected exception message: " + expected), (boolean)expected.getMessage().contains("DataPolicy.NORMAL is not supported"));
        }
        finally {
            ex.remove();
        }
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate_ClientServer() {
        VM empty = this.replicate3;
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedRegionFunctionExecutionDUnitTest.executeUnregisteredFunction();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate_ClientServer_WithoutRegister() {
        VM empty = this.replicate3;
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedRegionFunctionExecutionDUnitTest.executeFunction();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate_ClientServer_FunctionInvocationTargetException() {
        VM empty = this.replicate3;
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(true), new Integer(5));
        Integer port1 = (Integer)this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionFunctionInvocationTargetException_ClientServer();
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyReplicate_ClientServer_FunctionInvocationTargetException_WithoutHA() {
        VM empty = this.replicate3;
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(false), new Integer(0));
        Integer port1 = (Integer)this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.NORMAL});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionFunctionInvocationTargetException_ClientServer_WithoutHA();
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_ClientServer_FunctionInvocationTargetException() {
        VM empty1 = this.replicate3;
        VM empty2 = this.normal;
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(true), new Integer(5));
        Integer port1 = (Integer)empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        Integer port2 = (Integer)empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(true), new Integer(5)});
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionFunctionInvocationTargetException_ClientServer();
        ex.remove();
    }

    public void testDistributedRegionFunctionExecutionOnDataPolicyEmpty_ClientServer_FunctionInvocationTargetException_WithoutHA() {
        VM empty1 = this.replicate3;
        VM empty2 = this.normal;
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        DistributedRegionFunctionExecutionDUnitTest.registerFunction(new Boolean(false), new Integer(0));
        Integer port1 = (Integer)empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        Integer port2 = (Integer)empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.EMPTY});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        empty1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        empty2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction", new Object[]{new Boolean(false), new Integer(0)});
        DistributedTestCase.ExpectedException ex = DistributedRegionFunctionExecutionDUnitTest.addExpectedException("I have been thrown");
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionFunctionInvocationTargetException_ClientServer_WithoutHA();
        ex.remove();
    }

    public void testBug40714() {
        VM empty = this.replicate3;
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        Integer port1 = (Integer)this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createPeer", new Object[]{DataPolicy.REPLICATE});
        this.normal.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction");
        empty.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction");
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "registerFunction");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInVm();
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedRegionFunctionExecutionDUnitTest.registerFunction();
        DistributedRegionFunctionExecutionDUnitTest.executeInlineFunction();
    }

    public void testBug41118() {
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "bug41118");
    }

    public void testBug41367() {
        VM client = this.replicate1;
        VM server = this.replicate2;
        server.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm_41367");
        client.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInClientVm_41367");
        Integer port1 = (Integer)server.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        client.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createClient_41367", new Object[]{port1});
        for (int i = 0; i < 3; ++i) {
            try {
                client.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "executeFunction_NoResult");
                client.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "put");
                continue;
            }
            catch (Exception e) {
                DistributedRegionFunctionExecutionDUnitTest.fail((String)("Exception " + e + " not expected"));
                e.printStackTrace();
            }
        }
    }

    public void testFunctionWithNoResultThrowsException() {
        this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createCacheInVm");
        DistributedRegionFunctionExecutionDUnitTest.createCacheInClientVm();
        Integer port1 = (Integer)this.replicate1.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        Integer port2 = (Integer)this.replicate2.invoke(DistributedRegionFunctionExecutionDUnitTest.class, "createServer", new Object[]{DataPolicy.REPLICATE});
        DistributedRegionFunctionExecutionDUnitTest.createClientAndPopulateClientRegion(DataPolicy.EMPTY, port1, port2);
        DistributedRegionFunctionExecutionDUnitTest.executeFunctionWithNoResultThrowException();
        DistributedRegionFunctionExecutionDUnitTest.pause(10000);
    }

    public static void executeFunction_NoResult() {
        TestFunction function = new TestFunction(false, "TestFunction1");
        Execution dataset = FunctionService.onRegion((Region)region);
        dataset.execute((Function)function);
    }

    public static void put() {
        region.put((Object)"K1", (Object)"B1");
    }

    public static void bug41118() {
        InternalDistributedSystem ds = new DistributedRegionFunctionExecutionDUnitTest("temp").getSystem();
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        ds = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
        DM dm = ds.getDistributionManager();
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((String)"Distributed System is not loner", (boolean)true, (boolean)(dm instanceof LonerDistributionManager));
        Cache cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(REGION_NAME, factory.create());
        try {
            DistributedRegionFunctionExecutionDUnitTest.executeInlineFunction();
            ds.disconnect();
        }
        catch (Exception e) {
            DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + e.getMessage());
            e.printStackTrace();
            DistributedRegionFunctionExecutionDUnitTest.fail("Test failed", e);
        }
    }

    public static void executeInlineFunction() {
        List list = (List)FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Success");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.TRUE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        }).getResult();
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)list.size());
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, list.get(0));
    }

    public static void registerFunction() {
        FunctionService.registerFunction((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Failure");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.FALSE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        });
    }

    public static void registerFunction(Boolean isHA, Integer retryCount) {
        DistribuedRegionFunctionFunctionInvocationException function = new DistribuedRegionFunctionFunctionInvocationException(isHA, retryCount);
        FunctionService.registerFunction((Function)function);
    }

    public static void createCacheInVm() {
        new DistributedRegionFunctionExecutionDUnitTest("temp").createCache(new Properties());
    }

    public static void createCacheInVm_41367() {
        Properties props = new Properties();
        props.put("name", "SecurityServer");
        props.put("security-client-authenticator", "templates.security.DummyAuthenticator.create");
        new DistributedRegionFunctionExecutionDUnitTest("temp").createCache(props);
    }

    public static void createCacheInClientVm() {
        Properties props = new Properties();
        props.put("mcast-port", "0");
        props.put("locators", "");
        new DistributedRegionFunctionExecutionDUnitTest("temp").createCache(new Properties());
    }

    public static void createCacheInClientVm_41367() {
        Properties props = new Properties();
        props.put("mcast-port", "0");
        props.put("locators", "");
        props.put("name", "SecurityClient");
        props.put("security-client-auth-init", "templates.security.UserPasswordAuthInit.create");
        props.put("security-username", "reader1");
        props.put("security-password", "reader1");
        new DistributedRegionFunctionExecutionDUnitTest("temp").createCache(props);
    }

    public static void executeFunction() {
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        FunctionService.onRegion((Region)region).withFilter(filter).execute(function).getResult();
    }

    public static void executeFunctionWithNoResultThrowException() {
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        FunctionService.onRegion((Region)region).withFilter(filter).execute(functionWithNoResultThrowsException);
    }

    public static void executeFunction_SendException() {
        TestFunction function = new TestFunction(true, "executeFunction_SendException");
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        ResultCollector rs = FunctionService.onRegion((Region)region).withFilter(filter).withArgs((Object)Boolean.TRUE).execute((Function)function);
        List list = (List)rs.getResult();
        DistributedRegionFunctionExecutionDUnitTest.assertTrue((boolean)(list.get(0) instanceof MyFunctionExecutionException));
        rs = FunctionService.onRegion((Region)region).withFilter(filter).withArgs((Object)filter).execute((Function)function);
        List resultList = (List)rs.getResult();
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)(filter.size() + 1), (int)resultList.size());
        Iterator resultIterator = resultList.iterator();
        int exceptionCount = 0;
        while (resultIterator.hasNext()) {
            Object o = resultIterator.next();
            if (!(o instanceof MyFunctionExecutionException)) continue;
            ++exceptionCount;
        }
        DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)exceptionCount);
    }

    public static void executeFunction_NoLastResult() {
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        try {
            FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)new TestFunction(true, "executeFunctionWithoutLastResult")).getResult();
            DistributedRegionFunctionExecutionDUnitTest.fail((String)"FunctionException expected : Function did not send last result");
        }
        catch (Exception ex) {
            DistributedRegionFunctionExecutionDUnitTest.assertTrue((boolean)ex.getMessage().contains("did not send last result"));
        }
    }

    public static void executeUnregisteredFunction() {
        FunctionService.unregisterFunction((String)function.getId());
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        FunctionService.onRegion((Region)region).withFilter(filter).execute(function).getResult();
    }

    public static void executeFunctionFunctionInvocationTargetException() {
        try {
            ResultCollector rc1 = FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute("DistribuedRegionFunctionFunctionInvocationException");
            ArrayList list = (ArrayList)rc1.getResult();
            DistributedRegionFunctionExecutionDUnitTest.assertEquals((Object)5, list.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            DistributedRegionFunctionExecutionDUnitTest.fail("This is not expected Exception", e);
        }
    }

    public static void executeFunctionFunctionInvocationTargetExceptionWithoutHA() {
        block2: {
            try {
                ResultCollector rc1 = FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute("DistribuedRegionFunctionFunctionInvocationException", true, false);
                rc1.getResult();
                DistributedRegionFunctionExecutionDUnitTest.fail((String)"Function Invocation Target Exception should be thrown");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() instanceof FunctionInvocationTargetException) break block2;
                DistributedRegionFunctionExecutionDUnitTest.fail((String)"FunctionInvocationTargetException should be thrown");
            }
        }
    }

    public static void executeFunctionFunctionInvocationTargetException_ClientServer() {
        try {
            ArrayList list = (ArrayList)FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute("DistribuedRegionFunctionFunctionInvocationException").getResult();
            DistributedRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)list.size());
            DistributedRegionFunctionExecutionDUnitTest.assertEquals((Object)5, list.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            DistributedRegionFunctionExecutionDUnitTest.fail("This is not expected Exception", e);
        }
    }

    public static void executeFunctionFunctionInvocationTargetException_ClientServer_WithoutHA() {
        block2: {
            try {
                FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute("DistribuedRegionFunctionFunctionInvocationException", true, false).getResult();
                DistributedRegionFunctionExecutionDUnitTest.fail((String)"Function Invocation Target Exception should be thrown");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() instanceof FunctionInvocationTargetException) break block2;
                DistributedRegionFunctionExecutionDUnitTest.fail((String)"FunctionInvocationTargetException should be thrown");
            }
        }
    }

    public static List executeFunctionHA() {
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        List list = (List)FunctionService.onRegion((Region)region).withFilter(filter).execute(function).getResult();
        return list;
    }

    public static List executeFunctionHACacheClose() {
        HashSet<String> filter = new HashSet<String>();
        for (int i = 100; i < 120; ++i) {
            filter.add("execKey-" + i);
        }
        List list = (List)FunctionService.onRegion((Region)region).withFilter(filter).withArgs((Object)Boolean.TRUE).execute(function).getResult();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientAndPopulateClientRegion(DataPolicy policy, Integer port1, Integer port2) {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port1.intValue()).addServer("localhost", port2.intValue()).setPingInterval(3000L).setSubscriptionEnabled(false).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(2).create("DistributedRegionFunctionExecutionDUnitTest_pool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        factory.setDataPolicy(policy);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(REGION_NAME, factory.create());
        DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Client Region Created :" + region);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        for (int i = 1; i <= 200; ++i) {
            region.put((Object)("execKey-" + i), (Object)new Integer(i));
        }
    }

    public static void createClient_41367(Integer port1) {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port1.intValue()).setPingInterval(3000L).setSubscriptionEnabled(false).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(1).setMaxConnections(1).setRetryAttempts(2).create("DistributedRegionFunctionExecutionDUnitTest_pool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(REGION_NAME, factory.create());
        DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Client Region Created :" + region);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
    }

    public static Integer createServer(DataPolicy policy) {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(policy);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(REGION_NAME, factory.create());
        DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Region Created :" + region);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        CacheServer server = cache.addCacheServer();
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        try {
            server.start();
        }
        catch (IOException e) {
            DistributedRegionFunctionExecutionDUnitTest.fail("Failed to start the Server", e);
        }
        DistributedRegionFunctionExecutionDUnitTest.assertTrue((boolean)server.isRunning());
        return new Integer(server.getPort());
    }

    public static void createPeer(DataPolicy policy) {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(policy);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(REGION_NAME, factory.create());
        DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Region Created :" + region);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
    }

    public static void populateRegion() {
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.getRegion(REGION_NAME);
        DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        for (int i = 1; i <= 200; ++i) {
            region.put((Object)("execKey-" + i), (Object)new Integer(i));
        }
    }

    private void createCache(Properties props) {
        try {
            InternalDistributedSystem ds = this.getSystem(props);
            DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Created Cache on peer");
            DistributedRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
            FunctionService.registerFunction((Function)function);
        }
        catch (Exception e) {
            DistributedRegionFunctionExecutionDUnitTest.fail("DistributedRegionFunctionExecutionDUnitTest#createCache() Failed while creating the cache", e);
        }
    }

    public static void closeCache() {
        long startTime = System.currentTimeMillis();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 3000L, 200L, false);
        long endTime = System.currentTimeMillis();
        region.getCache().getLogger().fine("Time wait for Cache Close = " + (endTime - startTime));
        cache.close();
    }

    public static void startServerHA() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 2000L, 500L, false);
        List bridgeServers = cache.getCacheServers();
        DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("Start Server Bridge Servers list : " + bridgeServers.size());
        Iterator bridgeIterator = bridgeServers.iterator();
        CacheServer bridgeServer = (CacheServer)bridgeIterator.next();
        DistributedRegionFunctionExecutionDUnitTest.getLogWriter().info("start Server Bridge Server" + bridgeServer);
        try {
            bridgeServer.start();
        }
        catch (IOException e) {
            DistributedRegionFunctionExecutionDUnitTest.fail((String)"not able to start the server");
        }
    }

    public static void stopServerHA() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 1000L, 200L, false);
        try {
            Iterator iter = cache.getCacheServers().iterator();
            if (iter.hasNext()) {
                CacheServer server = (CacheServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            DistributedRegionFunctionExecutionDUnitTest.fail((String)("failed while stopServer()" + e));
        }
    }

    public static void closeCacheHA() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 1000L, 200L, false);
        if (cache != null && !cache.isClosed()) {
            try {
                Iterator iter = cache.getCacheServers().iterator();
                if (iter.hasNext()) {
                    CacheServer server = (CacheServer)iter.next();
                    server.stop();
                }
            }
            catch (Exception e) {
                DistributedRegionFunctionExecutionDUnitTest.fail((String)("failed while stopServer()" + e));
            }
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void disconnect() {
        long startTime = System.currentTimeMillis();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 2000L, 200L, false);
        long endTime = System.currentTimeMillis();
        region.getCache().getLogger().fine("Time wait for Disconnecting = " + (endTime - startTime));
        cache.getDistributedSystem().disconnect();
    }
}

