/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallback;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderFactoryImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestCase;

public class UpdateVersionDUnitTest
extends DistributedTestCase {
    protected static final String regionName = "testRegion";
    protected static Cache cache;
    private static Set<DistributedTestCase.ExpectedException> expectedExceptions;

    public UpdateVersionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        UpdateVersionDUnitTest.closeCache();
        UpdateVersionDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                UpdateVersionDUnitTest.closeCache();
            }
        });
    }

    public void testUpdateVersionAfterCreateWithSerialSender() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String key = "key-1";
        Integer lnPort = (Integer)vm0.invoke(UpdateVersionDUnitTest.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm0.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{lnPort});
        vm0.invoke(UpdateVersionDUnitTest.class, "createSender", new Object[]{"ln1", 2, false, 10, 1, false, false, null, true});
        vm0.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "ln1", 1, 1});
        vm0.invoke(UpdateVersionDUnitTest.class, "startSender", new Object[]{"ln1"});
        vm0.invoke(UpdateVersionDUnitTest.class, "waitForSenderRunningState", new Object[]{"ln1"});
        Integer nyPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "", 1, 1});
        vm3.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{nyPort});
        vm3.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "", 1, 1});
        VersionTag tag = (VersionTag)vm0.invoke(new SerializableCallable("Update a single entry and get its version"){

            public Object call() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(UpdateVersionDUnitTest.regionName);
                TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                region.put((Object)"key-1", (Object)"value-1");
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                VersionSource memberId = (VersionSource)cache.getDistributedSystem().getDistributedMember();
                VersionTag tag = VersionTag.create((VersionSource)memberId);
                int entryVersion = stamp.getEntryVersion() - 1;
                int dsid = stamp.getDistributedSystemId();
                long time = System.currentTimeMillis();
                tag.setEntryVersion(entryVersion);
                tag.setDistributedSystemId(dsid);
                tag.setVersionTimeStamp(time);
                tag.setIsRemoteForTesting();
                EntryEventImpl event = UpdateVersionDUnitTest.this.createNewEvent((LocalRegion)((PartitionedRegion)region), tag, entry.getKey(), "value-2");
                ((LocalRegion)region).basicUpdate(event, false, true, 0L, false, false);
                entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                stamp = regionEntry.getVersionStamp();
                TestCase.assertEquals((String)"Time stamp did NOT get updated by UPDATE_VERSION operation on LocalRegion", (long)time, (long)stamp.getVersionTimeStamp());
                TestCase.assertEquals((int)(++entryVersion), (int)stamp.getEntryVersion());
                TestCase.assertEquals((int)dsid, (int)stamp.getDistributedSystemId());
                return stamp.asVersionTag();
            }
        });
        VersionTag remoteTag = (VersionTag)vm3.invoke(new SerializableCallable("Get timestamp from remote site"){

            public Object call() throws Exception {
                Cache cache = CacheFactory.getAnyInstance();
                final PartitionedRegion region = (PartitionedRegion)cache.getRegion(UpdateVersionDUnitTest.regionName);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        EntrySnapshot entry = null;
                        try {
                            entry = region.getDataStore().getEntryLocally(0, (Object)"key-1", false, null, false);
                        }
                        catch (EntryNotFoundException entryNotFoundException) {
                        }
                        catch (ForceReattemptException forceReattemptException) {
                        }
                        catch (PRLocallyDestroyedException e) {
                            throw new RuntimeException("unexpected exception", e);
                        }
                        if (entry != null) {
                            DistributedTestCase.getLogWriter().info("found entry " + entry);
                        }
                        return entry != null;
                    }

                    @Override
                    public String description() {
                        return "Expected key-1 to be received on remote WAN site";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 500L, true);
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((String)("entry class is wrong: " + entry), (boolean)(entry instanceof EntrySnapshot));
                RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                return stamp.asVersionTag();
            }
        });
        UpdateVersionDUnitTest.assertEquals((String)"Local and remote site have different timestamps", (long)tag.getVersionTimeStamp(), (long)remoteTag.getVersionTimeStamp());
    }

    public void testUpdateVersionAfterCreateWithSerialSenderOnDR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String key = "key-1";
        Integer lnPort = (Integer)vm0.invoke(UpdateVersionDUnitTest.class, "createFirstLocatorWithDSId", new Object[]{1});
        vm0.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{lnPort});
        vm0.invoke(UpdateVersionDUnitTest.class, "createSender", new Object[]{"ln1", 2, false, 10, 1, false, false, null, true});
        vm0.invoke(UpdateVersionDUnitTest.class, "createReplicatedRegion", new Object[]{regionName, "ln1"});
        vm0.invoke(UpdateVersionDUnitTest.class, "startSender", new Object[]{"ln1"});
        vm0.invoke(UpdateVersionDUnitTest.class, "waitForSenderRunningState", new Object[]{"ln1"});
        Integer nyPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(UpdateVersionDUnitTest.class, "createReplicatedRegion", new Object[]{regionName, ""});
        vm3.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{nyPort});
        vm3.invoke(UpdateVersionDUnitTest.class, "createReplicatedRegion", new Object[]{regionName, ""});
        VersionTag tag = (VersionTag)vm0.invoke(new SerializableCallable("Update a single entry and get its version"){

            public Object call() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(UpdateVersionDUnitTest.regionName);
                TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                region.put((Object)"key-1", (Object)"value-1");
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof LocalRegion.NonTXEntry));
                RegionEntry regionEntry = ((LocalRegion.NonTXEntry)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                VersionSource memberId = (VersionSource)cache.getDistributedSystem().getDistributedMember();
                VersionTag tag = VersionTag.create((VersionSource)memberId);
                int entryVersion = stamp.getEntryVersion() - 1;
                int dsid = stamp.getDistributedSystemId();
                long time = System.currentTimeMillis();
                tag.setEntryVersion(entryVersion);
                tag.setDistributedSystemId(dsid);
                tag.setVersionTimeStamp(time);
                tag.setIsRemoteForTesting();
                EntryEventImpl event = UpdateVersionDUnitTest.this.createNewEvent((LocalRegion)((DistributedRegion)region), tag, entry.getKey(), "value-2");
                ((LocalRegion)region).basicUpdate(event, false, true, 0L, false, false);
                entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof LocalRegion.NonTXEntry));
                regionEntry = ((LocalRegion.NonTXEntry)entry).getRegionEntry();
                stamp = regionEntry.getVersionStamp();
                TestCase.assertEquals((String)"Time stamp did NOT get updated by UPDATE_VERSION operation on LocalRegion", (long)time, (long)stamp.getVersionTimeStamp());
                TestCase.assertEquals((int)(++entryVersion), (int)stamp.getEntryVersion());
                TestCase.assertEquals((int)dsid, (int)stamp.getDistributedSystemId());
                return stamp.asVersionTag();
            }
        });
        VersionTag remoteTag = (VersionTag)vm3.invoke(new SerializableCallable("Get timestamp from remote site"){

            public Object call() throws Exception {
                Cache cache = CacheFactory.getAnyInstance();
                final Region region = cache.getRegion(UpdateVersionDUnitTest.regionName);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.getEntry((Object)"key-1") != null;
                    }

                    @Override
                    public String description() {
                        return "Expected key-1 to be received on remote WAN site";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 500L, true);
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof LocalRegion.NonTXEntry));
                RegionEntry regionEntry = ((LocalRegion.NonTXEntry)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                return stamp.asVersionTag();
            }
        });
        UpdateVersionDUnitTest.assertEquals((String)"Local and remote site have different timestamps", (long)tag.getVersionTimeStamp(), (long)remoteTag.getVersionTimeStamp());
    }

    public void testUpdateVersionAfterCreateWithParallelSender() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        Integer lnPort = (Integer)vm0.invoke(UpdateVersionDUnitTest.class, "createFirstLocatorWithDSId", new Object[]{1});
        String key = "key-1";
        vm0.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{lnPort});
        vm0.invoke(UpdateVersionDUnitTest.class, "createSender", new Object[]{"ln1", 2, true, 10, 1, false, false, null, true});
        vm0.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "ln1", 1, 1});
        vm0.invoke(UpdateVersionDUnitTest.class, "startSender", new Object[]{"ln1"});
        vm0.invoke(UpdateVersionDUnitTest.class, "waitForSenderRunningState", new Object[]{"ln1"});
        Integer nyPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "", 1, 1});
        vm3.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{nyPort});
        vm3.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "", 1, 1});
        VersionTag tag = (VersionTag)vm0.invoke(new SerializableCallable("Put a single entry and get its version"){

            public Object call() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(UpdateVersionDUnitTest.regionName);
                TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                region.put((Object)"key-1", (Object)"value-1");
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                VersionSource memberId = (VersionSource)cache.getDistributedSystem().getDistributedMember();
                VersionTag tag = VersionTag.create((VersionSource)memberId);
                int entryVersion = stamp.getEntryVersion() - 1;
                int dsid = stamp.getDistributedSystemId();
                long time = System.currentTimeMillis();
                tag.setEntryVersion(entryVersion);
                tag.setDistributedSystemId(dsid);
                tag.setVersionTimeStamp(time);
                tag.setIsRemoteForTesting();
                EntryEventImpl event = UpdateVersionDUnitTest.this.createNewEvent((LocalRegion)((PartitionedRegion)region), tag, entry.getKey(), "value-2");
                ((LocalRegion)region).basicUpdate(event, false, true, 0L, false, false);
                entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                stamp = regionEntry.getVersionStamp();
                TestCase.assertEquals((String)"Time stamp did NOT get updated by UPDATE_VERSION operation on LocalRegion", (long)time, (long)stamp.getVersionTimeStamp());
                TestCase.assertEquals((int)(++entryVersion), (int)stamp.getEntryVersion());
                TestCase.assertEquals((int)dsid, (int)stamp.getDistributedSystemId());
                return stamp.asVersionTag();
            }
        });
        VersionTag remoteTag = (VersionTag)vm3.invoke(new SerializableCallable("Get timestamp from remote site"){

            public Object call() throws Exception {
                Cache cache = CacheFactory.getAnyInstance();
                final PartitionedRegion region = (PartitionedRegion)cache.getRegion(UpdateVersionDUnitTest.regionName);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        EntrySnapshot entry = null;
                        try {
                            entry = region.getDataStore().getEntryLocally(0, (Object)"key-1", false, null, false);
                        }
                        catch (EntryNotFoundException entryNotFoundException) {
                        }
                        catch (ForceReattemptException forceReattemptException) {
                        }
                        catch (PRLocallyDestroyedException e) {
                            throw new RuntimeException("unexpected exception", e);
                        }
                        if (entry != null) {
                            DistributedTestCase.getLogWriter().info("found entry " + entry);
                        }
                        return entry != null;
                    }

                    @Override
                    public String description() {
                        return "Expected key-1 to be received on remote WAN site";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 500L, true);
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                return stamp.asVersionTag();
            }
        });
        UpdateVersionDUnitTest.assertEquals((String)"Local and remote site have different timestamps", (long)tag.getVersionTimeStamp(), (long)remoteTag.getVersionTimeStamp());
    }

    public void testUpdateVersionAfterCreateWithConcurrentSerialSender() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        Integer lnPort = (Integer)vm0.invoke(UpdateVersionDUnitTest.class, "createFirstLocatorWithDSId", new Object[]{1});
        String key = "key-1";
        vm0.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{lnPort});
        vm0.invoke(UpdateVersionDUnitTest.class, "createConcurrentSender", new Object[]{"ln1", 2, false, 10, 2, false, false, null, true, 2});
        vm0.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "ln1", 1, 1});
        vm0.invoke(UpdateVersionDUnitTest.class, "startSender", new Object[]{"ln1"});
        vm0.invoke(UpdateVersionDUnitTest.class, "waitForSenderRunningState", new Object[]{"ln1"});
        Integer nyPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        Integer nyRecPort = (Integer)vm2.invoke(UpdateVersionDUnitTest.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "", 1, 1});
        vm3.invoke(UpdateVersionDUnitTest.class, "createCache", new Object[]{nyPort});
        vm3.invoke(UpdateVersionDUnitTest.class, "createPartitionedRegion", new Object[]{regionName, "", 1, 1});
        VersionTag tag = (VersionTag)vm0.invoke(new SerializableCallable("Put a single entry and get its version"){

            public Object call() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(UpdateVersionDUnitTest.regionName);
                TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                region.put((Object)"key-1", (Object)"value-1");
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                VersionSource memberId = (VersionSource)cache.getDistributedSystem().getDistributedMember();
                VersionTag tag = VersionTag.create((VersionSource)memberId);
                int entryVersion = stamp.getEntryVersion() - 1;
                int dsid = stamp.getDistributedSystemId();
                long time = System.currentTimeMillis();
                tag.setEntryVersion(entryVersion);
                tag.setDistributedSystemId(dsid);
                tag.setVersionTimeStamp(time);
                tag.setIsRemoteForTesting();
                EntryEventImpl event = UpdateVersionDUnitTest.this.createNewEvent((LocalRegion)((PartitionedRegion)region), tag, entry.getKey(), "value-2");
                ((LocalRegion)region).basicUpdate(event, false, true, 0L, false, false);
                entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                stamp = regionEntry.getVersionStamp();
                TestCase.assertEquals((String)"Time stamp did NOT get updated by UPDATE_VERSION operation on LocalRegion", (long)time, (long)stamp.getVersionTimeStamp());
                TestCase.assertEquals((int)(++entryVersion), (int)stamp.getEntryVersion());
                TestCase.assertEquals((int)dsid, (int)stamp.getDistributedSystemId());
                return stamp.asVersionTag();
            }
        });
        VersionTag remoteTag = (VersionTag)vm3.invoke(new SerializableCallable("Get timestamp from remote site"){

            public Object call() throws Exception {
                Cache cache = CacheFactory.getAnyInstance();
                final PartitionedRegion region = (PartitionedRegion)cache.getRegion(UpdateVersionDUnitTest.regionName);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        EntrySnapshot entry = null;
                        try {
                            entry = region.getDataStore().getEntryLocally(0, (Object)"key-1", false, null, false);
                        }
                        catch (EntryNotFoundException entryNotFoundException) {
                        }
                        catch (ForceReattemptException forceReattemptException) {
                        }
                        catch (PRLocallyDestroyedException e) {
                            throw new RuntimeException("unexpected exception", e);
                        }
                        if (entry != null) {
                            DistributedTestCase.getLogWriter().info("found entry " + entry);
                        }
                        return entry != null;
                    }

                    @Override
                    public String description() {
                        return "Expected key-1 to be received on remote WAN site";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 500L, true);
                Region.Entry entry = region.getEntry((Object)"key-1");
                TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                VersionStamp stamp = regionEntry.getVersionStamp();
                return stamp.asVersionTag();
            }
        });
        UpdateVersionDUnitTest.assertEquals((String)"Local and remote site have different timestamps", (long)tag.getVersionTimeStamp(), (long)remoteTag.getVersionTimeStamp());
    }

    private EntryEventImpl createNewEvent(LocalRegion region, VersionTag tag, Object key, Object value) {
        EntryEventImpl updateEvent = EntryEventImpl.createVersionTagHolder((VersionTag)tag);
        updateEvent.setOperation(Operation.UPDATE);
        updateEvent.setRegion(region);
        if (region instanceof PartitionedRegion) {
            updateEvent.setKeyInfo(((PartitionedRegion)region).getKeyInfo(key));
        } else {
            updateEvent.setKeyInfo(new KeyInfo(key, value, null));
        }
        updateEvent.setNewValue(value);
        updateEvent.setGenerateCallbacks(true);
        updateEvent.distributedMember = region.getSystem().getDistributedMember();
        updateEvent.setNewEventId((DistributedSystem)region.getSystem());
        return updateEvent;
    }

    private static void createCache(Integer locPort) {
        UpdateVersionDUnitTest test = new UpdateVersionDUnitTest(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        DistributedTestCase.ExpectedException ex = new DistributedTestCase.ExpectedException("could not get remote locator information for remote site");
        cache.getLogger().info(ex.getAddString());
        expectedExceptions.add(ex);
        ex = new DistributedTestCase.ExpectedException("Pool ln1 is not available");
        cache.getLogger().info(ex.getAddString());
        expectedExceptions.add(ex);
    }

    private static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            for (DistributedTestCase.ExpectedException expectedException : expectedExceptions) {
                cache.getLogger().info(expectedException.getRemoveString());
            }
            expectedExceptions.clear();
            cache.getDistributedSystem().disconnect();
            cache.close();
        }
        cache = null;
    }

    public static void createSender(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean isManualStart) {
        File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        if (isParallel) {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setParallel(true);
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManualStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setBatchConflationEnabled(isConflation);
            gateway.create(dsName, remoteDsId);
        } else {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManualStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            gateway.setBatchConflationEnabled(isConflation);
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.create(dsName, remoteDsId);
        }
    }

    public static void createPartitionedRegion(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setTotalNumBuckets(totalNumBuckets.intValue());
        pfact.setRedundantCopies(redundantCopies.intValue());
        pfact.setRecoveryDelay(0L);
        fact.setPartitionAttributes(pfact.create());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        UpdateVersionDUnitTest.assertNotNull((Object)r);
    }

    public static void createReplicatedRegion(String regionName, String senderIds) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        fact.setDataPolicy(DataPolicy.REPLICATE);
        fact.setScope(Scope.DISTRIBUTED_ACK);
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        UpdateVersionDUnitTest.assertNotNull((Object)r);
    }

    public static void waitForSenderRunningState(String senderId) {
        Set senders = cache.getGatewaySenders();
        final GatewaySender sender = UpdateVersionDUnitTest.getGatewaySenderById(senders, senderId);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return sender != null && sender.isRunning();
            }

            @Override
            public String description() {
                return "Expected sender isRunning state to be true but is false";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 300000L, 500L, true);
    }

    public static Integer createFirstRemoteLocator(int dsId, int remoteLocPort) {
        UpdateVersionDUnitTest test = new UpdateVersionDUnitTest(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
        return port;
    }

    public static void createConcurrentSender(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean isManulaStart, int concurrencyLevel) {
        File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        if (isParallel) {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setParallel(true);
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setBatchConflationEnabled(isConflation);
            gateway.create(dsName, remoteDsId);
        } else {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            gateway.setBatchConflationEnabled(isConflation);
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setDispatcherThreads(concurrencyLevel);
            gateway.create(dsName, remoteDsId);
        }
    }

    public static int createReceiver(int locPort) {
        UpdateVersionDUnitTest test = new UpdateVersionDUnitTest(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            UpdateVersionDUnitTest.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
        return port;
    }

    public static void startSender(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        sender.start();
    }

    private static GatewaySender getGatewaySenderById(Set<GatewaySender> senders, String senderId) {
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            return s;
        }
        return null;
    }

    public static Integer createFirstLocatorWithDSId(int dsId) {
        UpdateVersionDUnitTest test = new UpdateVersionDUnitTest(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        test.getSystem(props);
        return port;
    }

    static {
        expectedExceptions = new HashSet<DistributedTestCase.ExpectedException>();
    }

    protected static class MyLocatorCallback
    extends LocatorDiscoveryCallbackAdapter {
        private final Set discoveredLocators = new HashSet();
        private final Set removedLocators = new HashSet();

        protected MyLocatorCallback() {
        }

        public synchronized void locatorsDiscovered(List locators) {
            this.discoveredLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void locatorsRemoved(List locators) {
            this.removedLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public boolean waitForDiscovery(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.discoveredLocators, locator, time);
        }

        public boolean waitForRemove(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.removedLocators, locator, time);
        }

        private synchronized boolean waitFor(Set set, InetSocketAddress locator, long time) throws InterruptedException {
            long remaining = time;
            long endTime = System.currentTimeMillis() + time;
            while (!set.contains(locator) && remaining >= 0L) {
                ((Object)((Object)this)).wait(remaining);
                remaining = endTime - System.currentTimeMillis();
            }
            return set.contains(locator);
        }

        public synchronized Set getDiscovered() {
            return new HashSet(this.discoveredLocators);
        }

        public synchronized Set getRemoved() {
            return new HashSet(this.removedLocators);
        }
    }
}

