/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class PutAllDAckDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static CacheTransactionManager cacheTxnMgr;
    static boolean beforeCreate;
    static int beforeCreateputAllcounter;
    static boolean flag;

    public PutAllDAckDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllDAckDUnitTest.class, "createCacheForVM0");
        vm1.invoke(PutAllDAckDUnitTest.class, "createCacheForVM1");
        PutAllDAckDUnitTest.getLogWriter().fine("Cache created successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllDAckDUnitTest.class, "closeCache");
        vm1.invoke(PutAllDAckDUnitTest.class, "closeCache");
    }

    public static void createCacheForVM0() throws Exception {
        ds = new PutAllDAckDUnitTest("temp").getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attr = factory.create();
        region = cache.createRegion("map", attr);
    }

    public static void createCacheForVM1() throws Exception {
        BeforeCreateCallback aWriter = new BeforeCreateCallback();
        ds = new PutAllDAckDUnitTest("temp").getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setCacheWriter((CacheWriter)aWriter);
        RegionAttributes attr = factory.create();
        region = cache.createRegion("map", attr);
    }

    public static void closeCache() throws Exception {
        cache.close();
        ds.disconnect();
    }

    public void testputAllRemoteVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Object[] objArr = new Object[1];
        for (int i = 0; i < 2; ++i) {
            objArr[0] = "" + i;
            vm0.invoke(PutAllDAckDUnitTest.class, "putMethod", objArr);
        }
        vm0.invoke(PutAllDAckDUnitTest.class, "putAllMethod");
        flag = vm1.invokeBoolean(PutAllDAckDUnitTest.class, "getFlagVM1");
        vm1.invoke(new CacheSerializableRunnable("temp1"){

            @Override
            public void run2() throws CacheException {
                if (flag) {
                    TestCase.assertEquals((int)region.size(), (int)beforeCreateputAllcounter);
                }
            }
        });
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            PutAllDAckDUnitTest.fail("Failed while region.put", ex);
        }
        return obj;
    }

    public static void putAllMethod() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        int i = 2;
        try {
            for (int cntr = 0; cntr < 2; ++cntr) {
                m.put(new Integer(i), new String("map" + i));
                ++i;
            }
            region.putAll(m);
        }
        catch (Exception ex) {
            PutAllDAckDUnitTest.fail("Failed while region.putAll", ex);
        }
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            PutAllDAckDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static boolean containsValueMethod(Object ob) {
        boolean flag = false;
        try {
            flag = region.containsValue(ob);
        }
        catch (Exception ex) {
            PutAllDAckDUnitTest.fail((String)"Failed while region.containsValueMethod");
        }
        return flag;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            PutAllDAckDUnitTest.fail((String)"Failed while region.size");
        }
        return i;
    }

    public static void clearMethod() {
        try {
            region.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean getFlagVM1() {
        return beforeCreate;
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        beforeCreate = false;
        beforeCreateputAllcounter = 0;
        flag = false;
    }

    static class BeforeCreateCallback
    extends CacheWriterAdapter {
        BeforeCreateCallback() {
        }

        public void beforeCreate(EntryEvent event) {
            ++beforeCreateputAllcounter;
            DistributedTestCase.getLogWriter().fine("*******BeforeCreate*****");
            beforeCreate = true;
        }
    }
}

