/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class PutAllCSDUnitTest
extends BridgeTestCase {
    final int numberOfEntries = 100;
    final int testEndPointSwitchNumber = 200;
    final int thousandEntries = 1000;
    final int TOTAL_BUCKETS = 10;
    static Object lockObject = new Object();
    static Object lockObject2 = new Object();
    static Object lockObject3 = new Object();
    static Object lockObject4 = new Object();
    final String expectedExceptions = PutAllPartialResultException.class.getName() + "||" + ServerConnectivityException.class.getName() + "||" + RegionDestroyedException.class.getName();
    List<VersionTag> client1Versions = null;
    List<VersionTag> client2Versions = null;
    List<String> expectedVersions = null;
    List<String> actualVersions = null;

    public PutAllCSDUnitTest(String name) {
        super(name);
    }

    public void testOneServer() throws CacheException, InterruptedException {
        String title = "testOneServer:";
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server.getHost());
        this.createBridgeServer(server, mcastPort, regionName, serverPort, false, 0, null);
        this.createClient(client1, regionName, serverHost, new int[]{serverPort}, -1, -1, false, true);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort}, -1, -1, false, true);
        server.invoke(new CacheSerializableRunnable("testOneServer:server add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
            }
        });
        client2.invoke(new CacheSerializableRunnable("testOneServer:client2 registerInterest and add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testOneServer:client1 create local region and run putAll"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory2 = new AttributesFactory();
                factory2.setScope(Scope.LOCAL);
                factory2.addCacheListener((CacheListener)new MyListener(false));
                PutAllCSDUnitTest.this.createRegion("localsave", factory2.create());
                Region region = PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 100);
                TestCase.assertEquals((int)100, (int)region.size());
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("testOneServer:client1 create CQ"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region localregion = PutAllCSDUnitTest.this.getRootRegion().getSubregion("localsave");
                CqAttributesFactory cqf1 = new CqAttributesFactory();
                EOCQEventListener EOCQListener = new EOCQEventListener(localregion);
                cqf1.addCqListener((CqListener)EOCQListener);
                CqAttributes cqa1 = cqf1.create();
                String cqName1 = "EOInfoTracker";
                String queryStr1 = "SELECT ALL * FROM /root/" + regionName + " ii WHERE ii.getTicker() >= '10' and ii.getTicker() < '20'";
                DistributedTestCase.getLogWriter().info("Query String: " + queryStr1);
                try {
                    QueryService cqService = PutAllCSDUnitTest.this.getCache().getQueryService();
                    CqQuery EOTracker = cqService.newCq(cqName1, queryStr1, cqa1);
                    CqResults rs1 = EOTracker.executeWithInitialResults();
                    List list1 = rs1.asList();
                    for (int i = 0; i < list1.size(); ++i) {
                        Struct s = (Struct)list1.get(i);
                        TestObject o = (TestObject)s.get("value");
                        DistributedTestCase.getLogWriter().info("InitialResult:" + i + ":" + o);
                        localregion.put((Object)("key-" + i), (Object)o);
                    }
                    if (localregion.size() > 0) {
                        DistributedTestCase.getLogWriter().info("CQ is ready");
                        Object object = lockObject;
                        synchronized (object) {
                            lockObject.notify();
                        }
                    }
                    PutAllCSDUnitTest.waitTillNotify(lockObject2, 20000, EOCQListener.num_creates == 5 && EOCQListener.num_updates == 5);
                    EOTracker.close();
                }
                catch (CqClosedException e) {
                    DistributedTestCase.fail("CQ", e);
                }
                catch (RegionNotFoundException e) {
                    DistributedTestCase.fail("CQ", e);
                }
                catch (QueryInvalidException e) {
                    DistributedTestCase.fail("CQ", e);
                }
                catch (CqExistsException e) {
                    DistributedTestCase.fail("CQ", e);
                }
                catch (CqException e) {
                    DistributedTestCase.fail("CQ", e);
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("testOneServer:verify Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)100, (int)region.size());
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                }
            }
        });
        client1.invoke(new CacheSerializableRunnable("testOneServer:verify CQ is ready"){

            @Override
            public void run2() throws CacheException {
                Region localregion = PutAllCSDUnitTest.this.getRootRegion().getSubregion("localsave");
                PutAllCSDUnitTest.waitTillNotify(lockObject, 10000, localregion.size() > 0);
                TestCase.assertTrue((localregion.size() > 0 ? 1 : 0) != 0);
            }
        });
        client2.invoke(new CacheSerializableRunnable("testOneServer:verify client2"){

            @Override
            public void run2() throws CacheException {
                final Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.size() == 100;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertEquals((int)100, (int)region.size());
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                }
                region.destroy((Object)"key-10");
                region.destroy((Object)"key-11");
                region.destroy((Object)"key-12");
                region.destroy((Object)"key-13");
                region.destroy((Object)"key-14");
                TestCase.assertEquals(null, (Object)region.get((Object)"key-10"));
                LinkedHashMap<String, TestObject> map = new LinkedHashMap<String, TestObject>();
                for (int i = 10; i < 20; ++i) {
                    map.put("key-" + i, new TestObject(i * 10));
                }
                region.putAll(map);
            }
        });
        client1.invoke(new CacheSerializableRunnable("testOneServer:Verify client1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region localregion = PutAllCSDUnitTest.this.getRootRegion().getSubregion("localsave");
                for (int i = 10; i < 20; ++i) {
                    TestObject obj = null;
                    for (int cnt = 0; cnt < 100 && ((obj = (TestObject)localregion.get((Object)("key-" + i))) == null || obj.getPrice() != i * 10); ++cnt) {
                        DistributedTestCase.pause(100);
                        DistributedTestCase.getLogWriter().info("Waiting 100ms(" + cnt + ") for obj.getPrice() == i*10 at entry " + i);
                    }
                    TestCase.assertEquals((int)(i * 10), (int)obj.getPrice());
                }
                Object object = lockObject2;
                synchronized (object) {
                    lockObject2.notify();
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        client1.invoke(new CacheSerializableRunnable("testOneServer:test exception handling"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                HashMap<Integer, String> m = null;
                boolean NPEthrowed = false;
                try {
                    region.putAll(m);
                    TestCase.fail((String)"Should have thrown NullPointerException");
                }
                catch (NullPointerException ex) {
                    NPEthrowed = true;
                }
                TestCase.assertTrue((boolean)NPEthrowed);
                region.localDestroyRegion();
                boolean RDEthrowed = false;
                try {
                    m = new HashMap<Integer, String>();
                    for (int i = 1; i < 21; ++i) {
                        m.put(new Integer(i), Integer.toString(i));
                    }
                    region.putAll(m);
                    TestCase.fail((String)"Should have thrown RegionDestroyedException");
                }
                catch (RegionDestroyedException ex) {
                    RDEthrowed = true;
                }
                TestCase.assertTrue((boolean)RDEthrowed);
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testOldValueInEvent() throws CacheException, InterruptedException {
        String title = "testOldValueInEvent:";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createClient(client1, regionName, serverHost, new int[]{serverPort1}, -1, -1, false, true);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort2}, -1, -1, false, true);
        client2.invoke(new CacheSerializableRunnable("testOldValueInEvent:client2 registerInterest and add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testOldValueInEvent:client1 create local region and run putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                PutAllCSDUnitTest.this.doPutAll(regionName, "testOldValueInEvent:", 100);
                TestCase.assertEquals((int)100, (int)region.size());
                PutAllCSDUnitTest.this.doPutAll(regionName, "testOldValueInEvent:", 100);
                TestCase.assertEquals((int)100, (int)region.size());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testOldValueInEvent:verify after update events"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.waitTillNotify(lockObject, 20000, region.size() == 100);
            }
        });
        client2.invoke(new CacheSerializableRunnable("testOldValueInEvent:verify after update events"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.waitTillNotify(lockObject, 20000, region.size() == 100);
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void test2Server() throws CacheException, InterruptedException {
        String title = "test2Server:";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1}, -1, -1);
        this.createBridgeClient(client2, regionName, serverHost, new int[]{serverPort2}, -1, -1);
        client2.invoke(new CacheSerializableRunnable("test2Server:client2 add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
            }
        });
        client1.invoke(new CacheSerializableRunnable("test2Server:client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 100);
                TestCase.assertEquals((int)100, (int)region.size());
            }
        });
        server1.invoke(new CacheSerializableRunnable("test2Server:verify Bridge Server 1"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)100, (int)region.size());
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("test2Server:verify Bridge Server 2"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)100, (int)region.size());
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                }
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("test2Server:async putAll1 from client1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "async1key-", 100);
            }
        });
        AsyncInvocation async2 = client1.invokeAsync(new CacheSerializableRunnable("test2Server:async putAll2 from client1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "async2key-", 100);
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        DistributedTestCase.join(async2, 30000L, PutAllCSDUnitTest.getLogWriter());
        server2.invoke(new CacheSerializableRunnable("test2Server:verify Bridge Server 2 for async keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                long ts1 = 0L;
                long ts2 = 0L;
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("async1key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts1 ? 1 : 0) != 0);
                    ts1 = obj.getTS();
                    obj = (TestObject)region.getEntry((Object)("async2key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts2 ? 1 : 0) != 0);
                    ts2 = obj.getTS();
                }
            }
        });
        server1.invoke(new CacheSerializableRunnable("test2Server:server1 execute P2P putAll"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "p2pkey-", 100);
            }
        });
        server2.invoke(new CacheSerializableRunnable("test2Server:verify Bridge Server 2 for async keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                long ts1 = 0L;
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("p2pkey-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts1 ? 1 : 0) != 0);
                    ts1 = obj.getTS();
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("test2Server:execute putAll on client2 for key 0-10"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 10);
            }
        });
        client1.invoke(new CacheSerializableRunnable("test2Server:verify client1 for local invalidate"){

            @Override
            public void run2() throws CacheException {
                final Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 0; i < 10; ++i) {
                    final int ii = i;
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return region.getEntry((Object)("key-" + ii)).getValue() == null;
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                    TestObject obj = null;
                    obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals(null, (Object)obj);
                }
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testPRServer() throws CacheException, InterruptedException {
        String title = "testPRServer:";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 1, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 1, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1}, -1, 59000);
        this.createBridgeClient(client2, regionName, serverHost, new int[]{serverPort2}, -1, 59000);
        client2.invoke(new CacheSerializableRunnable("testPRServer:client2 add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
            }
        });
        client1.invoke(new CacheSerializableRunnable("testPRServer:client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 100);
                TestCase.assertEquals((int)100, (int)region.size());
            }
        });
        server1.invoke(new CacheSerializableRunnable("testPRServer:verify Bridge Server 1"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)100, (int)region.size());
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("testPRServer:verify Bridge Server 2"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)100, (int)region.size());
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                }
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("testPRServer:async putAll1 from client1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "async1key-", 100);
            }
        });
        AsyncInvocation async2 = client1.invokeAsync(new CacheSerializableRunnable("testPRServer:async putAll2 from client1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "async2key-", 100);
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        DistributedTestCase.join(async2, 30000L, PutAllCSDUnitTest.getLogWriter());
        server2.invoke(new CacheSerializableRunnable("testPRServer:verify Bridge Server 2 for async keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                long ts1 = 0L;
                long ts2 = 0L;
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("async1key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts1 ? 1 : 0) != 0);
                    ts1 = obj.getTS();
                    obj = (TestObject)region.getEntry((Object)("async2key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts2 ? 1 : 0) != 0);
                    ts2 = obj.getTS();
                }
            }
        });
        server1.invoke(new CacheSerializableRunnable("testPRServer:server1 execute P2P putAll"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "p2pkey-", 100);
            }
        });
        server2.invoke(new CacheSerializableRunnable("testPRServer:verify Bridge Server 2 for async keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                long ts1 = 0L;
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("p2pkey-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts1 ? 1 : 0) != 0);
                    ts1 = obj.getTS();
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("testPRServer:execute putAll on client2 for key 0-10"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 10);
            }
        });
        client1.invoke(new CacheSerializableRunnable("testPRServer:verify client1 for local invalidate"){

            @Override
            public void run2() throws CacheException {
                final Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 0; i < 10; ++i) {
                    final int ii = i;
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return region.getEntry((Object)("key-" + ii)).getValue() == null;
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    TestCase.assertEquals(null, (Object)obj);
                }
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testPartialKeyInLocalRegion() throws CacheException, InterruptedException {
        String title = "testPartialKeyInLocalRegion:";
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        final VM server2 = host.getVM(1);
        final VM client1 = host.getVM(2);
        final VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createClient(client1, regionName, serverHost, new int[]{serverPort1}, -1, -1, false, true);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort1}, -1, -1, false, true);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(this.addExceptionTag1(this.expectedExceptions));
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInLocalRegion:server1 add cacheWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter(15));
            }
        });
        client2.invoke(new CacheSerializableRunnable("testPartialKeyInLocalRegion:client2 add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client1 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInLocalRegion:client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInLocalRegion:", 100);
                    TestCase.fail((String)"Expect ServerOperationException caused by PutAllParitialResultException");
                }
                catch (ServerOperationException soe) {
                    TestCase.assertTrue((boolean)soe.getMessage().contains(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(new Object[]{region.getFullPath()})));
                    TestCase.assertTrue((boolean)(soe.getCause() instanceof RuntimeException));
                    TestCase.assertTrue((boolean)soe.getCause().getMessage().contains("Triggered exception as planned, created 15 keys"));
                }
            }
        });
        DistributedTestCase.WaitCriterion waitForSizes = new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "waiting for conditions to be met";
            }

            @Override
            public boolean done() {
                int c1Size = PutAllCSDUnitTest.this.getRegionSize(client1, regionName);
                int c2Size = PutAllCSDUnitTest.this.getRegionSize(client2, regionName);
                int s1Size = PutAllCSDUnitTest.this.getRegionSize(server1, regionName);
                int s2Size = PutAllCSDUnitTest.this.getRegionSize(server2, regionName);
                DistributedTestCase.getLogWriter().info("region sizes: " + c1Size + "," + c2Size + "," + s1Size + "," + s2Size);
                if (c1Size != 15) {
                    DistributedTestCase.getLogWriter().info("waiting for client1 to get all updates");
                    return false;
                }
                if (c2Size != 15) {
                    DistributedTestCase.getLogWriter().info("waiting for client2 to get all updates");
                    return false;
                }
                if (s1Size != 15) {
                    DistributedTestCase.getLogWriter().info("waiting for server1 to get all updates");
                    return false;
                }
                if (s2Size != 15) {
                    DistributedTestCase.getLogWriter().info("waiting for server2 to get all updates");
                    return false;
                }
                return true;
            }
        };
        PutAllCSDUnitTest.waitForCriterion(waitForSizes, 10000L, 200L, true);
        int server1Size = this.getRegionSize(server1, regionName);
        int server2Size = this.getRegionSize(server1, regionName);
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInLocalRegion:server1 add cacheWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter(15));
            }
        });
        server2.invoke(new CacheSerializableRunnable("testPartialKeyInLocalRegion:server2 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInLocalRegion:again:", 100);
                    TestCase.fail((String)"Expect original RuntimeException caused by cacheWriter");
                }
                catch (RuntimeException rte) {
                    TestCase.assertTrue((boolean)rte.getMessage().contains("Triggered exception as planned, created 15 keys"));
                }
            }
        });
        server2Size = this.getRegionSize(server1, regionName);
        PutAllCSDUnitTest.assertEquals((int)(server1Size + 15), (int)server2Size);
        server1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        server2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        this.stopBridgeServers(this.getCache());
    }

    public void testPartialKeyInPR() throws CacheException, InterruptedException {
        String title = "testPartialKeyInPR:";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        final VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 0, "ds1");
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, "ds1");
        this.createClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1, false, false);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1, false, false);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(this.addExceptionTag1(this.expectedExceptions));
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInPR:server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        final SharedCounter sc_server2 = new SharedCounter("server2");
        server2.invoke(new CacheSerializableRunnable("testPartialKeyInPR:server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(server2, true, sc_server2, 10));
            }
        });
        client2.invoke(new CacheSerializableRunnable("testPartialKeyInPR:client2 add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("testPartialKeyInPR:client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                block3: {
                    Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                    region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                    region.registerInterest((Object)"ALL_KEYS");
                    try {
                        PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPR:", 100);
                        TestCase.fail((String)"Expect ServerOperationException caused by PutAllParitialResultException");
                    }
                    catch (ServerOperationException soe) {
                        if (!(soe.getCause() instanceof PartitionOfflineException)) {
                            throw soe;
                        }
                        if (soe.getMessage().contains(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(new Object[]{region.getFullPath()}))) break block3;
                        throw soe;
                    }
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            PutAllCSDUnitTest.fail("Aync1 get exceptions:", async1.getException());
        }
        int client1Size = this.getRegionSize(client1, regionName);
        int client2Size = this.getRegionSize(client2, regionName);
        int server1Size = this.getRegionSize(server1, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes: " + client1Size + "," + client2Size + "," + server1Size);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, "ds1");
        server1Size = this.getRegionSize(server1, regionName);
        int server2Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after server2 restarted: " + client1Size + "," + client2Size + "," + server1Size + ":" + server2Size);
        PutAllCSDUnitTest.assertEquals((int)client2Size, (int)server1Size);
        PutAllCSDUnitTest.assertEquals((int)client2Size, (int)server2Size);
        this.closeCache(server2);
        server1Size = this.getRegionSize(server1, regionName);
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInPR:client1 does putAll again"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPR:again:", 100);
                    TestCase.fail((String)"Expect ServerOperationException caused by PutAllParitialResultException");
                }
                catch (ServerOperationException soe) {
                    TestCase.assertTrue((boolean)soe.getMessage().contains(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(new Object[]{region.getFullPath()})));
                    TestCase.assertTrue((boolean)(soe.getCause() instanceof PartitionOfflineException));
                }
            }
        });
        int new_server1Size = this.getRegionSize(server1, regionName);
        int new_client1Size = this.getRegionSize(client1, regionName);
        int new_client2Size = this.getRegionSize(client2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after re-run the putAll: " + new_client1Size + "," + new_client2Size + "," + new_server1Size);
        PutAllCSDUnitTest.assertEquals((int)(server1Size + 50), (int)new_server1Size);
        PutAllCSDUnitTest.assertEquals((int)(client1Size + 50), (int)new_client1Size);
        PutAllCSDUnitTest.assertEquals((int)(client2Size + 50), (int)new_client2Size);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, "ds1");
        server1Size = this.getRegionSize(server1, regionName);
        server2Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after restart server2: " + server1Size + "," + server2Size);
        PutAllCSDUnitTest.assertEquals((int)server1Size, (int)server2Size);
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInPR:server1 execute P2P putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter(15));
            }
        });
        server2.invoke(new CacheSerializableRunnable("testPartialKeyInPR:server2 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPR:once again:", 100);
                    TestCase.fail((String)"Expected a CacheWriterException to be thrown by test");
                }
                catch (CacheWriterException rte) {
                    TestCase.assertTrue((boolean)rte.getMessage().contains("Triggered exception as planned, created 15 keys"));
                }
            }
        });
        new_server1Size = this.getRegionSize(server1, regionName);
        int new_server2Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after restart server2: " + new_server1Size + "," + new_server2Size);
        PutAllCSDUnitTest.assertEquals((int)(server1Size + 15), (int)new_server1Size);
        PutAllCSDUnitTest.assertEquals((int)(server2Size + 15), (int)new_server2Size);
        server1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        server2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        this.stopBridgeServers(this.getCache());
    }

    public void testPartialKeyInPRSingleHop() throws CacheException, InterruptedException {
        String title = "testPartialKeyInPRSingleHop_";
        int cacheWriterAllowedKeyNum = 16;
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        final VM server2 = host.getVM(1);
        final VM client1 = host.getVM(2);
        final VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 0, "ds1");
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, "ds1");
        this.createClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1, false, false);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1, false, false);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client2 add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_do some putAll to get ClientMetaData for future putAll"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 100);
            }
        });
        DistributedTestCase.WaitCriterion waitForSizes = new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "waiting for conditions to be met";
            }

            @Override
            public boolean done() {
                int c1Size = PutAllCSDUnitTest.this.getRegionSize(client1, regionName);
                int c2Size = PutAllCSDUnitTest.this.getRegionSize(client2, regionName);
                int s1Size = PutAllCSDUnitTest.this.getRegionSize(server1, regionName);
                int s2Size = PutAllCSDUnitTest.this.getRegionSize(server2, regionName);
                DistributedTestCase.getLogWriter().info("region sizes: " + c1Size + "," + c2Size + "," + s1Size + "," + s2Size);
                if (c1Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for client1 to get all updates");
                    return false;
                }
                if (c2Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for client2 to get all updates");
                    return false;
                }
                if (s1Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for server1 to get all updates");
                    return false;
                }
                if (s2Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for server2 to get all updates");
                    return false;
                }
                return true;
            }
        };
        PutAllCSDUnitTest.waitForCriterion(waitForSizes, 10000L, 200L, true);
        int client1Size = this.getRegionSize(client1, regionName);
        int client2Size = this.getRegionSize(client2, regionName);
        int server1Size = this.getRegionSize(server1, regionName);
        int server2Size = this.getRegionSize(server2, regionName);
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        final SharedCounter sc_server2 = new SharedCounter("server2");
        server2.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(server2, true, sc_server2, 10));
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPRSingleHop_", 100);
                    TestCase.fail((String)"Expect ServerOperationException caused by PutAllParitialResultException");
                }
                catch (ServerOperationException soe) {
                    TestCase.assertTrue((boolean)soe.getMessage().contains(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(new Object[]{region.getFullPath()})));
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            PutAllCSDUnitTest.fail("Aync1 get exceptions:", async1.getException());
        }
        client1Size = this.getRegionSize(client1, regionName);
        client2Size = this.getRegionSize(client2, regionName);
        server1Size = this.getRegionSize(server1, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes: " + client1Size + "," + client2Size + "," + server1Size);
        PutAllCSDUnitTest.getLogWriter().info("restarting server 2");
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, "ds1");
        client1Size = this.getRegionSize(client1, regionName);
        client2Size = this.getRegionSize(client2, regionName);
        server1Size = this.getRegionSize(server1, regionName);
        server2Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after server2 restarted: " + client1Size + "," + client2Size + "," + server1Size);
        PutAllCSDUnitTest.assertEquals((int)150, (int)client1Size);
        PutAllCSDUnitTest.assertEquals((int)client2Size, (int)server1Size);
        PutAllCSDUnitTest.assertEquals((int)client2Size, (int)server2Size);
        this.closeCache(server2);
        server1Size = this.getRegionSize(server1, regionName);
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client1 does putAll again"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPRSingleHop_again:", 100);
                    TestCase.fail((String)"Expect ServerOperationException caused by PutAllParitialResultException");
                }
                catch (ServerOperationException soe) {
                    TestCase.assertTrue((boolean)soe.getMessage().contains(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(new Object[]{region.getFullPath()})));
                }
            }
        });
        int new_server1Size = this.getRegionSize(server1, regionName);
        int new_client1Size = this.getRegionSize(client1, regionName);
        int new_client2Size = this.getRegionSize(client2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after re-run the putAll: " + new_client1Size + "," + new_client2Size + "," + new_server1Size);
        PutAllCSDUnitTest.assertEquals((int)(server1Size + 50), (int)new_server1Size);
        PutAllCSDUnitTest.assertEquals((int)(client1Size + 50), (int)new_client1Size);
        PutAllCSDUnitTest.assertEquals((int)(client2Size + 50), (int)new_client2Size);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, "ds1");
        server1Size = this.getRegionSize(server1, regionName);
        server2Size = this.getRegionSize(server1, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after restart server2: " + server1Size + "," + server2Size);
        PutAllCSDUnitTest.assertEquals((int)server1Size, (int)server2Size);
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_server1 add cachewriter to throw exception after created some keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter(16));
            }
        });
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client1 does putAll once more"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPRSingleHop_once more:", 100);
                    TestCase.fail((String)"Expect ServerOperationException caused by PutAllParitialResultException");
                }
                catch (ServerOperationException soe) {
                    TestCase.assertTrue((boolean)soe.getMessage().contains(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(new Object[]{region.getFullPath()})));
                }
            }
        });
        int oncemore_client1Size = this.getRegionSize(client1, regionName);
        int oncemore_client2Size = this.getRegionSize(client2, regionName);
        int oncemore_server1Size = this.getRegionSize(server1, regionName);
        int oncemore_server2Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes in once more test: " + oncemore_client1Size + "," + oncemore_client2Size + "," + oncemore_server1Size + "," + oncemore_server2Size);
        int delta_at_server = oncemore_server1Size - server1Size;
        PutAllCSDUnitTest.assertEquals((int)(new_client1Size + delta_at_server), (int)oncemore_client1Size);
        PutAllCSDUnitTest.assertEquals((int)oncemore_server1Size, (int)oncemore_client2Size);
        PutAllCSDUnitTest.assertEquals((int)oncemore_server2Size, (int)oncemore_server1Size);
        server1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        server2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        this.stopBridgeServers(this.getCache());
    }

    public void testPartialKeyInPRSingleHopWithRedundency() throws CacheException, InterruptedException {
        String title = "testPartialKeyInPRSingleHop_";
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        final VM server2 = host.getVM(1);
        final VM client1 = host.getVM(2);
        final VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 1, "ds1");
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 1, "ds1");
        this.createClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1, false, false);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1, false, false);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client2 add listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_do some putAll to get ClientMetaData for future putAll"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 100);
            }
        });
        DistributedTestCase.WaitCriterion waitForSizes = new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "waiting for conditions to be met";
            }

            @Override
            public boolean done() {
                int c1Size = PutAllCSDUnitTest.this.getRegionSize(client1, regionName);
                int c2Size = PutAllCSDUnitTest.this.getRegionSize(client2, regionName);
                int s1Size = PutAllCSDUnitTest.this.getRegionSize(server1, regionName);
                int s2Size = PutAllCSDUnitTest.this.getRegionSize(server2, regionName);
                DistributedTestCase.getLogWriter().info("region sizes: " + c1Size + "," + c2Size + "," + s1Size + "," + s2Size);
                if (c1Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for client1 to get all updates");
                    return false;
                }
                if (c2Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for client2 to get all updates");
                    return false;
                }
                if (s1Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for server1 to get all updates");
                    return false;
                }
                if (s2Size != 100) {
                    DistributedTestCase.getLogWriter().info("waiting for server2 to get all updates");
                    return false;
                }
                return true;
            }
        };
        PutAllCSDUnitTest.waitForCriterion(waitForSizes, 10000L, 200L, true);
        int client1Size = this.getRegionSize(client1, regionName);
        int client2Size = this.getRegionSize(client2, regionName);
        int server1Size = this.getRegionSize(server1, regionName);
        int server2Size = this.getRegionSize(server2, regionName);
        server1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        final SharedCounter sc_server2 = new SharedCounter("server2");
        server2.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(server2, true, sc_server2, 10));
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPRSingleHop_", 100);
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            PutAllCSDUnitTest.fail("Aync1 get exceptions:", async1.getException());
        }
        client1Size = this.getRegionSize(client1, regionName);
        client2Size = this.getRegionSize(client2, regionName);
        server1Size = this.getRegionSize(server1, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes: " + client1Size + "," + client2Size + "," + server1Size);
        PutAllCSDUnitTest.assertEquals((int)server1Size, (int)client1Size);
        PutAllCSDUnitTest.assertEquals((int)server1Size, (int)client2Size);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 1, "ds1");
        server1Size = this.getRegionSize(server1, regionName);
        server2Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after server2 restarted: " + client1Size + "," + client2Size + "," + server1Size);
        PutAllCSDUnitTest.assertEquals((int)client2Size, (int)server1Size);
        PutAllCSDUnitTest.assertEquals((int)client2Size, (int)server2Size);
        this.closeCache(server2);
        server1Size = this.getRegionSize(server1, regionName);
        client1.invoke(new CacheSerializableRunnable("testPartialKeyInPRSingleHop_client1 does putAll again"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "testPartialKeyInPRSingleHop_again:", 100);
            }
        });
        int new_server1Size = this.getRegionSize(server1, regionName);
        int new_client1Size = this.getRegionSize(client1, regionName);
        int new_client2Size = this.getRegionSize(client2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes after re-run the putAll: " + new_client1Size + "," + new_client2Size + "," + new_server1Size);
        PutAllCSDUnitTest.assertEquals((int)new_server1Size, (int)new_client1Size);
        PutAllCSDUnitTest.assertEquals((int)new_server1Size, (int)new_client2Size);
        this.stopBridgeServers(this.getCache());
    }

    public void testEventIdMisorderInPRSingleHop() throws CacheException, InterruptedException {
        String title = "testEventIdMisorderInPRSingleHop_";
        Host host = Host.getHost(0);
        final VM server1 = host.getVM(0);
        final VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client1 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort3 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        final SharedCounter sc_server1 = new SharedCounter("server1");
        final SharedCounter sc_server2 = new SharedCounter("server2");
        final SharedCounter sc_server3 = new SharedCounter("server3");
        SharedCounter sc_client2 = new SharedCounter("client2");
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, null);
        this.createBridgeServer(server3, mcastPort, regionName, serverPort3, true, 0, null);
        this.createClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2, serverPort3}, -1, -1, false, true);
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        try {
            this.getCache();
            BridgeTestCase.configureConnectionPool(factory, serverHost, new int[]{serverPort1, serverPort2, serverPort3}, true, -1, -1, null);
            this.createRegion(regionName, factory.create());
            PutAllCSDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(regionName));
        }
        catch (CacheException ex) {
            PutAllCSDUnitTest.fail("While creating Region on Edge", ex);
        }
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        server3.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        this.addExceptionTag1(this.expectedExceptions);
        client1.invoke(new CacheSerializableRunnable("testEventIdMisorderInPRSingleHop_do some putAll to get ClientMetaData for future putAll"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 100);
            }
        });
        MyListener myListener = new MyListener(false, sc_client2);
        Region region = this.getRootRegion().getSubregion(regionName);
        region.getAttributesMutator().addCacheListener((CacheListener)myListener);
        region.registerInterest((Object)"ALL_KEYS");
        server1.invoke(new CacheSerializableRunnable("testEventIdMisorderInPRSingleHop_server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region r = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                r.getAttributesMutator().addCacheListener((CacheListener)new MyListener(server1, true, sc_server1, 10));
            }
        });
        server2.invoke(new CacheSerializableRunnable("testEventIdMisorderInPRSingleHop_server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region r = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                r.getAttributesMutator().addCacheListener((CacheListener)new MyListener(server2, true, sc_server2, 10));
            }
        });
        server3.invoke(new CacheSerializableRunnable("testEventIdMisorderInPRSingleHop_server3 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region r = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                r.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true, sc_server3));
            }
        });
        int client1Size = this.getRegionSize(client1, regionName);
        int server1Size = this.getRegionSize(server1, regionName);
        int server2Size = this.getRegionSize(server2, regionName);
        int server3Size = this.getRegionSize(server2, regionName);
        PutAllCSDUnitTest.getLogWriter().info("region sizes: " + client1Size + "," + server1Size + "," + server2Size + "," + server3Size);
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("testEventIdMisorderInPRSingleHop_client1 add listener and putAll"){

            @Override
            public void run2() throws CacheException {
                Region r = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                r.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                PutAllCSDUnitTest.this.doPutAll(regionName, "testEventIdMisorderInPRSingleHop_", 100);
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            PutAllCSDUnitTest.fail("Aync1 get exceptions:", async1.getException());
        }
        server3.invoke(new CacheSerializableRunnable("testEventIdMisorderInPRSingleHop_server3 print counter"){

            @Override
            public void run2() throws CacheException {
                Region r = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                MyListener l = (MyListener)r.getAttributes().getCacheListeners()[0];
                DistributedTestCase.getLogWriter().info("event counters : " + l.sc);
                TestCase.assertEquals((int)100, (int)l.sc.num_create_event);
                TestCase.assertEquals((int)0, (int)l.sc.num_update_event);
            }
        });
        PutAllCSDUnitTest.getLogWriter().info("event counters : " + myListener.sc);
        PutAllCSDUnitTest.assertEquals((int)100, (int)myListener.sc.num_create_event);
        PutAllCSDUnitTest.assertEquals((int)0, (int)myListener.sc.num_update_event);
        server1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        server2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        server3.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        this.removeExceptionTag1(this.expectedExceptions);
        this.stopBridgeServers(this.getCache());
    }

    public void test2FailOverDistributedServer() throws CacheException, InterruptedException {
        String title = "test2FailOverDistributedServer:";
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        final int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1);
        this.createBridgeClient(client2, regionName, serverHost, new int[]{serverPort2, serverPort1}, -1, -1);
        server1.invoke(new CacheSerializableRunnable("test2FailOverDistributedServer:server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        server2.invoke(new CacheSerializableRunnable("test2FailOverDistributedServer:server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        client1.invoke(new CacheSerializableRunnable("test2FailOverDistributedServer:client1 registerInterest"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client1 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client2.invoke(new CacheSerializableRunnable("test2FailOverDistributedServer:client2 registerInterest"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        AsyncInvocation async1 = client1.invokeAsync(new CacheSerializableRunnable("test2FailOverDistributedServer:async putAll1 from client1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "async1key-", 100);
            }
        });
        PutAllCSDUnitTest.pause(2000);
        server1.invoke(new CacheSerializableRunnable("test2FailOverDistributedServer:stop Bridge Server 1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.stopOneBridgeServer(serverPort1);
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        server2.invoke(new CacheSerializableRunnable("test2FailOverDistributedServer:verify Bridge Server 2 for async keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                long ts1 = 0L;
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("async1key-" + i)).getValue();
                    TestCase.assertEquals((int)i, (int)obj.getPrice());
                    TestCase.assertTrue((obj.getTS() >= ts1 ? 1 : 0) != 0);
                    ts1 = obj.getTS();
                }
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testClientTimeOut() throws CacheException, InterruptedException {
        String title = "testClientTimeOut:";
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, -1, -1);
        this.createBridgeClient(client2, regionName, serverHost, new int[]{serverPort2, serverPort1}, -1, -1);
        server1.invoke(new CacheSerializableRunnable("testClientTimeOut:server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        server2.invoke(new CacheSerializableRunnable("testClientTimeOut:server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        client1.invoke(new CacheSerializableRunnable("testClientTimeOut:client1 execute putAll"){

            @Override
            public void run2() throws CacheException {
                boolean exceptionTriggered = false;
                try {
                    PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 1000);
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().info("testClientTimeOut:Expected SocketTimeOut:" + e.getMessage());
                    if (e instanceof BridgeWriterException && !e.getMessage().startsWith("Pool unexpected socket timed out on client")) {
                        DistributedTestCase.fail("Expect BridgeWriterException: socket timeout", e);
                    }
                    exceptionTriggered = true;
                }
                TestCase.assertTrue((boolean)exceptionTriggered);
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testEndPointSwitch() throws CacheException, InterruptedException {
        String title = "testEndPointSwitch:";
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, 1, -1);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort2, serverPort1}, 1, -1, false, true);
        server1.invoke(new CacheSerializableRunnable("testEndPointSwitch:server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        client2.invoke(new CacheSerializableRunnable("testEndPointSwitch:client2 registerInterest"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client1.invoke(new CacheSerializableRunnable("testEndPointSwitch:putAll from client1"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    try {
                        PutAllCSDUnitTest.this.doPutAll(regionName, "testEndPointSwitch:", 200);
                    }
                    catch (Exception e) {
                        DistributedTestCase.getLogWriter().info("testEndPointSwitch:Expected SocketTimeOut" + e.getMessage());
                        if (!(e instanceof BridgeWriterException) || e.getMessage().startsWith("Pool unexpected socket timed out on client")) break block2;
                        DistributedTestCase.fail("Expect BridgeWriterException: socket timeout", e);
                    }
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("testEndPointSwitch:verify Bridge client2 for keys arrived finally"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.waitTillNotify(lockObject3, 100000, region.size() == 200);
                TestCase.assertEquals((int)200, (int)region.size());
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testHADRFailOver() throws CacheException, InterruptedException {
        String title = "testHADRFailOver:";
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        final int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1, serverPort2}, 1, -1);
        this.createClient(client2, regionName, serverHost, new int[]{serverPort2, serverPort1}, 1, -1, false, true);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(new CacheSerializableRunnable("testHADRFailOver:client1 registerInterest"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client1 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        client2.invoke(new CacheSerializableRunnable("testHADRFailOver:client2 registerInterest"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(false));
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        AsyncInvocation async1 = server2.invokeAsync(new CacheSerializableRunnable("testHADRFailOver:async putAll1 from server2"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "testHADRFailOver:1:", 1000);
            }
        });
        AsyncInvocation async2 = client1.invokeAsync(new CacheSerializableRunnable("testHADRFailOver:async putAll1 from client1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.doPutAll(regionName, "testHADRFailOver:2:", 1000);
            }
        });
        PutAllCSDUnitTest.pause(2000);
        server1.invoke(new CacheSerializableRunnable("testHADRFailOver:stop Bridge Server 1"){

            @Override
            public void run2() throws CacheException {
                PutAllCSDUnitTest.this.stopOneBridgeServer(serverPort1);
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        DistributedTestCase.join(async2, 30000L, PutAllCSDUnitTest.getLogWriter());
        client2.invokeAsync(new CacheSerializableRunnable("testHADRFailOver:verify Bridge client2 for async keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.waitTillNotify(lockObject4, 100000, region.size() == 2000);
                TestCase.assertEquals((int)2000, (int)region.size());
            }
        });
        server1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        server2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        client2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        this.stopBridgeServers(this.getCache());
    }

    public void no_testTX() throws CacheException, InterruptedException {
        String title = "testTX:";
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        server1.invoke(new CacheSerializableRunnable("testTX:server1 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        server2.invoke(new CacheSerializableRunnable("testTX:server2 add slow listener"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.getAttributesMutator().addCacheListener((CacheListener)new MyListener(true));
            }
        });
        AsyncInvocation async1 = server1.invokeAsync(new CacheSerializableRunnable("testTX:TX1: async putAll from server1"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                LinkedHashMap<String, TestObject> map = new LinkedHashMap<String, TestObject>();
                for (int i = 0; i < 100; ++i) {
                    map.put("key-" + i, new TestObject(i));
                }
                region.putAll(map);
                try {
                    DistributedTestCase.getLogWriter().info("before commit TX1");
                    DistributedTestCase.getLogWriter().info("TX1 committed");
                }
                catch (ConflictException e) {
                    DistributedTestCase.getLogWriter().info("TX1 rollbacked");
                }
            }
        });
        PutAllCSDUnitTest.pause(500);
        AsyncInvocation async2 = server2.invokeAsync(new CacheSerializableRunnable("testTX:TX2: async putAll from server2"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                LinkedHashMap<String, TestObject> map = new LinkedHashMap<String, TestObject>();
                for (int i = 0; i < 100; ++i) {
                    map.put("key-" + i, new TestObject(i + 100));
                }
                region.putAll(map);
                try {
                    DistributedTestCase.getLogWriter().info("before commit TX2");
                    DistributedTestCase.getLogWriter().info("TX2 committed");
                }
                catch (ConflictException e) {
                    DistributedTestCase.getLogWriter().info("TX2 rollbacked");
                }
            }
        });
        AsyncInvocation async3 = server2.invokeAsync(new CacheSerializableRunnable("testTX:TX3: async putAll from server2"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                LinkedHashMap<String, TestObject> map = new LinkedHashMap<String, TestObject>();
                for (int i = 0; i < 100; ++i) {
                    map.put("key-" + i, new TestObject(i + 200));
                }
                region.putAll(map);
                try {
                    DistributedTestCase.getLogWriter().info("before commit TX3");
                    DistributedTestCase.getLogWriter().info("TX3 committed");
                }
                catch (ConflictException e) {
                    DistributedTestCase.getLogWriter().info("TX3 rollbacked");
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PutAllCSDUnitTest.getLogWriter());
        DistributedTestCase.join(async2, 30000L, PutAllCSDUnitTest.getLogWriter());
        DistributedTestCase.join(async3, 30000L, PutAllCSDUnitTest.getLogWriter());
        server2.invoke(new CacheSerializableRunnable("testTX:verify Bridge server2 for keys"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)100, (int)region.size());
                int tx_no = 0;
                for (int i = 0; i < 100; ++i) {
                    TestObject obj = (TestObject)region.getEntry((Object)("key-" + i)).getValue();
                    if (tx_no == 0) {
                        if (obj.getPrice() == i) {
                            tx_no = 1;
                        } else if (obj.getPrice() == i + 100) {
                            tx_no = 2;
                        } else if (obj.getPrice() == i + 200) {
                            tx_no = 3;
                        }
                        DistributedTestCase.getLogWriter().info("Verifying TX:" + tx_no);
                    }
                    if (tx_no == 1) {
                        TestCase.assertEquals((int)i, (int)obj.getPrice());
                        continue;
                    }
                    if (tx_no == 2) {
                        TestCase.assertEquals((int)(i + 100), (int)obj.getPrice());
                        continue;
                    }
                    TestCase.assertEquals((int)(i + 200), (int)obj.getPrice());
                }
            }
        });
        this.stopBridgeServers(this.getCache());
    }

    public void testVersionsOnClientsWithNotificationsOnly() {
        String title = "testVersionsInClients";
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1}, 0, 59000);
        this.createBridgeClient(client2, regionName, serverHost, new int[]{serverPort2}, 0, 59000);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(new CacheSerializableRunnable("testVersionsInClientsclient1 putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 200);
                TestCase.assertEquals((int)200, (int)region.size());
            }
        });
        client2.invoke(new CacheSerializableRunnable("testVersionsInClientsclient2 versions collection"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        this.client1Versions = (List)client1.invoke(new SerializableCallable("testVersionsInClientsclient1 versions collection"){

            public Object call() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)200, (int)region.size());
                ArrayList<VersionTag> versions = new ArrayList<VersionTag>(200);
                RegionMap entries = ((LocalRegion)region).entries;
                for (Object key : entries.keySet()) {
                    RegionEntry internalRegionEntry = entries.getEntry(key);
                    VersionTag tag = internalRegionEntry.getVersionStamp().asVersionTag();
                    DistributedTestCase.getLogWriter().info("Entry version tag on client for " + key + ": " + tag);
                    versions.add(tag);
                }
                return versions;
            }
        });
        this.client2Versions = (List)client2.invoke(new SerializableCallable("testVersionsInClientsclient2 versions collection"){

            public Object call() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)200, (int)region.size());
                ArrayList<VersionTag> versions = new ArrayList<VersionTag>(200);
                RegionMap entries = ((LocalRegion)region).entries;
                for (Object key : entries.keySet()) {
                    RegionEntry internalRegionEntry = entries.getEntry(key);
                    VersionTag tag = internalRegionEntry.getVersionStamp().asVersionTag();
                    DistributedTestCase.getLogWriter().info("Entry version tag on client for " + key + ": " + tag);
                    versions.add(tag);
                }
                return versions;
            }
        });
        PutAllCSDUnitTest.assertEquals((int)200, (int)this.client1Versions.size());
        PutAllCSDUnitTest.getLogWriter().info(Arrays.toString(this.client1Versions.toArray()));
        PutAllCSDUnitTest.getLogWriter().info(Arrays.toString(this.client2Versions.toArray()));
        for (VersionTag tag : this.client1Versions) {
            if (this.client2Versions.contains(tag)) continue;
            PutAllCSDUnitTest.fail((String)("client 2 does not have the tag contained in client 1" + tag));
        }
    }

    public void testVersionsOnServersWithNotificationsOnly() {
        String title = "testVersionsInClients";
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client1 = host.getVM(3);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort3 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, true, 1, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, true, 1, null);
        this.createBridgeServer(server3, mcastPort, regionName, serverPort3, true, 1, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort3}, 0, 59000);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        server3.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(new CacheSerializableRunnable("testVersionsInClientsclient2 versions collection"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.registerInterest((Object)"ALL_KEYS");
                DistributedTestCase.getLogWriter().info("client2 registerInterest ALL_KEYS at " + region.getFullPath());
            }
        });
        server1.invoke(new CacheSerializableRunnable("testVersionsInClientsclient1 putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 200);
                TestCase.assertEquals((int)200, (int)region.size());
            }
        });
        this.expectedVersions = (List)server1.invoke(new SerializableCallable("testVersionsInClientsserver1 versions collection"){

            public Object call() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)200, (int)region.size());
                ArrayList<String> versions = new ArrayList<String>(200);
                Set buckets = ((PartitionedRegion)region).dataStore.getAllLocalPrimaryBucketRegions();
                for (BucketRegion br : buckets) {
                    RegionMap entries = br.entries;
                    for (Object key : entries.keySet()) {
                        RegionEntry internalRegionEntry = entries.getEntry(key);
                        VersionTag tag = internalRegionEntry.getVersionStamp().asVersionTag();
                        DistributedTestCase.getLogWriter().info("Entry version tag on server1:" + tag);
                        versions.add(key + " " + tag);
                    }
                }
                return versions;
            }
        });
        PutAllCSDUnitTest.pause(1000);
        this.actualVersions = (List)client1.invoke(new SerializableCallable("testVersionsInClientsclient2 versions collection"){

            public Object call() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)200, (int)region.size());
                ArrayList<String> versions = new ArrayList<String>(200);
                RegionMap entries = ((LocalRegion)region).entries;
                for (Object key : entries.keySet()) {
                    RegionEntry internalRegionEntry = entries.getEntry(key);
                    VersionTag tag = internalRegionEntry.getVersionStamp().asVersionTag();
                    tag.setMemberID(null);
                    versions.add(key + " " + tag);
                }
                return versions;
            }
        });
        PutAllCSDUnitTest.getLogWriter().info(Arrays.toString(this.expectedVersions.toArray()));
        PutAllCSDUnitTest.assertEquals((int)200, (int)this.actualVersions.size());
        PutAllCSDUnitTest.getLogWriter().info(Arrays.toString(this.actualVersions.toArray()));
        for (String keyTag : this.expectedVersions) {
            if (this.actualVersions.contains(keyTag)) continue;
            PutAllCSDUnitTest.fail((String)("client 2 does not have the tag contained in client 1" + keyTag));
        }
    }

    public void testVersionsOnReplicasAfterPutAll() {
        String title = "testVersionsInClients";
        this.client1Versions = null;
        this.client2Versions = null;
        PutAllCSDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort1 = AvailablePort.getRandomAvailablePort((int)0);
        int serverPort2 = AvailablePort.getRandomAvailablePort((int)0);
        String serverHost = PutAllCSDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, serverPort1, false, 0, null);
        this.createBridgeServer(server2, mcastPort, regionName, serverPort2, false, 0, null);
        this.createBridgeClient(client1, regionName, serverHost, new int[]{serverPort1}, 0, 59000);
        server1.invoke(this.addExceptionTag1(this.expectedExceptions));
        server2.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(this.addExceptionTag1(this.expectedExceptions));
        client1.invoke(new CacheSerializableRunnable("testVersionsInClientsclient1 putAll"){

            @Override
            public void run2() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                PutAllCSDUnitTest.this.doPutAll(regionName, "key-", 200);
                TestCase.assertEquals((int)200, (int)region.size());
            }
        });
        this.client1Versions = (List)server1.invoke(new SerializableCallable("testVersionsInClientsclient1 versions collection"){

            public Object call() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)200, (int)region.size());
                ArrayList<VersionTag> versions = new ArrayList<VersionTag>(200);
                RegionMap entries = ((LocalRegion)region).entries;
                for (Object key : entries.keySet()) {
                    RegionEntry internalRegionEntry = entries.getEntry(key);
                    VersionTag tag = internalRegionEntry.getVersionStamp().asVersionTag();
                    DistributedTestCase.getLogWriter().info("Entry version tag on client:" + tag);
                    versions.add(tag);
                }
                return versions;
            }
        });
        this.client2Versions = (List)server2.invoke(new SerializableCallable("testVersionsInClientsclient2 versions collection"){

            public Object call() throws CacheException {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                TestCase.assertEquals((int)200, (int)region.size());
                ArrayList<VersionTag> versions = new ArrayList<VersionTag>(200);
                RegionMap entries = ((LocalRegion)region).entries;
                for (Object key : entries.keySet()) {
                    RegionEntry internalRegionEntry = entries.getEntry(key);
                    versions.add(internalRegionEntry.getVersionStamp().asVersionTag());
                }
                return versions;
            }
        });
        PutAllCSDUnitTest.assertEquals((int)200, (int)this.client1Versions.size());
        PutAllCSDUnitTest.getLogWriter().info(Arrays.toString(this.client1Versions.toArray()));
        PutAllCSDUnitTest.getLogWriter().info(Arrays.toString(this.client2Versions.toArray()));
        for (VersionTag tag : this.client2Versions) {
            tag.setMemberID(null);
            if (this.client1Versions.contains(tag)) continue;
            PutAllCSDUnitTest.fail((String)("client 2 have the tag NOT contained in client 1" + tag));
        }
    }

    private void createBridgeServer(VM server, final int mcastPort, final String regionName, final int serverPort, final boolean createPR, final int redundantCopies, final String diskStoreName) {
        server.invoke(new CacheSerializableRunnable("Create server"){

            @Override
            public void run2() throws CacheException {
                DiskStore ds;
                Properties config = new Properties();
                config.setProperty("mcast-port", String.valueOf(mcastPort));
                config.setProperty("locators", "");
                PutAllCSDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                Cache cache = PutAllCSDUnitTest.this.getCache();
                if (diskStoreName == null) {
                    factory.setConcurrencyChecksEnabled(true);
                }
                if (diskStoreName != null && (ds = cache.findDiskStore(diskStoreName)) == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create(diskStoreName);
                }
                if (createPR) {
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(redundantCopies);
                    paf.setTotalNumBuckets(10);
                    factory.setPartitionAttributes(paf.create());
                    if (diskStoreName != null) {
                        factory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                        factory.setDiskStoreName(diskStoreName);
                    } else {
                        factory.setDataPolicy(DataPolicy.PARTITION);
                    }
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    if (diskStoreName != null) {
                        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                        factory.setDiskStoreName(diskStoreName);
                    } else {
                        factory.setDataPolicy(DataPolicy.REPLICATE);
                    }
                }
                PutAllCSDUnitTest.this.createRootRegion(new AttributesFactory().create());
                Region region = PutAllCSDUnitTest.this.createRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
                try {
                    int retPort = PutAllCSDUnitTest.this.startBridgeServer(serverPort);
                    DistributedTestCase.getLogWriter().info("Cache Server Started:" + retPort + ":" + serverPort);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("While starting CacheServer", e);
                }
            }
        });
    }

    private void createClient(VM client, final String regionName, final String serverHost, final int[] serverPorts, final int redundency, final int readTimeOut, final boolean receiveInvalidates, final boolean concurrencyChecks) {
        client.invoke(new CacheSerializableRunnable("Create client"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                config.setProperty("locators", "");
                PutAllCSDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                if (concurrencyChecks) {
                    factory.setConcurrencyChecksEnabled(true);
                }
                try {
                    PutAllCSDUnitTest.this.getCache();
                    if (readTimeOut > 0) {
                        PoolFactory pf = PoolManager.createFactory();
                        for (int i = 0; i < serverPorts.length; ++i) {
                            pf.addServer(serverHost, serverPorts[i]);
                        }
                        pf.setReadTimeout(59000).setSubscriptionEnabled(true).create("myPool");
                        factory.setPoolName("myPool");
                    } else {
                        BridgeTestCase.configureConnectionPool(factory, serverHost, serverPorts, true, redundency, -1, null);
                    }
                    Region r = PutAllCSDUnitTest.this.createRegion(regionName, factory.create());
                    if (receiveInvalidates) {
                        r.registerInterestRegex(".*", false, false);
                    }
                    TestCase.assertNotNull((Object)PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName));
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Region on Edge", ex);
                }
            }
        });
    }

    private void createBridgeClient(VM client, String regionName, String serverHost, int[] serverPorts, int redundency, int readTimeOut) {
        this.createClient(client, regionName, serverHost, serverPorts, redundency, readTimeOut, true, true);
    }

    protected Region doPutAll(String regionName, String keyStub, int numEntries) {
        Region region = this.getRootRegion().getSubregion(regionName);
        LinkedHashMap<String, TestObject> map = new LinkedHashMap<String, TestObject>();
        for (int i = 0; i < numEntries; ++i) {
            map.put(keyStub + i, new TestObject(i));
        }
        region.putAll(map);
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitTillNotify(Object lock_object, int waitTime, boolean ready) {
        Object object = lock_object;
        synchronized (object) {
            if (!ready) {
                try {
                    long then = System.currentTimeMillis();
                    lock_object.wait(waitTime);
                    long now = System.currentTimeMillis();
                    if (now - then > (long)waitTime) {
                        PutAllCSDUnitTest.fail((String)"Did not receive expected events");
                    }
                }
                catch (InterruptedException e) {
                    PutAllCSDUnitTest.fail((String)"interrupted");
                }
            }
        }
    }

    public void stopOneBridgeServer(int port) {
        BridgeServer bridge2 = null;
        boolean foundServer = false;
        for (BridgeServer bridge2 : this.getCache().getBridgeServers()) {
            if (bridge2.getPort() != port) continue;
            bridge2.stop();
            PutAllCSDUnitTest.assertFalse((boolean)bridge2.isRunning());
            foundServer = true;
            break;
        }
        PutAllCSDUnitTest.assertTrue((boolean)foundServer);
    }

    protected void closeCache(VM vm0) {
        SerializableRunnable close = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PutAllCSDUnitTest.this.getCache();
                cache.close();
            }
        };
        vm0.invoke(close);
    }

    protected void closeCacheAsync(VM vm0) {
        SerializableRunnable close = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PutAllCSDUnitTest.this.getCache();
                cache.close();
            }
        };
        vm0.invokeAsync(close);
    }

    protected int getRegionSize(VM vm, final String regionName) {
        SerializableCallable getRegionSize = new SerializableCallable("get region size"){

            public Object call() throws Exception {
                Region region = PutAllCSDUnitTest.this.getRootRegion().getSubregion(regionName);
                return new Integer(region.size());
            }
        };
        return (Integer)vm.invoke(getRegionSize);
    }

    class MyWriter
    extends CacheWriterAdapter
    implements Declarable {
        int exceptionAtItem = -1;
        public int num_created;

        public MyWriter(int exceptionAtItem) {
            this.exceptionAtItem = exceptionAtItem;
        }

        public void init(Properties props) {
        }

        public synchronized void beforeCreate(EntryEvent event) {
            if (this.exceptionAtItem != -1 && this.num_created >= this.exceptionAtItem) {
                throw new CacheWriterException("Triggered exception as planned, created " + this.num_created + " keys.");
            }
            DistributedTestCase.getLogWriter().info("MyWriter:beforeCreate " + event.getKey() + ":" + event.getNewValue() + "num_created=" + this.num_created);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++this.num_created;
        }

        public void beforeUpdate(EntryEvent event) {
            DistributedTestCase.getLogWriter().info("MyWriter:beforeUpdate " + event.getKey() + ":" + event.getNewValue());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    class MyListener
    extends CacheListenerAdapter
    implements Declarable {
        boolean delay = false;
        public int num_testEndPointSwitch;
        public int num_testHADRFailOver;
        public int num_oldValueInAfterUpdate;
        public SharedCounter sc;
        public VM vm;
        public int closeCacheAtItem = -1;

        public MyListener(boolean delay) {
            this.delay = delay;
            this.sc = new SharedCounter("dummy");
        }

        public MyListener(boolean delay, SharedCounter sc) {
            this.delay = delay;
            this.sc = sc;
        }

        public MyListener(VM vm, boolean delay, SharedCounter sc, int closeCacheAtItem) {
            this.vm = vm;
            this.delay = delay;
            this.sc = sc;
            this.closeCacheAtItem = closeCacheAtItem;
        }

        public void init(Properties props) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            Object object;
            ++this.sc.num_create_event;
            if (this.closeCacheAtItem != -1 && this.sc.num_create_event >= this.closeCacheAtItem) {
                PutAllCSDUnitTest.this.closeCacheAsync(this.vm);
            }
            DistributedTestCase.getLogWriter().fine("MyListener:afterCreate " + event.getKey() + ":" + event.getNewValue() + ":num_create_event=" + this.sc.num_create_event + ":eventID=" + ((EntryEventImpl)event).getEventId());
            if (this.delay) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            if (event.getKey().toString().startsWith("testEndPointSwitch")) {
                ++this.num_testEndPointSwitch;
                if (this.num_testEndPointSwitch == 200) {
                    DistributedTestCase.getLogWriter().info("testEndPointSwitch received expected events");
                    object = lockObject3;
                    synchronized (object) {
                        lockObject3.notify();
                    }
                }
            }
            if (event.getKey().toString().startsWith("testHADRFailOver")) {
                ++this.num_testHADRFailOver;
                if (this.num_testHADRFailOver == 2000) {
                    DistributedTestCase.getLogWriter().info("testHADRFailOver received expected events");
                    object = lockObject4;
                    synchronized (object) {
                        lockObject4.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent event) {
            ++this.sc.num_update_event;
            DistributedTestCase.getLogWriter().fine("MyListener:afterUpdate " + event.getKey() + ":" + event.getNewValue() + ":" + event.getOldValue() + ":num_update_event=" + this.sc.num_update_event + ":eventID=" + ((EntryEventImpl)event).getEventId());
            if (this.delay) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            if (event.getKey().toString().contains("OldValue") && event.getOldValue() != null) {
                ++this.num_oldValueInAfterUpdate;
                if (this.num_oldValueInAfterUpdate == 100) {
                    DistributedTestCase.getLogWriter().info("received expected OldValue events");
                    Object object = lockObject;
                    synchronized (object) {
                        lockObject.notify();
                    }
                }
            }
        }

        public void afterInvalidate(EntryEvent event) {
            ++this.sc.num_invalidate_event;
            DistributedTestCase.getLogWriter().info("local invalidate is triggered for " + event.getKey() + ":num_invalidte_event=" + this.sc.num_invalidate_event);
        }

        public void afterDestroy(EntryEvent event) {
            ++this.sc.num_destroy_event;
            DistributedTestCase.getLogWriter().info("local destroy is triggered for " + event.getKey() + ":num_invalidte_event=" + this.sc.num_destroy_event);
        }
    }

    class SharedCounter
    implements Serializable {
        public String owner;
        public int num_create_event;
        public int num_update_event;
        public int num_invalidate_event;
        public int num_destroy_event;

        public SharedCounter(String owner) {
            this.owner = owner;
            this.num_create_event = 0;
            this.num_update_event = 0;
            this.num_invalidate_event = 0;
            this.num_destroy_event = 0;
        }

        public String toString() {
            String str = "Owner=" + this.owner + ",create=" + this.num_create_event + ",update=" + this.num_update_event + ",invalidate=" + this.num_invalidate_event + ",destroy=" + this.num_destroy_event;
            return str;
        }
    }

    class EOCQEventListener
    implements CqListener {
        Region localregion;
        public int num_creates;
        public int num_updates;

        public EOCQEventListener(Region region) {
            this.localregion = region;
        }

        public void onError(CqEvent cqEvent) {
        }

        public void onEvent(CqEvent cqEvent) {
            if (cqEvent.getQueryOperation() == Operation.DESTROY) {
                return;
            }
            Object key = cqEvent.getKey();
            Object newValue = cqEvent.getNewValue();
            if (newValue == null) {
                this.localregion.create(key, newValue);
                ++this.num_creates;
            } else {
                this.localregion.put(key, newValue);
                ++this.num_updates;
            }
            DistributedTestCase.getLogWriter().info("CQListener:TestObject:" + key + ":" + newValue);
        }

        public void close() {
        }
    }

    public static class TestObject
    implements DataSerializable {
        protected String _ticker;
        protected int _price;
        protected long _ts = System.currentTimeMillis();

        public TestObject() {
        }

        public TestObject(int price) {
            this._price = price;
            this._ticker = Integer.toString(price);
        }

        public TestObject(String ticker, int price) {
            this._ticker = ticker;
            this._price = price;
        }

        public String getTicker() {
            return this._ticker;
        }

        public int getPrice() {
            return this._price;
        }

        public long getTS() {
            return this._ts;
        }

        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeString((String)this._ticker, (DataOutput)out);
            out.writeInt(this._price);
            out.writeLong(this._ts);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this._ticker = DataSerializer.readString((DataInput)in);
            this._price = in.readInt();
            this._ts = in.readLong();
        }

        public boolean equals(TestObject o) {
            return this._price == o._price && this._ticker.equals(o._ticker);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Price=" + this._price);
            return sb.toString();
        }
    }
}

