/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.SystemMemberCacheEvent;
import com.gemstone.gemfire.admin.SystemMemberCacheListener;
import com.gemstone.gemfire.admin.SystemMemberRegionEvent;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.PureJavaMode;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;

public class PartitionedRegionSystemMemberRegionListenerDUnitTest
extends AdminDUnitTestCase {
    public static AdminDistributedSystem ads = null;

    public PartitionedRegionSystemMemberRegionListenerDUnitTest(String name) {
        super(name);
    }

    public static DistributedMember getVMDM() {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        PartitionedRegionSystemMemberRegionListenerDUnitTest.assertNotNull((Object)ds);
        return ds.getDistributedMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminAPIInPartitionedRegions() throws Exception {
        Host host = Host.getHost(0);
        VM cacheVm1 = host.getVM(1);
        VM cacheVm2 = host.getVM(2);
        TestAlertListener tal = TestAlertListener.getInstance();
        tal.resetList();
        PartitionedRegionSystemMemberRegionListenerDUnitTest.assertFalse((boolean)this.isConnectedToDS());
        AdminDistributedSystemImpl adsi = (AdminDistributedSystemImpl)this.getAdminDistributedSystem();
        try {
            adsi.addCacheListener((SystemMemberCacheListener)TestSystemMemberCacheListener.getInstance());
            adsi.addAlertListener((AlertListener)tal);
        }
        catch (Exception e) {
            PartitionedRegionSystemMemberRegionListenerDUnitTest.getLogWriter().severe("Exception", (Throwable)e);
            PartitionedRegionSystemMemberRegionListenerDUnitTest.fail((String)("Exception e: " + e));
        }
        final DistributedMember adminMemberId = adsi.getDistributedMember();
        CacheSerializableRunnable verifyRegistration = new CacheSerializableRunnable("Verify admin listener for " + this.getName()){

            @Override
            public void run2() throws CacheException {
                final InternalDistributedSystem ds = PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getSystem();
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ds.hasAlertListenerFor(adminMemberId);
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            }
        };
        cacheVm1.invoke(verifyRegistration);
        cacheVm2.invoke(verifyRegistration);
        boolean redundancy = false;
        int localMaxMemory = 200;
        final String prPrefix = this.getUniqueName();
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("testCreateCacheVM"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                try {
                    cache.createRegion(prPrefix, PartitionedRegionSystemMemberRegionListenerDUnitTest.this.createRegionAttrsForPR(0, 200));
                }
                catch (RegionExistsException ex) {
                    TestCase.fail((String)"Got incorrect exception because the partition region being created prior to local region");
                }
            }
        };
        cacheVm1.invoke(createRegion);
        DistributedMember vm1dm = (DistributedMember)cacheVm1.invoke(PartitionedRegionSystemMemberRegionListenerDUnitTest.class, "getVMDM");
        int vm1pid = cacheVm1.getPid();
        TestSystemMemberCacheListener rel = TestSystemMemberCacheListener.getInstance();
        rel.waitForCreate(prPrefix, vm1dm);
        TestSystemMemberCacheListener testSystemMemberCacheListener = rel;
        synchronized (testSystemMemberCacheListener) {
            HashSet hs = (HashSet)rel.createSet.get("/" + prPrefix);
            PartitionedRegionSystemMemberRegionListenerDUnitTest.assertNotNull((Object)hs);
            if (!PureJavaMode.isPure()) {
                String s = hs.toString();
                PartitionedRegionSystemMemberRegionListenerDUnitTest.assertTrue((String)("vm1pid " + vm1pid + " not found in createSet: " + s), (s.indexOf(Integer.toString(vm1pid)) > -1 ? 1 : 0) != 0);
            }
        }
        cacheVm2.invoke(createRegion);
        DistributedMember vm2dm = (DistributedMember)cacheVm2.invoke(PartitionedRegionSystemMemberRegionListenerDUnitTest.class, "getVMDM");
        TestSystemMemberCacheListener rel2 = TestSystemMemberCacheListener.getInstance();
        rel2.waitForCreate(prPrefix, vm2dm);
        CacheSerializableRunnable destroyRegion = new CacheSerializableRunnable("destroyRegion"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getCache();
                Region pr = cache.getRegion("/" + prPrefix);
                TestCase.assertNotNull((String)"This region is null", (Object)pr);
                pr.destroyRegion();
            }
        };
        cacheVm2.invoke(destroyRegion);
        TestSystemMemberCacheListener rel3 = TestSystemMemberCacheListener.getInstance();
        rel3.waitForDestroy(prPrefix, vm2dm);
        rel3 = TestSystemMemberCacheListener.getInstance();
        rel3.waitForDestroy(prPrefix, vm1dm);
        rel3.waitForDestroy(prPrefix, vm2dm);
        LogWriter lw = PartitionedRegionSystemMemberRegionListenerDUnitTest.getLogWriter();
        TestAlertListener testAlertListener = tal;
        synchronized (testAlertListener) {
            int j = 0;
            for (Alert a : tal.alerts) {
                lw.severe("Unexpected Alert " + j + ":" + a);
            }
            PartitionedRegionSystemMemberRegionListenerDUnitTest.assertEquals((String)"Alerts were found", (int)0, (int)tal.alerts.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlertWhenLocalMaxExceeded() throws Exception {
        Host host = Host.getHost(0);
        VM cacheVm1 = host.getVM(1);
        VM cacheVm2 = host.getVM(2);
        TestAlertListener tal = TestAlertListener.getInstance();
        tal.resetList();
        PartitionedRegionSystemMemberRegionListenerDUnitTest.assertFalse((boolean)this.isConnectedToDS());
        AdminDistributedSystemImpl adsi = (AdminDistributedSystemImpl)this.getAdminDistributedSystem();
        try {
            adsi.addAlertListener((AlertListener)tal);
        }
        catch (Exception e) {
            PartitionedRegionSystemMemberRegionListenerDUnitTest.getLogWriter().severe("Exception", (Throwable)e);
            PartitionedRegionSystemMemberRegionListenerDUnitTest.fail((String)("Exception e: " + e));
        }
        final DistributedMember adminMemberId = adsi.getDistributedMember();
        CacheSerializableRunnable verifyRegistration = new CacheSerializableRunnable("Verify admin listener"){

            @Override
            public void run2() throws CacheException {
                final InternalDistributedSystem ds = PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getSystem();
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ds.hasAlertListenerFor(adminMemberId);
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            }
        };
        cacheVm1.invoke(verifyRegistration);
        cacheVm2.invoke(verifyRegistration);
        boolean redundancy = false;
        int localMaxMemory = 2;
        final String prPrefix = this.getUniqueName();
        int numBuckets = 5;
        int valBytes = 1228800;
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("testCreateCacheVM"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getCache();
                Region pr = new RegionFactory().setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).setLocalMaxMemory(2).setTotalNumBuckets(5).create()).create(prPrefix);
                int start = pr.size();
                int end = start + 2;
                DistributedTestCase.getLogWriter().info("start: " + start + " end: " + end);
                for (int i = start; i < end; ++i) {
                    pr.put((Object)new Integer(i), (Object)"createBucket");
                    pr.put((Object)new Integer(i), (Object)new byte[1228800]);
                }
            }
        };
        cacheVm1.invoke(createRegion);
        DistributedMember vm1dm = (DistributedMember)cacheVm1.invoke(PartitionedRegionSystemMemberRegionListenerDUnitTest.class, "getVMDM");
        cacheVm2.invoke(createRegion);
        DistributedMember vm2dm = (DistributedMember)cacheVm2.invoke(PartitionedRegionSystemMemberRegionListenerDUnitTest.class, "getVMDM");
        HashSet<DistributedMember> hs = new HashSet<DistributedMember>();
        hs.add(vm1dm);
        hs.add(vm2dm);
        tal.waitForEvents(2);
        TestAlertListener testAlertListener = tal;
        synchronized (testAlertListener) {
            int numExceedAlerts = 0;
            for (Alert a : tal.alerts) {
                if (a.getMessage().indexOf(" has exceeded local maximum memory configuration ") <= 0) continue;
                PartitionedRegionSystemMemberRegionListenerDUnitTest.assertTrue((boolean)hs.contains(a.getSystemMember().getDistributedMember()));
                ++numExceedAlerts;
            }
            PartitionedRegionSystemMemberRegionListenerDUnitTest.assertEquals((int)2, (int)numExceedAlerts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoAlertWhenLocalMaxExceededWithEviction() throws Exception {
        Host host = Host.getHost(0);
        VM cacheVm1 = host.getVM(1);
        VM cacheVm2 = host.getVM(2);
        TestAlertListener tal = TestAlertListener.getInstance();
        tal.resetList();
        PartitionedRegionSystemMemberRegionListenerDUnitTest.assertFalse((boolean)this.isConnectedToDS());
        AdminDistributedSystemImpl adsi = (AdminDistributedSystemImpl)this.getAdminDistributedSystem();
        try {
            adsi.addAlertListener((AlertListener)tal);
        }
        catch (Exception e) {
            PartitionedRegionSystemMemberRegionListenerDUnitTest.getLogWriter().severe("Exception", (Throwable)e);
            PartitionedRegionSystemMemberRegionListenerDUnitTest.fail((String)("Exception e: " + e));
        }
        final DistributedMember adminMemberId = adsi.getDistributedMember();
        CacheSerializableRunnable verifyRegistration = new CacheSerializableRunnable("Verify admin listener"){

            @Override
            public void run2() throws CacheException {
                final InternalDistributedSystem ds = PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getSystem();
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ds.hasAlertListenerFor(adminMemberId);
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            }
        };
        cacheVm1.invoke(verifyRegistration);
        cacheVm2.invoke(verifyRegistration);
        boolean redundancy = false;
        int localMaxMemory = 2;
        final String prPrefix = this.getUniqueName();
        int numBuckets = 5;
        int valBytes = 1228800;
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("testCreateCacheVM"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionSystemMemberRegionListenerDUnitTest.this.getCache();
                Region pr = new RegionFactory().setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).setLocalMaxMemory(2).setTotalNumBuckets(5).create()).setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)Integer.MAX_VALUE, (EvictionAction)EvictionAction.LOCAL_DESTROY)).create(prPrefix);
                int start = pr.size();
                int end = start + 2;
                DistributedTestCase.getLogWriter().info("start: " + start + " end: " + end);
                for (int i = start; i < end; ++i) {
                    pr.put((Object)new Integer(i), (Object)"createBucket");
                    pr.put((Object)new Integer(i), (Object)new byte[1228800]);
                }
            }
        };
        cacheVm1.invoke(createRegion);
        DistributedMember vm1dm = (DistributedMember)cacheVm1.invoke(PartitionedRegionSystemMemberRegionListenerDUnitTest.class, "getVMDM");
        cacheVm2.invoke(createRegion);
        DistributedMember vm2dm = (DistributedMember)cacheVm2.invoke(PartitionedRegionSystemMemberRegionListenerDUnitTest.class, "getVMDM");
        PartitionedRegionSystemMemberRegionListenerDUnitTest.pause(500);
        TestAlertListener testAlertListener = tal;
        synchronized (testAlertListener) {
            PartitionedRegionSystemMemberRegionListenerDUnitTest.assertEquals((int)0, (int)tal.alerts.size());
        }
    }

    protected RegionAttributes createRegionAttrsForPR(int red, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(red).setLocalMaxMemory(localMaxMem).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    static class TestAlertListener
    implements AlertListener {
        protected ArrayList alerts;
        private static TestAlertListener instance;

        public static synchronized TestAlertListener getInstance() {
            if (instance == null) {
                instance = new TestAlertListener();
                instance.resetList();
            }
            return instance;
        }

        public synchronized void resetList() {
            this.alerts = new ArrayList();
        }

        public synchronized void alert(Alert alert) {
            this.alerts.add(alert);
            this.notifyAll();
        }

        public synchronized int getAlertCount() {
            return this.alerts.size();
        }

        public synchronized Alert[] getAlerts() {
            Alert[] ret = new Alert[this.alerts.size()];
            this.alerts.toArray(ret);
            return ret;
        }

        public synchronized void waitForEvents(int totalEvents) throws InterruptedException {
            long startTime = System.currentTimeMillis();
            while (this.alerts.size() < totalEvents) {
                this.waitForAnEvent(startTime);
            }
            return;
        }

        public synchronized void waitForEventsWithSeverity(int numToWaitFor, int severity) throws InterruptedException {
            long startTime = System.currentTimeMillis();
            while (true) {
                int numSeenWithSeverity = 0;
                for (Alert a : this.alerts) {
                    if (a.getLevel().getSeverity() != severity) continue;
                    ++numSeenWithSeverity;
                }
                if (numSeenWithSeverity >= numToWaitFor) {
                    return;
                }
                this.waitForAnEvent(startTime);
            }
        }

        private void waitForAnEvent(long startTime) throws InterruptedException {
            ArrayList lastAlertList;
            int lastSize;
            TestCase.assertTrue((boolean)Thread.holdsLock(this));
            int waitTime = 200;
            long maxWaitFail = 180000L;
            do {
                lastAlertList = this.alerts;
                lastSize = lastAlertList.size();
                this.wait(200L);
                if (System.currentTimeMillis() - startTime > 180000L) {
                    TestCase.fail((String)"Waited over 180000 ms");
                }
                if (lastAlertList == this.alerts) continue;
                TestCase.fail((String)"TestAlertListener was reset");
            } while (lastSize == lastAlertList.size());
        }
    }

    static class TestSystemMemberCacheListener
    implements SystemMemberCacheListener {
        public static TestSystemMemberCacheListener instance;
        protected final HashMap createSet = new HashMap();
        private final HashMap destroySet = new HashMap();
        private boolean seenEvent = false;

        public static synchronized TestSystemMemberCacheListener getInstance() {
            if (instance == null) {
                instance = new TestSystemMemberCacheListener();
            }
            return instance;
        }

        private TestSystemMemberCacheListener() {
        }

        public synchronized void afterRegionCreate(SystemMemberRegionEvent event) {
            HashSet hosts = (HashSet)this.createSet.get(event.getRegionPath());
            if (hosts != null) {
                hosts.add(event.getDistributedMember());
            } else {
                HashSet<DistributedMember> s = new HashSet<DistributedMember>();
                s.add(event.getDistributedMember());
                this.createSet.put(event.getRegionPath(), s);
            }
            DistributedTestCase.getLogWriter().info("SystemMemberCacheListener::regionCreated event, Region path is " + event.getRegionPath());
            this.seenEvent = true;
            this.notifyAll();
        }

        public synchronized void afterRegionLoss(SystemMemberRegionEvent event) {
            HashSet hosts = (HashSet)this.destroySet.get(event.getRegionPath());
            if (hosts != null) {
                hosts.add(event.getDistributedMember());
            } else {
                HashSet<DistributedMember> s = new HashSet<DistributedMember>();
                s.add(event.getDistributedMember());
                this.destroySet.put(event.getRegionPath(), s);
            }
            DistributedTestCase.getLogWriter().info("SystemMemberCacheListener::regionDestroyed event, Region path is " + event.getRegionPath());
            this.seenEvent = true;
            this.notifyAll();
        }

        public void afterCacheCreate(SystemMemberCacheEvent event) {
        }

        public void afterCacheClose(SystemMemberCacheEvent event) {
        }

        public void waitForCreate(String rName, DistributedMember fromMember) throws InterruptedException {
            this.waitForEvent(rName, fromMember, this.createSet);
        }

        public void waitForDestroy(String rName, DistributedMember fromMember) throws InterruptedException {
            this.waitForEvent(rName, fromMember, this.destroySet);
        }

        private synchronized void waitForEvent(String rName, DistributedMember fromMember, HashMap eventMap) throws InterruptedException {
            int waitTime = 250;
            long maxWaitFail = 60000L;
            long startTime = System.currentTimeMillis();
            HashSet hosts;
            while ((hosts = (HashSet)eventMap.get('/' + rName)) == null || !hosts.contains(fromMember)) {
                while (!this.seenEvent) {
                    if (System.currentTimeMillis() - startTime > 60000L) {
                        TestCase.fail((String)"Waited over 60000 ms");
                    }
                    this.wait(250L);
                }
                this.seenEvent = false;
            }
            return;
        }
    }
}

