/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class PartitionedRegionPerfDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_NAME_PREFIX = "p_";
    public static final String DR_NAME_PREFIX = "d_";
    public static final Scope scope = Scope.DISTRIBUTED_ACK;
    public static final MirrorType mirror = MirrorType.KEYS_VALUES;
    public static final long RUN_LENGTH = 60000L;
    public static final Integer SMALL_OBJECT_SIZE = new Integer(100);
    public static final Integer MEDIUM_OBJECT_SIZE = new Integer(1000);
    public static final Integer LARGE_OBJECT_SIZE = new Integer(10000);
    public static int TARGET_TOTAL_BYTES = 1000000;
    public VM vm0;
    public VM vm1;
    public VM vm2;
    public VM vm3;

    public PartitionedRegionPerfDUnitTest(String name) {
        super(name);
    }

    public void testCompareIteratorGetsWithCHM_42553() {
        int index;
        int index2;
        int key;
        String statsDisabled = System.setProperty("gemfire.statsDisabled", "true");
        String timeStats = System.setProperty("gemfire.enable-time-statistics", "false");
        ConcurrentHashMap<String, String> map1 = new ConcurrentHashMap<String, String>();
        Properties dsProps = this.getAllDistributedSystemProperties(new Properties());
        dsProps.put("mcast-port", "0");
        LocalRegion lmap2 = (LocalRegion)new CacheFactory(dsProps).create().createRegionFactory(RegionShortcut.LOCAL).create("map2");
        AbstractRegionMap amap2 = (AbstractRegionMap)lmap2.entries;
        int numOps = 10000;
        for (key = 1; key <= 10000; ++key) {
            map1.put("key-" + key, "value-" + key);
        }
        for (key = 1; key <= 10000; ++key) {
            lmap2.put((Object)("key-" + key), (Object)("value-" + key));
        }
        for (index2 = 0; index2 < 2000; ++index2) {
            for (Object key2 : map1.keySet()) {
                map1.get(key2);
            }
        }
        long currentTime = System.currentTimeMillis();
        int count = 0;
        for (index2 = 0; index2 < 10000; ++index2) {
            for (Object key2 : map1.keySet()) {
                map1.get(key2);
                ++count;
            }
        }
        long duration1 = System.currentTimeMillis() - currentTime;
        PartitionedRegionPerfDUnitTest.getLogWriter().info("ConcurrentHashMap gets time " + duration1 + " count=" + count);
        map1.clear();
        System.gc();
        for (index = 0; index < 2000; ++index) {
            for (Object key3 : lmap2.keySet()) {
                amap2.getEntry(key3);
            }
        }
        currentTime = System.currentTimeMillis();
        count = 0;
        for (index = 0; index < 10000; ++index) {
            for (Object key3 : lmap2.keySet()) {
                amap2.getEntry(key3);
                ++count;
            }
        }
        long duration2 = System.currentTimeMillis() - currentTime;
        PartitionedRegionPerfDUnitTest.getLogWriter().info("AbstractRegionMap#getEntry time " + duration2 + " count=" + count);
        long diff = duration2 - duration1;
        if (diff * 2L <= duration1) {
            PartitionedRegionPerfDUnitTest.getLogWriter().info("Yay! diff between CHM iteration and LocalRegion iteration (" + diff * 100L / duration1 + "%) is less than 50%");
        } else {
            PartitionedRegionPerfDUnitTest.getLogWriter().error("Difference between CHM iteration and LocalRegion iteration (" + diff * 100L / duration1 + "%) is more than 50%");
        }
        if (statsDisabled != null) {
            System.setProperty("gemfire.statsDisabled", statsDisabled);
        } else {
            System.clearProperty("gemfire.statsDisabled");
        }
        if (timeStats != null) {
            System.setProperty("gemfire.enable-time-statistics", timeStats);
        } else {
            System.clearProperty("gemfire.enable-time-statistics");
        }
    }

    public void doCreateRegions(final String pRegionName, final String dRegionName) throws Exception {
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        CacheSerializableRunnable createRegions = new CacheSerializableRunnable("createRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionPerfDUnitTest.this.getCache();
                cache.createRegion(pRegionName, PartitionedRegionPerfDUnitTest.this.createRegionAttributesForPR(0, 50));
                cache.createRegion(dRegionName, PartitionedRegionPerfDUnitTest.this.createRegionAttributesForDR(scope, mirror));
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionPerfDUnitTest.this.getCache();
                cache.createRegion(pRegionName, PartitionedRegionPerfDUnitTest.this.createRegionAttributesForPR(0, 0));
                cache.createRegion(dRegionName, PartitionedRegionPerfDUnitTest.this.createRegionAttributesForDR(scope, MirrorType.NONE));
            }
        };
        this.vm0.invoke(createAccessor);
        this.vm1.invoke(createRegions);
        this.vm2.invoke(createRegions);
        this.vm3.invoke(createRegions);
    }

    public PerfResults doPuts(String regionName, Integer objectSize_) throws Exception {
        int objectSize = objectSize_;
        Cache cache = this.getCache();
        Region r = cache.getRegion("/" + regionName);
        int origLogLevel = PartitionedRegionPerfDUnitTest.setLogLevel(cache.getLogger(), 900);
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 60000L;
        int putCount = 0;
        int maxKey = TARGET_TOTAL_BYTES / objectSize;
        byte[] value = new byte[objectSize];
        while (System.currentTimeMillis() < endTime) {
            for (int i = 0; i < 100; ++i) {
                r.put((Object)String.valueOf(putCount % maxKey), (Object)value);
                ++putCount;
            }
        }
        endTime = System.currentTimeMillis();
        PartitionedRegionPerfDUnitTest.setLogLevel(cache.getLogger(), origLogLevel);
        PerfResults results = new PerfResults();
        results.putCount = putCount;
        results.objectSize = objectSize;
        results.operationType = "PUT";
        results.time = endTime - startTime;
        return results;
    }

    public PerfResults doGets(String regionName, Integer objectSize_) throws Exception {
        int i;
        int objectSize = objectSize_;
        Cache cache = this.getCache();
        Region r = cache.getRegion("/" + regionName);
        boolean partitioned = false;
        if (r instanceof PartitionedRegion) {
            partitioned = true;
        }
        int origLogLevel = PartitionedRegionPerfDUnitTest.setLogLevel(cache.getLogger(), 900);
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 60000L;
        int getCount = 0;
        int missCount = 0;
        int maxKey = TARGET_TOTAL_BYTES / objectSize;
        Object value = new byte[objectSize];
        for (i = 0; i < maxKey; ++i) {
            r.put((Object)String.valueOf(i), value);
        }
        if (!partitioned) {
            for (i = 0; i < maxKey; ++i) {
                r.localInvalidate((Object)String.valueOf(i));
            }
        }
        value = null;
        while (System.currentTimeMillis() < endTime) {
            for (i = 0; i < 500; ++i) {
                value = r.get((Object)String.valueOf(getCount % maxKey));
                ++getCount;
                if (value == null) {
                    ++missCount;
                }
                if (partitioned) continue;
                r.localInvalidate((Object)String.valueOf(getCount % maxKey));
            }
        }
        endTime = System.currentTimeMillis();
        PartitionedRegionPerfDUnitTest.setLogLevel(cache.getLogger(), origLogLevel);
        PerfResults results = new PerfResults();
        results.getCount = getCount;
        results.missCount = missCount;
        results.objectSize = objectSize;
        results.operationType = "GET";
        results.time = endTime - startTime;
        return results;
    }

    public PerfResults doMisses(String regionName) throws Exception {
        Cache cache = this.getCache();
        Region r = cache.getRegion("/" + regionName);
        int origLogLevel = PartitionedRegionPerfDUnitTest.setLogLevel(cache.getLogger(), 900);
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 60000L;
        int missCount = 0;
        Object value = null;
        while (System.currentTimeMillis() < endTime) {
            for (int i = 0; i < 500; ++i) {
                value = r.get((Object)String.valueOf(missCount));
                ++missCount;
                if (value == null) continue;
                PartitionedRegionPerfDUnitTest.fail((String)"Got back non-null value for a key that should have no value.");
            }
        }
        endTime = System.currentTimeMillis();
        PartitionedRegionPerfDUnitTest.setLogLevel(cache.getLogger(), origLogLevel);
        PerfResults results = new PerfResults();
        results.missCount = missCount;
        results.objectSize = 0L;
        results.operationType = "MISS";
        results.time = endTime - startTime;
        return results;
    }

    public String displayComparedResults(PerfResults res1, PerfResults res2) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n######################################\n");
        sb.append("### ");
        sb.append(res1.operationType);
        sb.append(" ##############################\n");
        sb.append("######################################\n");
        sb.append("Object Size = ");
        sb.append(res1.objectSize);
        sb.append(" bytes\n");
        sb.append("Test Length = ");
        sb.append(res1.time);
        sb.append(" ms\n");
        sb.append("## ");
        sb.append(res1.mode);
        sb.append(" ##");
        if (res1.putCount != 0L) {
            sb.append("\nPut count = ");
            sb.append(res1.putCount);
            sb.append("\nPuts/sec = ");
            sb.append(1000.0 * (double)res1.putCount / (double)res1.time);
        }
        if (res1.getCount != 0L) {
            sb.append("\nGet count = ");
            sb.append(res1.getCount);
            sb.append("\nGets/sec = ");
            sb.append(1000.0 * (double)res1.getCount / (double)res1.time);
        }
        if (res1.missCount != 0L) {
            sb.append("\nMiss count = ");
            sb.append(res1.missCount);
            sb.append("\nMisses/sec = ");
            sb.append(1000.0 * (double)res1.missCount / (double)res1.time);
        }
        sb.append("\n");
        sb.append("## ");
        sb.append(res2.mode);
        sb.append(" ##");
        if (res2.putCount != 0L) {
            sb.append("\nPut count = ");
            sb.append(res2.putCount);
            sb.append("\nPuts/sec = ");
            sb.append(1000.0 * (double)res2.putCount / (double)res2.time);
        }
        if (res2.getCount != 0L) {
            sb.append("\nGet count = ");
            sb.append(res2.getCount);
            sb.append("\nGets/sec = ");
            sb.append(1000.0 * (double)res2.getCount / (double)res2.time);
        }
        if (res2.missCount != 0L) {
            sb.append("\nMiss count = ");
            sb.append(res2.missCount);
            sb.append("\nMisses/sec = ");
            sb.append(1000.0 * (double)res2.missCount / (double)res2.time);
        }
        sb.append("\n");
        sb.append("######################################\n");
        sb.append("######################################\n");
        sb.append("######################################\n");
        return sb.toString();
    }

    public String displayResults(String operationName, int objectSize, long totalTime, int operationCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("######################################\n");
        sb.append("### ");
        sb.append(operationName);
        sb.append(" #############################\n");
        sb.append("######################################\n");
        sb.append("Object Size = ");
        sb.append(objectSize);
        sb.append(" bytes\n");
        sb.append("Test Length = ");
        sb.append(totalTime);
        sb.append(" ms\n");
        sb.append("Operation count = ");
        sb.append(operationCount);
        sb.append("\n");
        sb.append("Operations/sec = ");
        if (totalTime == 0L) {
            sb.append("unbounded");
        } else {
            sb.append(1000.0 * (double)operationCount / (double)totalTime);
        }
        sb.append("\n");
        sb.append("######################################\n");
        sb.append("######################################\n");
        sb.append("######################################\n");
        return sb.toString();
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    protected RegionAttributes createRegionAttributesForDR(Scope scope, MirrorType mirror) {
        AttributesFactory attr = new AttributesFactory();
        attr.setScope(scope);
        attr.setMirrorType(mirror);
        return attr.create();
    }

    class PerfResults
    implements Serializable {
        String operationType;
        String mode;
        long time;
        long putCount = 0L;
        long getCount = 0L;
        long missCount = 0L;
        long objectSize;

        PerfResults() {
        }
    }
}

